/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.Bus;
import com.fluendo.jst.Clock;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Object;
import com.fluendo.jst.Pad;
import com.fluendo.jst.PadListener;
import com.fluendo.jst.Query;
import com.fluendo.utils.Debug;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Element
extends Object {
    public static final int FLAG_IS_SINK = 32;
    public static final int ELEMENT_FLAG_LAST = 0x100000;
    protected Vector pads = new Vector();
    protected java.lang.Object stateLock = new java.lang.Object();
    private Vector padListeners = new Vector();
    protected Clock clock;
    protected Bus bus;
    protected long baseTime;
    public static final int NONE = 0;
    public static final int STOP = 1;
    public static final int PAUSE = 2;
    public static final int PLAY = 3;
    protected static String[] stateNames = new String[]{"none", "stop", "pause", "play"};
    private static final int SHIFT = 4;
    private static final int MASK = 15;
    public static final int STOP_PAUSE = 18;
    public static final int PAUSE_PLAY = 35;
    public static final int PLAY_PAUSE = 50;
    public static final int PAUSE_STOP = 33;
    public static final int FAILURE = 0;
    public static final int SUCCESS = 1;
    public static final int ASYNC = 2;
    public static final int NO_PREROLL = 3;
    public static String[] stateReturnNames = new String[]{"FAILURE", "SUCCESS", "ASYNC", "NO_PREROLL"};
    protected int currentState = 1;
    protected int nextState = 0;
    protected int pendingState = 0;
    protected int lastReturn = 1;

    public static String getStateName(int n) {
        return stateNames[n];
    }

    public static String getStateReturnName(int n) {
        return stateReturnNames[n];
    }

    public String getMime() {
        return null;
    }

    public abstract String getFactoryName();

    public int typeFind(byte[] byArray, int n, int n2) {
        return -1;
    }

    public Element() {
        this(null);
    }

    public Element(String string) {
        super(string);
    }

    public String toString() {
        return "Element: [" + this.getName() + "]";
    }

    public synchronized void setClock(Clock clock) {
        Debug.debug(this + ".setClock(" + clock + ")");
        this.clock = clock;
    }

    public synchronized Clock getClock() {
        return this.clock;
    }

    public synchronized void setBus(Bus bus) {
        this.bus = bus;
    }

    public synchronized Bus getBus() {
        return this.bus;
    }

    public synchronized void addPadListener(PadListener padListener) {
        this.padListeners.addElement(padListener);
    }

    public synchronized void removePadListener(PadListener padListener) {
        this.padListeners.removeElement(padListener);
    }

    private synchronized void doPadListeners(int n, Pad pad) {
        Enumeration enumeration = this.padListeners.elements();
        while (enumeration.hasMoreElements()) {
            PadListener padListener = (PadListener)enumeration.nextElement();
            switch (n) {
                case 0: {
                    padListener.padAdded(pad);
                    break;
                }
                case 1: {
                    padListener.padRemoved(pad);
                    break;
                }
                case 2: {
                    padListener.noMorePads();
                }
            }
        }
    }

    public synchronized Pad getPad(String string) {
        Enumeration enumeration = this.pads.elements();
        while (enumeration.hasMoreElements()) {
            Pad pad = (Pad)enumeration.nextElement();
            if (!string.equals(pad.getName())) continue;
            return pad;
        }
        return null;
    }

    public synchronized boolean addPad(Pad pad) {
        if (!pad.setParent(this)) {
            return false;
        }
        this.pads.addElement(pad);
        this.doPadListeners(0, pad);
        return true;
    }

    public synchronized boolean removePad(Pad pad) {
        if (pad.getParent() != this) {
            return false;
        }
        pad.unParent();
        this.pads.removeElement(pad);
        this.doPadListeners(1, pad);
        return true;
    }

    public synchronized void noMorePads() {
        this.doPadListeners(2, null);
    }

    public Enumeration enumPads() {
        return this.pads.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMessage(Message message) {
        Bus bus;
        Element element = this;
        synchronized (element) {
            bus = this.bus;
        }
        if (bus != null) {
            bus.post(message);
        }
    }

    public synchronized int getState(int[] nArray, int[] nArray2, long l) {
        if (this.lastReturn == 2 && this.pendingState != 0) {
            long l2 = l == 0L ? 0L : (l < 1000L ? 1L : l / 1000L);
            try {
                this.wait(l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (nArray != null) {
            nArray[0] = this.currentState;
        }
        if (nArray2 != null) {
            nArray2[0] = this.pendingState;
        }
        return this.lastReturn;
    }

    private boolean padsActivate(boolean bl) {
        int n = bl ? 1 : 0;
        boolean bl2 = true;
        Enumeration enumeration = this.pads.elements();
        while (enumeration.hasMoreElements()) {
            Pad pad = (Pad)enumeration.nextElement();
            if (bl2 &= pad.activate(n)) continue;
            return bl2;
        }
        return bl2;
    }

    public int getStateNext(int n, int n2) {
        int n3 = n2 - n;
        n3 = n3 > 0 ? 1 : (n3 < 0 ? -1 : 0);
        return n + n3;
    }

    public int getTransition(int n, int n2) {
        return n << 4 | n2;
    }

    public int getTransitionCurrent(int n) {
        return n >> 4;
    }

    public int getTransitionNext(int n) {
        return n & 0xF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int continueState(int n) {
        Message message = null;
        int n2 = 0;
        Element element = this;
        synchronized (element) {
            int n3 = this.lastReturn;
            this.lastReturn = n;
            int n4 = this.pendingState;
            if (n4 == 0) {
                return n;
            }
            int n5 = this.currentState;
            int n6 = this.nextState;
            this.currentState = n6;
            int n7 = this.currentState;
            if (n4 == n7) {
                this.pendingState = 0;
                this.nextState = 0;
                n2 = 0;
                if (n5 != n6 || n3 == 2) {
                    message = Message.newStateChanged(this, n5, n6, n4);
                }
            } else {
                int n8 = this.getStateNext(n7, n4);
                n2 = this.getTransition(n7, n8);
                this.nextState = n8;
                this.lastReturn = 2;
                message = Message.newStateChanged(this, n5, n6, n4);
            }
        }
        if (message != null) {
            this.postMessage(message);
        }
        if (n2 != 0) {
            n = this.doChangeState(n2);
        } else {
            element = this;
            synchronized (element) {
                this.notifyAll();
            }
        }
        return n;
    }

    public synchronized void abortState() {
        if (this.pendingState != 0 && this.lastReturn != 0) {
            this.lastReturn = 0;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lostState() {
        boolean bl = false;
        int n = 0;
        Element element = this;
        synchronized (element) {
            if (this.pendingState == 0 && this.lastReturn != 0) {
                n = this.currentState;
                this.pendingState = this.nextState = this.currentState;
                this.lastReturn = 2;
                bl = true;
            }
        }
        if (bl) {
            this.postMessage(Message.newStateChanged(this, n, n, n));
            this.postMessage(Message.newStateDirty(this));
        }
    }

    protected int changeState(int n) {
        boolean bl;
        int n2 = this.getTransitionCurrent(n);
        int n3 = this.getTransitionNext(n);
        if (n3 == 0 || n2 == n3) {
            return this.lastReturn;
        }
        switch (n) {
            case 18: {
                bl = this.padsActivate(true);
                break;
            }
            case 35: {
                bl = true;
                break;
            }
            case 50: {
                bl = true;
                break;
            }
            case 33: {
                bl = this.padsActivate(false);
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doChangeState(int n) {
        int n2 = this.getTransitionCurrent(n);
        int n3 = this.getTransitionNext(n);
        int n4 = this.changeState(n);
        switch (n4) {
            case 0: {
                this.abortState();
                break;
            }
            case 1: 
            case 3: {
                n4 = this.continueState(n4);
                break;
            }
            case 2: {
                if (n2 < n3) {
                    Element element = this;
                    synchronized (element) {
                        if (this.pendingState != 0) {
                            this.lastReturn = n4;
                        }
                        break;
                    }
                }
                n4 = this.continueState(1);
            }
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int setState(int n) {
        int n2;
        java.lang.Object object = this.stateLock;
        synchronized (object) {
            int n3;
            Element element = this;
            synchronized (element) {
                if (this.lastReturn == 0) {
                    this.nextState = 0;
                    this.pendingState = 0;
                    this.lastReturn = 1;
                }
                int n4 = this.pendingState;
                this.pendingState = n;
                if (n4 != 0) {
                    if (n4 <= n) {
                        this.lastReturn = 2;
                        return 2;
                    }
                    if (this.nextState == n) {
                        this.lastReturn = 2;
                        return 2;
                    }
                    if (this.nextState > n && this.lastReturn == 2) {
                        this.currentState = this.nextState;
                    }
                }
                this.nextState = this.getStateNext(this.currentState, n);
                n3 = this.getTransition(this.currentState, this.nextState);
            }
            n2 = this.doChangeState(n3);
        }
        return n2;
    }

    public boolean sendEvent(Event event) {
        return false;
    }

    public boolean query(Query query) {
        return false;
    }
}

