/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.Constants;
import com.fluendo.jheora.Info;
import com.fluendo.jheora.Playback;
import com.jcraft.jogg.Buffer;

public class Quant {
    private static final int MIN_DEQUANT_VAL = 2;
    private static final int IDCT_SCALE_FACTOR = 2;

    private static int ilog(long l) {
        int n = 0;
        while (l != 0L) {
            ++n;
            l >>= 1;
        }
        return n;
    }

    private static int _read_qtable_range(Info info, Buffer buffer, int n) {
        int n2;
        buffer.readB(Quant.ilog(n - 1));
        for (int i = 0; i < 63; i += n2) {
            n2 = buffer.readB(Quant.ilog(62 - i));
            if (++n2 <= 0) {
                return -20;
            }
            buffer.readB(Quant.ilog(n - 1));
        }
        return 0;
    }

    public static int readQTables(Info info, Buffer buffer) {
        long l;
        int n;
        long l2 = buffer.readB(4);
        ++l2;
        for (n = 0; n < 64; ++n) {
            l = buffer.readB((int)l2);
            if (l2 < 0L) {
                return -20;
            }
            info.QThreshTable[n] = (int)l;
        }
        l2 = buffer.readB(4);
        ++l2;
        for (n = 0; n < 64; ++n) {
            l = buffer.readB((int)l2);
            if (l2 < 0L) {
                return -20;
            }
            info.DcScaleFactorTable[n] = (short)l;
        }
        int n2 = buffer.readB(9);
        info.qmats = new short[++n2 * 64];
        info.MaxQMatrixIndex = n2;
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < 64; ++n) {
                l = buffer.readB(8);
                if (l2 < 0L) {
                    return -20;
                }
                info.qmats[(i << 6) + n] = (short)l;
            }
        }
        int n3 = Quant._read_qtable_range(info, buffer, n2);
        if (n3 < 0) {
            return n3;
        }
        int n4 = buffer.readB(1);
        if (n4 < 0) {
            return -20;
        }
        if (n4 != 0 && (n3 = Quant._read_qtable_range(info, buffer, n2)) < 0) {
            return n3;
        }
        n4 = buffer.readB(1);
        if (n4 < 0) {
            return -20;
        }
        if (n4 != 0 && (n3 = Quant._read_qtable_range(info, buffer, n2)) < 0) {
            return n3;
        }
        n4 = buffer.readB(1);
        if (n4 < 0) {
            return -20;
        }
        if (n4 != 0) {
            n3 = Quant._read_qtable_range(info, buffer, n2);
            if (n3 < 0) {
                return n3;
            }
        } else {
            n4 = buffer.readB(1);
            if (n4 < 0) {
                return -20;
            }
            if (n4 != 0) {
                // empty if block
            }
        }
        if ((n4 = buffer.readB(1)) < 0) {
            return -20;
        }
        if (n4 != 0) {
            n3 = Quant._read_qtable_range(info, buffer, n2);
            if (n3 < 0) {
                return n3;
            }
        } else {
            n4 = buffer.readB(1);
            if (n4 < 0) {
                return -20;
            }
            if (n4 != 0) {
                // empty if block
            }
        }
        if ((n4 = buffer.readB(1)) < 0) {
            return -20;
        }
        if (n4 != 0) {
            n3 = Quant._read_qtable_range(info, buffer, n2);
            if (n3 < 0) {
                return n3;
            }
        } else {
            n4 = buffer.readB(1);
            if (n4 < 0) {
                return -20;
            }
            if (n4 != 0) {
                // empty if block
            }
        }
        if (n2 == 3) {
            System.arraycopy(info.qmats, 0, info.Y_coeffs, 0, 64);
            System.arraycopy(info.qmats, 64, info.U_coeffs, 0, 64);
            System.arraycopy(info.qmats, 64, info.V_coeffs, 0, 64);
            System.arraycopy(info.qmats, 128, info.Inter_Y_coeffs, 0, 64);
            System.arraycopy(info.qmats, 128, info.Inter_U_coeffs, 0, 64);
            System.arraycopy(info.qmats, 128, info.Inter_V_coeffs, 0, 64);
        } else if (n2 == 6) {
            System.arraycopy(info.qmats, 0, info.Y_coeffs, 0, 64);
            System.arraycopy(info.qmats, 64, info.U_coeffs, 0, 64);
            System.arraycopy(info.qmats, 128, info.V_coeffs, 0, 64);
            System.arraycopy(info.qmats, 192, info.Inter_Y_coeffs, 0, 64);
            System.arraycopy(info.qmats, 256, info.Inter_U_coeffs, 0, 64);
            System.arraycopy(info.qmats, 320, info.Inter_V_coeffs, 0, 64);
        } else {
            return -20;
        }
        return 0;
    }

    static void BuildQuantIndex_Generic(Playback playback) {
        int n = 0;
        while (n < 64) {
            int n2 = Constants.dequant_index[n];
            playback.quant_index[n2] = n++;
        }
    }

    static void init_dequantizer(Playback playback, int n, byte by) {
        int n2;
        short[] sArray = playback.Y_coeffs;
        short[] sArray2 = playback.U_coeffs;
        short[] sArray3 = playback.V_coeffs;
        short[] sArray4 = playback.Inter_Y_coeffs;
        short[] sArray5 = playback.Inter_U_coeffs;
        short[] sArray6 = playback.Inter_V_coeffs;
        short[] sArray7 = playback.DcScaleFactorTable;
        short[] sArray8 = playback.DcScaleFactorTable;
        Quant.BuildQuantIndex_Generic(playback);
        for (n2 = 0; n2 < 64; ++n2) {
            int n3 = playback.quant_index[n2];
            playback.dequant_Y_coeffs[n3] = sArray[n2];
            playback.dequant_U_coeffs[n3] = sArray2[n2];
            playback.dequant_V_coeffs[n3] = sArray3[n2];
            playback.dequant_Inter_Y_coeffs[n3] = sArray4[n2];
            playback.dequant_Inter_U_coeffs[n3] = sArray5[n2];
            playback.dequant_Inter_V_coeffs[n3] = sArray6[n2];
        }
        playback.dequant_Y_coeffs[0] = (short)(sArray7[by] * playback.dequant_Y_coeffs[0] / 100);
        if (playback.dequant_Y_coeffs[0] < 4) {
            playback.dequant_Y_coeffs[0] = 4;
        }
        playback.dequant_Y_coeffs[0] = (short)(playback.dequant_Y_coeffs[0] << 2);
        playback.dequant_U_coeffs[0] = (short)(sArray8[by] * playback.dequant_U_coeffs[0] / 100);
        if (playback.dequant_U_coeffs[0] < 4) {
            playback.dequant_U_coeffs[0] = 4;
        }
        playback.dequant_U_coeffs[0] = (short)(playback.dequant_U_coeffs[0] << 2);
        playback.dequant_V_coeffs[0] = (short)(sArray8[by] * playback.dequant_V_coeffs[0] / 100);
        if (playback.dequant_V_coeffs[0] < 4) {
            playback.dequant_V_coeffs[0] = 4;
        }
        playback.dequant_V_coeffs[0] = (short)(playback.dequant_V_coeffs[0] << 2);
        playback.dequant_Inter_Y_coeffs[0] = (short)(sArray7[by] * playback.dequant_Inter_Y_coeffs[0] / 100);
        if (playback.dequant_Inter_Y_coeffs[0] < 8) {
            playback.dequant_Inter_Y_coeffs[0] = 8;
        }
        playback.dequant_Inter_Y_coeffs[0] = (short)(playback.dequant_Inter_Y_coeffs[0] << 2);
        playback.dequant_Inter_U_coeffs[0] = (short)(sArray8[by] * playback.dequant_Inter_U_coeffs[0] / 100);
        if (playback.dequant_Inter_U_coeffs[0] < 8) {
            playback.dequant_Inter_U_coeffs[0] = 8;
        }
        playback.dequant_Inter_U_coeffs[0] = (short)(playback.dequant_Inter_U_coeffs[0] << 2);
        playback.dequant_Inter_V_coeffs[0] = (short)(sArray8[by] * playback.dequant_Inter_V_coeffs[0] / 100);
        if (playback.dequant_Inter_V_coeffs[0] < 8) {
            playback.dequant_Inter_V_coeffs[0] = 8;
        }
        playback.dequant_Inter_V_coeffs[0] = (short)(playback.dequant_Inter_V_coeffs[0] << 2);
        for (n2 = 1; n2 < 64; ++n2) {
            playback.dequant_Y_coeffs[n2] = (short)(n * playback.dequant_Y_coeffs[n2] / 100);
            if (playback.dequant_Y_coeffs[n2] < 2) {
                playback.dequant_Y_coeffs[n2] = 2;
            }
            playback.dequant_Y_coeffs[n2] = (short)(playback.dequant_Y_coeffs[n2] << 2);
            playback.dequant_U_coeffs[n2] = (short)(n * playback.dequant_U_coeffs[n2] / 100);
            if (playback.dequant_U_coeffs[n2] < 2) {
                playback.dequant_U_coeffs[n2] = 2;
            }
            playback.dequant_U_coeffs[n2] = (short)(playback.dequant_U_coeffs[n2] << 2);
            playback.dequant_V_coeffs[n2] = (short)(n * playback.dequant_V_coeffs[n2] / 100);
            if (playback.dequant_V_coeffs[n2] < 2) {
                playback.dequant_V_coeffs[n2] = 2;
            }
            playback.dequant_V_coeffs[n2] = (short)(playback.dequant_V_coeffs[n2] << 2);
            playback.dequant_Inter_Y_coeffs[n2] = (short)(n * playback.dequant_Inter_Y_coeffs[n2] / 100);
            if (playback.dequant_Inter_Y_coeffs[n2] < 4) {
                playback.dequant_Inter_Y_coeffs[n2] = 4;
            }
            playback.dequant_Inter_Y_coeffs[n2] = (short)(playback.dequant_Inter_Y_coeffs[n2] << 2);
            playback.dequant_Inter_U_coeffs[n2] = (short)(n * playback.dequant_Inter_U_coeffs[n2] / 100);
            if (playback.dequant_Inter_U_coeffs[n2] < 4) {
                playback.dequant_Inter_U_coeffs[n2] = 4;
            }
            playback.dequant_Inter_U_coeffs[n2] = (short)(playback.dequant_Inter_U_coeffs[n2] << 2);
            playback.dequant_Inter_V_coeffs[n2] = (short)(n * playback.dequant_Inter_V_coeffs[n2] / 100);
            if (playback.dequant_Inter_V_coeffs[n2] < 4) {
                playback.dequant_Inter_V_coeffs[n2] = 4;
            }
            playback.dequant_Inter_V_coeffs[n2] = (short)(playback.dequant_Inter_V_coeffs[n2] << 2);
        }
    }

    public static void UpdateQ(Playback playback, int n) {
        int n2 = n;
        if (n2 < playback.QThreshTable[63]) {
            n2 = playback.QThreshTable[63];
        } else if (n2 > playback.QThreshTable[0]) {
            n2 = playback.QThreshTable[0];
        }
        playback.FrameQIndex = 63;
        while (playback.FrameQIndex >= 0 && playback.FrameQIndex != 0 && playback.QThreshTable[playback.FrameQIndex] < n) {
            --playback.FrameQIndex;
        }
        Quant.init_dequantizer(playback, n2, (byte)playback.FrameQIndex);
    }
}

