ws_blast = function (options){
	var $ = jQuery;
	options.duration = options.duration || 1000;
	
	var boxSize = 100; 
	var distance = 1;

	var columns = 4; //Math.round(options.width/boxSize);
	var rows = 3; //Math.round(options.height/boxSize);
	var Images = [];
	var curIdx = 0;
	var partsOut;
	var partsIn;
	var $partCont;
	
	
	this.init = function(aCont){
		Images = $('img', aCont).get();
		$(Images).each(function(Index){
			if (!Index) $(this).show()
			else $(this).hide();
		});
		
		$(aCont).css({ overflow:'visible' });
		
		// create parts
		$partCont = $('<div></div>');
		aCont.append($partCont);
		$partCont.css({
			position:'absolute',
			left: (options.outWidth - options.width)/2 + 'px',
			top: (options.outHeight - options.height)/2 + 'px',
			width: options.width+'px',
			height:options.height+'px'
		});
		
		partsOut = [];
		partsIn = [];
		for (var index=0; index<columns*rows; index++){
			var i = index % columns;
			var j = Math.floor(index/columns);
			var left0 = Math.round(options.width * (i)/columns);
			var top0  = Math.round(options.height * (j)/rows);
			var left1 = Math.round(options.width * (i+1)/columns);
			var top1  = Math.round(options.height * (j+1)/rows);

			$([partsIn[index] = document.createElement('div'), partsOut[index] = document.createElement('div')])
				.css({
					position:'absolute',
					width: left1-left0,
					height: top1-top0,
					'background-position': -left0+'px -' + top0+'px'
				})
				.appendTo($partCont);
		};
		
		partsOut = $(partsOut);
		partsIn  = $(partsIn);
		
		setPos(partsOut);
		setPos(partsIn, true);		
	}
	
	function setPos(parts, random, animate){
		var pWidth  = options.width/columns;
		var pHeight = options.width/rows;
		var wpos = {
			left  : $(window).scrollLeft(),
			top   : $(window).scrollTop(),
			width : $(window).width(),
			height: $(window).height()
		};
		
		$(parts).each(function(index){
			if (random){
				var left0 = distance * options.width * (2* Math.random() -1) + options.width/2;
				var top0  = distance * options.height * (2* Math.random() -1) + options.height/2;
				var gpos = $partCont.offset();
				gpos.left += left0;
				gpos.top += top0;
				if (gpos.left < wpos.left) left0 -= gpos.left + wpos.left;
				if (gpos.top  < wpos.top)   top0  -= gpos.top  + wpos.top;
				if (gpos.left > wpos.left+wpos.width -pWidth)  left0 -= gpos.left - (wpos.left+wpos.width)  + pWidth;
				if (gpos.top  > wpos.top +wpos.height-pHeight) top0  -= gpos.top  - (wpos.top +wpos.height) + pHeight;
			}else{
				var left0 = Math.round(options.width * (index % columns)/columns);
				var top0  = Math.round(options.height * (Math.floor(index/columns))/rows);
			};
			
			if (animate)
				$(this).animate(
					{ left: left0, top: top0 },
					{ queue:false, duration:options.duration }
				)
			else
				$(this).css({ left: left0, top: top0 });
		})
	};
	
	this.go = function(new_index){
		$partCont.show();
		$(partsOut).css({
			opacity: 1,
			'background-image': 'url(' + $(Images[curIdx]).attr('src') + ')'
		});
		$(partsIn).css({
			opacity: 0,
			'background-image': 'url(' + $(Images[new_index]).attr('src') + ')'
		});
		
		
		// start 
		setPos(partsIn, false, true);
		$(partsIn).animate(
			{ opacity: 1 },
			{
				queue: false, 
				duration: options.duration, 
				complete: function(){
					$(Images[curIdx]).hide();
				} 
			}
		);
		setPos(partsOut, true, true);
		$(partsOut).animate(
			{ opacity: 0 },
			{
				queue: false, 
				duration: options.duration, 
				complete: function(){
					$(Images[new_index]).show();
					for (var i=0; i<Images.length; i++) if (new_index!=i) $(Images[i]).hide();
					$partCont.hide();
				}
			}
		);
		
		
		var tmp = partsIn; partsIn = partsOut; partsOut = tmp; // swap
		curIdx = new_index;
		return true;
	}
}
/** WowSlider version 1.0 
 * Created by WowSlider.com
 * Modified 8:58 07.12.2010
 * Using structure
 * <div id=wowslider-container>
 *	<div id=wowslider-images>
 *		<a id=wows0><img src="..."/></a>...
 *	</div>
 *	<div class=ws_bullets>
 *		<a href="#wows0"></a>...
 *	</div>
 * </div>
 */
function WowSlider(options){
	var $=jQuery;
	options = options || {};
	
	
	var $Elements = $('#wowslider-images A');

	// store text and remove from element to fix white gap in google chrome
	$Elements.each(function(index){
		var inner = $(this).html()||""; 
		var pos = inner.indexOf('>', inner);
		if (pos>=0){
			$(this).data('descr', inner.substr(pos+1));
			if (pos<inner.length-1) $(this).html(inner.substr(0,pos+1));
		};
		$(this).css({'font-size': 0});
	});
	
	
	var elementsCount = $Elements.length; // init first because effect may added self elements
	var $ws_container = $('#wowslider-container');
	var frame = $('A#wowslider-frame').get(0);
	
	
	// init engine function
	var curIdx = 0;
	function go(index){
		if (curIdx == index) return;
		
		// try run effect
		var current = effect.go(index);
		if (!current) return;
		if (typeof current != 'object') current = $Elements[index];
		
		curIdx = index;
		go2(index);
		if (options.caption) setTitle(current);
	};
	
	
	function go2(index){
		if (options.bullets) setBullet(index);
		if (frame) frame.setAttribute('href', $Elements.get(index).href);
	}
	
	// autoplay
	var autoPlayTimer;
	function restartPlay(){
		stopPlay();
		
		if (options.autoPlay)
			autoPlayTimer = setTimeout(function(){
					go(curIdx<elementsCount-1? curIdx+1: 0);
					restartPlay();
				}, 
				options.delay + options.duration
			);
	};
	function stopPlay(){
		if (autoPlayTimer) clearTimeout(autoPlayTimer);
		autoPlayTimer = null;
	};
	
	
	$Elements.find('IMG').css('position','absolute');
	
	// init effect
	var effect = new window["ws_" + options.effect](options);
	effect.init($('#wowslider-images'));
	$Elements.find('IMG').css('visibility','visible');

	
	// ---- reg
	// check and create overlay contaner
	var ic = c = $('#wowslider-images');
	var t="";
	c = t? $('<div></div>'):0;
	if (c) {
		c.css({
			position:'absolute',
			right:'2px',
			bottom:'2px',
			padding:'0 0 0 0'
		});
		ic.append(c);
	};

	// for IE use iframe
	if (c && document.all){
		var f = $('<iframe src="javascript:false"></iframe>');
		f.css({
			position:'absolute',
			left:0,
			top:0,
			width:'100%',
			height:'100%',
			filter:'alpha(opacity=0)'
		});
		
		f.attr({
			scrolling:"no",
			framespacing:0,
			border:0,
			frameBorder:"no"
		});
		
		c.append(f);
	};
	
	var d = c? $(document.createElement("A")):c;
	if(d){
		d.css({
			position:'relative',
			display:'block',
			'background-color':'#E4EFEB',
			color:'#837F80',
			'font-family':'Lucida Grande,sans-serif',
			'font-size':'11px',
			'font-weight':'normal',
			'font-style':'normal',
			'-moz-border-radius':'5px',
			'border-radius':'5px',
			padding:'1px 5px',
			width:'auto',
			height:'auto',
			margin:'0 0 0 0',
			outline:'none'
		});
		d.attr({href:'ht'+'tp://' + t.toLowerCase()});
		d.html(t);
		d.bind('contextmenu', function(eventObject){
			return false;
		});
		
		c.append(d);
	}
	// ---- reg
	
	// add arrows
	if (options.controls){
		var $next_photo = $('<a href="#" class="ws_next">'+options.next+'</a>');
		var $prev_photo = $('<a href="#" class="ws_prev">'+options.prev+'</a>');
		$ws_container.append($next_photo);
		$ws_container.append($prev_photo);
	
		/**
		* when hovering each one of the images, 
		* we show the button to navigate through them
		*
		$ws_container.live('mouseenter',function(){
			$next_photo.show();
			$prev_photo.show();
		}).live('mouseleave',function(){
			$next_photo.hide();
			$prev_photo.hide();
		});*/
		
		$next_photo.bind('click', function (e){
			stopPlay();
			e.preventDefault();
			go(curIdx<elementsCount-1? curIdx+1: 0)
			restartPlay();
		});
		$prev_photo.bind('click', function (e){
			stopPlay();
			e.preventDefault();
			go(curIdx>0? curIdx-1: elementsCount - 1);
			restartPlay();
		});
	};
	
	
	// bullets
	function initBullets(){
		$bullets = $('.ws_bullets a', $ws_container);
		$bullets.each(function(index){
			$(this).bind('click', function(e){
				stopPlay();
				e.preventDefault();
				go(index);
				restartPlay();
			});
		});
	}

	function setBullet(new_index){
		$(".ws_bullets A", $ws_container).each(function(index){
			if (index == new_index)
				$(this).addClass("ws_selbull")
			else
				$(this).removeClass("ws_selbull");
		})
	}
	
	
	// create title bar
	if (options.caption){
		$caption = $("<div class='ws-title' style='display:none'></div>");
		$ws_container.append($caption);
		$caption.bind('mouseover', function(e){ stopPlay() });
		$caption.bind('mouseout', function(e){ restartPlay() });
	}
	
	function setTitle(A){
		var title = $('img', A).attr("title");
		var descr = $(A).data('descr');
		
		var $Title = $('.ws-title', $ws_container);
		$Title.hide();
		if (title||descr){
			$Title.html((title? '<span>'+title+'</span>': '') + (descr? '<div>'+descr+'</div>': ''));
			$Title.fadeIn(400,function(){if($.browser.msie) $(this).get(0).style.removeAttribute('filter') });//css({opacity: 0}).animate({opacity: 'show'}, 400);
		}
	}
	
	// init
	if (options.bullets) initBullets();
	go2(0);
	if (options.caption) setTitle($Elements[0]);
	restartPlay();
};

// init main object
// jQuery(document).ready - conflicted with some scripts
// Transition time = 2.4s = 20/10
// SlideShow delay = 6.5s = 10/10
var wowSlider = new WowSlider({
	effect:"blast", 
	prev:"", 
	next:"", 
	duration: 10*100, 
	delay:20*100, 
	outWidth:960,
	outHeight:360,
	width:960,
	height:360,
	caption: true, 
	controls:true,
	autoPlay:true,
	bullets:true
})

