/*
 * Copyright 2009 by DISTINCT Corp
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
* Versions: 0.1    2009-06-16 Initial release
*           0.2    2009-06-17 Fixed some bugs, added initial support for submenu's
 *
 */

(function($){
  $.fn.spritemenu = function(settings) {
    var settings = $.extend({}, $.fn.spritemenu.defaults, settings);
    return this.each(function() {
      var aniParamsOrig = {};
      var aniParamsBack = {};
      $(this).children(settings.buttonselector).each(function(index) {
        var $mainlink = $(this).children('a');
        $mainlink.parent().children('ul').css('opacity',0).hide();
        $mainlink
          .css('display','block')
          .css('position','relative')
          .css('width',settings.buttonwidth)
          .css('height',settings.buttonheight)
          .css('background-image','url('+settings.grid+')')
          .css('background-repeat','no-repeat')
          .css('background-position',((0-index) * settings.buttonwidth)+'px 0px')
          .css('z-index',settings.zindex)
        .append('<span></span>').children('span')
          .css('display','block')
          .css('position','absolute')
          .css('top',0)
          .css('left',0)
          .css('width',settings.buttonwidth)
          .css('height',settings.buttonheight)
          .css('background-image','url('+settings.grid+')')
          .css('background-repeat','no-repeat')
          .css('background-position',((0-index) * settings.buttonwidth)+'px ' + (-1*settings.buttonheight) + 'px')
          .css('z-index',(settings.zindex+1));
          aniParamsOrig[settings.animate] = $mainlink.children('span').css(settings.animate);
          aniParamsBack[settings.animate] = 0;
          $mainlink.children('span').css(settings.animate,0).hide();
      }).hover(function () {
        $(this).children('a').children('span').stop().show().animate(aniParamsOrig, {queue: true, duration: settings.speed, easing: settings.easing, complete: function() {
          $(this).parent().parent().children('ul').stop().show().animate({opacity: 1}, {queue: true, duration: 'slow'});
        }});
    	},
    	function () {
        $(this).children('a').children('span').stop().animate(aniParamsBack, {queue: true, duration: settings.speed, easing: settings.easing, complete: function() {
          $(this).hide().parent().parent().children('ul').stop().animate({opacity: 0}, {queue: true, duration: 'slow'}).hide();
        }});
    	});
    });
	}
  $.fn.spritemenu.defaults = {
    grid: 'menugrid.png',
    buttonwidth: 100,
    buttonheight: 100,
    buttonselector: 'li',
    zindex: 10,
    speed: 'slow',
    easing: 'swing',
    animate: 'opacity'
  };
  function abort() {
    arguments[0] = 'spritemenu: ' + arguments[0];
    throw format.apply(null, arguments);
  }
  function format(str) {
    for (var i = 1; i < arguments.length; i++)
      str = str.replace(new RegExp('\\{' + (i-1) + '}', 'g'), arguments[i]);
    return str;
  }
})(jQuery);
