/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class BlackViper
extends Applet {
    int WIDTH = 404;
    int HEIGHT = 251;
    int BACKIMG = 0;
    int ICONIMG = 1;
    int TITLEIMG = 2;
    int BODYIMG = 3;
    int CRASHIMG = 4;
    int BUTIMG = 5;
    int LEVELFILESIZE = 5;
    boolean SOUND = true;
    boolean WIN = false;
    Color FOREGROUND = Color.black;
    Color BACKGROUND = Color.orange;
    Color LIGHTBACK = new Color(255, 255, 200);
    Color ORANGE = new Color(255, 50, 5);
    Color GREEN = new Color(74, 174, 8);
    Color YELLOW = new Color(255, 240, 1);
    Color LIGHTBLUE = new Color(73, 176, 255);
    Color BLUE = new Color(43, 78, 255);
    Color DARKORANGE = new Color(158, 123, 0);
    Font normalFont = new Font("SansSerif", 1, 12);
    Font bigFont = new Font("SansSerif", 1, 43);
    Image offImg;
    Graphics offG;
    String[] globalImageNames = new String[]{"background.jpg", "icons.gif", "title.gif", "body.gif", "crash.gif", "buttons.jpg"};
    int[] globalImageSizes = new int[]{4, 3, 4, 2, 5, 6};
    String[] globalSoundNames = new String[]{"bvcherry.au", "bvcrash.au", "bvlevel.au", "bvlife.au", "bvnix.au", "bvover.au", "bvpopup.au", "bvscrape.au", "bvstart.au", "bvtick.au", "bvturn.au", "bvclick.au", "bvdrop.au"};
    int[] globalSoundSizes = new int[]{1, 9, 19, 8, 1, 15, 2, 3, 17, 1, 2, 1, 3};
    MediaTracker mediaTracker = null;
    Image[] globalImages;
    AudioClip[] globalSounds;
    String[] globalLines;
    String levelData;
    State state = null;
    State Game = null;
    Thread loader = null;

    public void init() {
        this.levelData = "down.gif";
        String s = this.getParameter("mylevel");
        if (s != null && s.equalsIgnoreCase("true")) {
            this.levelData = "bvlevel.dat";
        }
        if ((s = this.getParameter("sound")) != null) {
            this.SOUND = !s.equalsIgnoreCase("false");
        }
        this.setFont(this.normalFont);
        this.offImg = this.createImage(this.WIDTH, this.HEIGHT);
        try {
            this.offG = this.offImg.getGraphics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.Game = new Game();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.requestFocus();
        if (this.loader == null) {
            Loader loaderState = new Loader();
            loaderState.init();
            this.loader = new Thread(loaderState);
            this.state = loaderState;
            this.loader.start();
        }
    }

    public void start() {
        this.requestFocus();
    }

    public void stop() {
        this.state.stop();
    }

    public void destroy() {
        this.Game = null;
        this.state = null;
    }

    private void jbInit() throws Exception {
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                BlackViper.this.state.keyPressed(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                BlackViper.this.state.mousePressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                BlackViper.this.state.mouseReleased(e);
            }
        });
    }

    public void update(Graphics g) {
        this.paint(this.offG);
        g.drawImage(this.offImg, 0, 0, this);
    }

    public void paint(Graphics g) {
        if (this.state != null) {
            this.state.paint(g);
        }
    }

    public void setState(State state) {
        this.state = state;
        state.init();
        this.repaint();
        Thread.yield();
    }

    public void gotoURL(String s) {
        try {
            URL myurl = new URL(s);
            this.getAppletContext().showDocument(myurl, "_blank");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void getLevel() {
        try {
            String l;
            BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(this.levelData)));
            int num = 0;
            while (in.readLine() != null) {
                ++num;
            }
            in.close();
            in = null;
            in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(this.levelData)));
            this.globalLines = new String[num];
            int i = 0;
            while ((l = in.readLine()) != null) {
                this.globalLines[i] = l;
                ++i;
            }
            in.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public Image getImage(String s) {
        if (this.mediaTracker == null) {
            this.mediaTracker = new MediaTracker(this);
        }
        Image img = null;
        try {
            DataInputStream in = new DataInputStream(this.getClass().getResourceAsStream(s));
            byte[] data = new byte[in.available()];
            in.readFully(data);
            in.close();
            img = Toolkit.getDefaultToolkit().createImage(data);
        }
        catch (Exception e) {
            img = this.getImage(this.getCodeBase(), "images/".concat(String.valueOf(String.valueOf(s))));
        }
        this.mediaTracker.addImage(img, 0);
        try {
            this.mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return img;
    }

    class Game
    implements State,
    Runnable {
        FButton bFennex;
        FButton bAdd;
        FButton bPlay;
        RepaintThread repainter;
        Thread thread;
        Vector bodyVector;
        Vector iconVector;
        Vector iconBufferVector;
        Tail tail;
        int cherry;
        int points;
        int lives;
        int level;
        int xHead;
        int yHead;
        int deltaX;
        int deltaY;
        int xMin;
        int xMax;
        int yMin;
        int yMax;
        int xCrash;
        int yCrash;
        int intCrash;
        int countDownNumber;
        int countText;
        int oilCount;
        int multiplier;
        int speedUp;
        int speedMulti;
        int cherryProLevel;
        int lifeBuffer;
        int dir;
        int dx;
        int dy;
        long threadDelay;
        int[] xMem = new int[435];
        int[] yMem = new int[435];
        boolean running;
        boolean runAnimation;
        boolean showText;
        boolean gameOver;
        boolean kingMode;
        boolean suddenDeath;
        boolean paused;
        boolean pausedOver;
        boolean collision;
        boolean soundOn;
        boolean crashLoop;
        String infoText;
        FontMetrics fm;
        Graphics g;

        Game() {
        }

        public void init() {
            this.cherryProLevel = 15;
            this.threadDelay = 20L;
            this.dir = 1;
            this.paused = false;
            this.pausedOver = false;
            this.suddenDeath = false;
            this.level = 0;
            this.points = 0;
            this.lives = 100;
            this.xMem[0] = 25;
            this.yMem[0] = 68;
            this.xHead = this.xMem[0] - 1;
            this.yHead = this.yMem[0] - 2;
            this.xMin = 0;
            this.xMax = 404;
            this.yMin = 0;
            this.yMax = 251;
            for (int i = 1; i < this.xMem.length; ++i) {
                this.xMem[i] = this.xMem[0];
                this.yMem[i] = this.yMem[0];
            }
            this.g = BlackViper.this.getGraphics();
            this.fm = this.g.getFontMetrics();
            this.runAnimation = false;
            this.kingMode = false;
            this.showText = false;
            this.gameOver = false;
            this.soundOn = true;
            this.bFennex = new FButton(BlackViper.this.globalImages[BlackViper.this.BUTIMG], 2, 3, 314, 9);
            this.bAdd = new FButton(BlackViper.this.globalImages[BlackViper.this.BUTIMG], 0, 1, 314, 25);
            this.bPlay = new FButton(BlackViper.this.globalImages[BlackViper.this.BUTIMG], 4, 5, 172, 95);
            this.tail = new Tail(this.xMem[0], this.yMem[0], BlackViper.this.globalImages[BlackViper.this.BODYIMG]);
            this.bodyVector = new Vector();
            this.addBody(3);
            this.iconVector = new Vector();
            this.iconBufferVector = new Vector();
            this.newLevel();
        }

        public void stop() {
            this.pause(true);
        }

        public void newLevel() {
            this.kingMode = false;
            this.speedMulti = 1;
            this.multiplier = 1;
            this.oilCount = 0;
            this.countText = 0;
            this.countDownNumber = 0;
            this.multiplier = 1;
            this.xMem[0] = 25;
            this.yMem[0] = 68;
            this.xHead = this.xMem[0] - 1;
            this.yHead = this.yMem[0] - 2;
            for (int i = 1; i < this.xMem.length; ++i) {
                this.xMem[i] = this.xMem[0];
                this.yMem[i] = this.yMem[0];
            }
            this.bodyVector.removeAllElements();
            this.iconVector.removeAllElements();
            this.addBody(3);
            this.tail = new Tail(this.xMem[0], this.yMem[0], BlackViper.this.globalImages[BlackViper.this.BODYIMG]);
            this.cherry = 0;
            ++this.level;
            BlackViper.this.WIN = this.setWalls(this.level);
            if (BlackViper.this.WIN) {
                --this.level;
            }
            boolean b = false;
            for (int i = 0; i < this.iconVector.size(); ++i) {
                Icon ic = (Icon)this.iconVector.elementAt(i);
                if (ic.getID() != 9) continue;
                b = true;
                break;
            }
            if (!b) {
                this.addIcon(9);
            }
            BlackViper.this.repaint();
            if (!BlackViper.this.WIN) {
                this.thread = null;
                this.thread = new Thread((Runnable)this, "BlackViper Game Thread");
                this.thread.start();
            }
        }

        public void addBody(int howMany) {
            int i;
            int s = this.bodyVector.size();
            for (i = 7 * (s + 1) + 1; i < 7 * (howMany + s + 1) + 1; ++i) {
                this.xMem[i] = this.xMem[7 * (s + 1) + 1];
                this.yMem[i] = this.yMem[7 * (s + 1) + 1];
            }
            for (i = 0; i < howMany; ++i) {
                Body b = new Body(this.xMem[7 * s + 1], this.yMem[7 * s + 1], BlackViper.this.globalImages[BlackViper.this.BODYIMG]);
                this.bodyVector.addElement(b);
            }
        }

        public boolean detectCollision(int x, int y, int width) {
            boolean b = this.xHead < x + width && this.xHead + 15 > x && this.yHead < y + width && this.yHead + 15 > y;
            return b;
        }

        public boolean detectCollision(int x, int y, int width, int contractHead) {
            boolean b = this.xHead + contractHead < x + width && this.xHead + 15 - contractHead > x && this.yHead + contractHead < y + width && this.yHead + 15 - contractHead > y;
            return b;
        }

        public void pause(boolean b) {
            this.paused = b;
            if (!b) {
                this.thread = new Thread((Runnable)this, "BlackViper Game Thread");
                this.thread.start();
                this.pausedOver = true;
                this.showText = false;
                if (this.crashLoop && this.soundOn && BlackViper.this.SOUND) {
                    BlackViper.this.globalSounds[7].loop();
                }
                BlackViper.this.repaint(50, 64, 300, 16);
            } else {
                this.thread = null;
                if (this.crashLoop && BlackViper.this.SOUND) {
                    BlackViper.this.globalSounds[7].stop();
                }
                this.setText("Game paused. Press 'P' to continue");
            }
        }

        public void scanForRepaintRect() {
            this.xMin = this.xHead;
            this.xMax = this.xHead;
            this.yMin = this.yHead;
            this.yMax = this.yHead;
            for (int i = 1; i < this.bodyVector.size() + 2; ++i) {
                if (this.xMin > this.xMem[7 * i + 1]) {
                    this.xMin = this.xMem[7 * i + 1];
                }
                if (this.xMax < this.xMem[7 * i + 1]) {
                    this.xMax = this.xMem[7 * i + 1];
                }
                if (this.yMin > this.yMem[7 * i + 1]) {
                    this.yMin = this.yMem[7 * i + 1];
                }
                if (this.yMax >= this.yMem[7 * i + 1]) continue;
                this.yMax = this.yMem[7 * i + 1];
            }
            this.xMin -= 10;
            this.yMin -= 10;
            this.xMax += 20;
            this.yMax += 20;
        }

        public void addIcon(int iconID) {
            int i;
            int x = (int)((double)373 * Math.random() + (double)8);
            int y = (int)((double)179 * Math.random() + (double)50);
            if (this.xHead < x + 15 && this.xHead + 15 > x && this.yHead < x + 15 && this.yHead > y) {
                this.addIcon(iconID);
                return;
            }
            for (i = 1; i < this.bodyVector.size() + 2; ++i) {
                if (this.xMem[7 * i + 1] >= x + 15 || this.xMem[7 * i + 1] + 15 <= x || this.yMem[7 * i + 1] >= y + 15 || this.yMem[7 * i + 1] + 15 <= y) continue;
                this.addIcon(iconID);
                return;
            }
            for (i = 0; i < this.iconVector.size(); ++i) {
                Icon ic = (Icon)this.iconVector.elementAt(i);
                int ix = ic.getX();
                int iy = ic.getY();
                if (ix >= x + 15 || ix + 15 <= x || iy >= y + 15 || iy + 15 <= y) continue;
                this.addIcon(iconID);
                return;
            }
            Icon ic = new Icon(BlackViper.this.globalImages[BlackViper.this.ICONIMG], iconID, x, y);
            this.iconVector.addElement(ic);
            BlackViper.this.repaint(x, y, 15, 15);
        }

        public void addIcon(int iconID, int howMany) {
            for (int i = 0; i < howMany; ++i) {
                this.addIcon(iconID);
            }
        }

        public void addIcon(int x, int y, int id) {
            Icon ic = new Icon(BlackViper.this.globalImages[BlackViper.this.ICONIMG], id, x + 7, y + 49);
            this.iconVector.addElement(ic);
        }

        public void gotAnIcon(int id, int index) {
            block41: {
                if (this.kingMode && id != 9 && id != 6 && id != 7) {
                    id = 0;
                }
                if (id > 3 && id != 13) {
                    Icon ic = (Icon)this.iconVector.elementAt(index);
                    int x = ic.getX();
                    int y = ic.getY();
                    this.iconVector.removeElementAt(index);
                    BlackViper.this.repaint(x, y, 15, 15);
                }
                block0 : switch (id) {
                    case 9: {
                        this.points += this.multiplier;
                        ++this.cherry;
                        this.playSound(0);
                        if (this.cherry >= this.cherryProLevel) {
                            this.running = false;
                            break;
                        }
                        for (int i = 0; i < this.iconBufferVector.size(); ++i) {
                            IconBuffer ib = (IconBuffer)this.iconBufferVector.elementAt(i);
                            ib.randomCheck();
                        }
                        this.addBody(3);
                        this.addIcon(9);
                        break;
                    }
                    case 7: {
                        ++this.points;
                        this.playSound(3);
                        this.lives += (int)((double)40 * Math.random()) + 10;
                        if (this.lives > 500) {
                            this.lives = 500;
                        }
                        this.setText("More Health");
                        break;
                    }
                    case 8: {
                        this.playSound(12);
                        this.points += 5;
                        int height = 46;
                        if (this.yHead + height > 229) {
                            height = 229 - this.yHead + 1;
                        }
                        for (int i = 0; i < 7 * (this.bodyVector.size() + 1); ++i) {
                            this.yMem[i] = this.yMem[i] + height;
                        }
                        this.yHead += height;
                        this.setText("2 inch Drop-Down");
                        BlackViper.this.repaint();
                        break;
                    }
                    case 6: {
                        this.playSound(3);
                        int ii = (int)(Math.random() * (double)15) + 2;
                        this.points += this.multiplier * ii;
                        this.setText("Extra Cash");
                        break;
                    }
                    case 5: {
                        this.playSound(11);
                        this.dx = 1;
                        this.dy = 1;
                        if (Math.random() < 0.5) {
                            this.dx = -1;
                        }
                        if (Math.random() < 0.5) {
                            this.dy = -1;
                        }
                        ++this.points;
                        this.oilCount = this.oilCount >= 1 ? 2 : 1;
                        this.setText("Attention: Oil on road!");
                        break;
                    }
                    case 4: {
                        this.playSound(0);
                        this.points += 3;
                        this.speedUp = this.speedUp > 1 ? 2 : 1;
                        this.setText("Speed Up");
                        break;
                    }
                    case 11: {
                        this.playSound(3);
                        this.kingMode = true;
                        this.points += 2;
                        this.setText("You are the King");
                        break;
                    }
                    case 13: {
                        this.running = false;
                        this.runAnimation = true;
                        this.suddenDeath = true;
                        break;
                    }
                    case 10: {
                        this.playSound(9);
                        this.setText("Turn the Switch");
                        this.points += 2;
                        int s = 7 * (this.bodyVector.size() + 1);
                        int sx = s / 2;
                        for (int i = 0; i < sx; ++i) {
                            int a = this.xMem[s - i];
                            this.xMem[s - i] = this.xMem[i];
                            this.xMem[i] = a;
                            a = this.yMem[s - i];
                            this.yMem[s - i] = this.yMem[i];
                            this.yMem[i] = a;
                        }
                        this.deltaX = 0;
                        this.deltaY = 0;
                        switch (this.tail.getDir()) {
                            case 12: {
                                this.deltaX = 2;
                                break block0;
                            }
                            case 24: {
                                this.deltaX = -2;
                                break block0;
                            }
                            case 36: {
                                this.deltaY = 2;
                                break block0;
                            }
                            case 48: {
                                this.deltaY = -2;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 1: {
                        if (!this.kingMode) {
                            if (this.deltaY != 0) {
                                this.deltaY = 0;
                                this.deltaX = Math.random() > 0.5 ? 2 : -2;
                            }
                            --this.lives;
                            this.collision = true;
                        }
                        BlackViper.this.repaint(210, 27, 82, 8);
                        break;
                    }
                    case 2: {
                        if (!this.kingMode) {
                            if (this.deltaX != 0) {
                                this.deltaX = 0;
                                this.deltaY = Math.random() > 0.5 ? 2 : -2;
                            }
                            --this.lives;
                            this.collision = true;
                        }
                        BlackViper.this.repaint(210, 27, 82, 8);
                        break;
                    }
                    case 3: {
                        if (!this.kingMode) {
                            Icon ic = (Icon)this.iconVector.elementAt(index);
                            int x = ic.getX();
                            int y = ic.getY();
                            if (this.deltaY == 0) {
                                this.deltaX = 0;
                                if (this.deltaY - y < -11) {
                                    this.deltaY = -2;
                                } else if (this.deltaY - y > 9) {
                                    this.deltaY = 2;
                                } else {
                                    int n = this.deltaY = Math.random() > 0.5 ? 2 : -2;
                                }
                            }
                            if (this.deltaX == 0) {
                                this.deltaY = 0;
                                this.deltaX = this.deltaX - x < -11 ? -2 : (this.deltaX - x > 9 ? 2 : (Math.random() > 0.5 ? 2 : -2));
                            }
                            --this.lives;
                            this.collision = true;
                        }
                        BlackViper.this.repaint(210, 27, 82, 8);
                        break;
                    }
                }
                BlackViper.this.repaint(120, 8, 190, 33);
                if (this.points % 100 != 0 || this.points <= 0 || id <= 3) break block41;
                this.addIcon(11);
                this.playSound(6);
            }
        }

        public void setText(String s) {
            this.infoText = s;
            this.showText = true;
            this.countText = 0;
            BlackViper.this.repaint(50, 64, 300, 16);
        }

        public void run() {
            block46: {
                block45: {
                    int i;
                    if (!this.pausedOver) {
                        int i2;
                        if (this.level > 1) {
                            this.playSound(2);
                            this.setText(String.valueOf(String.valueOf(new StringBuffer("Level: ").append(String.valueOf(this.level)).append(" - Cherry: ").append(String.valueOf(this.cherryProLevel)))));
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        BlackViper.this.repaint();
                        for (i2 = 3; i2 > 0; --i2) {
                            this.countDownNumber = i2;
                            this.playSound(9);
                            BlackViper.this.repaint(180, 80, 50, 50);
                            try {
                                Thread.sleep(1000L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        this.showText = false;
                        this.countDownNumber = 0;
                        BlackViper.this.repaint();
                        this.running = true;
                        switch (this.dir) {
                            case 1: {
                                this.lifeBuffer = 3;
                                break;
                            }
                            case 2: {
                                this.lifeBuffer = 6;
                            }
                        }
                        for (i2 = 0; i2 < this.iconBufferVector.size(); ++i2) {
                            IconBuffer ib = (IconBuffer)this.iconBufferVector.elementAt(i2);
                            ib.randomCheck();
                        }
                        this.playSound(8);
                    }
                    this.repainter = new RepaintThread(25);
                    this.repainter.startThread();
                    this.pausedOver = false;
                    this.crashLoop = false;
                    while (this.running && !this.paused) {
                        long afterTime;
                        long delta;
                        int i3;
                        long beforeTime = System.currentTimeMillis();
                        if (this.speedUp == 1) {
                            ++this.multiplier;
                            this.speedMulti = 2;
                        }
                        if (this.speedUp > 0) {
                            ++this.speedUp;
                            if (this.speedUp > 120) {
                                --this.multiplier;
                                this.speedMulti = 1;
                                this.speedUp = 0;
                            }
                        }
                        for (i = this.xMem.length - 1; i > 0; --i) {
                            this.xMem[i] = this.xMem[i - 1];
                            this.yMem[i] = this.yMem[i - 1];
                        }
                        this.xMem[0] = this.xMem[0] + this.deltaX * this.speedMulti;
                        this.yMem[0] = this.yMem[0] + this.deltaY * this.speedMulti;
                        this.xHead = this.xMem[0] - 1;
                        this.yHead = this.yMem[0] - 2;
                        int s = this.bodyVector.size();
                        for (i3 = 0; i3 < s; ++i3) {
                            Body b = (Body)this.bodyVector.elementAt(i3);
                            b.move(this.xMem[7 * (i3 + 1) + 1], this.yMem[7 * (i3 + 1) + 1]);
                        }
                        this.tail.move(this.xMem[7 * (s + 1) + 1], this.yMem[7 * (s + 1) + 1], this.xMem[7 * (s + 1)], this.yMem[7 * (s + 1)]);
                        if (this.oilCount == 1) {
                            this.multiplier += 2;
                        }
                        if (this.oilCount > 0) {
                            for (i3 = 0; i3 < 7 * (this.bodyVector.size() + 1); ++i3) {
                                this.xMem[i3] = this.xMem[i3] + this.dx;
                                this.yMem[i3] = this.yMem[i3] + this.dy;
                            }
                            this.xHead += this.dx;
                            this.yHead += this.dy;
                            ++this.oilCount;
                            if (this.oilCount > 40 || this.xHead < 6 || this.xHead > 382 || this.yHead > 229 || this.yHead < 48) {
                                this.oilCount = 0;
                                this.multiplier -= 2;
                            }
                        }
                        this.collision = false;
                        for (i3 = 2; i3 < s + 2; ++i3) {
                            boolean bb = this.detectCollision(this.xMem[7 * i3 + 1] + 4, this.yMem[7 * i3 + 1] + 4, 4, 5);
                            if (!bb) continue;
                            if (this.lifeBuffer > 0) {
                                --this.lifeBuffer;
                                continue;
                            }
                            if (!this.kingMode) {
                                --this.lives;
                                this.collision = true;
                            }
                            BlackViper.this.repaint(210, 27, 82, 8);
                        }
                        for (i3 = 0; i3 < this.iconVector.size(); ++i3) {
                            Icon ic = (Icon)this.iconVector.elementAt(i3);
                            int a = ic.detectCollision(this.xHead, this.yHead);
                            if (a <= 0) continue;
                            this.gotAnIcon(a, i3);
                        }
                        if (this.yHead > 229 || this.yHead < 48) {
                            if (!this.kingMode && this.deltaY != 0) {
                                this.deltaY = 0;
                                this.deltaX = Math.random() > 0.5 ? 2 : -2;
                            }
                            --this.lives;
                            this.collision = true;
                            BlackViper.this.repaint(210, 27, 82, 8);
                        }
                        if (this.xHead < 6 || this.xHead > 382) {
                            if (this.deltaX != 0) {
                                this.deltaX = 0;
                                this.deltaY = Math.random() > 0.5 ? 2 : -2;
                            }
                            --this.lives;
                            this.collision = true;
                            BlackViper.this.repaint(210, 27, 82, 8);
                        }
                        if (this.collision && !this.crashLoop && this.soundOn && BlackViper.this.SOUND) {
                            BlackViper.this.globalSounds[7].loop();
                            this.crashLoop = true;
                        }
                        if (!this.collision && this.crashLoop && BlackViper.this.SOUND) {
                            BlackViper.this.globalSounds[7].stop();
                            this.crashLoop = false;
                        }
                        if (this.showText) {
                            ++this.countText;
                            if (this.countText >= 50) {
                                this.countText = 0;
                                this.showText = false;
                                BlackViper.this.repaint(50, 64, 300, 16);
                            }
                        }
                        if (this.lives < 1) {
                            this.running = false;
                            this.runAnimation = true;
                        }
                        if ((delta = (afterTime = System.currentTimeMillis()) - beforeTime) > (long)10) {
                            delta = 10L;
                        }
                        try {
                            Thread.sleep(this.threadDelay - delta);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                            break;
                        }
                    }
                    this.repainter.stopThread();
                    this.repainter = null;
                    if (this.crashLoop && BlackViper.this.SOUND) {
                        BlackViper.this.globalSounds[1].stop();
                    }
                    if (!this.runAnimation) break block45;
                    if (BlackViper.this.SOUND) {
                        BlackViper.this.globalSounds[7].stop();
                    }
                    this.playSound(1);
                    this.xCrash = this.xHead - 12;
                    this.yCrash = this.yHead - 7;
                    i = 0;
                    while (i < 22) {
                        this.intCrash = i++;
                        BlackViper.this.repaint(this.xCrash, this.yCrash, 40, 30);
                        try {
                            Thread.sleep(60L);
                        }
                        catch (InterruptedException ie) {
                            break;
                        }
                    }
                    if (this.suddenDeath) {
                        this.setText("Sudden Death, Game Over");
                    } else {
                        this.setText("Game Over");
                    }
                    this.runAnimation = false;
                    this.gameOver = true;
                    BlackViper.this.repaint(this.xCrash, this.yCrash, 40, 30);
                    BlackViper.this.repaint(170, 95, 61, 16);
                    break block46;
                }
                if (this.paused) break block46;
                this.newLevel();
            }
        }

        public void paint(Graphics g) {
            int i;
            for (i = 0; i < 5; ++i) {
                for (int a = 0; a < 4; ++a) {
                    g.drawImage(BlackViper.this.globalImages[BlackViper.this.BACKIMG], 100 * i, 100 * a, null);
                }
            }
            g.setFont(BlackViper.this.normalFont);
            g.setColor(BlackViper.this.DARKORANGE);
            g.drawString("Copyright Fennex 2002", 265, 241);
            g.setColor(BlackViper.this.FOREGROUND);
            for (i = 11; i < 404; i += 15) {
                g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], i, -4, i + 15, 11, 15, 0, 30, 15, null);
                g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], i, 240, i + 15, 255, 15, 0, 30, 15, null);
                g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], i, 38, i + 15, 53, 15, 0, 30, 15, null);
            }
            for (i = 11; i < 260; i += 15) {
                g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], -4, i, 11, i + 15, 30, 0, 45, 15, null);
                g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], 393, i, 408, i + 15, 30, 0, 45, 15, null);
            }
            g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], -4, -4, 11, 11, 45, 0, 60, 15, null);
            g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], 393, -4, 408, 11, 45, 0, 60, 15, null);
            g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], -4, 240, 11, 255, 45, 0, 60, 15, null);
            g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], 393, 240, 408, 255, 45, 0, 60, 15, null);
            g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], -4, 38, 11, 53, 45, 0, 60, 15, null);
            g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], 393, 38, 408, 53, 45, 0, 60, 15, null);
            g.drawRect(0, 0, BlackViper.this.WIDTH - 1, BlackViper.this.HEIGHT - 1);
            g.drawImage(BlackViper.this.globalImages[BlackViper.this.TITLEIMG], 9, 8, null);
            this.bFennex.paint(g);
            this.bAdd.paint(g);
            for (i = 0; i < this.iconVector.size(); ++i) {
                Icon ic = (Icon)this.iconVector.elementAt(i);
                ic.paint(g);
            }
            g.setFont(BlackViper.this.normalFont);
            g.drawString("Points:", 125, 22);
            g.drawString(String.valueOf(this.points), 170, 22);
            g.drawString("Level:", 125, 36);
            g.drawString(String.valueOf(this.level), 170, 36);
            g.drawString("Cherry:", 210, 22);
            g.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(String.valueOf(this.cherry)))).append("/").append(String.valueOf(this.cherryProLevel)))), 255, 22);
            g.setColor(Color.black);
            g.drawRect(209, 27, 81, 8);
            int z = (this.lives - 1) / 100;
            switch (z) {
                case 4: 
                case 5: {
                    g.setColor(BlackViper.this.BLUE);
                    break;
                }
                case 3: {
                    g.setColor(BlackViper.this.LIGHTBLUE);
                    break;
                }
                case 2: {
                    g.setColor(BlackViper.this.GREEN);
                    break;
                }
                case 1: {
                    g.setColor(BlackViper.this.YELLOW);
                    break;
                }
                case 0: {
                    g.setColor(BlackViper.this.ORANGE);
                }
            }
            if (this.lives > 0) {
                int l = this.lives % 100;
                if (l == 0) {
                    l = 100;
                }
                int w = (int)(0.8 * (double)l);
                g.fillRect(210, 28, w, 7);
            }
            if (!BlackViper.this.WIN) {
                this.tail.paint(g);
                for (int i2 = this.bodyVector.size() - 1; i2 >= 0; --i2) {
                    Body b = (Body)this.bodyVector.elementAt(i2);
                    b.paint(g);
                }
                if (this.kingMode) {
                    g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], this.xHead, this.yHead, this.xHead + 15, this.yHead + 15, 180, 0, 195, 15, null);
                } else {
                    g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], this.xHead, this.yHead, this.xHead + 15, this.yHead + 15, 0, 0, 15, 15, null);
                }
            }
            if (this.showText) {
                int wi = this.fm.stringWidth(this.infoText);
                int x = (404 - wi) / 2;
                g.setColor(BlackViper.this.LIGHTBACK);
                g.fillRect(x - 7, 65, wi + 13, 14);
                g.setColor(BlackViper.this.BLUE);
                g.drawRect(x - 7, 65, wi + 13, 14);
                g.drawString(this.infoText, x, 77);
            }
            if (this.countDownNumber > 0) {
                g.setColor(BlackViper.this.BACKGROUND);
                g.fillOval(182, 84, 40, 40);
                g.setFont(BlackViper.this.bigFont);
                g.setColor(BlackViper.this.BLUE);
                FontMetrics fm2 = g.getFontMetrics(BlackViper.this.bigFont);
                String s = String.valueOf(this.countDownNumber);
                int x = (BlackViper.this.WIDTH - fm2.stringWidth(s)) / 2;
                g.drawString(s, x, 120);
                switch (this.dir) {
                    case 1: {
                        g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], this.xHead + 18, this.yHead + 1, this.xHead + 33, this.yHead + 16, 210, 0, 225, 15, null);
                        break;
                    }
                    case 2: {
                        g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], this.xHead, this.yHead + 18, this.xHead + 15, this.yHead + 33, 225, 0, 240, 15, null);
                    }
                }
            }
            if (this.gameOver) {
                this.bPlay.paint(g);
                g.setColor(BlackViper.this.BACKGROUND);
                g.drawRect(171, 94, 61, 16);
            }
            if (this.runAnimation) {
                g.drawImage(BlackViper.this.globalImages[BlackViper.this.CRASHIMG], this.xCrash, this.yCrash, this.xCrash + 40, this.yCrash + 30, 40 * this.intCrash, 0, 40 * this.intCrash + 40, 30, null);
            }
            if (BlackViper.this.WIN) {
                g.setFont(new Font("TimesRoman", 1, 25));
                g.setColor(Color.black);
                g.drawString("You have won it all!", 95, 85);
                g.setFont(new Font("TimesRoman", 1, 20));
                g.setColor(BlackViper.this.BLUE);
                g.drawString("Your Score:", 120, 150);
                g.drawString(String.valueOf(this.points), 240, 150);
                g.setColor(Color.black);
                g.setFont(BlackViper.this.normalFont);
                g.drawString("Thanks for playing BlackViper", 118, 180);
                this.bPlay.paint(g);
            }
        }

        public void mousePressed(MouseEvent e) {
            int y;
            int x = e.getX();
            if (this.bFennex.checkMousePressed(x, y = e.getY())) {
                // empty if block
            }
            if (this.bAdd.checkMousePressed(x, y)) {
                // empty if block
            }
            if (this.bPlay.checkMousePressed(x, y) && this.gameOver) {
                BlackViper.this.repaint(170, 95, 61, 16);
            }
            BlackViper.this.repaint(300, 8, 100, 34);
        }

        public void mouseReleased(MouseEvent e) {
            int y;
            int x = e.getX();
            if (this.bFennex.checkMouseReleased(x, y = e.getY()) == 2) {
                this.playSound(11);
                BlackViper.this.gotoURL("http://www.fennex.de");
            }
            if (this.bAdd.checkMouseReleased(x, y) == 2) {
                this.playSound(11);
                BlackViper.this.gotoURL("http://www.fennex.de/web/add/blackviper.html");
            }
            if (this.bPlay.checkMouseReleased(x, y) == 2 && (this.gameOver || BlackViper.this.WIN)) {
                BlackViper.this.repaint(170, 95, 61, 16);
                this.lives = 100;
                this.showText = false;
                this.gameOver = false;
                this.runAnimation = false;
                this.points = 0;
                this.level = 0;
                this.newLevel();
            }
            BlackViper.this.repaint(300, 8, 100, 34);
        }

        public void playSound(int number) {
            if (this.soundOn && BlackViper.this.SOUND) {
                BlackViper.this.globalSounds[number].play();
                BlackViper.this.globalSounds[4].play();
            }
        }

        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 39: {
                    if (this.deltaX == -2 || !this.running || this.paused) break;
                    this.deltaX = 2;
                    this.deltaY = 0;
                    this.playSound(10);
                    break;
                }
                case 37: {
                    if (this.deltaX == 2 || !this.running || this.paused) break;
                    this.deltaX = -2;
                    this.deltaY = 0;
                    this.playSound(10);
                    break;
                }
                case 40: {
                    if (this.deltaY == -2 || !this.running || this.paused) break;
                    this.deltaX = 0;
                    this.deltaY = 2;
                    this.playSound(10);
                    break;
                }
                case 38: {
                    if (this.deltaY == 2 || !this.running || this.paused) break;
                    this.deltaX = 0;
                    this.deltaY = -2;
                    this.playSound(10);
                    break;
                }
                case 80: {
                    if (this.countDownNumber != 0 || this.runAnimation || this.gameOver || !this.running) break;
                    this.playSound(11);
                    this.pause(!this.paused);
                    break;
                }
                case 83: {
                    if (!BlackViper.this.SOUND) break;
                    boolean bl = this.soundOn = !this.soundOn;
                    if (this.soundOn) {
                        this.setText("Sound: ON");
                    } else {
                        this.setText("Sound: OFF");
                    }
                    this.playSound(11);
                    break;
                }
                case 88: {
                    this.running = false;
                    break;
                }
                case 89: {
                    this.level -= 2;
                    this.running = false;
                }
            }
        }

        public boolean setWalls(int level) {
            int t;
            int y;
            String[] lines;
            this.iconVector.removeAllElements();
            this.iconBufferVector.removeAllElements();
            if (4 * (level - 1) < BlackViper.this.globalLines.length) {
                lines = new String[4];
                for (int i = 0; i < 4; ++i) {
                    lines[i] = BlackViper.this.globalLines[4 * (level - 1) + i];
                }
                try {
                    while (lines[0].length() > 0) {
                        int x = Integer.parseInt(lines[0].substring(0, lines[0].indexOf(",")));
                        y = Integer.parseInt(lines[1].substring(0, lines[1].indexOf(",")));
                        t = Integer.parseInt(lines[2].substring(0, lines[2].indexOf(",")));
                        lines[0] = lines[0].substring(lines[0].indexOf(",") + 1, lines[0].length());
                        lines[1] = lines[1].substring(lines[1].indexOf(",") + 1, lines[1].length());
                        lines[2] = lines[2].substring(lines[2].indexOf(",") + 1, lines[2].length());
                        this.addIcon(x, y, t);
                    }
                }
                catch (Exception x) {
                    // empty catch block
                }
            } else {
                return true;
            }
            int x = Integer.parseInt(lines[0]);
            y = Integer.parseInt(lines[1]);
            t = Integer.parseInt(lines[2]);
            this.addIcon(x, y, t);
            String s = lines[3].substring(0, 1);
            this.dir = Integer.parseInt(s);
            String ch = lines[3].substring(2);
            this.cherryProLevel = Integer.parseInt(ch);
            if (this.dir == 1) {
                this.deltaX = 2;
                this.deltaY = 0;
            } else {
                this.deltaX = 0;
                this.deltaY = 2;
            }
            IconBuffer ib = new IconBuffer(7, 1.0, this.cherryProLevel);
            IconBuffer ib2 = new IconBuffer(6, 0.5, this.cherryProLevel);
            this.iconBufferVector.addElement(ib);
            this.iconBufferVector.addElement(ib2);
            return false;
        }

        public class RepaintThread
        extends Thread {
            long delay;
            long delta;
            boolean running;

            public RepaintThread(int fps) {
                this.delay = 1000 / fps;
                this.delta = 0L;
                this.running = false;
                this.setName("BlackViper Repaint Thread");
            }

            public void stopThread() {
                this.running = false;
            }

            public void startThread() {
                this.running = true;
                this.start();
            }

            public boolean isRunning() {
                return this.running;
            }

            public void run() {
                long lastTime = System.currentTimeMillis();
                long curTime = 0L;
                while (this.running) {
                    Game.this.scanForRepaintRect();
                    BlackViper.this.repaint(Game.this.xMin, Game.this.yMin, Game.this.xMax - Game.this.xMin, Game.this.yMax - Game.this.yMin);
                    Thread.yield();
                    curTime = System.currentTimeMillis();
                    this.delta = this.delay - (long)((int)(curTime - lastTime));
                    if (this.delta < (long)10) {
                        this.delta = 10L;
                    }
                    try {
                        Thread.sleep(this.delta);
                    }
                    catch (InterruptedException ie) {
                        System.out.println(ie);
                        break;
                    }
                    lastTime = System.currentTimeMillis();
                }
            }
        }

        public class IconBuffer
        implements Runnable {
            int iconID;
            double howMany;
            double bodies;
            Thread thread;

            public IconBuffer(int iconID, double howMany, double bodies) {
                this.iconID = iconID;
                this.howMany = howMany;
                this.bodies = bodies;
                if (howMany > bodies) {
                    howMany = bodies;
                }
            }

            public void randomCheck() {
                double d = this.howMany / this.bodies;
                double r = Math.random();
                if (r < d) {
                    this.thread = new Thread((Runnable)this, "BlackViper TimeOut Thread");
                    this.thread.start();
                }
            }

            public void run() {
                long ms = (long)(Math.random() * (double)3000) + (long)500;
                try {
                    Thread.sleep(ms);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Game.this.addIcon(this.iconID);
                Game.this.playSound(6);
            }
        }
    }

    class Loader
    implements State,
    Runnable {
        int totalKb = 0;
        int loaded = 0;
        int loadedKb = 0;
        long start = 0L;
        int barWidth = 300;
        int barX;
        int barY;
        String mm;

        Loader() {
        }

        public void init() {
            int a;
            for (a = 0; a < BlackViper.this.globalImageSizes.length; ++a) {
                this.totalKb += BlackViper.this.globalImageSizes[a];
            }
            if (BlackViper.this.SOUND) {
                for (a = 0; a < BlackViper.this.globalSoundSizes.length; ++a) {
                    this.totalKb += BlackViper.this.globalSoundSizes[a];
                }
            }
            this.totalKb += BlackViper.this.LEVELFILESIZE;
            BlackViper.this.globalImages = new Image[BlackViper.this.globalImageNames.length];
            BlackViper.this.globalSounds = new AudioClip[BlackViper.this.globalSoundNames.length];
            this.barX = (BlackViper.this.WIDTH - this.barWidth) / 2;
            this.barY = (BlackViper.this.HEIGHT - 19) / 2 - 5;
            this.mm = "Loading images...";
        }

        public void run() {
            int a;
            for (a = 0; a < BlackViper.this.globalImageNames.length; ++a) {
                BlackViper.this.repaint();
                BlackViper.this.globalImages[a] = BlackViper.this.getImage(BlackViper.this.globalImageNames[a]);
                ++this.loaded;
                this.loadedKb += BlackViper.this.globalImageSizes[a];
            }
            this.mm = "Loading levels...";
            BlackViper.this.repaint();
            BlackViper.this.getLevel();
            this.loadedKb += BlackViper.this.LEVELFILESIZE;
            if (BlackViper.this.SOUND) {
                this.mm = "Loading sounds...";
                for (a = 0; a < BlackViper.this.globalSoundNames.length; ++a) {
                    BlackViper.this.repaint();
                    BlackViper.this.globalSounds[a] = BlackViper.this.getAudioClip(BlackViper.this.getCodeBase(), "audio/".concat(String.valueOf(String.valueOf(BlackViper.this.globalSoundNames[a]))));
                    ++this.loaded;
                    this.loadedKb += BlackViper.this.globalSoundSizes[a];
                }
            }
            BlackViper.this.repaint();
            BlackViper.this.setState(BlackViper.this.Game);
            BlackViper.this.repaint();
        }

        private void drawRect(Graphics g, int x, int y, int w, int h, Color fill, Color outline, boolean innen) {
            if (innen) {
                g.setColor(fill);
                g.fillRect(x, y, w, h);
            }
            g.setColor(outline);
            g.drawRect(x, y, w, h);
        }

        public void paint(Graphics g) {
            g.setFont(BlackViper.this.normalFont);
            g.setColor(BlackViper.this.BACKGROUND);
            g.fillRect(0, 0, BlackViper.this.WIDTH - 1, BlackViper.this.HEIGHT - 1);
            if (this.loaded > 1) {
                int i;
                for (i = 0; i < 5; ++i) {
                    for (int a = 0; a < 4; ++a) {
                        g.drawImage(BlackViper.this.globalImages[BlackViper.this.BACKIMG], 100 * i, 100 * a, null);
                    }
                }
                for (i = 11; i < 404; i += 15) {
                    g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], i, -4, i + 15, 11, 15, 0, 30, 15, null);
                    g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], i, 240, i + 15, 255, 15, 0, 30, 15, null);
                }
                for (i = 11; i < 260; i += 15) {
                    g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], -4, i, 11, i + 15, 30, 0, 45, 15, null);
                    g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], 393, i, 408, i + 15, 30, 0, 45, 15, null);
                }
                g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], -4, -4, 11, 11, 45, 0, 60, 15, null);
                g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], 393, -4, 408, 11, 45, 0, 60, 15, null);
                g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], -4, 240, 11, 255, 45, 0, 60, 15, null);
                g.drawImage(BlackViper.this.globalImages[BlackViper.this.ICONIMG], 393, 240, 408, 255, 45, 0, 60, 15, null);
                g.drawRect(0, 0, BlackViper.this.WIDTH - 1, BlackViper.this.HEIGHT - 1);
            }
            g.setColor(BlackViper.this.DARKORANGE);
            g.drawString("Copyright Fennex 2002", 265, 241);
            g.setColor(BlackViper.this.FOREGROUND);
            g.drawRect(0, 0, BlackViper.this.WIDTH - 1, BlackViper.this.HEIGHT - 1);
            int percent = 0;
            if (this.totalKb != 0) {
                percent = this.loadedKb * 100 / this.totalKb;
            }
            int width = (this.barWidth - 6) * percent / 100;
            this.drawRect(g, this.barX, this.barY, this.barWidth, 16, BlackViper.this.BACKGROUND, BlackViper.this.FOREGROUND, false);
            this.drawRect(g, this.barX + 3, this.barY + 3, width, 10, BlackViper.this.FOREGROUND, BlackViper.this.FOREGROUND, true);
            g.setColor(BlackViper.this.FOREGROUND);
            g.drawString(this.mm, this.barX, this.barY - 5);
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void stop() {
        }
    }

    static interface State {
        public void init();

        public void stop();

        public void paint(Graphics var1);

        public void mousePressed(MouseEvent var1);

        public void mouseReleased(MouseEvent var1);

        public void keyPressed(KeyEvent var1);
    }
}

