/*
 * MemoryNumberDisplay.java
 *
 * Created on 10. August 2002, 18:34
 */

import java.awt.*;
import java.awt.image.*;

/** Representation of numbers
 *
 * @author  Markus Eichenberger
 */
public class MemoryNumberDisplay extends Component {
    
    Image m_arrImageNumber[];
    int m_nPosX;
    int m_nPosY;
    int m_nMaxDigits;
    int m_nValue;
    
    /** Create new number
     * @param arrImageNumber[] Array with ciphres
     * @param nPosX Position in X
     * @param nPosY Poition in Y
     * @param nMaxDigits Maximum of digit
     * @param nValue Value
     */
    public MemoryNumberDisplay(Image[] arrImageNumber, int nPosX, int nPosY, int nMaxDigits, int nValue) {
        m_arrImageNumber = arrImageNumber;
        m_nPosX = nPosX;
        m_nPosY = nPosY;
        m_nMaxDigits = nMaxDigits;
        m_nValue = nValue;
    }
   
    /** Set new value
     * @param nValue Wert der Anzeige
     */
    public void setValue(int nValue) {
        m_nValue = nValue;
    }
   
    /** Draw number
     * @param g Grafikkontext
     */
    public void paint(Graphics g) {
        String strValue = "" + m_nValue;
        while(strValue.length() < m_nMaxDigits) {
            strValue = " " + strValue;
        }
        
        int nPosX = m_nPosX;
        for(int i = 0; i < strValue.length(); i++) {
            int nIndex = "0123456789".indexOf(strValue.charAt(i));
            if(nIndex >= 0 && nIndex <= 9) {
                g.drawImage(m_arrImageNumber[nIndex], nPosX, m_nPosY, this);
            }
            else {
                g.drawImage(m_arrImageNumber[10], nPosX, m_nPosY, this);
            }   
            nPosX += m_arrImageNumber[10].getWidth(this);
        }
    }
}
