/*
 * MemoryMessageBox.java
 *
 * Created on 12. August 2002, 18:27
 */

import java.awt.*;
import java.awt.event.*;

/**
 *
 * @author  Markus Eichenberger
 */
public class MemoryMessageBox extends Frame implements Runnable, ActionListener, WindowListener {
    
    private static boolean m_bRunning = false;
    private static MemoryMessageBox m_memoryMessageBox = null;
    private Thread m_thread = null;
    private static String m_strMessage = "";
    private Label m_labelMessage;
    
    /**  Create a messagebox
     */
    private MemoryMessageBox() {
        super("Memory Applet");
        setLayout(new GridBagLayout());

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = GridBagConstraints.NONE;
        gbc.ipadx = 0;
        gbc.ipady = 0;

        m_labelMessage = new Label("xxx");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth  = 1;
        gbc.gridheight = 1;
        gbc.anchor = GridBagConstraints.CENTER;
        gbc.insets = new Insets(10, 10, 0, 10);
        add(m_labelMessage, gbc);

        Button buttonClose = new Button("Close");
        buttonClose.addActionListener((ActionListener)this);
        Panel p = new Panel();
        p.setLayout(new GridLayout(0, 3, 5, 5));
        p.add(new Label(""));
        p.add(buttonClose);
        p.add(new Label(""));

        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth  = 1;
        gbc.gridheight = 1;
        gbc.anchor = GridBagConstraints.CENTER;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.insets = new Insets(10, 10, 10, 10);
        add(p, gbc);
        
        setBackground(new Color(0xFFFF99));
        addWindowListener(this);
    }
    
    /** Instance the messagebox (Singleton Pattern, only one instance can exists)
     * @param strMessage Message
     */
    public static MemoryMessageBox getExemplar(String strMessage)
    {
        if(m_memoryMessageBox == null) {
            m_memoryMessageBox = new MemoryMessageBox();
        }
        m_strMessage = strMessage;
 
        return m_memoryMessageBox;
    }
    
    /** Show dialog
     * @param nPosX Position in X
     * @param nPosX Position in Y
     */
    public void showDialog(int nPosX, int nPosY)
    {
        if(m_memoryMessageBox != null) {
            m_memoryMessageBox.m_labelMessage.setText(m_strMessage);
            m_memoryMessageBox.pack();
            m_memoryMessageBox.setVisible(true);
            m_memoryMessageBox.show();
        
            m_memoryMessageBox.m_thread = new Thread(this);
            m_memoryMessageBox.m_thread.start();

            m_memoryMessageBox.setLocation(nPosX, nPosY);
            m_memoryMessageBox.toFront();
        }
   
    }

    /** Events
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if(actionEvent.getSource() instanceof Button) {
            m_bRunning = false;
        }
    }

    /** Dummy action until dialog closed 
     */
    public void run() {
        m_bRunning = true;
        while(m_bRunning) {
            try {
                Thread.sleep(250);
            }
            catch(InterruptedException e) {
                break;
            }
        }
        m_memoryMessageBox.setVisible(false);
        m_memoryMessageBox.dispose();
     }
    
    public void windowActivated(java.awt.event.WindowEvent windowEvent) {
    }
    
    public void windowClosed(java.awt.event.WindowEvent windowEvent) {
    }
    
    public void windowClosing(java.awt.event.WindowEvent windowEvent) {
        m_memoryMessageBox.setVisible(false);
        m_memoryMessageBox.dispose();
    }
    
    public void windowDeactivated(java.awt.event.WindowEvent windowEvent) {
    }
    
    public void windowDeiconified(java.awt.event.WindowEvent windowEvent) {
    }
    
    public void windowIconified(java.awt.event.WindowEvent windowEvent) {
    }
    
    public void windowOpened(java.awt.event.WindowEvent windowEvent) {
    }
    
}
