/*
 * MemoryImageButton.java
 *
 * Created on 2. August 2002, 18:56
 */

import java.awt.*;
import java.awt.image.*;

/** Graphic button
 *
 * @author Markus Eichenberger
 */
public class MemoryImageButton extends MemoryImage {
    
    private Image m_image2;
    private String m_strId = "";
    private boolean m_bActive = true;
      
    /** Create a butten on position nPosX,nPosY
     * @param image1 Image for state active
     * @param image2 Image for state active
     * @param strId Id of the button, used as callback id
     * @param nPosX Position of the button in X
     * @param nPosY Position or the button in Y
     * @param bActive true=Button is ready for events, false=Button ignore events
    */
    public MemoryImageButton(Image image1, Image image2, String strId, int nPosX, int nPosY, boolean bActive) {
        super(image1, nPosX, nPosY);
        m_image2 = image2;
        m_bActive = bActive;
        m_strId = strId;
    }
 
    /** Set state of button
     * @param bActive true=active, false=inactiv
     */
    public void setActive(boolean bActive) {
        m_bActive = bActive;
    }
    
    /** Get the button id
     * @return ID des Buttons
     */
    public String getId() {
        return m_strId;
    }
  
    /** Draw the button
     * @param g Grafikkontext
     */
    public void paint(Graphics g) {
        if(m_bActive) {
            g.drawImage(m_image1, m_nPosX, m_nPosY, this);
        }
        else {
            g.drawImage(m_image2, m_nPosX, m_nPosY, this);
        }
    }
    
    
    /** Is the mouse button over the button ?
     * @param nPosX Position of mouse in X
     * @param nPosY Position of mouse in Y
     * @return true if mouse is over the button
     */
    public boolean hasFocus(int nPosX, int nPosY) {
        boolean bReturn = false;
        
        if(m_bActive) {
            if(nPosX >= m_nPosX && nPosY >= m_nPosY && nPosX < m_nPosX + m_image1.getWidth(this) && nPosY < m_nPosY + m_image1.getHeight(this)) {
                bReturn = true;
            }
        }
    
        return bReturn;
    }
    
 
 }
