/*
 * MemoryCookieHelper.js
 *
 * Part of memory game by Markus Eichenberger http://mypage.bluewin.ch/katzenseite
 *
 * Created on 12. Dezember 2003, 15:58
 *
 */

/* Ask for access cookies */
function jsCheckForCookies(memoryCookieWrapper) {
  if(memoryCookieWrapper != null) {
    var bCookies = false;
    if(document.cookie != "") {
      bCookies = true;
    }
    else {
      jsSetCookie("MemoryApplet", "by Markus Eichenberger");
      if(document.cookie == "") {
        bCookies = false;
      }
      else {
        bCookies = true;
      }
    }
    /* Callback to the Java Applet to enable cookie access */
    memoryCookieWrapper.cbSetCookiesEnabled(bCookies);
  }
}

/* Set a cookie with a id and a value */
function jsSetCookie(strId, strValue) {
  document.cookie = strId + "=" + escape(strValue) + ";expires=" + new Date(2036, 12, 31).toGMTString();
}

/* Get a cookie identified by an id and add to Applet's highscore */
function jsGetCookie(memoryCookieWrapper, strId) {
  if(document.cookie != "") {
    var arrCookies = document.cookie.split(";");
    for(var i = 0; i < arrCookies.length; i++) {
      var arrCookie = arrCookies[i].split("=");
      if(arrCookie.length == 2) {
         if(strTrim(arrCookie[0]) == strTrim(strId)) {
           memoryCookieWrapper.cbAddScore(unescape(arrCookie[1]));
        }
      }
    }
  }
}
 
/* Remove all white spaces */
function strTrim(str) {
  var strReturn = "";
  for(var i = 0; i < str.length; i++) {
    if(str.charAt(i) != " ") {
      strReturn += str.charAt(i);
    }
  }
  return strReturn;
}

