/*
 * Memory.java
 *
 * Memory Spiel von Markus Eichenberger http://mypage.bluewin.ch/katzenseite
 *
 * Created on 6. Juli 2002, 11:28
 *
 * Version 0.9.0  27.08.2002  First release of memory game
 * Version 0.9.1  19.09.2002  Simple score
 * Version 1.0.0  24.12.2003  Memory Applet with highscore
 * Version 1.1.0  27.06.2004  Memory Applet with PHP highscore
 */

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.util.*;
import java.net.URL;
import java.net.MalformedURLException;
import java.io.*;

/** Memory Game
 *
 * @author Markus Eichenberger http://mypage.bluewin.ch/katzenseite
 */
public class Memory extends Applet implements Runnable, MouseListener, MouseMotionListener {
    
    private Thread m_thread = null;
    private MemoryImageContainer m_imageContainer;
    private MemoryImageButtonContainer m_imageButtonContainer;
    private MemoryImageFieldContainer m_imageFieldContainer;
    private MemoryNumberDisplay m_memoryNumberDisplayLevel;
    private MemoryNumberDisplay m_memoryNumberDisplaySeconds;
    private MemoryNumberDisplay m_memoryNumberDisplayAttempts;
    private MemoryNumberDisplay m_memoryNumberDisplayHits;
    private MediaTracker m_mediaTracker;
    private String m_strPicturePath = "./images/";
    private String m_strSoundPath = "./sounds/";
    private int m_nLevel = 4;
    private int m_nSeconds = 0;
    private int m_nAttempts = 0;
    private int m_nHits = 0;
    private int m_nPoints = 0;
    private int m_nHighscore = 0;
    private boolean m_bTimeout = false;
    private MemoryPreloader m_fPreloader;
    private MemoryPlayerName m_fPlayerName;
    private MemoryHighscore m_fHighscore;
    private MemoryImageButton m_imageButtonCat;
    private AudioClip m_soundTurncard;
    private AudioClip m_soundDontmatch;
    private AudioClip m_soundMatch;
    private AudioClip m_soundGameover;
    private String m_strPlayerName = "xxx";
    private Vector m_vectorHighscore;
    private MemoryCookieWrapper m_cookieWrapper;
    private boolean m_bPhpHighscore = false;
    private String m_strPhpSaveScore = "save_score.php";
    private String m_strPhpGetScore = "get_score.php";
    
    /** Init the memory applet */
    public void init() {
        setCursor(new Cursor(Cursor.WAIT_CURSOR));
        m_imageContainer = new MemoryImageContainer();
        m_imageButtonContainer = new MemoryImageButtonContainer();
        m_imageFieldContainer = new MemoryImageFieldContainer();
        
        // Set defaults for the applet
        showStatus("Initialize memory applet ...");
        initComponents();
        setBackground(new Color(0xFFFF99));
        
        // Preloader, center of screen
        m_fPreloader = new MemoryPreloader();
        Dimension d = getToolkit().getScreenSize();
        Rectangle rectApplet = getBounds();
        Rectangle rectPreloader = m_fPreloader.getBounds();
        int x = (d.width - rectPreloader.width) / 2;
        int y = (d.height - rectPreloader.height) / 2;
        m_fPreloader.setLocation(x, y);
        m_fPreloader.setVisible(true);
        
        // Audiofiles
        m_fPreloader.m_lblPreloader.setText("Loading sound files ...");
        m_soundTurncard = getAudioClip(getCodeBase(), m_strSoundPath + "turncard.au");
        m_soundDontmatch = getAudioClip(getCodeBase(), m_strSoundPath + "dontmatch.au");
        m_soundMatch = getAudioClip(getCodeBase(), m_strSoundPath + "match.au");
        m_soundGameover = getAudioClip(getCodeBase(), m_strSoundPath + "gameover.au");
        
        // MediaTracker to track the load process of the images
        m_mediaTracker = new MediaTracker(this);
        
        // Get the path from HTML parameter
        if(getParameter("picturepath") != null) {
            m_strPicturePath = getParameter("picturepath");
        }
        if(getParameter("soundpath") != null) {
            m_strSoundPath = getParameter("soundpath");
        }
        if(getParameter("highscore") != null) {
            if(getParameter("highscore").equals("php")) {
                m_bPhpHighscore = true;
            }
        }
        if(getParameter("get_score") != null) {
            m_strPhpGetScore = getParameter("get_score");
        }
        if(getParameter("save_score") != null) {
            m_strPhpSaveScore = getParameter("save_score");
        }
        
        // Load the cat pictures
        m_fPreloader.m_lblPreloader.setText("Loading cat pictures ...");
        Image imageBlank = getImage(getDocumentBase(), m_strPicturePath + "10.gif");
        m_mediaTracker.addImage(imageBlank, 0);
        Image imageCard = getImage(getDocumentBase(), m_strPicturePath + "card.jpg");
        m_mediaTracker.addImage(imageCard, 0);
        Image imagePicture1 = getImage(getDocumentBase(), m_strPicturePath + "pic1.jpg");
        m_mediaTracker.addImage(imagePicture1, 0);
        Image imagePicture2 = getImage(getDocumentBase(), m_strPicturePath + "pic2.jpg");
        m_mediaTracker.addImage(imagePicture2, 0);
        Image imagePicture3 = getImage(getDocumentBase(), m_strPicturePath + "pic3.jpg");
        m_mediaTracker.addImage(imagePicture3, 0);
        Image imagePicture4 = getImage(getDocumentBase(), m_strPicturePath + "pic4.jpg");
        m_mediaTracker.addImage(imagePicture4, 0);
        Image imagePicture5 = getImage(getDocumentBase(), m_strPicturePath + "pic5.jpg");
        m_mediaTracker.addImage(imagePicture5, 0);
        Image imagePicture6 = getImage(getDocumentBase(), m_strPicturePath + "pic6.jpg");
        m_mediaTracker.addImage(imagePicture6, 0);
        Image imagePicture7 = getImage(getDocumentBase(), m_strPicturePath + "pic7.jpg");
        m_mediaTracker.addImage(imagePicture7, 0);
        Image imagePicture8 = getImage(getDocumentBase(), m_strPicturePath + "pic8.jpg");
        m_mediaTracker.addImage(imagePicture8, 0);
        Image imageUrlCat = getImage(getDocumentBase(), m_strPicturePath + "urlcat.gif");
        m_mediaTracker.addImage(imageUrlCat, 0);
        
        // Wait until all cat pictures are loaded
        try {
            m_mediaTracker.waitForID(0);
        }
        catch(InterruptedException e) {}
        
        // Load the pictures of the GUI
        m_fPreloader.m_lblPreloader.setText("Loading user interface ...");
        m_imageButtonContainer.add(loadImageButton("startstop1.gif", "startstop2.gif", "start", getSize().width - 90, 0, true));
        m_imageButtonContainer.add(loadImageButton("startstop3.gif", "startstop4.gif", "stop", getSize().width - 90, 38, false));
        m_imageContainer.add(loadImage("level.gif", getSize().width - 90, 79));
        m_imageButtonContainer.add(loadImageButton("plusminus3.gif", "plusminus4.gif", "minus", getSize().width - 82, 99, true));
        m_imageButtonContainer.add(loadImageButton("plusminus1.gif", "plusminus2.gif", "plus", getSize().width - 22, 99, true));
        m_imageContainer.add(getScaledImage(imageBlank, getSize().width - 90, 99, 90, 20));
        m_imageContainer.add(loadImage("time.gif", getSize().width - 90, 130));
        m_imageContainer.add(loadImage("s.gif", getSize().width - 15, 150));
        m_imageContainer.add(loadImage("attempts.gif", getSize().width - 90, 175));
        m_imageContainer.add(loadImage("10.gif", getSize().width - 15, 195));
        m_imageContainer.add(loadImage("found.gif", getSize().width - 90, 220));
        m_imageContainer.add(loadImage("10.gif", getSize().width - 15, 240));
        m_imageButtonContainer.add(loadImageButton("highscore.gif", "blank.gif", "highscore", getSize().width - 90, 285, true));
        
        m_imageFieldContainer.add(getImageButton(imageCard, imagePicture1, "pic1", 0, 0, true));
        m_imageFieldContainer.add(getImageButton(imageCard, imagePicture1, "pic1", 89, 0, true));
        m_imageFieldContainer.add(getImageButton(imageCard, imagePicture2, "pic2", 178, 0, true));
        m_imageFieldContainer.add(getImageButton(imageCard, imagePicture2, "pic2", 267, 0, true));
        m_imageFieldContainer.add(getImageButton(imageCard, imagePicture3, "pic3", 0, 79, true));
        m_imageFieldContainer.add(getImageButton(imageCard, imagePicture3, "pic3", 89, 79, true));
        m_imageFieldContainer.add(getImageButton(imageCard, imagePicture4, "pic4", 178, 79, true));
        m_imageFieldContainer.add(getImageButton(imageCard, imagePicture4, "pic4", 267, 79, true));
        m_imageFieldContainer.add(getImageButton(imageCard, imagePicture5, "pic5", 0, 158, true));
        m_imageFieldContainer.add(getImageButton(imageCard, imagePicture5, "pic5", 89, 158, true));
        m_imageFieldContainer.add(getImageButton(imageCard, imagePicture6, "pic6", 178, 158, true));
        m_imageFieldContainer.add(getImageButton(imageCard, imagePicture6, "pic6", 267, 158, true));
        m_imageFieldContainer.add(getImageButton(imageCard, imagePicture7, "pic7", 0, 237, true));
        m_imageFieldContainer.add(getImageButton(imageCard, imagePicture7, "pic7", 89, 237, true));
        m_imageFieldContainer.add(getImageButton(imageCard, imagePicture8, "pic8", 178, 237, true));
        m_imageFieldContainer.add(getImageButton(imageCard, imagePicture8, "pic8", 267, 237, true));
        
        // Load ciphers
        m_fPreloader.m_lblPreloader.setText("Loading other images ...");
        Image arrImageNumber[] = new Image[11];
        for(int i = 0; i < 11; i++) {
            arrImageNumber[i] = getImage(getDocumentBase(), m_strPicturePath + i + ".gif");
            m_mediaTracker.addImage(arrImageNumber[i], 1);
        }
        
        // Wait until all ciphres are loaded
        m_fPreloader.m_lblPreloader.setText("Finishing loading ...");
        try {
            m_mediaTracker.waitForID(1);
        }
        catch(InterruptedException e) {}
        
        // The number displays
        m_memoryNumberDisplayLevel = new MemoryNumberDisplay(arrImageNumber, getSize().width - 52, 99, 1, m_nLevel);
        m_memoryNumberDisplaySeconds = new MemoryNumberDisplay(arrImageNumber, getSize().width - 90, 150, 5, m_nSeconds);
        m_memoryNumberDisplayAttempts = new MemoryNumberDisplay(arrImageNumber, getSize().width - 90, 195, 5, m_nSeconds);
        m_memoryNumberDisplayHits = new MemoryNumberDisplay(arrImageNumber, getSize().width - 90, 240, 5, m_nHits);
        
        // Playername
        m_fPlayerName = new MemoryPlayerName(this);
        m_fPlayerName.setVisible(false);
        
        // Highscore form
        m_fHighscore = new MemoryHighscore(getAppletContext(), imageUrlCat);
        m_fHighscore.setVisible(false);
        
        // Highscore Vector
        m_vectorHighscore = new Vector();
        
        // Try to load highscore from cookies
        m_cookieWrapper = new MemoryCookieWrapper(this);
        loadHighscore();
        
        setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
        addMouseListener(this);
        addMouseMotionListener(this);
        
        m_fPreloader.setVisible(false);
    }
    
    /** Applet has been activated */
    public void start() {
        repaint();
    }
    
    /** Applet has been deactivated */
    public void stop() {
    }
    
    
    /** Load a button
     * @param strFile1 Filename for the picture of state active
     * @param strFile2 Filename for the picture of state inactive
     * @param strId Id of the button, used as callback id
     * @param nPosX Position of the button in X
     * @param nPosY Position or the button in Y
     * @param bActive true=Button is ready for events, false=Button ignore events
     */
    public MemoryImageButton loadImageButton(String strFile1, String strFile2, String strId, int nPosX, int nPosY, boolean bActive) {
        Image image1 = getImage(getDocumentBase(), m_strPicturePath + strFile1);
        Image image2 = getImage(getDocumentBase(), m_strPicturePath + strFile2);
        m_mediaTracker.addImage(image1, 1);
        m_mediaTracker.addImage(image2, 1);
        return new MemoryImageButton(image1, image2, strId, nPosX, nPosY, bActive);
    }
    
    /** Instance a button
     * @param image1 Image for the state active
     * @param image2 Image for the state inactive
     * @param strId Id of the button, used as callback id
     * @param nPosX Position of the button in X
     * @param nPosY Position of the button in Y
     * @param bActive true=Button is ready for events, false=Button ignore events
     */
    public MemoryImageButton getImageButton(Image image1, Image image2, String strId, int nPosX, int nPosY, boolean bActive) {
        return new MemoryImageButton(image1, image2, strId, nPosX, nPosY, bActive);
    }
    
    /** Load picture from server
     * @param strFile Filename
     * @param nPosX Position of the button in X
     * @param nPosY Position of the button in Y
     */
    public MemoryImage loadImage(String strFile, int nPosX, int nPosY) {
        Image image = getImage(getDocumentBase(), m_strPicturePath + strFile);
        m_mediaTracker.addImage(image, 1);
        return new MemoryImage(image, nPosX, nPosY);
    }
    
    /** Get a picture an scale it
     * @param image Image that sould be scaled
     * @param nPosX Position of the button in X
     * @param nPosY Position of the button in Y
     * @return Scaled instance of the image
     */
    public MemoryImage getScaledImage(Image image, int nPosX, int nPosY, int nWidth, int nHeight) {
        return new MemoryImage(image.getScaledInstance(nWidth, nHeight, Image.SCALE_FAST), nPosX, nPosY);
    }
    
    
    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents

        setLayout(null);

    }//GEN-END:initComponents
    
    /** Repaint the game without clear background
     * @param g Grafikkontext
     */
    public void update(Graphics g) {
        synchronized (this) {
            paint(g);
        }
    }
    
    /** Repaint the game
     * @param g Graphic context
     */
    public void paint(Graphics g) {
        g.setColor(new Color(0x9999FF));
        g.fillRect(getSize().width - 90, 99, 90, 20);
        m_imageContainer.paint(g);
        m_imageButtonContainer.paint(g);
        m_imageFieldContainer.paint(g);
        
        m_memoryNumberDisplayLevel.paint(g);
        m_memoryNumberDisplaySeconds.paint(g);
        m_memoryNumberDisplayAttempts.paint(g);
        m_memoryNumberDisplayHits.paint(g);
    }
    
    public void mouseClicked(java.awt.event.MouseEvent mouseEvent) {
    }
    
    public void mouseEntered(java.awt.event.MouseEvent mouseEvent) {
    }
    
    public void mouseExited(java.awt.event.MouseEvent mouseEvent) {
    }
    
    /** Mouse click */
    public void mouseReleased(java.awt.event.MouseEvent mouseEvent) {
        if(!m_bTimeout) {
            String strClickIdButton = m_imageButtonContainer.getClickId(mouseEvent.getX(), mouseEvent.getY());
            String strClickIdField = m_imageFieldContainer.getClickId(mouseEvent.getX(), mouseEvent.getY());
            
            // Highscore clicked
            if(strClickIdButton.equals("highscore") && m_thread == null) {
                if(m_bPhpHighscore == false) {
                    sortScore();
                    m_fHighscore.listHighscore(m_vectorHighscore);
                }
                else {
                    try {
                        URL url;
                        if(m_strPhpGetScore.indexOf("http:") >= 0) {
                            url = new URL(m_strPhpGetScore);
                        }
                        else {
                            url = new URL(getCodeBase(), m_strPhpGetScore);
                        }
                        m_fHighscore.listHighscore(url);
                    }
                    catch(MalformedURLException e) {
                        getAppletContext().showStatus(e.getMessage());
                    }
                }
                Point p = getLocationOnScreen();
                m_fHighscore.setLocation(p.x, p.y - 50);
                m_fHighscore.show();
                m_fHighscore.toFront();
                m_fHighscore.requestFocus();
            }
            
            // Start button clicked, start the game
            if(strClickIdButton.equals("start") && m_thread == null) {
                startMemory();
            }
            
            // Stop button clicked, stop the game
            if(strClickIdButton.equals("stop") && m_thread != null) {
                m_nHits = 0;
                m_nAttempts = 0;
                m_nSeconds = 0;
                stopMemory();
                repaint();
            }
            
            // Minus utton clicked, Level - 1
            if(strClickIdButton.equals("minus") && m_nLevel > 0) {
                m_memoryNumberDisplayLevel.setValue(--m_nLevel);
                m_nHits = 0;
                m_nAttempts = 0;
                m_nSeconds = 0;
                repaint();
            }
            
            // Plus button clicked, Level + 1
            if(strClickIdButton.equals("plus") && m_nLevel < 9) {
                m_memoryNumberDisplayLevel.setValue(++m_nLevel);
                m_nHits = 0;
                m_nAttempts = 0;
                m_nSeconds = 0;
                repaint();
            }
            
            // Cat picture clicked, but game not started
            if(!strClickIdField.equals("") && m_thread == null) {
            }
            
            // Cat picture clicked
            if(!strClickIdField.equals("") && m_thread != null) {
                m_imageFieldContainer.showCard(mouseEvent.getX(), mouseEvent.getY());
                repaint();
                //m_soundTurncard.play();
                
                // Are two cards uncovered ?
                if(m_imageFieldContainer.hasTwoCards()) {
                    m_memoryNumberDisplayAttempts.setValue(++m_nAttempts);
                    
                    // Check for hit
                    if(m_imageFieldContainer.isHit()) {
                        m_memoryNumberDisplayHits.setValue(++m_nHits);
                        if(m_nHits == 8) {
                            stopMemory();
                            calcPoints();
                            if(m_nPoints > m_nHighscore) {
                                m_nHighscore = m_nPoints;
                            }
                            m_fPlayerName.setTitle("Your score is " + m_nPoints + " points !");
                            Point p = getLocationOnScreen();
                            m_fPlayerName.setLocation(p.x + 20, p.y + 20);
                            m_fPlayerName.show();
                            m_fPlayerName.m_textFieldPlayerName.requestFocus();
                            m_soundGameover.play();
                        }
                        else {
                            m_soundMatch.play();
                        }
                    }
                    else {
                        synchronized (this) {
                            new MemoryTimer(2000 - m_nLevel * 200, this);
                            m_bTimeout = true;
                            m_soundDontmatch.play();
                        }
                    }
                }
            }
        }
    }
    
    /** Start game
     */
    private void startMemory() {
        m_imageButtonContainer.setActive("start", false);
        m_imageButtonContainer.setActive("stop", true);
        m_imageButtonContainer.setActive("minus", false);
        m_imageButtonContainer.setActive("plus", false);
        m_nAttempts = 0;
        m_memoryNumberDisplayAttempts.setValue(m_nAttempts);
        m_nHits = 0;
        m_memoryNumberDisplayHits.setValue(m_nHits);
        m_imageFieldContainer.hideAllCards();
        m_imageFieldContainer.shuffle();
        m_nPoints = 0;
        repaint();
        m_nSeconds = 0;
        m_thread = new Thread(this);
        m_thread.start();
    }
    
    /** Stop game
     */
    private void stopMemory() {
        m_thread = null;
        m_imageButtonContainer.setActive("start", true);
        m_imageButtonContainer.setActive("stop", false);
        m_imageButtonContainer.setActive("minus", true);
        m_imageButtonContainer.setActive("plus", true);
        repaint();
    }
    
    public void mousePressed(java.awt.event.MouseEvent mouseEvent) {
    }
    
    public void mouseDragged(java.awt.event.MouseEvent mouseEvent) {
    }
    
    public void mouseMoved(java.awt.event.MouseEvent mouseEvent) {
        boolean bButton = m_imageButtonContainer.hasFocus(mouseEvent.getX(), mouseEvent.getY());
        boolean bField  = m_imageFieldContainer.hasFocus(mouseEvent.getX(), mouseEvent.getY());
        
        if(bButton || bField) {
            setCursor(new Cursor(Cursor.HAND_CURSOR));
        }
        else {
            setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
        }
    }
    
    /** Applet parameter info */
    public String[][] getParameterInfo() {
        String strParamInfo[][] = {
            {"picturepath", "path", "Path to pictures"},
            {"soundpath", "path", "Path to sounds"},
            {"highscore", "string", "\"php\" to activate the PHP highscore"},
            {"save_score", "url", "PHP script to save the highscore"},
            {"show_score", "url", "PHP script to print out the highscore"}
        };
        return strParamInfo;
    }
    
    /** Applet info */
    public String getAppletInfo() {
        return "Memory Applet 2002-2004 by Markus Eichenberger";
    }
    
    /** The main thread */
    public void run() {
        Thread actThread = Thread.currentThread();
        while(m_thread == actThread) {
            synchronized (this) {
                m_memoryNumberDisplaySeconds.setValue(++m_nSeconds);
            }
            repaint();
            try {
                Thread.sleep(1000);
            }
            catch(InterruptedException e) {
                break;
            }
        }
    }
    
    /** Callback if time expired
     */
    public synchronized void timeExpired() {
        m_imageFieldContainer.hideSelectedCards();
        repaint();
        m_bTimeout = false;
    }
    
    /** Draw score
     */
    private void drawHighscore(Graphics g) {
        g.setColor(new Color(0x9999FF));
        g.fillRect(getSize().width - 90, 262, 90, 48);
        g.setColor(Color.white);
        g.setFont(new Font("SansSerif", Font.PLAIN, 12));
        g.drawString("Points:", 365, 275);
        g.drawString("Player:", 365, 290);
        g.drawString("Top 1:", 365, 305);
        g.drawString("" + m_nPoints + "", 410, 290);
        g.drawString("" + m_nHighscore + "", 410, 305);
    }
    
    /** Calculate points
     */
    private void calcPoints() {
        m_nPoints = Math.round(100000 * (m_nLevel + 1) / m_nSeconds  / m_nAttempts);
    }
    
    /** Name des Spielers zuweisen
     */
    public void setPlayerName(java.lang.String strPlayerName) {
        m_strPlayerName = strPlayerName;
    }
    
    /** Add score to the highscore list
     */
    public void addScore() {
        MemoryScoreEntry mse = new MemoryScoreEntry(m_nPoints, m_strPlayerName, m_nSeconds, m_nAttempts, m_nLevel, "");
        if(m_bPhpHighscore == false) {
            m_vectorHighscore.addElement(mse);
            sortScore();
            saveHighscore();
            m_fHighscore.listHighscore(m_vectorHighscore);
        }
        else {
            try {
                URL url;
                if(m_strPhpSaveScore.indexOf("http:") >= 0) {
                    url = new URL(m_strPhpSaveScore + mse.getURLScore());
                }
                else {
                    url = new URL(getCodeBase(), m_strPhpSaveScore + mse.getURLScore());
                }
                //getAppletContext().showDocument(url, "_blank");
                BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                in.close();
            }
            catch(Exception e) {
                getAppletContext().showStatus(e.getMessage());
            }
        }
    }
    
    /** Sort score by points
     */
    public void sortScore() {
        // Bubblesort
        int nSize = m_vectorHighscore.size();
        for(int n = 0; n < nSize - 1; n++) {
            for(int m = 0; m < nSize - 1; m++) {
                int n1 = ((MemoryScoreEntry)m_vectorHighscore.elementAt(m)).getPoints();
                int n2 = ((MemoryScoreEntry)m_vectorHighscore.elementAt(m + 1)).getPoints();
                if(n1 < n2) {
                    MemoryScoreEntry mse = (MemoryScoreEntry)m_vectorHighscore.elementAt(m);
                    m_vectorHighscore.setElementAt((MemoryScoreEntry)m_vectorHighscore.elementAt(m + 1), m);
                    m_vectorHighscore.setElementAt(mse, m + 1);
                }
            }
        }
    }
    
    /** Add to highscore */
    public void addToHighscore(MemoryScoreEntry mse) {
        m_vectorHighscore.addElement(mse);
    }
    
    /** Save highscore, max 10 scores (limited size of cookies) */
    public void saveHighscore() {
        int i = 0;
        for(Enumeration e = m_vectorHighscore.elements(); e.hasMoreElements();) {
            MemoryScoreEntry mse = (MemoryScoreEntry)e.nextElement();
            String strId = "Score" + i++;
            String strScore = mse.getCookieScore();
            if(m_cookieWrapper.cookiesEnabled()) {
                if(i <= 10) {
                    m_cookieWrapper.setCookie(strId, strScore);
                }
            }
        }
    }
    
    /** Load highscore */
    public void loadHighscore() {
        m_vectorHighscore.removeAllElements();
        for(int i = 0; i < 10; i++) {
            if(m_cookieWrapper.cookiesEnabled()) {
                m_cookieWrapper.getCookie("Score" + i);
            }
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
}
