/*
 * Decompiled with CFR 0.152.
 */
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MemoryScoreEntry {
    private int m_nPoints;
    private int m_nLevel;
    private int m_nAttempts;
    private int m_nTime;
    private String m_strName;
    private String m_strDate;

    public MemoryScoreEntry() {
        this.m_nPoints = 0;
        this.m_strName = "";
        this.m_nTime = 0;
        this.m_nAttempts = 0;
        this.m_nLevel = 0;
        this.m_strDate = "";
    }

    public MemoryScoreEntry(int n, String string, int n2, int n3, int n4, String string2) {
        this.m_nPoints = n;
        this.m_strName = string;
        this.m_nTime = n2;
        this.m_nAttempts = n3;
        this.m_nLevel = n4;
        if (string2.length() == 0) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            this.m_strDate = simpleDateFormat.format(new Date());
        } else {
            this.m_strDate = string2;
        }
    }

    public int getPoints() {
        return this.m_nPoints;
    }

    public String getFormatedHeader() {
        return this.getFormatedString("Points", 7) + this.getFormatedString("Name", 22) + this.getFormatedString("Time", 5) + this.getFormatedString("Att.", 5) + this.getFormatedString("Lev.", 5) + this.getFormatedString("Date", 17);
    }

    public String getFormatedScore() {
        return this.getFormatedString("" + this.m_nPoints, 7) + this.getFormatedString(this.m_strName, 22) + this.getFormatedString("" + this.m_nTime, 5) + this.getFormatedString("" + this.m_nAttempts, 5) + this.getFormatedString("" + this.m_nLevel, 5) + this.getFormatedString(this.m_strDate, 17);
    }

    private String getFormatedString(String string, int n) {
        while (string.length() < n) {
            string = string + " ";
        }
        return string.substring(0, n);
    }

    public String getCookieScore() {
        return "" + this.m_nPoints + ";" + this.getFormatedString(this.m_strName, 22).trim() + ";" + this.m_nTime + ";" + this.m_nAttempts + ";" + this.m_nLevel + ";" + this.m_strDate;
    }

    public String getURLScore() {
        return "?p=" + this.m_nPoints + "&n=" + URLEncoder.encode(this.m_strName) + "&d=" + URLEncoder.encode(this.m_strDate) + "&l=" + this.m_nLevel + "&t=" + this.m_nTime + "&a=" + this.m_nAttempts;
    }
}

