/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;

public final class MazeCanvasThread4
extends Canvas
implements Runnable {
    BitSet[][] paths;
    BitSet walls;
    BitSet empty_bs = new BitSet(4);
    boolean create_new = true;
    boolean interactive = false;
    boolean openended = false;
    Color dot_color;
    FontMetrics fm;
    Graphics bufferG;
    Graphics mazeG;
    Image bufferI;
    Image mazeI;
    int width;
    int height;
    int rows;
    int columns;
    int cellsize;
    int[] ix = new int[]{0, 1, 0, -1};
    int[] iy = new int[]{-1, 0, 1, 0};
    int[] wrap_x;
    Point start_point;
    Point finish_point;
    Point dot_position;
    String maze_id = "";
    Thread woohoo;
    Vector dot_steps = new Vector();

    MazeCanvasThread4(BitSet bitSet, int n, int n2, String string, int n3, Point point, Point point2, boolean bl) {
        this(n, n2, n3, point, point2, null, bl);
        this.walls = bitSet;
        this.create_new = false;
        this.maze_id = string;
    }

    MazeCanvasThread4(int n, int n2, int n3, boolean bl) {
        this(n, n2, n3, new Point(0, 0), new Point(n2 - 1, n - 1), null, bl);
    }

    MazeCanvasThread4(int n, int n2, int n3, Color color, boolean bl) {
        this(n, n2, n3, new Point(0, 0), new Point(n2 - 1, n - 1), color, bl);
    }

    MazeCanvasThread4(int n, int n2, int n3, Point point, Point point2, Color color, boolean bl) {
        this.rows = n;
        this.columns = n2;
        this.cellsize = n3;
        this.start_point = point;
        this.finish_point = point2;
        this.openended = bl;
        if (this.finish_point.x > this.columns - 1) {
            this.finish_point.x = this.columns - 1;
        }
        if (this.finish_point.y > this.rows - 1) {
            this.finish_point.y = this.rows - 1;
        }
        this.wrap_x = new int[this.rows];
        int n4 = 0;
        while (n4 < this.rows) {
            this.wrap_x[n4] = this.openended ? (int)(Math.random() * (double)this.columns) : this.columns - 1;
            ++n4;
        }
        if (color != null) {
            this.interactive = true;
            this.dot_color = color;
        }
        this.width = this.columns * this.cellsize + 1;
        this.height = this.rows * this.cellsize + 1;
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setFont(new Font("Helvetica", 0, 16));
    }

    public void start() {
        if (this.woohoo == null) {
            this.woohoo = new Thread(this);
        }
        this.woohoo.start();
    }

    public void run() {
        if (this.bufferG == null || this.mazeG == null) {
            this.mazeI = this.createImage(this.width, this.height);
            this.mazeG = this.mazeI.getGraphics();
            this.bufferI = this.createImage(this.width, this.height);
            this.bufferG = this.bufferI.getGraphics();
            this.bufferG.setFont(this.getFont());
            this.bufferG.setColor(this.getForeground());
            this.fm = this.bufferG.getFontMetrics();
        }
        if (this.create_new) {
            int n;
            int n2;
            this.dot_position = this.start_point;
            this.dot_steps.removeAllElements();
            long l = System.currentTimeMillis();
            this.paths = new BitSet[this.rows][this.columns];
            int n3 = 0;
            while (n3 < this.rows) {
                n2 = 0;
                while (n2 < this.columns) {
                    this.paths[n3][n2] = new BitSet(4);
                    ++n2;
                }
                ++n3;
            }
            this.paths[this.rows - 1][this.columns - 1].set(3);
            this.paths[this.rows - 1][this.columns - 2].set(1);
            n2 = this.columns - 2;
            int n4 = 0;
            int n5 = this.rows - 1;
            int n6 = 0;
            int n7 = 1;
            int n8 = 1;
            int n9 = 2;
            boolean bl = false;
            while (n9 < this.rows * this.columns) {
                n = (int)(Math.random() * 4.0);
                BitSet bitSet = this.paths[n5][n2];
                if (!bitSet.equals(this.empty_bs) || !true) {
                    bl = true;
                    int n10 = 4;
                    while (n10 > 0) {
                        BitSet bitSet2;
                        n4 = this.openended ? (n2 + this.ix[n] + this.columns) % this.columns : n2 + this.ix[n];
                        n6 = n5 + this.iy[n];
                        if (n6 + 1 > 0 && n6 < this.rows && (this.openended || n4 + 1 > 0 && n4 < this.columns) && (bitSet2 = this.paths[n6][n4]).equals(this.empty_bs) && true) {
                            bl = false;
                            break;
                        }
                        n = n + 1 & 3;
                        --n10;
                    }
                }
                if (!bl) {
                    this.paths[n5][n2].set(n);
                    this.paths[n6][n4].set(n + 2 & 3);
                    n2 = n4;
                    n5 = n6;
                    ++n9;
                    continue;
                }
                if (n7 > 0 && n2 == this.wrap_x[n5] || n7 < 0 && n2 == (this.wrap_x[n5] + 1) % this.columns) {
                    n7 = -n7;
                    if (n5 + n8 + 1 > 0 && n5 + n8 < this.rows) {
                        n5 += n8;
                        continue;
                    }
                    n8 = -n8;
                    continue;
                }
                n2 = (n2 + n7 + this.columns) % this.columns;
            }
            this.walls = new BitSet(this.rows * this.columns * 2);
            n = 0;
            while (n < this.rows) {
                int n11 = 0;
                while (n11 < this.columns) {
                    if (!this.paths[n][n11].get(0)) {
                        this.walls.set(n * this.columns + n11 << 1);
                    }
                    if (!this.paths[n][n11].get(3)) {
                        this.walls.set((n * this.columns + n11 << 1) + 1);
                    }
                    ++n11;
                }
                ++n;
            }
            long l2 = System.currentTimeMillis();
            this.maze_id = String.valueOf(l2);
            long l3 = l2 - l;
            System.out.println("Time to construct: " + l3 + "ms");
        }
        this.drawMaze(this.mazeG, 0, 0);
        this.paintMaze();
        this.repaint();
    }

    public void paintMaze() {
        this.bufferG.drawImage(this.mazeI, 0, 0, null);
        if (this.interactive) {
            this.bufferG.setColor(this.dot_color);
            Enumeration enumeration = this.dot_steps.elements();
            while (enumeration.hasMoreElements()) {
                Point point = (Point)enumeration.nextElement();
                this.bufferG.drawLine(point.x * this.cellsize + this.cellsize / 2, point.y * this.cellsize + this.cellsize / 2, point.x * this.cellsize + this.cellsize / 2, point.y * this.cellsize + this.cellsize / 2);
            }
            this.bufferG.fillOval(this.dot_position.x * this.cellsize + 1, this.dot_position.y * this.cellsize + 1, this.cellsize - 2, this.cellsize - 2);
        }
        this.repaint();
    }

    public void drawMaze(Graphics graphics, int n, int n2) {
        Color color;
        graphics.setFont(new Font("SanSerif", 0, this.cellsize - 2));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Color color2 = n == 0 && n2 == 0 ? this.getBackground() : Color.white;
        Color color3 = color = n == 0 && n2 == 0 ? this.getForeground() : Color.black;
        if (n == 0 && n2 == 0) {
            graphics.setColor(color2);
            graphics.fillRect(0, 0, this.width, this.height);
        }
        graphics.setColor(color);
        int n3 = this.columns;
        if (!this.openended) {
            graphics.drawRect(n, n2, this.width - 1, this.height - 1);
        } else {
            n3 += 2;
            graphics.drawLine(n, n2, n + this.width - 1 + 2 * this.cellsize, n2);
            graphics.drawLine(n, n2 + this.height - 1, n + this.width - 1 + 2 * this.cellsize, n2 + this.height - 1);
        }
        int n4 = 0;
        while (n4 < this.rows) {
            int n5 = 0;
            while (n5 < n3) {
                int n6 = this.openended && n5 >= this.columns ? n5 % this.columns : n5;
                graphics.drawLine(n5 * this.cellsize + n, n4 * this.cellsize + n2, n5 * this.cellsize + n, n4 * this.cellsize + n2);
                if (this.walls.get((n4 * this.columns + n6) * 2)) {
                    graphics.drawLine(n5 * this.cellsize + n, n4 * this.cellsize + n2, n5 * this.cellsize + this.cellsize + n, n4 * this.cellsize + n2);
                }
                if (this.walls.get((n4 * this.columns + n6) * 2 + 1)) {
                    graphics.drawLine(n5 * this.cellsize + n, n4 * this.cellsize + n2, n5 * this.cellsize + n, n4 * this.cellsize + this.cellsize + n2);
                }
                if (n6 == this.start_point.x && n4 == this.start_point.y && this.cellsize - 2 > 3) {
                    graphics.drawString("S", n5 * this.cellsize + (this.cellsize - fontMetrics.stringWidth("S")) / 2 + 1 + n, n4 * this.cellsize + this.cellsize - 1 + n2);
                }
                if (n6 == this.finish_point.x && n4 == this.finish_point.y && this.cellsize - 2 > 3) {
                    graphics.drawString("F", n5 * this.cellsize + (this.cellsize - fontMetrics.stringWidth("F")) / 2 + 1 + n, n4 * this.cellsize + this.cellsize - 1 + n2);
                }
                ++n5;
            }
            ++n4;
        }
        graphics.setFont(new Font("SanSerif", 0, 4));
        FontMetrics fontMetrics2 = graphics.getFontMetrics();
        graphics.drawString("Maze (#" + this.rows + "-" + this.columns + "-" + this.cellsize + "-" + this.maze_id + ") generated by MazeMaker, Copyright " + '\u00a9' + " 1998, Eric Harshbarger, http://www.ericharshbarger.org/", n, this.rows * this.cellsize + fontMetrics2.getHeight() + n2);
        if (this.openended) {
            graphics.drawString("Maze (#" + this.rows + "-" + this.columns + "-" + this.cellsize + "-" + this.maze_id + ") generated by MazeMaker, Copyright " + '\u00a9' + " 1998, Eric Harshbarger, http://www.ericharshbarger.org/", n + this.columns * this.cellsize, this.rows * this.cellsize + fontMetrics2.getHeight() + n2);
        }
    }

    public String getMazeID() {
        return this.maze_id;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getCellSize() {
        return this.cellsize;
    }

    public Point getStartPoint() {
        return this.start_point;
    }

    public Point getFinishPoint() {
        return this.finish_point;
    }

    public boolean isOpenEnded() {
        return this.openended;
    }

    public BitSet getWalls() {
        return this.walls;
    }

    private boolean cellIsUnused(BitSet bitSet) {
        return bitSet.equals(this.empty_bs);
    }

    public void stop() {
        if (this.woohoo != null) {
            this.woohoo.stop();
            this.woohoo = null;
        }
    }

    public void destroy() {
        if (this.bufferG != null) {
            this.bufferG.dispose();
        }
        if (this.mazeG != null) {
            this.mazeG.dispose();
        }
    }

    public Dimension minimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension preferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.bufferG == null || this.mazeG == null) {
            this.mazeI = this.createImage(this.width, this.height);
            this.mazeG = this.mazeI.getGraphics();
            this.bufferI = this.createImage(this.width, this.height);
            this.bufferG = this.bufferI.getGraphics();
            this.bufferG.setFont(this.getFont());
            this.bufferG.setColor(this.getForeground());
            this.fm = this.bufferG.getFontMetrics();
        }
        Math.min(this.height / 6, this.width / 6);
        graphics.drawImage(this.bufferI, 0, 0, null);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 403 && this.interactive) {
            if (event.key == 1005 && this.paths[this.dot_position.y][this.dot_position.x].get(2)) {
                this.dot_steps.addElement(new Point(this.dot_position.x, this.dot_position.y));
                this.dot_position = new Point(this.dot_position.x, this.dot_position.y + 1);
                this.paintMaze();
            } else if (event.key == 1004 && this.paths[this.dot_position.y][this.dot_position.x].get(0)) {
                this.dot_steps.addElement(new Point(this.dot_position.x, this.dot_position.y));
                this.dot_position = new Point(this.dot_position.x, this.dot_position.y - 1);
                this.paintMaze();
            } else if (event.key == 1007 && this.paths[this.dot_position.y][this.dot_position.x].get(1)) {
                this.dot_steps.addElement(new Point(this.dot_position.x, this.dot_position.y));
                this.dot_position = new Point(this.dot_position.x + 1, this.dot_position.y);
                this.paintMaze();
            } else if (event.key == 1006 && this.paths[this.dot_position.y][this.dot_position.x].get(3)) {
                this.dot_steps.addElement(new Point(this.dot_position.x, this.dot_position.y));
                this.dot_position = new Point(this.dot_position.x - 1, this.dot_position.y);
                this.paintMaze();
            } else if (event.key == 1000) {
                this.dot_steps.addElement(new Point(this.dot_position.x, this.dot_position.y));
                this.dot_position = new Point(this.start_point.x, this.start_point.y);
                this.paintMaze();
            } else if (event.key == 1001) {
                this.dot_steps.addElement(new Point(this.dot_position.x, this.dot_position.y));
                this.dot_position = new Point(this.finish_point.x, this.finish_point.y);
                this.paintMaze();
            }
        }
        return super.handleEvent(event);
    }
}

