/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

final class PlayField
extends Canvas
implements Runnable,
KeyListener {
    protected Invaders inv;
    protected Data data;
    protected Thread mainThread;
    protected boolean runFlag = false;
    protected boolean threadAlive = true;
    protected int keyCode;
    protected int delay = 22;
    protected boolean shoot;
    protected int a = 0;
    private Image buffer;
    protected boolean starting = false;
    private Graphics bufferGraphics;
    protected boolean gameOver;
    protected Font textfont = new Font("Helvetica", 1, 12);
    protected int bbcount;
    protected int loop = 0;
    protected long time;
    protected boolean takeTime = true;
    protected int fps;

    public PlayField(Invaders invaders, Data data) {
        this.inv = invaders;
        this.data = data;
        this.buffer = invaders.getEmptyImage(400, 300);
        this.bufferGraphics = this.buffer.getGraphics();
        this.mainThread = new Thread(this);
        this.mainThread.start();
        this.setBackground(data.bgColor);
        this.addKeyListener(this);
        this.requestFocus();
        this.starting = true;
    }

    private void checkBonusCollision() {
        int n = 0;
        while (n < 8) {
            if (this.data.playerFire[n].isAlive() && !this.data.bonus.isExploding() && this.data.bonus.isAlive() && this.data.bonus.getXco() < this.data.playerFire[n].getXco() && this.data.bonus.getXco() + 20 > this.data.playerFire[n].getXco() && this.data.bonus.getYco() > this.data.playerFire[n].getYco() && this.data.bonus.getYco() - 20 < this.data.playerFire[n].getYco()) {
                this.data.bonus.explode(30);
                this.data.playerFire[n].disable();
                this.data.bonusKilled();
                this.inv.explodeS.play();
            }
            ++n;
        }
    }

    private void checkBulletBug() {
        this.bbcount = this.data.getBulletsLeft() == 0 ? ++this.bbcount : 0;
        if (this.bbcount > 20) {
            this.data.addToBullets(1);
        }
    }

    private void checkCollision() {
        int n = 0;
        while (n < 8) {
            if (this.data.playerFire[n].isAlive()) {
                int n2 = 0;
                while (n2 < this.data.getEnemyNumber()) {
                    if (!this.data.enemies[n2].isExploding() && this.data.enemies[n2].isAlive()) {
                        if (this.data.enemies[n2].getXco() < this.data.playerFire[n].getXco() && this.data.enemies[n2].getXco() + 20 > this.data.playerFire[n].getXco() && !this.data.bossMode && this.data.enemies[n2].getYco() > this.data.playerFire[n].getYco() && this.data.enemies[n2].getYco() - 20 < this.data.playerFire[n].getYco()) {
                            this.data.enemies[n2].explode(10);
                            if (!this.data.superBullets) {
                                this.data.playerFire[n].disable();
                            }
                            this.data.enemyKilled();
                            this.inv.dieS.play();
                            if (this.data.isMode(1) && !this.data.superBullets) {
                                this.data.addToBullets(1);
                            } else if (!this.data.superBullets) {
                                this.data.addToBullets(1, n);
                            }
                        }
                        if (this.data.bossMode && this.data.enemies[n2].getXco() < this.data.playerFire[n].getXco() && this.data.enemies[n2].getXco() + 60 > this.data.playerFire[n].getXco() && this.data.enemies[n2].getYco() > this.data.playerFire[n].getYco() && this.data.enemies[n2].getYco() - 60 < this.data.playerFire[n].getYco()) {
                            ++this.data.bossHits;
                            if (this.data.bossHits > this.data.getLevel() * 2) {
                                this.data.enemies[n2].explode(10);
                                this.data.enemyKilled();
                            }
                            if (!this.data.superBullets) {
                                this.data.playerFire[n].disable();
                            }
                            this.inv.dieS.play();
                            if (this.data.isMode(1) && !this.data.superBullets) {
                                this.data.addToBullets(1);
                            } else {
                                if (n > 3 && !this.data.playerFire[n - 4].isAlive()) {
                                    this.data.addToBullets(1);
                                }
                                if (n < 4 && !this.data.playerFire[n + 4].isAlive()) {
                                    this.data.addToBullets(1);
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void checkPlayerCollision() {
        int n = 0;
        while (n < this.data.getEnemyFire()) {
            if (this.data.enemyFire[n].isAlive() && !this.data.player.isExploding() && this.data.player.isAlive() && this.data.player.getXco() < this.data.enemyFire[n].getXco() && this.data.player.getXco() + 20 > this.data.enemyFire[n].getXco() && this.data.player.getYco() > this.data.enemyFire[n].getYco() && this.data.player.getYco() - 20 < this.data.enemyFire[n].getYco()) {
                this.data.player.explode(40);
                this.data.enemyFire[n].disable();
                this.data.playerKilled();
                this.inv.explodeS.play();
            }
            ++n;
        }
    }

    private void checkRespawn() {
        if (!this.data.player.isAlive() && this.data.getShipsLeft() > 0) {
            this.data.player.enable();
        } else if (!this.data.player.isAlive() && this.data.getShipsLeft() == 0) {
            this.gameOver();
        }
    }

    private void doHighScores(int n, int n2) {
        HighScoreTool highScoreTool = new HighScoreTool(this.inv);
        highScoreTool.setScore(n);
        highScoreTool.setLevel(n2);
        highScoreTool.setFile(this.inv.file);
        highScoreTool.setDir(this.inv.dir);
        highScoreTool.doHigh();
    }

    private void doPaint() {
        this.repaint();
    }

    private void enemyAttack() {
        int n = 0;
        while (n < this.data.getEnemyNumber()) {
            if (this.data.enemies[n].isAlive() && !this.data.enemies[n].isExploding()) {
                this.data.enemies[n].randAttack();
            }
            ++n;
        }
    }

    public void gameOver() {
        this.inv.endS.play();
        this.gameOver = true;
        this.data.waitMode(true);
        this.runFlag = false;
    }

    private void generateBonus() {
        if (this.data.bonus.isAlive()) {
            this.data.bonus.calcMove();
        }
        this.data.generateBonus();
    }

    private int getKey() {
        return this.keyCode;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.data.isWaiting() || this.starting) {
            if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyChar() == '\n') {
                if (this.starting) {
                    this.starting = false;
                } else if (!this.gameOver) {
                    this.loadnext();
                } else {
                    this.data.gameOver();
                    if (this.inv.doHighScore) {
                        this.doHighScores(this.data.getScore(), this.data.getLevel());
                    }
                }
                this.data.waitMode(false);
            }
        } else if (this.data.player.isAlive()) {
            if (keyEvent.getKeyCode() != 39 && keyEvent.getKeyCode() != 37) {
                this.data.player.randAttack();
            } else if (keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39) {
                this.keyCode = keyEvent.getKeyCode();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        boolean bl = keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 37;
        if (this.keyCode == keyEvent.getKeyCode()) {
            this.keyCode = 0;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void kill() {
        this.threadAlive = false;
    }

    private void loadnext() {
        this.data.nextLevel();
    }

    private void moveBullets() {
        int n = 0;
        while (n < 8) {
            if (this.data.playerFire[n].isAlive()) {
                this.data.playerFire[n].calcMove(6, n);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.data.getEnemyFire()) {
            if (this.data.enemyFire[n2].isAlive()) {
                this.data.enemyFire[n2].calcMove();
            }
            ++n2;
        }
    }

    private void moveShips() {
        int n = 0;
        while (n < this.data.getEnemyNumber()) {
            if (this.data.enemies[n].isAlive() && !this.data.enemies[n].isExploding()) {
                this.data.enemies[n].calcMove();
            }
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        int n;
        this.buffer.flush();
        this.bufferGraphics.setFont(this.textfont);
        this.bufferGraphics.setColor(this.data.bgColor);
        this.bufferGraphics.clearRect(0, 0, 400, 300);
        this.bufferGraphics.fillRect(0, 0, 400, 300);
        this.bufferGraphics.setColor(this.data.fgColor);
        this.bufferGraphics.fillRect(0, 280, this.data.getLimitBlock(), 20);
        this.bufferGraphics.fillRect(400 - this.data.getLimitBlock(), 280, this.data.getLimitBlock(), 20);
        this.bufferGraphics.drawRect(1, 1, 398, 298);
        this.bufferGraphics.setColor(this.data.bgColor);
        this.bufferGraphics.fillRect(5, 290, 4 * this.data.getBulletsLeft(), 5);
        this.bufferGraphics.setColor(this.data.fgColor);
        if (!this.inv.registered) {
            this.bufferGraphics.drawString("Unregistered Version", 10, 20);
            this.bufferGraphics.drawString("Http://www.realapplets.com", 230, 20);
        }
        if (this.data.player.isAlive()) {
            this.bufferGraphics.drawImage(this.data.player.getFace(), this.data.player.getXco(), this.data.player.getYco(), this);
        }
        if (this.data.bonus.isAlive()) {
            this.bufferGraphics.drawImage(this.data.bonus.getFace(), this.data.bonus.getXco(), this.data.bonus.getYco(), this);
        }
        int n2 = 0;
        while (n2 < this.data.getEnemyNumber()) {
            if (this.data.enemies[n2].isAlive()) {
                if (this.data.bossMode) {
                    n = (int)((double)this.data.bossHits / (double)(this.data.getLevel() * 2) * 100.0);
                    this.bufferGraphics.drawRect(this.data.enemies[n2].getXco(), this.data.enemies[n2].getYco() - 20, 50, 5);
                    this.bufferGraphics.fillRect(this.data.enemies[n2].getXco(), this.data.enemies[n2].getYco() - 20, n / 2, 5);
                    this.bufferGraphics.drawImage(this.data.enemies[n2].getFace(), this.data.enemies[n2].getXco(), this.data.enemies[n2].getYco(), 60, 60, this);
                } else {
                    this.bufferGraphics.drawImage(this.data.enemies[n2].getFace(), this.data.enemies[n2].getXco(), this.data.enemies[n2].getYco(), this);
                }
            }
            ++n2;
        }
        n = 0;
        while (n < 8) {
            if (this.data.playerFire[n].isAlive()) {
                this.bufferGraphics.drawImage(this.data.playerFire[n].getFace(), this.data.playerFire[n].getXco(), this.data.playerFire[n].getYco(), this);
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < this.data.getEnemyFire()) {
            if (this.data.enemyFire[n3].isAlive()) {
                this.bufferGraphics.drawImage(this.data.enemyFire[n3].getFace(), this.data.enemyFire[n3].getXco(), this.data.enemyFire[n3].getYco(), this);
            }
            ++n3;
        }
        if (this.data.isWaiting() || this.starting) {
            this.bufferGraphics.setColor(Color.gray);
            this.bufferGraphics.fillRect(82, 82, 240, 140);
            this.bufferGraphics.setColor(this.data.bgColor);
            this.bufferGraphics.fillRect(80, 80, 240, 140);
            this.bufferGraphics.setColor(this.data.fgColor);
            this.bufferGraphics.drawRect(81, 81, 238, 138);
            if (this.starting) {
                this.bufferGraphics.drawString("Press Enter to Start", 100, 190);
                this.bufferGraphics.drawString("Save The Earth!", 100, 100);
            } else {
                this.bufferGraphics.drawString("Level " + this.data.getLevel() + " completed!", 100, 160);
                this.bufferGraphics.drawString("Score: " + this.data.getScore(), 100, 130);
                if (!this.gameOver) {
                    this.bufferGraphics.drawString("Press Enter for next level", 100, 190);
                    this.bufferGraphics.drawString(this.data.getMesg(this.data.getLevel()), 100, 100);
                } else {
                    if (this.inv.doHighScore) {
                        this.bufferGraphics.drawString("Press Enter to view highscores", 100, 190);
                    } else {
                        this.bufferGraphics.drawString("Press Enter to Restart", 100, 190);
                    }
                    if (this.data.getLevel() < 5) {
                        this.bufferGraphics.drawString("You had to shoot those moving things", 100, 100);
                    } else if (this.data.getLevel() < 10) {
                        this.bufferGraphics.drawString("No No No! Not good!", 100, 100);
                    } else if (this.data.getLevel() < 15) {
                        this.bufferGraphics.drawString("Could've been worse...", 100, 100);
                    } else {
                        this.bufferGraphics.drawString("Excellent play!", 100, 100);
                    }
                }
            }
        }
        graphics.drawImage(this.buffer, 0, 0, this);
    }

    public void processEvent(int n) {
        if (n == 37) {
            this.data.player.calcMove(-5);
        }
        if (n == 39) {
            this.data.player.calcMove(5);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        ** GOTO lbl27
        {
            this.requestFocus();
            try {
                Thread.sleep(this.delay);
            }
            catch (Exception v0) {}
            if (!this.starting) {
                this.processEvent(this.getKey());
                this.moveShips();
                this.moveBullets();
                this.enemyAttack();
                this.checkCollision();
                this.checkPlayerCollision();
                this.checkRespawn();
                this.generateBonus();
                this.checkBonusCollision();
                this.checkBulletBug();
                this.doPaint();
            }
            do {
                if (this.runFlag) continue block4;
                try {
                    if (this.gameOver) {
                        Thread.sleep(2000L);
                    }
                    Thread.sleep(500L);
                }
                catch (Exception v1) {}
lbl27:
                // 3 sources

            } while (this.threadAlive);
        }
        System.out.println("Thread has stopped");
    }

    public void startActions() {
        if ((this.data.getLevel() - 1) % 5 == 0) {
            this.inv.startS.play();
        }
        this.runFlag = true;
        this.inv.info.refresh();
    }

    public void stopActions() {
        this.runFlag = false;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

