/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;

final class Enemy
extends Ship {
    private Data data;
    private int id;
    private int type;
    private String face1;
    private String face2;

    public Enemy(Data data, int n) {
        this.id = n;
        this.data = data;
        this.setDirection(1);
        this.setType(1);
        if (n * 50 < 210) {
            this.xco = n * 50;
            this.yco = 30;
            data.idOld = n + 1;
        } else if ((n - data.idOld) * 50 < 210 && !data.inOrder()) {
            this.xco = (n - data.idOld) * 50;
            this.yco = 90;
        } else {
            if (!data.inOrder()) {
                data.setInOrder(true);
                data.idOld = n;
            }
            this.xco = (n - data.idOld) * 50;
            this.yco = 140;
        }
    }

    public void calcMove() {
        int n = 0;
        n = this.data.bossMode ? 40 : 0;
        if (this.isAlive()) {
            if (this.direction > 0) {
                if (this.xco < 370 - n) {
                    if (this.data.enemyKilled < 8) {
                        ++this.xco;
                    } else if (this.data.enemyKilled > 7) {
                        this.xco += 2;
                    }
                    if (this.data.getLevel() > 11) {
                        ++this.xco;
                    }
                    if (this.data.bossMode) {
                        this.xco += 2;
                    }
                } else {
                    this.changeDirectionAll();
                }
            } else if (this.direction < 0) {
                if (this.xco > 2) {
                    if (this.data.enemyKilled < 8) {
                        --this.xco;
                    } else if (this.data.enemyKilled > 7) {
                        this.xco -= 2;
                    }
                    if (this.data.getLevel() > 11) {
                        --this.xco;
                    }
                    if (this.data.bossMode) {
                        this.xco -= 2;
                    }
                } else {
                    this.changeDirectionAll();
                }
            }
        }
        if (this.yco > 260 - n) {
            this.explode(10);
            this.data.player.explode(20);
            this.data.playerKilled();
            this.data.inv.explodeS.play();
            this.data.inv.field.gameOver();
        }
    }

    public void changeDirectionAll() {
        int n = 0;
        while (n < this.data.getEnemyNumber()) {
            this.data.enemies[n].drop();
            this.data.enemies[n].changeDirection();
            ++n;
        }
    }

    public Image getFace() {
        if (!this.exploding) {
            this.animate();
            if (this.defaultFace) {
                return this.data.getGraphic(this.face1);
            }
            return this.data.getGraphic(this.face2);
        }
        this.explode(10);
        if (this.explodeCount % 4 == 0) {
            return this.data.getGraphic("explode1G");
        }
        return this.data.getGraphic("explode2G");
    }

    public int getType() {
        return this.type;
    }

    public void randAttack() {
        double d = 0.0;
        if (this.type == 3) {
            if (this.getXco() - this.data.player.getXco() < 5 && this.getXco() - this.data.player.getXco() > -5 && (int)(d = Math.random() * (double)this.data.getRandomMod()) % 5 == 0) {
                d = 1.0;
            }
        } else if (this.type == 4) {
            if (this.getXco() - this.data.player.getXco() < 90 && this.getXco() - this.data.player.getXco() > 80) {
                d = Math.random() * (double)this.data.getRandomMod();
                if ((int)d % 5 == 0) {
                    d = 1.0;
                }
            } else if (this.getXco() - this.data.player.getXco() > -90 && this.getXco() - this.data.player.getXco() < -80 && (int)(d = Math.random() * (double)this.data.getRandomMod()) % 5 == 0) {
                d = 1.0;
            }
        }
        if (d != 1.0) {
            d = Math.random() * (double)this.data.getRandomMod();
            if (this.type == 2 && d >= 2.0) {
                d /= 2.0;
            }
        }
        if ((int)d == 1) {
            int n = 0;
            while (n < this.data.getEnemyFire()) {
                if (!this.data.enemyFire[n].isAlive()) {
                    this.data.enemyFire[n].setXco(this.getXco() + 10);
                    this.data.enemyFire[n].setYco(this.getYco() + 10);
                    this.data.enemyFire[n].setDirection(1);
                    int n2 = 0;
                    if (this.data.bossMode) {
                        n2 = 2;
                    }
                    if (this.getType() == 1) {
                        this.data.enemyFire[n].setSpeed(3 + n2);
                    } else if (this.getType() == 2) {
                        this.data.enemyFire[n].setSpeed(4 + n2);
                    } else if (this.getType() == 3) {
                        this.data.enemyFire[n].setSpeed(5 + n2);
                    } else if (this.getType() == 4) {
                        this.data.enemyFire[n].setSpeed(6 + n2);
                    }
                    this.data.enemyFire[n].enable();
                    break;
                }
                ++n;
            }
        }
    }

    public void setType(int n) {
        if (n == 1) {
            this.face1 = "alien1aG";
            this.face2 = "alien1bG";
            this.type = 1;
        } else if (n == 2) {
            this.face1 = "alien2aG";
            this.face2 = "alien2bG";
            this.type = 2;
        } else if (n == 3) {
            this.face1 = "alien3aG";
            this.face2 = "alien3bG";
            this.type = 3;
        } else {
            this.face1 = "alien4aG";
            this.face2 = "alien4bG";
            this.type = 4;
        }
    }
}

