/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Image;

final class Data {
    protected Invaders inv;
    protected Player player;
    private Image player1G;
    private Image player2G;
    private Image alien1aG;
    private Image alien1bG;
    private Image explode1G;
    private Image explode2G;
    private Image bulletG;
    private Image bullet2G;
    private Image alien4aG;
    private Image alien4bG;
    private Image bonus1G;
    private Image bonus2G;
    private Image alien2aG;
    private Image alien2bG;
    private Image alien3aG;
    private Image alien3bG;
    protected Image bt1a;
    protected Image bt1b;
    protected Image bt1c;
    protected Image bt2a;
    protected Image bt2b;
    protected Image bt2c;
    protected Image bt3a;
    protected Image bt3b;
    protected Image bt3c;
    protected Image real1;
    protected Image real2;
    protected Image real3;
    protected Image bgimage;
    protected Image logoG;
    private int score;
    private int level;
    private int ships;
    private int bullets;
    protected Color bgColor;
    protected Color fgColor;
    protected Color[] bgCol = new Color[5];
    protected Enemy[] enemies;
    protected Bullet[] playerFire = new Bullet[8];
    protected Bullet[] enemyFire;
    protected int idOld;
    protected boolean firstRun = false;
    private int limitBlock = 30;
    protected int numberOfEnemies;
    protected int enemyKilled;
    protected int numberOfEnemyFire;
    private int speed;
    private int randomMod;
    private boolean waiting;
    private String[] mesg = new String[20];
    private int bonusTime;
    protected Bonus bonus = new Bonus(this);
    private int bonusCount;
    protected int mode;
    protected int cbonus;
    protected boolean superBullets;
    protected boolean bossMode;
    protected int bossHits;

    public Data(Invaders invaders) {
        this.inv = invaders;
        this.bgColor = new Color(0, 0, 0);
        this.fgColor = new Color(255, 255, 255);
        this.score = 0;
    }

    public void addToBonus(int n) {
        this.cbonus = n == 0 ? 0 : (this.cbonus += n);
    }

    public void addToBullets(int n) {
        this.bullets = n == 0 ? 4 : (this.bullets += n);
    }

    public void addToBullets(int n, int n2) {
        if (n2 < 4 && !this.playerFire[n2 + 4].isAlive()) {
            this.addToBullets(1);
        } else if (n2 > 3 && !this.playerFire[n2 - 4].isAlive()) {
            this.addToBullets(1);
        }
    }

    public void addToLevel(int n) {
        this.level = n == 0 ? 1 : (this.level += n);
    }

    public void addToLimit() {
        this.limitBlock += 2;
    }

    public void addToScore(int n) {
        this.score += n;
        this.inv.info.refresh();
    }

    public void addToShips(int n) {
        this.ships = n == 0 ? 4 : (this.ships += n);
    }

    public void bonusKilled() {
        this.addToScore(100);
        if (this.getBonus() < 3) {
            this.addToBonus(1);
        } else {
            this.addToBonus(0);
            this.addToBonus(1);
        }
        if (this.mode < 3) {
            ++this.mode;
        } else {
            this.superBullets = true;
            this.mode = 1;
            this.addToShips(1);
            this.inv.info.refresh();
        }
    }

    public void bulletsUp() {
        if (this.randomMod > 10) {
            this.randomMod -= 5;
            System.out.println("Randommod is: " + this.randomMod);
        }
    }

    public void enemyKilled() {
        this.addToScore(5);
        ++this.enemyKilled;
        if (this.enemyKilled == 8 && this.getLevel() % 3 == 1) {
            this.inv.endS.play();
        }
        if (this.enemyKilled == this.getEnemyNumber()) {
            this.waitMode(true);
            this.inv.field.stopActions();
        }
    }

    public void gameOver() {
        this.inv.gameOver();
    }

    public void generateBonus() {
        ++this.bonusCount;
        if (this.bonusCount == this.bonusTime) {
            this.bonus.reset();
            this.bonus.enable();
        }
    }

    public int getBonus() {
        return this.cbonus;
    }

    public int getBulletsLeft() {
        return this.bullets;
    }

    public int getEnemyFire() {
        return this.numberOfEnemyFire;
    }

    public int getEnemyNumber() {
        return this.numberOfEnemies;
    }

    public Image getGraphic(String string) {
        if (string.equals("player1G")) {
            return this.player1G;
        }
        if (string.equals("player2G")) {
            return this.player2G;
        }
        if (string.equals("alien1aG")) {
            return this.alien1aG;
        }
        if (string.equals("alien1bG")) {
            return this.alien1bG;
        }
        if (string.equals("alien2aG")) {
            return this.alien2aG;
        }
        if (string.equals("alien2bG")) {
            return this.alien2bG;
        }
        if (string.equals("alien3aG")) {
            return this.alien3aG;
        }
        if (string.equals("alien3bG")) {
            return this.alien3bG;
        }
        if (string.equals("alien4aG")) {
            return this.alien4aG;
        }
        if (string.equals("alien4bG")) {
            return this.alien4bG;
        }
        if (string.equals("bullet2G")) {
            return this.bullet2G;
        }
        if (string.equals("bulletG")) {
            return this.bulletG;
        }
        if (string.equals("explode1G")) {
            return this.explode1G;
        }
        if (string.equals("explode2G")) {
            return this.explode2G;
        }
        if (string.equals("bonus1G")) {
            return this.bonus1G;
        }
        if (string.equals("bonus2G")) {
            return this.bonus2G;
        }
        if (string.equals("logoG")) {
            return this.logoG;
        }
        return null;
    }

    public int getLevel() {
        return this.level;
    }

    public int getLimitBlock() {
        return this.limitBlock;
    }

    public String getMesg(int n) {
        if (n < 20) {
            return this.mesg[n];
        }
        return "No Comments, Sir.";
    }

    public int getRandomMod() {
        return this.randomMod;
    }

    public int getScore() {
        return this.score;
    }

    public int getShipsLeft() {
        return this.ships;
    }

    public int getSpeed() {
        return this.speed;
    }

    public boolean inOrder() {
        return this.firstRun;
    }

    public void initData() {
        this.superBullets = false;
        this.mode = 1;
        this.bossMode = false;
        this.bgCol[0] = Color.cyan;
        this.bgCol[1] = Color.blue;
        this.bgCol[2] = Color.yellow;
        this.bgCol[3] = Color.red;
        this.bgCol[4] = Color.green;
        this.fgColor = this.bgCol[this.getLevel() % 5];
        this.loadMesg();
        this.randomMod = 150;
        this.speedUp();
        this.speedUp();
        this.setEnemies(10, 5);
        this.addToScore(0);
        this.addToShips(0);
        this.addToBullets(0);
        this.addToLevel(0);
        this.bonusTime = (int)(Math.random() * 500.0);
        this.bonusCount = 0;
        this.player = new Player(this);
        this.player.enable();
        this.setInOrder(false);
        this.enemies = new Enemy[this.getEnemyNumber()];
        this.enemyFire = new Bullet[this.getEnemyFire()];
        int n = 0;
        while (n < this.getEnemyNumber()) {
            this.enemies[n] = new Enemy(this, n);
            this.enemies[n].enable();
            ++n;
        }
        int n2 = 0;
        while (n2 < 8) {
            this.playerFire[n2] = new Bullet(this);
            this.playerFire[n2].setType(2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < 5) {
            this.enemyFire[n3] = new Bullet(this);
            ++n3;
        }
    }

    public boolean isMode(int n) {
        return n == this.mode;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public void loadGraphics(int n) {
        switch (n) {
            case 1: {
                this.player1G = this.inv.loadImage("player1G.gif");
                break;
            }
            case 2: {
                this.player2G = this.inv.loadImage("player2G.gif");
                break;
            }
            case 3: {
                this.bulletG = this.inv.loadImage("bulletG.gif");
                break;
            }
            case 4: {
                this.alien1aG = this.inv.loadImage("alien1aG.gif");
                break;
            }
            case 5: {
                this.alien1bG = this.inv.loadImage("alien1bG.gif");
                break;
            }
            case 6: {
                this.explode2G = this.inv.loadImage("explode1G.gif");
                break;
            }
            case 7: {
                this.explode1G = this.inv.loadImage("explode2G.gif");
                break;
            }
            case 8: {
                this.logoG = this.inv.loadImage("logo.gif");
                break;
            }
            case 9: {
                this.alien2aG = this.inv.loadImage("alien2aG.gif");
                break;
            }
            case 10: {
                this.alien2bG = this.inv.loadImage("alien2bG.gif");
                break;
            }
            case 11: {
                this.alien3aG = this.inv.loadImage("alien3aG.gif");
                break;
            }
            case 12: {
                this.alien3bG = this.inv.loadImage("alien3bG.gif");
                break;
            }
            case 13: {
                this.alien4aG = this.inv.loadImage("alien4aG.gif");
                break;
            }
            case 14: {
                this.alien4bG = this.inv.loadImage("alien4bG.gif");
                break;
            }
            case 15: {
                this.bgimage = this.inv.loadImage("invbg.gif");
                break;
            }
            case 16: {
                this.logoG = this.inv.loadImage("logoG.gif");
                break;
            }
            case 17: {
                this.bonus1G = this.inv.loadImage("bonus1G.gif");
                break;
            }
            case 18: {
                this.bonus2G = this.inv.loadImage("bonus2G.gif");
                break;
            }
            case 19: {
                this.bullet2G = this.inv.loadImage("bullet2G.gif");
                break;
            }
            case 20: {
                this.bt1a = this.inv.loadImage("bt1a.gif");
                break;
            }
            case 21: {
                this.bt1b = this.inv.loadImage("bt1b.gif");
                break;
            }
            case 22: {
                this.bt1c = this.inv.loadImage("bt1c.gif");
                break;
            }
            case 23: {
                this.bt2a = this.inv.loadImage("bt2a.gif");
                break;
            }
            case 24: {
                this.bt2b = this.inv.loadImage("bt2b.gif");
                break;
            }
            case 25: {
                this.bt2c = this.inv.loadImage("bt2c.gif");
                break;
            }
            case 26: {
                this.bt3a = this.inv.loadImage("bt3a.gif");
                break;
            }
            case 27: {
                this.bt3b = this.inv.loadImage("bt3b.gif");
                break;
            }
            case 28: {
                this.bt3c = this.inv.loadImage("bt3c.gif");
                break;
            }
            case 29: {
                this.real1 = this.inv.loadImage("real1.gif");
                break;
            }
            case 30: {
                this.real2 = this.inv.loadImage("real2.gif");
                break;
            }
            case 31: {
                this.real3 = this.inv.loadImage("real3.gif");
                break;
            }
        }
        this.inv.repaint();
    }

    private void loadMesg() {
        this.mesg[1] = "So you found the shoot button, huh?";
        this.mesg[2] = "This is just the beginning...";
        this.mesg[3] = "Still warming up.";
        this.mesg[4] = "That was easy";
        this.mesg[5] = "Stress? What is that?";
        this.mesg[6] = "Ooooooh you made it";
        this.mesg[7] = "You think your really something, wait.";
        this.mesg[8] = "Agression comes back to you";
        this.mesg[9] = "Still relaxed?";
        this.mesg[10] = "Even my grandmother got this far";
        this.mesg[11] = "Alright, try this then";
        this.mesg[12] = "Still alive? Better than I thought";
        this.mesg[13] = "Try this";
        this.mesg[14] = "That woke you, didn't it?";
        this.mesg[15] = "It's time to lose";
        this.mesg[16] = "Stop playing, this is bad for you";
        this.mesg[17] = "You are good!";
        this.mesg[18] = "Breaking records...";
        this.mesg[19] = "That's it, I'm out of here";
    }

    public void makeEnemies() {
        int n = 0;
        while (n < this.getEnemyNumber()) {
            this.enemies[n] = new Enemy(this, n);
            this.enemies[n].enable();
            if (this.getLevel() < 3) {
                if (n % 4 == 0) {
                    this.enemies[n].setType(2);
                } else {
                    this.enemies[n].setType(1);
                }
            }
            if (this.getLevel() > 2 && this.getLevel() < 5) {
                if (n < 5) {
                    this.enemies[n].setType(2);
                } else {
                    this.enemies[n].setType(1);
                }
                if (n == 2 || n == 3) {
                    this.enemies[n].setType(3);
                }
            }
            if (this.getLevel() > 4 && this.getLevel() < 8) {
                if (n < 5) {
                    this.enemies[n].setType(3);
                } else if (n < 10) {
                    this.enemies[n].setType(2);
                } else {
                    this.enemies[n].setType(1);
                }
            }
            if (this.getLevel() > 7 && this.getLevel() < 11) {
                if (n < 10) {
                    this.enemies[n].setType(2);
                } else {
                    this.enemies[n].setType(3);
                }
                if (n == 2 || n == 3) {
                    this.enemies[n].setType(4);
                }
            }
            if (this.getLevel() > 10 && this.getLevel() < 16) {
                if (n < 10) {
                    this.enemies[n].setType(3);
                } else {
                    this.enemies[n].setType(4);
                }
                if (n == 2 || n == 3) {
                    this.enemies[n].setType(2);
                }
            }
            if (this.getLevel() > 15) {
                if (n < 10) {
                    this.enemies[n].setType(4);
                } else {
                    this.enemies[n].setType(3);
                }
                if (n == 2 || n == 3) {
                    this.enemies[n].setType(2);
                }
            }
            if (this.bossMode) {
                if (this.getLevel() == 5) {
                    this.enemies[n].setType(1);
                }
                if (this.getLevel() == 10) {
                    this.enemies[n].setType(2);
                }
                if (this.getLevel() == 15) {
                    this.enemies[n].setType(3);
                }
                if (this.getLevel() > 15) {
                    this.enemies[n].setType(4);
                }
            }
            ++n;
        }
    }

    public void nextLevel() {
        this.fgColor = this.bgCol[this.getLevel() % 5];
        this.bossMode = false;
        this.bossHits = 0;
        this.bonusTime = (int)(Math.random() * 500.0);
        this.bonusCount = 0;
        this.enemyKilled = 0;
        this.addToLevel(1);
        this.addToLimit();
        this.setEnemies(10 + this.getLevel() - 1, 1 + this.getLevel());
        if (this.getLevel() % 5 == 0) {
            this.setEnemies(1, 10);
            this.bossMode = true;
        }
        this.addToScore(100);
        this.addToBullets(0);
        this.player = new Player(this);
        this.player.enable();
        this.setInOrder(false);
        this.enemyFire = new Bullet[this.getEnemyFire()];
        int n = 0;
        while (n < this.getEnemyFire()) {
            this.enemyFire[n] = new Bullet(this);
            ++n;
        }
        this.enemies = new Enemy[this.getEnemyNumber()];
        this.makeEnemies();
        int n2 = 0;
        while (n2 < 8) {
            this.playerFire[n2] = new Bullet(this);
            this.playerFire[n2].setType(2);
            ++n2;
        }
        this.inv.field.startActions();
    }

    public void playerKilled() {
        this.addToShips(-1);
        this.addToBonus(0);
        this.mode = 1;
        this.superBullets = false;
        this.inv.info.refresh();
    }

    public void reset() {
        this.limitBlock = 30;
        this.firstRun = false;
        this.score = 0;
        this.enemyKilled = 0;
        this.superBullets = false;
        this.mode = 1;
        this.bossMode = false;
    }

    public void setEnemies(int n, int n2) {
        this.numberOfEnemyFire = n2;
        if (n < 16) {
            this.numberOfEnemies = n;
        } else {
            this.speedUp();
            this.numberOfEnemies = 15;
        }
    }

    public void setInOrder(boolean bl) {
        this.firstRun = bl;
    }

    public void speedUp() {
        if (this.speed < 5) {
            ++this.speed;
            System.out.println("speed is: " + this.speed);
        } else {
            this.bulletsUp();
        }
    }

    public void waitMode(boolean bl) {
        this.waiting = bl;
    }
}

