/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;

public class Ship {
    private int m_iRow;
    private int m_iCol;
    private int m_iLength;
    private boolean m_bIsHoriz;
    private String m_sName;

    boolean getIsHoriz() {
        return this.m_bIsHoriz;
    }

    Ship(int n, String string) {
        this.m_iLength = n;
        this.m_sName = string;
    }

    public boolean hasSunk(Board board) {
        int n = 0;
        while (n < this.m_iLength) {
            if (this.m_bIsHoriz ? board.getSquare(this.m_iRow, this.m_iCol + n) == 's' : board.getSquare(this.m_iRow + n, this.m_iCol) == 's') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getName() {
        return this.m_sName;
    }

    public boolean placeShip(Board board, int n, int n2, boolean bl) {
        if (n < 0 || n2 < 0) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.m_iLength) {
            if (bl) {
                if (n2 + n3 >= 10) {
                    return false;
                }
                if (board.getSquare(n, n2 + n3) == 's') {
                    return false;
                }
                if (board.getSquare(n, n2 + n3) != ' ') {
                    return false;
                }
                if (n - 1 >= 0 && board.getSquare(n - 1, n2 + n3) != ' ') {
                    return false;
                }
                if (n + 1 < 10 && board.getSquare(n + 1, n2 + n3) != ' ') {
                    return false;
                }
            } else {
                if (n + n3 >= 10) {
                    return false;
                }
                if (board.getSquare(n + n3, n2) == 's') {
                    return false;
                }
                if (board.getSquare(n + n3, n2) != ' ') {
                    return false;
                }
                if (n2 - 1 >= 0 && board.getSquare(n + n3, n2 - 1) != ' ') {
                    return false;
                }
                if (n2 + 1 < 10 && board.getSquare(n + n3, n2 + 1) != ' ') {
                    return false;
                }
            }
            ++n3;
        }
        if (bl) {
            if (n2 - 1 >= 0 && board.getSquare(n, n2 - 1) != ' ') {
                return false;
            }
            if (n2 + this.m_iLength < 10 && board.getSquare(n, n2 + this.m_iLength) != ' ') {
                return false;
            }
        } else {
            if (n - 1 >= 0 && board.getSquare(n - 1, n2) != ' ') {
                return false;
            }
            if (n + this.m_iLength < 10 && board.getSquare(n + this.m_iLength, n2) != ' ') {
                return false;
            }
        }
        this.m_iRow = n;
        this.m_iCol = n2;
        this.m_bIsHoriz = bl;
        n3 = 0;
        while (n3 < this.m_iLength) {
            if (bl) {
                board.markBoard(n, n2 + n3, 's');
            } else {
                board.markBoard(n + n3, n2, 's');
            }
            ++n3;
        }
        return true;
    }

    public int getLength() {
        return this.m_iLength;
    }

    public boolean hasSquare(int n, int n2) {
        if (this.m_bIsHoriz) {
            if (this.m_iRow != n) {
                return false;
            }
            int n3 = this.m_iCol + this.m_iLength;
            return n2 >= this.m_iCol && n2 < n3;
        }
        if (this.m_iCol != n2) {
            return false;
        }
        int n4 = this.m_iRow + this.m_iLength;
        return n >= this.m_iRow && n < n4;
    }

    Point getLocation() {
        return new Point(this.m_iRow, this.m_iCol);
    }
}

