/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class HotSpot
extends Canvas
implements MouseListener {
    private static HotSpotListener hsl;
    private Color fgcolor1;
    private Color fgcolor2;
    private Color fgcolor3;
    private Color bgcolor1 = new Color(122, 122, 122);
    private Color bgcolor2 = new Color(188, 188, 188);
    private Color bgcolor3 = new Color(0, 0, 0);
    private String mesg1 = "";
    private String mesg2 = "";
    private String mesg3 = "";
    private Image bgimage1;
    private Image bgimage2;
    private Image bgimage3;
    private int width;
    private int height;
    private boolean mouseOver;
    private boolean mousePressed;
    private boolean enabled;
    private boolean useImages;
    private boolean action;
    private FontMetrics fm;
    private int fontwidth;
    private int fontsize;
    private Image buff;
    private Graphics g;
    private boolean mouseOverAction = false;

    public HotSpot(HotSpotListener hotSpotListener) {
        this.fgcolor1 = new Color(0, 0, 0);
        this.fgcolor2 = new Color(48, 48, 48);
        this.fgcolor3 = new Color(255, 255, 255);
        this.setBackground(Color.yellow);
        hsl = hotSpotListener;
        this.addMouseListener(this);
    }

    public HotSpot(String string, HotSpotListener hotSpotListener) {
        this(hotSpotListener);
        this.mesg1 = string;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseOver = true;
        this.setCursor(new Cursor(12));
        if (this.mouseOverAction) {
            hsl.hotSpotOver(this);
        }
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseOver = false;
        this.mousePressed = false;
        this.setCursor(new Cursor(0));
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mousePressed = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        hsl.hotSpotEvent(this);
        this.mousePressed = false;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.buff == null) {
            this.buff = this.createImage(dimension.width, dimension.height);
            this.g = this.buff.getGraphics();
        }
        int n = 0;
        if (this.mousePressed) {
            this.g.setColor(this.bgcolor3);
            this.g.fillRect(0, 0, dimension.width, dimension.height);
            if (this.bgimage3 != null) {
                int n2 = this.bgimage3.getWidth(this) / 2;
                n = this.bgimage3.getHeight(this) / 2;
                this.g.drawImage(this.bgimage3, dimension.width / 2 - n2, dimension.height / 2 - n, this);
            }
        } else if (this.mouseOver) {
            this.g.setColor(this.bgcolor2);
            this.g.fillRect(0, 0, dimension.width, dimension.height);
            if (this.bgimage2 != null) {
                int n3 = this.bgimage2.getWidth(this) / 2;
                n = this.bgimage2.getHeight(this) / 2;
                this.g.drawImage(this.bgimage2, dimension.width / 2 - n3, dimension.height / 2 - n, this);
            }
        } else {
            this.g.setColor(this.bgcolor1);
            this.g.fillRect(0, 0, dimension.width, dimension.height);
            if (this.bgimage1 != null) {
                int n4 = this.bgimage1.getWidth(this) / 2;
                n = this.bgimage1.getHeight(this) / 2;
                this.g.drawImage(this.bgimage1, dimension.width / 2 - n4, dimension.height / 2 - n, this);
            }
        }
        graphics.drawImage(this.buff, 0, 0, this);
    }

    public void setImage(Image image, int n) {
        switch (n) {
            case 1: {
                this.bgimage1 = image;
                break;
            }
            case 2: {
                this.bgimage2 = image;
                break;
            }
            case 3: {
                this.bgimage3 = image;
                break;
            }
            default: {
                this.bgimage1 = image;
            }
        }
    }

    public void setMouseOverAction(boolean bl) {
        this.mouseOverAction = bl;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

