/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import netscape.javascript.JSObject;

public class GConsole
extends Applet
implements HotSpotListener,
Loadable {
    private HotSpot hsUp;
    private HotSpot hsDown;
    private HotSpot hsLogo;
    private HotSpot hsStart;
    private Cdescription cdes;
    private Cselection csel;
    private Vector games;
    private String js;
    protected boolean registered;
    private RealMedia rm;
    private Graphics gbuf;
    private Image buf;
    private Dimension dim;
    private int gIndex = 0;
    private String companyname = "RealApplets";
    private boolean useWhite = false;
    private boolean ready;
    protected boolean demo = false;

    public void init() {
        this.registered = false;
        if (this.registered) {
            this.companyname = this.getParameter("user_name");
            if (this.companyname == null) {
                this.companyname = "Read readme for help about extra parameter";
            }
            if (!this.doCheckRoutine()) {
                System.out.println("License is missing");
                return;
            }
        }
        System.out.println("******************************");
        System.out.println("* RealApplets Game Console   *");
        if (this.registered) {
            System.out.println("* REGISTERED VERSION         *");
        } else {
            System.out.println("* UNREGISTERED VERSION       *");
        }
        System.out.println("* Release 1.3                *");
        System.out.println("******************************");
        this.setLayout(null);
        this.dim = this.getSize();
        this.buf = this.createImage(this.dim.width, this.dim.height);
        this.gbuf = this.buf.getGraphics();
        if (this.getParameter("useWhite").toUpperCase().equals("YES")) {
            this.useWhite = true;
        }
        ReadUtil readUtil = new ReadUtil(this, this.getParameter("games_file"));
        this.rm = new RealMedia(this);
        if (!this.registered || this.demo) {
            this.rm.add("logo1.jpg");
        }
        if (!this.registered || this.demo) {
            this.rm.add("logo2.jpg");
        }
        this.rm.add("gc_pijlup1.jpg");
        this.rm.add("gc_pijlup2.jpg");
        this.rm.add("gc_pijldown1.jpg");
        this.rm.add("gc_pijldown2.jpg");
        this.rm.add("button1.jpg");
        this.rm.add("button2.jpg");
        this.rm.add("gc_desc.jpg");
        this.rm.add("gc_sel.jpg");
        if (!this.useWhite) {
            this.rm.add("gc_ruw2.jpg");
        } else {
            this.rm.add("gc_ruw_white.jpg");
        }
        this.rm.load();
        readUtil.loadAll();
    }

    public void startUp() {
        while (!this.ready) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.hsUp = new HotSpot(this);
        this.hsDown = new HotSpot(this);
        this.hsLogo = new HotSpot(this);
        this.hsStart = new HotSpot(this);
        this.cdes = new Cdescription(this, 164, 228);
        this.csel = new Cselection(this, 147, 71);
        this.hsUp.setBounds(316, 126, 46, 27);
        this.hsDown.setBounds(316, 235, 46, 27);
        this.hsStart.setBounds(408, 277, 68, 40);
        this.hsLogo.setBounds(203, 273, 87, 47);
        this.csel.setBounds(267, 159, 147, 71);
        this.cdes.setBounds(10, 92, 164, 228);
        this.hsUp.setImage(this.rm.get("gc_pijlup1.jpg"), 1);
        this.hsUp.setImage(this.rm.get("gc_pijlup2.jpg"), 2);
        this.hsUp.setImage(this.rm.get("gc_pijlup2.jpg"), 3);
        this.hsDown.setImage(this.rm.get("gc_pijldown1.jpg"), 1);
        this.hsDown.setImage(this.rm.get("gc_pijldown2.jpg"), 2);
        this.hsDown.setImage(this.rm.get("gc_pijldown2.jpg"), 3);
        this.hsStart.setImage(this.rm.get("button1.jpg"), 1);
        this.hsStart.setImage(this.rm.get("button2.jpg"), 2);
        this.hsStart.setImage(this.rm.get("button2.jpg"), 3);
        if (!this.registered || this.demo) {
            this.hsLogo.setImage(this.rm.get("logo1.jpg"), 1);
        }
        if (!this.registered || this.demo) {
            this.hsLogo.setImage(this.rm.get("logo2.jpg"), 2);
        }
        if (!this.registered || this.demo) {
            this.hsLogo.setImage(this.rm.get("logo2.jpg"), 3);
        }
        this.hsLogo.setMouseOverAction(true);
        this.cdes.setImage(this.rm.get("gc_desc.jpg"));
        this.csel.setImage(this.rm.get("gc_sel.jpg"));
        this.addComponents();
    }

    private void addComponents() {
        this.add(this.hsUp);
        this.add(this.hsDown);
        this.add(this.hsStart);
        this.add(this.cdes);
        this.add(this.csel);
        if (!this.registered) {
            this.add(this.hsLogo);
        }
        this.hsUp.repaint();
        this.hsDown.repaint();
        this.hsStart.repaint();
        this.hsLogo.repaint();
        this.cdes.repaint();
        this.csel.repaint();
        this.repaint();
    }

    public void giveData(Vector vector) {
        this.ready = true;
        this.games = vector;
    }

    private boolean doCheckRoutine() {
        InputStream inputStream = null;
        try {
            String string = this.getDocumentBase() + "";
            boolean bl = false;
            inputStream = new URL(this.getDocumentBase(), "license.ra").openStream();
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return false;
        }
        return true;
    }

    public void paint(Graphics graphics) {
        if (this.useWhite) {
            this.gbuf.setColor(Color.white);
        } else {
            this.gbuf.setColor(Color.black);
        }
        this.gbuf.fillRect(0, 0, this.dim.width, this.dim.height);
        this.gbuf.setFont(new Font("Arial", 1, 12));
        if (!this.rm.isLoaded() || !this.ready) {
            if (!this.useWhite) {
                this.gbuf.setColor(Color.white);
            } else {
                this.gbuf.setColor(Color.black);
            }
            this.gbuf.drawString("Loading graphic file " + this.rm.getCurrent() + " of " + this.rm.getTotalFiles(), 20, 20);
            this.gbuf.drawRect(20, 60, 200, 20);
            this.gbuf.setColor(Color.gray);
            this.gbuf.fillRect(21, 61, 2 * this.rm.getPercent() - 2, 19);
            if (!this.useWhite) {
                this.gbuf.setColor(Color.white);
            } else {
                this.gbuf.setColor(Color.black);
            }
            this.gbuf.drawString(this.rm.getPercent() + " %", 70, 73);
            if (!this.ready) {
                this.gbuf.drawString("Reading games...", 20, 120);
            }
            this.gbuf.drawString("Game Console", 20, 150);
            if (!this.registered) {
                this.gbuf.drawString("Limited Unregistered Version (V1.1)", 20, 170);
                this.gbuf.drawString("Register now at Http://www.realapplets.com", 20, 190);
                this.gbuf.drawString("Limited to 10 games, full version has 30 games!", 20, 210);
                this.gbuf.drawString("Graphics and design by Carl Nollet", 300, 50);
                this.gbuf.drawString("Programming by Bavo Bruylandt", 300, 70);
            } else {
                this.gbuf.drawString("Registered to: " + this.companyname, 20, 170);
                if (this.demo) {
                    this.gbuf.drawString("DEMO of Registered Version (V1.1)", 20, 190);
                    this.gbuf.setFont(new Font("Arial", 2, 12));
                    this.gbuf.drawString("It is not allowed to link to this page", 20, 230);
                }
            }
        } else if (this.rm.isLoaded() && this.ready) {
            if (this.useWhite) {
                this.gbuf.drawImage(this.rm.get("gc_ruw_white.jpg"), 0, 0, this);
            } else {
                this.gbuf.drawImage(this.rm.get("gc_ruw2.jpg"), 0, 0, this);
            }
        }
        graphics.drawImage(this.buf, 0, 0, this);
    }

    private void popGame(Game game) {
        this.csel.rest();
        String string = null;
        URL uRL = null;
        string = this.getCodeBase() + "" + game.getDir() + "/" + game.getHTML();
        try {
            uRL = new URL(string);
            String string2 = "window.open('" + string + "','Game','status=yes,width=" + game.getWidth() + ",height=" + game.getHeight() + ", toolbar=no, location=no,menubar=no,scrollbars=yes,resizable=yes,copyhistory=no')";
            JSObject jSObject = JSObject.getWindow((Applet)this);
            jSObject.eval(string2);
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.out.println("Does your applet tag include MAYSCRIPT?");
            System.out.println("eg. <APPLET CODE=Console.class  archive=Console.jar WIDTH=550 HEIGHT=335 MAYSCRIPT>");
            this.getAppletContext().showDocument(uRL, "Game");
        }
    }

    public void updateDescription() {
        this.cdes.showDescription();
    }

    public void showAd() {
        this.cdes.showAd();
    }

    public Game getSelectedGame() {
        return (Game)this.games.elementAt(this.gIndex);
    }

    public void setSelectedGame(int n) {
        this.gIndex = n;
    }

    public int numberOfGames() {
        if (this.registered) {
            return this.games.size();
        }
        if (this.games.size() > 10) {
            return 10;
        }
        return this.games.size();
    }

    public Game gameAt(int n) {
        if (n > this.numberOfGames() - 1) {
            n = this.numberOfGames() - 1;
        } else if (n < 0) {
            n = 0;
        }
        return (Game)this.games.elementAt(n);
    }

    private void popRA() {
        if (!this.registered) {
            URL uRL = null;
            try {
                uRL = new URL("http://www.realapplets.com");
                this.getAppletContext().showDocument(uRL, "_blank");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getFontWidth(String string) {
        FontMetrics fontMetrics = this.getFontMetrics(new Font("Arial", 1, 16));
        return fontMetrics.stringWidth(string);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void hotSpotEvent(HotSpot hotSpot) {
        this.csel.wakeUp();
        if (hotSpot == this.hsUp) {
            this.csel.selectUp();
        } else if (hotSpot == this.hsDown) {
            this.csel.selectDown();
        } else if (hotSpot == this.hsStart) {
            this.popGame(this.getSelectedGame());
        } else if (hotSpot == this.hsLogo) {
            this.popRA();
        }
    }

    public void hotSpotOver(HotSpot hotSpot) {
        this.csel.wakeUp();
        if (!this.registered && hotSpot == this.hsLogo) {
            this.showAd();
        }
    }

    public Image loadImage(String string) {
        return this.getImage(this.getCodeBase(), string);
    }

    public AudioClip loadAudio(String string) {
        return this.getAudioClip(this.getCodeBase(), string);
    }

    public void destroy() {
        this.csel.quit();
        this.cdes.quit();
        try {
            this.csel = null;
            this.games = null;
            this.hsUp = null;
            this.hsDown = null;
            this.hsStart = null;
            this.cdes.quit();
            this.cdes = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

