/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;

class colorPanel {
    int x0;
    int y0;
    int panew;
    int paneh;
    int[] x;
    int[] y;
    int Npane = 9;
    int selectedColorPaneId;
    static int PANEID_QUIT = 6;
    static int PANEID_DONE = 7;
    static int PANEID_SPARE = 8;
    private Font colPaneFont;

    colorPanel(Dimension dimension) {
        this.panew = dimension.width / 3 / this.Npane;
        this.paneh = dimension.height / 3 / this.Npane;
        this.x0 = dimension.width - this.Npane * this.panew;
        this.y0 = dimension.height - this.paneh * 2;
        this.x = new int[this.Npane];
        this.y = new int[this.Npane];
        int n = 0;
        while (n < this.Npane) {
            this.x[n] = this.x0 + n * this.panew;
            this.y[n] = this.y0;
            ++n;
        }
        this.selectedColorPaneId = -1;
    }

    public int containing(Point point, boolean bl) {
        int n = -1;
        if (point.y >= this.y0 && point.y <= this.y0 + this.paneh && point.x >= this.x0 && point.x < this.x0 + (this.Npane - 1) * this.panew) {
            int n2 = 0;
            while (n2 < this.Npane - 1) {
                if (point.x < this.x0 + (n2 + 1) * this.panew) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        if (bl && n != -1) {
            this.selectedColorPaneId = n;
        }
        g.dbg(3, "colorPanel.containing: paneid=" + n + "; selectedColorPaneId=" + this.selectedColorPaneId);
        return n;
    }

    public void drawColorPanel(Graphics graphics) {
        int n = 0;
        while (n < 6) {
            g.dbg(0, "colorPanel.drawColorPanel: x=" + this.x[n] + "," + AcubeCanvas.colorArr[n] + AcubeCanvas.cName[n]);
            graphics.setColor(AcubeCanvas.colorArr[n]);
            graphics.fillRect(this.x[n], this.y[n], this.panew, this.paneh);
            graphics.setColor(Color.black);
            graphics.drawRect(this.x[n], this.y[n], this.panew, this.paneh);
            ++n;
        }
        graphics.setColor(Color.black);
        int n2 = Math.min(this.paneh, this.panew / 4);
        Font font = new Font("TimesRoman", 1, n2);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n3 = this.paneh - fontMetrics.getLeading();
        int n4 = (this.panew - fontMetrics.stringWidth("Quit ")) / 2;
        graphics.setFont(font);
        graphics.drawRect(this.x[PANEID_QUIT], this.y[PANEID_QUIT], this.panew, this.paneh);
        graphics.drawString("Quit", this.x[PANEID_QUIT] + n4, this.y[PANEID_QUIT] + n3);
        graphics.drawRect(this.x[PANEID_DONE], this.y[PANEID_DONE], this.panew, this.paneh);
        graphics.drawString("Done", this.x[PANEID_DONE] + n4, this.y[PANEID_DONE] + n3);
    }

    public void drawSelectedPane(Graphics graphics) {
        if (this.selectedColorPaneId == -1) {
            return;
        }
        this.drawColorPanel(graphics);
        graphics.setColor(Color.black);
        graphics.fillOval(this.x[this.selectedColorPaneId] + this.panew / 3, this.y[this.selectedColorPaneId] + this.paneh / 3, this.panew / 3, this.paneh / 3);
    }
}

