/*
 * Decompiled with CFR 0.152.
 */
class AsliceInfo {
    private AcubeLet[] cube;
    private int[] cell;
    private int nDIM;
    private int nDIM_1;
    private int nDIM2;
    private int sliceId;
    private int[] cubeId;
    AcolorPair[][] colorPair;
    int[] centerColorcode;
    int goodFaceColorcode;
    int NgoodCorner;
    int NbadEdge;
    int NoppositeCP;
    int NbadCP;
    AcolorPair targetCP;
    AcolorPair socketCP;
    static final int[][] sliceSide;

    static {
        int[][] nArrayArray = new int[6][];
        nArrayArray[0] = new int[]{2, 3, 4, 5};
        nArrayArray[1] = new int[]{2, 3, 4, 5};
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 5;
        nArrayArray[2] = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[2] = 4;
        nArray2[3] = 5;
        nArrayArray[3] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 3;
        nArrayArray[4] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[1] = 1;
        nArray4[2] = 2;
        nArray4[3] = 3;
        nArrayArray[5] = nArray4;
        sliceSide = nArrayArray;
    }

    AsliceInfo(AcubeLet[] acubeLetArray, int[] nArray, int n, int n2) {
        this.cube = acubeLetArray;
        this.cell = nArray;
        this.sliceId = n;
        this.nDIM = n2;
        this.nDIM2 = this.nDIM * this.nDIM;
        this.nDIM_1 = this.nDIM - 1;
        this.cubeId = new int[this.nDIM2];
        this.centerColorcode = new int[(this.nDIM - 2) * (this.nDIM - 2) + 1];
        this.colorPair = new AcolorPair[4][this.nDIM];
        int n3 = 0;
        while (n3 < 4) {
            int n4 = 0;
            while (n4 < this.nDIM) {
                this.colorPair[n3][n4] = new AcolorPair();
                ++n4;
            }
            ++n3;
        }
    }

    private void flagGood(int n) {
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < this.nDIM) {
                AcolorPair acolorPair = this.colorPair[n2][n3];
                if (acolorPair.cubeid == n) {
                    acolorPair.flag = 1;
                    g.dbg(0, "AsliceInfo.flagGood: top/side colors=" + acolorPair.topColor + "/" + acolorPair.sideColor + ";cubeid=" + n);
                }
                ++n3;
            }
            ++n2;
        }
    }

    AcolorPair locateCP(int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < 4) {
            int n5 = 0;
            while (n5 < this.nDIM) {
                AcolorPair acolorPair = this.colorPair[n4][n5];
                if (acolorPair.cubeid == n3 && acolorPair.topColor == n && acolorPair.sideColor == n2) {
                    g.dbg(0, "AsliceInfo.locateCP: found top/side colors=" + n + "/" + n2 + ";cubeid=" + n3 + acolorPair);
                    return acolorPair;
                }
                ++n5;
            }
            ++n4;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    AcolorPair locateSocket(AcolorPair acolorPair, int n) {
        int n2;
        int n3;
        int n4 = -1;
        int n5 = -1;
        g.dbg(2, "AsliceInfo::locateSocket: slice=" + this.sliceId + "; cpStartSideIx=" + n + "; plugcp=" + acolorPair);
        if (acolorPair != null) {
            n3 = acolorPair.topColor;
            n2 = acolorPair.sideColor;
        } else {
            n3 = 6;
            n2 = 6;
        }
        this.socketCP = null;
        int n6 = n;
        while (n6 < n + 4) {
            block11: {
                AcolorPair acolorPair2 = this.colorPair[n6 % 4][0];
                AcolorPair acolorPair3 = this.colorPair[n6 % 4][1];
                AcolorPair acolorPair4 = this.colorPair[n6 % 4][this.nDIM_1];
                if (acolorPair2.topColor == n3 && acolorPair2.sideColor == n2 || acolorPair4.topColor == n3 && acolorPair4.sideColor == n2) {
                    if (acolorPair3.topColor == n2 && acolorPair3.sideColor == n3) {
                        g.dbg(2, "AsliceInfo::locateSocket: found & ignore reverse plug/socket:" + acolorPair + "/" + acolorPair3);
                        break block11;
                    } else {
                        this.socketCP = this.colorPair[n6 % 4][1];
                        g.dbg(2, "AsliceInfo::locateSocket: found a mate socketCP=" + this.socketCP);
                        return this.socketCP;
                    }
                }
                if (acolorPair3.flag != 1) {
                    if (acolorPair3.topColor == n2 && acolorPair3.sideColor == n3) {
                        n5 = n6;
                    } else {
                        n4 = n6;
                    }
                }
            }
            ++n6;
        }
        if (n4 >= 0) {
            g.dbg(2, "AsliceInfo::locateSocket: found a non-mating socketCP=" + this.colorPair[n4 % 4][1]);
            return this.colorPair[n4 % 4][1];
        }
        if (n5 >= 0) {
            g.dbg(2, "AsliceInfo::locateSocket: found a reverse socketCP=" + this.colorPair[n5 % 4][1]);
            return this.colorPair[n5 % 4][1];
        }
        g.dbg(2, "AsliceInfo::locateSocket: found no socket/no bad/no reverse");
        return null;
    }

    private void markGood() {
        AcolorPair acolorPair;
        int n;
        int[] nArray = new int[8];
        int[] nArray2 = new int[4];
        AcolorPair acolorPair2 = null;
        AcolorPair acolorPair3 = null;
        this.goodFaceColorcode = 6;
        int n2 = 0;
        this.NbadEdge = 0;
        this.NbadCP = 0;
        this.NoppositeCP = 0;
        int n3 = 0;
        while (n3 < 4) {
            acolorPair2 = this.colorPair[n3][0];
            acolorPair3 = this.colorPair[n3][this.nDIM_1];
            if (acolorPair2.isIdenticalColor(acolorPair3) && (this.goodFaceColorcode == 6 || acolorPair2.topColor == this.goodFaceColorcode)) {
                this.goodFaceColorcode = acolorPair2.topColor;
                nArray[n2++] = acolorPair2.cubeid;
                nArray[n2++] = acolorPair3.cubeid;
            }
            ++n3;
        }
        this.NgoodCorner = n2 <= 2 ? n2 : (n2 == 8 ? 4 : (n2 == 4 ? 3 : 0));
        if (this.NgoodCorner == 0) {
            n3 = 0;
            while (n3 < 4) {
                n = 0;
                while (n < this.nDIM) {
                    acolorPair = this.colorPair[n3][n];
                    if (acolorPair.topColor == this.centerColorcode[0]) {
                        g.dbg(0, "AsliceInfo::markGood: colorPair[" + n3 + "][" + n + "]=" + acolorPair.toString());
                        this.goodFaceColorcode = acolorPair.topColor;
                        this.NgoodCorner = 1;
                        this.flagGood(acolorPair.cubeid);
                    }
                    n += this.nDIM_1;
                }
                ++n3;
            }
        }
        if (this.goodFaceColorcode == 6) {
            this.goodFaceColorcode = this.centerColorcode[0];
        }
        if (this.NgoodCorner == 0) {
            this.NbadEdge = 4 * (this.nDIM - 2);
            return;
        }
        n = 0;
        while (n < n2) {
            this.flagGood(nArray[n]);
            ++n;
        }
        n3 = 0;
        while (n3 < 4) {
            acolorPair2 = this.colorPair[n3][0];
            acolorPair3 = this.colorPair[n3][this.nDIM_1];
            if ((acolorPair2.flag == 1 || acolorPair3.flag == 1) && acolorPair3.flag == 1) {
                acolorPair2 = acolorPair3;
            }
            n = 1;
            while (n < this.nDIM_1) {
                acolorPair = this.colorPair[n3][n];
                if (acolorPair.isIdenticalColor(acolorPair2)) {
                    acolorPair.flagGood();
                } else {
                    ++this.NbadEdge;
                }
                ++n;
            }
            ++n3;
        }
    }

    public void setInfo() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.nDIM) {
            n2 = 0;
            while (n2 < this.nDIM) {
                int n5 = this.sliceId == 0 || this.sliceId == 1 ? this.sliceId * this.nDIM2 * this.nDIM_1 + n4 * this.nDIM + n2 : (this.sliceId == 2 || this.sliceId == 3 ? n4 * this.nDIM2 + (this.sliceId - 2) * this.nDIM * this.nDIM_1 + n2 : n4 * this.nDIM2 + n2 * this.nDIM + (this.sliceId - 4) * this.nDIM_1);
                this.cubeId[n4 * this.nDIM + n2] = n = this.cell[n5];
                if (n4 > 0 && n4 < this.nDIM_1 && n2 > 0 && n2 < this.nDIM_1) {
                    this.centerColorcode[n3++] = this.cube[n].getColorcode(this.sliceId);
                }
                if (this.nDIM == 2) {
                    this.centerColorcode[0] = this.cube[n].getColorcode(this.sliceId);
                }
                ++n2;
            }
            ++n4;
        }
        n2 = 0;
        while (n2 < 4) {
            int n6 = 0;
            while (n6 < this.nDIM) {
                int n7 = n2 == 0 || n2 == 1 ? n2 * this.nDIM * this.nDIM_1 + n6 : n6 * this.nDIM + (n2 - 2) * this.nDIM_1;
                n = this.cubeId[n7];
                int n8 = this.cube[n].getColorcode(this.sliceId);
                int n9 = this.cube[n].getColorcode(sliceSide[this.sliceId][n2]);
                this.colorPair[n2][n6].init(n8, n9, n, this.nDIM);
                this.colorPair[n2][n6].topNormal = this.cube[n].getFaceNormal(n8);
                this.colorPair[n2][n6].sideNormal = this.cube[n].getFaceNormal(n9);
                g.dbg(0, "AsliceInfo: colorPair[" + n2 + "][" + n6 + "]=" + this.colorPair[n2][n6].toString());
                ++n6;
            }
            ++n2;
        }
        this.markGood();
    }

    public int setNopposite(int n) {
        AcolorPair acolorPair = null;
        AcolorPair acolorPair2 = null;
        this.NoppositeCP = 0;
        this.NbadCP = 0;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 1;
            while (n3 < this.nDIM_1) {
                AcolorPair acolorPair3 = this.colorPair[n2][n3];
                if (acolorPair3.topColor == n) {
                    ++this.NoppositeCP;
                    acolorPair = acolorPair3;
                } else if (!acolorPair3.isIdenticalColor(this.colorPair[n2][0])) {
                    ++this.NbadCP;
                    acolorPair2 = acolorPair3;
                }
                ++n3;
            }
            ++n2;
        }
        if (this.NoppositeCP > 0) {
            this.targetCP = acolorPair;
        } else if (this.NbadCP > 0) {
            this.targetCP = acolorPair2;
            if (this.sliceId == 2 && this.colorPair[1][1].flag != 1) {
                this.targetCP = this.colorPair[1][1];
            }
        } else {
            this.targetCP = null;
        }
        if (this.NbadEdge != this.NoppositeCP + this.NbadCP) {
            g.abort("setNopposite: AsliceInfo[" + this.sliceId + "]: NoppositeCP+NbadCP=" + this.NoppositeCP + "+" + this.NbadCP + "!= NbadEdge=" + this.NbadEdge);
        }
        return this.NbadCP;
    }

    public int setScore() {
        int n;
        g.dbg(0, "AsliceInfo.setScore:");
        int n2 = 1;
        int n3 = 50;
        int n4 = 10;
        int n5 = 25;
        int n6 = 0;
        if (this.sliceId == 3) {
            n6 += n2;
        }
        int n7 = 0;
        while (n7 < 4) {
            n = 0;
            while (n < this.nDIM) {
                AcolorPair acolorPair = this.colorPair[n7][n];
                if (acolorPair.flag == 1) {
                    if (acolorPair.type == 3) {
                        n6 += n3;
                    } else if (acolorPair.type == 2) {
                        n6 += n4;
                    }
                }
                ++n;
            }
            ++n7;
        }
        n = 0;
        while (n < (this.nDIM - 2) * (this.nDIM - 2)) {
            if (this.centerColorcode[n] == this.goodFaceColorcode) {
                g.dbg(0, "setScore: goodFaceColorcode=" + this.goodFaceColorcode);
                n6 += n5;
            }
            ++n;
        }
        g.dbg(0, "setScore: sliceId=" + this.sliceId + ";score=" + n6 + "; goodFaceColorcode=" + this.goodFaceColorcode);
        g.dbg(0, "setScore: goodFaceColorcode=" + this.goodFaceColorcode);
        return n6;
    }

    AcolorPair socketForTrick1Bot(AcolorPair acolorPair) {
        return this.locateSocket(acolorPair, 2);
    }

    AcolorPair socketForTrick1Top(AcolorPair acolorPair) {
        return this.locateSocket(acolorPair, 1);
    }

    boolean starConfig() {
        int n = this.centerColorcode[0];
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < this.nDIM) {
                if (this.colorPair[n2][n3].topColor != n) {
                    return false;
                }
                n3 += this.nDIM - 1;
            }
            ++n2;
        }
        return true;
    }
}

