/*
 * Decompiled with CFR 0.152.
 */
public class AcubeLet {
    int id;
    int colorId;
    int nDIM;
    Apoint oCenter;
    Apoint[] vertice = new Apoint[8];
    Aface[] face = new Aface[6];
    static int[] colorEncode;
    static int[][] colId;

    static {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 20;
        nArray[3] = 30;
        nArray[4] = 400;
        nArray[5] = 500;
        colorEncode = nArray;
    }

    AcubeLet(int n, int n2) {
        this.id = n;
        this.nDIM = n2;
        int n3 = 0;
        while (n3 < 8) {
            this.vertice[n3] = new Apoint();
            ++n3;
        }
        int n4 = 0;
        while (n4 < 6) {
            this.face[n4] = new Aface();
            ++n4;
        }
        colId = new int[this.nDIM * this.nDIM * this.nDIM][2];
    }

    static int NmatchingColorId(int n) {
        if (n == -1) {
            int n2 = 0;
            while (n2 < colId.length) {
                AcubeLet.colId[n2][1] = 0;
                ++n2;
            }
            return 0;
        }
        int n3 = 0;
        while (n3 < colId.length) {
            if (colId[n3][0] == n) {
                return colId[n3][1];
            }
            ++n3;
        }
        return -1;
    }

    int cellId() {
        double d = (this.oCenter.pos[0] - 0.5) * (double)this.nDIM * (double)this.nDIM + (this.oCenter.pos[1] - 0.5) * (double)this.nDIM + (this.oCenter.pos[2] - 0.5);
        return (int)d;
    }

    public void cubeLetInit(double d, double d2, double d3, boolean bl) {
        int n;
        int n2;
        int n3;
        this.oCenter = new Apoint(d, d2, d3);
        Apoint apoint = new Apoint(this.oCenter.pos[0] - 0.5, this.oCenter.pos[1] - 0.5, this.oCenter.pos[2] - 0.5);
        int n4 = 0;
        while (n4 < 2) {
            n3 = 0;
            while (n3 < 2) {
                n2 = 0;
                while (n2 < 2) {
                    n = n4 * 4 + n3 * 2 + n2;
                    this.vertice[n].set(n4, n3, n2, n);
                    this.vertice[n].add(apoint);
                    ++n2;
                }
                ++n3;
            }
            ++n4;
        }
        this.face[0].init(this.oCenter, 0);
        this.face[1].init(this.oCenter, 1);
        this.face[2].init(this.oCenter, 2);
        this.face[3].init(this.oCenter, 3);
        this.face[4].init(this.oCenter, 4);
        this.face[5].init(this.oCenter, 5);
        n3 = this.id / (this.nDIM * this.nDIM);
        n2 = this.id % (this.nDIM * this.nDIM) / this.nDIM;
        n = this.id % this.nDIM;
        int n5 = this.nDIM - 1;
        int n6 = 0;
        this.colorId = 0;
        if (!bl) {
            if (n == 0) {
                this.face[4].colorcode = 7;
                ++n6;
            } else if (n == n5) {
                this.face[5].colorcode = 7;
                ++n6;
            }
            if (n2 == 0) {
                this.face[2].colorcode = 7;
                ++n6;
            } else if (n2 == n5) {
                this.face[3].colorcode = 7;
                ++n6;
            }
            if (n3 == 0) {
                this.face[0].colorcode = 7;
                ++n6;
            } else if (n3 == n5) {
                this.face[1].colorcode = 7;
                ++n6;
            }
            this.colorId = n6 == 0 ? 6 : -n6;
        }
        if (bl || n6 == 1) {
            n6 = 0;
            if (n == 0) {
                this.face[4].colorcode = 4;
                this.colorId = 4;
                ++n6;
            } else if (n == n5) {
                this.face[5].colorcode = 5;
                this.colorId = 5;
                ++n6;
            }
            if (n2 == 0) {
                this.face[2].colorcode = 2;
                this.colorId = this.colorId * 10 + 2;
                ++n6;
            } else if (n2 == n5) {
                this.face[3].colorcode = 3;
                this.colorId = this.colorId * 10 + 3;
                ++n6;
            }
            if (n3 == 0) {
                this.face[0].colorcode = 0;
                this.colorId *= 10;
                ++n6;
            } else if (n3 == n5) {
                this.face[1].colorcode = 1;
                this.colorId = this.colorId * 10 + 1;
                ++n6;
            }
            if (n6 == 0) {
                this.colorId = 6;
            }
            AcubeLet.colId[this.id][0] = this.colorId;
            AcubeLet.colId[this.id][1] = 0;
        }
    }

    public int getColorcode(int n) {
        int n2 = 0;
        while (n2 < 6) {
            if (this.face[n2].normal.equals(g.faceNormal[n])) break;
            ++n2;
        }
        return this.face[n2].colorcode;
    }

    public Aface getFace(int n) {
        int n2 = 0;
        while (n2 < 6) {
            if (this.face[n2].normal.equals(g.faceNormal[n])) break;
            ++n2;
        }
        if (n2 < 6) {
            return this.face[n2];
        }
        g.dbg(9, "*** getFace fail, fcode,faceNormal=" + n + "," + g.faceNormal[n].toString());
        g.dbg(9, this.toString());
        return this.face[n];
    }

    public Avec getFaceNormal(int n) {
        int n2 = 0;
        while (n2 < 6) {
            if (this.face[n2].colorcode == n) break;
            ++n2;
        }
        if (n2 < 6) {
            return this.face[n2].normal;
        }
        g.dbg(9, "*** getFaceNormal fail, colcode=" + n);
        g.dbg(9, this.toString());
        return this.face[0].normal;
    }

    public void resetFaceColor(int n) {
        int n2 = 0;
        while (n2 < 6) {
            if (this.face[n2].colorcode < 6) {
                this.face[n2].colorcode = n;
            }
            ++n2;
        }
    }

    public int setColorId() {
        g.dbg(0, "AcubeLet.setColorId: found colorId=" + this.colorId + this.toString());
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[]{6, 6, 6};
        int n3 = 5;
        while (n3 >= 0) {
            int n4 = this.face[n3].colorcode;
            if (n4 != 6) {
                ++n2;
                if (n4 == 5 || n4 == 4) {
                    nArray[2] = n4;
                } else if (n4 == 3 || n4 == 2) {
                    nArray[1] = n4;
                } else {
                    nArray[0] = n4;
                }
            }
            --n3;
        }
        int n5 = 2;
        while (n5 >= 0) {
            if (nArray[n5] != 6) {
                n = n * 10 + nArray[n5];
            }
            --n5;
        }
        this.colorId = n;
        g.dbg(3, "AcubeLet.setColorId: colorId=" + this.colorId);
        if (n2 == 0) {
            this.colorId = 6;
        }
        int n6 = -1;
        int n7 = 0;
        while (n7 < colId.length) {
            if (colId[n7][0] == this.colorId) {
                n6 = n7;
                int[] nArray2 = colId[n7];
                nArray2[1] = nArray2[1] + 1;
                break;
            }
            ++n7;
        }
        if (n6 != 1) {
            return this.colorId;
        }
        return -1;
    }

    public String toString() {
        String string = "c" + this.id + "; colorId=" + this.colorId + ": center=" + this.oCenter.toString();
        string = String.valueOf(string) + "; face colors=";
        int n = 0;
        while (n < 6) {
            string = String.valueOf(string) + this.face[n].colorcode;
            ++n;
        }
        return String.valueOf(string) + " ";
    }

    public String toString(char c) {
        String string = "id=" + this.id;
        if (c == 'c') {
            string = String.valueOf(string) + "; colorId=" + this.colorId + "; center=" + this.oCenter.toString();
        }
        return String.valueOf(string) + " ";
    }

    int transform(Apoint apoint, Amatx amatx) {
        Apoint apoint2 = amatx.matRotation(this.oCenter, apoint);
        this.oCenter.set(apoint2);
        int n = 0;
        while (n < 6) {
            amatx.matTransform(this.face[n].normal);
            apoint2 = Avec.VecAdd(this.oCenter, 0.5, this.face[n].normal, 0.0, null);
            this.face[n].oCenter.set(apoint2);
            ++n;
        }
        return this.cellId();
    }
}

