/*
 * Decompiled with CFR 0.152.
 */
class AcubeInfo {
    private AcubeLet[] cube;
    private int[] cell;
    private int nDIM;
    private int nDIM_1;
    private int nDIM2;
    private AsliceInfo[] sliceInfo;
    public int bestSliceId;
    public int NbadEdges;
    public int NbadCorners;
    private int[] topCubeIdIndex = new int[4];
    public int[] cornerCellId = new int[8];
    int targetCellId;
    int targetStrIx;
    Avec targetNormal;
    static final int[] oppSliceId;
    public String preTrick3Move;
    public String postTrick3Move;
    public String preTrick2Move;
    public String postTrick2Move;
    public String preTrick2Rotate;
    public String postTrick2Rotate;
    public boolean bTrick3Move;
    public boolean bTrick2Move;
    static final Avec trick1botTopNormal;
    static final Avec trick1botSideNormal;
    static final Avec trick1topTopNormal;
    static final Avec trick1topSideNormal;
    static final Avec trick1bacTopNormal;
    static final Avec trick1bacSideNormal;
    AcolorPair trick1BotCP;
    AcolorPair trick1TopCP;
    AcolorPair trick1BacCP;
    AcolorPair trick1BotSocket;
    AcolorPair trick1TopSocket;
    AcolorPair trick1BacSocket;
    public String opTrick1Top;
    public String opPreTrick1;
    AcolorPair trick1cp2;
    static final String[] targetStr;
    static final String[] newNormal;

    static {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[2] = 3;
        nArray[3] = 2;
        nArray[4] = 5;
        nArray[5] = 4;
        oppSliceId = nArray;
        trick1botTopNormal = new Avec(g.v_J);
        trick1botSideNormal = new Avec(g.vI);
        trick1topTopNormal = new Avec(g.vJ);
        trick1topSideNormal = new Avec(g.vI);
        trick1bacTopNormal = new Avec(g.v_I);
        trick1bacSideNormal = new Avec(g.v_J);
        targetStr = new String[]{"RN> B1<<RN< ", "RN> B1<<RN< ", "FN< B1<<FN> ", "RN< B1> RN> ", "RN< B1> RN> ", "F1< B1> F1< ", "FN< R1< FN> ", "", "RN> F1> RN< ", "R1<<", "FN> B1< FN< ", "FN> B1< FN< ", "B1>>", "B1>>", "B1>>", "B1> ", "B1> ", "B1> ", "", "", "", "B1< ", "B1< ", "B1< "};
        newNormal = new String[]{"i", "k", "k", "k", "i", "i", "i", "j", "k", "i", "k", "i", "i", "-j", "k", "k", "-j", "i", "i", "-j", "k", "k", "-j", "i"};
    }

    AcubeInfo(AcubeLet[] acubeLetArray, int[] nArray, int n) {
        this.cube = acubeLetArray;
        this.cell = nArray;
        this.nDIM = n;
        this.nDIM2 = this.nDIM * this.nDIM;
        this.nDIM_1 = this.nDIM - 1;
        this.sliceInfo = new AsliceInfo[6];
        int n2 = 0;
        while (n2 < 6) {
            this.sliceInfo[n2] = new AsliceInfo(this.cube, this.cell, n2, this.nDIM);
            ++n2;
        }
        this.topCubeIdIndex[0] = 0;
        this.topCubeIdIndex[1] = 2;
        this.topCubeIdIndex[2] = 8;
        this.topCubeIdIndex[3] = 6;
        this.cornerCellId[0] = this.nDIM_1 * this.nDIM;
        this.cornerCellId[1] = this.nDIM_1 * this.nDIM + this.nDIM_1;
        this.cornerCellId[2] = this.nDIM_1 * this.nDIM2 + this.nDIM_1 * this.nDIM + this.nDIM_1;
        this.cornerCellId[3] = this.nDIM_1 * this.nDIM2 + this.nDIM_1 * this.nDIM;
        this.cornerCellId[4] = 0;
        this.cornerCellId[5] = this.nDIM_1;
        this.cornerCellId[6] = this.nDIM_1 * this.nDIM2 + this.nDIM_1;
        this.cornerCellId[7] = this.nDIM_1 * this.nDIM2;
        this.trick1BotSocket = new AcolorPair();
        this.trick1TopSocket = new AcolorPair();
        this.trick1BacSocket = new AcolorPair();
    }

    private void allTopTurns() {
        int n = 0;
        while (n <= 5) {
            int n2 = 0;
            while (n2 < 4) {
                int n3 = 0;
                while (n3 < this.nDIM) {
                    String string = this.turnOpStr(this.sliceInfo[n].colorPair[n2][n3], this.sliceInfo[3].colorPair[3][2]);
                    g.dbg(4, "----allTopTurns: f,s,a=" + n + "," + n2 + "," + n3 + "; fromCP=" + this.sliceInfo[n].colorPair[n2][n3] + "; rotStr=" + string);
                    n3 += this.nDIM_1;
                }
                ++n2;
            }
            ++n;
        }
    }

    public int bestFace() {
        g.dbg(0, "AcubeInfo.bestFace:" + this.bestSliceId);
        this.setFaceScore();
        if (this.sliceInfo[3].NgoodCorner == 4) {
            return 3;
        }
        return this.bestSliceId;
    }

    int cellIdOf(AcolorPair acolorPair) {
        return this.cube[acolorPair.cubeid].cellId();
    }

    public int locateBadCornerCellid() {
        g.dbg(0, "AcubeInfo::locateBadTopCorner:NgoodCorner=" + this.sliceInfo[3].NgoodCorner);
        if (this.sliceInfo[3].NgoodCorner == 4) {
            return -1;
        }
        if (this.sliceInfo[3].NgoodCorner == 0) {
            return this.nDIM_1 * (this.nDIM2 + this.nDIM + 1);
        }
        if (this.sliceInfo[3].goodFaceColorcode == 6) {
            throw new InternalError();
        }
        int n = -1;
        if (this.sliceInfo[3].colorPair[0][0].flag == 1 && this.sliceInfo[3].colorPair[0][this.nDIM_1].flag != 1) {
            n = this.sliceInfo[3].colorPair[0][this.nDIM_1].cubeid;
        } else if (this.sliceInfo[3].colorPair[3][0].flag == 1 && this.sliceInfo[3].colorPair[3][this.nDIM_1].flag != 1) {
            n = this.sliceInfo[3].colorPair[3][this.nDIM_1].cubeid;
        } else if (this.sliceInfo[3].colorPair[1][this.nDIM_1].flag == 1 && this.sliceInfo[3].colorPair[1][0].flag != 1) {
            n = this.sliceInfo[3].colorPair[1][0].cubeid;
        } else if (this.sliceInfo[3].colorPair[2][this.nDIM_1].flag == 1 && this.sliceInfo[3].colorPair[2][0].flag != 1) {
            n = this.sliceInfo[3].colorPair[2][0].cubeid;
        }
        if (n == -1) {
            throw new InternalError();
        }
        int n2 = this.cube[n].cellId();
        g.dbg(0, "AcubeInfo::locateBadTopCorner:cellid=" + n2);
        return n2;
    }

    private int locateTarget_Center(int n) {
        g.dbg(0, "AcubeInfo.locateTarget_Center:");
        int n2 = 0;
        while (n2 < 6) {
            if (this.sliceInfo[n2].centerColorcode[0] == n) {
                return n2;
            }
            ++n2;
        }
        return 6;
    }

    private void locateTarget_Corner() {
        int n;
        int n2;
        g.dbg(0, "AcubeInfo.locateTarget_Corner:");
        if (this.sliceInfo[3].NgoodCorner > 0) {
            int cfr_ignored_0 = this.sliceInfo[3].colorPair[3][0].flag;
            n2 = this.sliceInfo[3].colorPair[3][0].topColor;
            n = this.sliceInfo[3].colorPair[3][0].sideColor;
        } else {
            n2 = this.sliceInfo[3].goodFaceColorcode;
            n = n2 < 4 ? n2 + 2 : n2 - 2;
        }
        this.targetCellId = -1;
        this.targetNormal = null;
        int n3 = 0;
        while (n3 < 8) {
            if (n3 != 1) {
                this.targetCellId = this.cornerCellId[n3];
                AcubeLet acubeLet = this.cube[this.cell[this.targetCellId]];
                int n4 = acubeLet.colorId / 100;
                int n5 = acubeLet.colorId % 100 / 10;
                int n6 = acubeLet.colorId % 10;
                g.dbg(0, "locateTarget_Corner: targetCellId=" + this.targetCellId + ";colorId=" + acubeLet.colorId);
                if (!(n != n4 && n != n5 && n != n6 || n2 != n4 && n2 != n5 && n2 != n6)) {
                    this.targetNormal = acubeLet.getFaceNormal(n2);
                    this.targetStrIx = this.targetNormal.getMultipleOf(g.vI) != 0.0 ? 0 : (this.targetNormal.getMultipleOf(g.vJ) != 0.0 ? 1 : 2);
                    this.targetStrIx += n3 * 3;
                    g.dbg(0, "locateTarget_Corner: targetCellId=" + this.targetCellId + ";targetNormal=" + this.targetNormal);
                    break;
                }
            }
            ++n3;
        }
        if (this.targetNormal == null) {
            g.abort("locateTarget_Corner: no targetNormal");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String moveCenterSlice(int n) {
        String string = "";
        if (n == 3) {
            int n2 = this.sliceInfo[3].goodFaceColorcode;
            if (this.sliceInfo[3].centerColorcode[0] == n2) return string;
            int n3 = this.locateTarget_Center(n2);
            switch (n3) {
                case 0: {
                    return "F2> ";
                }
                case 1: {
                    return "F2< ";
                }
                case 2: {
                    return "F2>>";
                }
                case 5: {
                    return "R2> ";
                }
                case 4: {
                    return "R2< ";
                }
                default: {
                    return string;
                }
            }
        }
        if (n != 1) return string;
        int n4 = this.sliceInfo[3].colorPair[1][0].sideColor;
        if (this.sliceInfo[1].centerColorcode[0] == n4) return string;
        int n5 = this.locateTarget_Center(n4);
        switch (n5) {
            case 0: {
                string = "B2>>";
                break;
            }
            case 5: {
                string = "B2> ";
                break;
            }
            case 4: {
                string = "B2< ";
            }
        }
        return string;
    }

    public String moveToRTF() {
        this.locateTarget_Corner();
        String string = targetStr[this.targetStrIx];
        if (newNormal[this.targetStrIx] == "i") {
            string = String.valueOf(string) + "RN> F1< RN< ";
        } else if (newNormal[this.targetStrIx] == "k") {
            string = String.valueOf(string) + "FN< R1> FN> ";
        } else if (newNormal[this.targetStrIx] == "-j") {
            string = String.valueOf(string) + "RN> F1<<RN< B1> RN> F1< RN< ";
        }
        return string;
    }

    private int opposingSlice() {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[2] = 3;
        nArray[3] = 2;
        nArray[4] = 5;
        nArray[5] = 4;
        int[] nArray2 = nArray;
        int n = 2;
        while (n < 8) {
            int n2 = n % 6;
            if (this.sliceInfo[n2].NbadCP > 0 && this.sliceInfo[nArray2[n2]].NbadCP > 0) {
                g.dbg(2, "oppositeSlice found: slice" + n2 + ": goodFaceColorcode=" + this.sliceInfo[n2].goodFaceColorcode + ";\tslice" + nArray2[n2] + ": goodFaceColorcode=" + this.sliceInfo[nArray2[n2]].goodFaceColorcode);
                return n2;
            }
            ++n;
        }
        g.dbg(2, "oppositeSlice: no opposing slices found!");
        return -1;
    }

    private String rotateOpStr(AcolorPair acolorPair, AcolorPair acolorPair2) {
        g.dbg(0, "----rotateOpStr: fromCP=" + acolorPair + "; toCP=" + acolorPair2);
        Avec avec = new Avec(acolorPair.topNormal);
        Avec avec2 = new Avec(acolorPair.sideNormal);
        Avec avec3 = new Avec(acolorPair2.topNormal);
        Avec avec4 = new Avec(acolorPair2.sideNormal);
        Apoint apoint = new Apoint(0.0, 0.0, 0.0);
        AxisRotation axisRotation = new AxisRotation();
        AxisRotation axisRotation2 = new AxisRotation();
        axisRotation.initVecCross(avec, avec3, avec2, this.nDIM);
        String string = axisRotation.turnStr(apoint);
        if (axisRotation.turnAxis != null) {
            axisRotation.rotateM.matTransform(avec2);
        }
        axisRotation2.initVecCross(avec2, avec4, null, this.nDIM);
        string = String.valueOf(string) + axisRotation2.turnStr(apoint);
        g.dbg(0, "----rotateOpStr: v0,w0" + avec + "," + avec2 + ";v1,w1=" + acolorPair2.topNormal + "," + avec4 + "; rotStr=" + string);
        return string;
    }

    private void setFaceScore() {
        g.dbg(0, "AcubeInfo.setFaceScore:");
        boolean bl = true;
        int n = 50;
        int n2 = 10;
        boolean bl2 = true;
        int n3 = 25;
        int n4 = 0;
        this.bestSliceId = 6;
        int n5 = 0;
        while (n5 < 6) {
            int n6 = this.sliceInfo[n5].setScore();
            if (n6 > n4) {
                n4 = n6;
                this.bestSliceId = n5;
            }
            g.dbg(0, "setFaceScore: f=" + n5 + ";fscore=" + n6);
            ++n5;
        }
        g.dbg(0, "AcubeInfo::setFaceScore:" + n4 + ";bestSliceId=" + this.bestSliceId);
    }

    public void setInfo() {
        this.NbadEdges = 0;
        int n = 0;
        while (n < 6) {
            this.sliceInfo[n].setInfo();
            this.NbadEdges += this.sliceInfo[n].NbadEdge;
            ++n;
        }
        this.NbadEdges /= 2;
        this.NbadCorners = 8 - this.sliceInfo[3].NgoodCorner - this.sliceInfo[2].NgoodCorner;
        g.dbg(2, "***************************AcubeInfo.setInfo: NbadCorners=" + this.NbadCorners + ";NbadEdges=" + this.NbadEdges);
    }

    private String trick1AlternateTurn(String string) {
        if (string.length() == 0) {
            return "";
        }
        String string2 = null;
        if (string.compareTo("F2< ") == 0) {
            string2 = "R3< F1< B1< ";
        } else if (string.compareTo("F2< B1>>") == 0) {
            string2 = "R3> F1< B1< ";
        } else if (string.compareTo("F2> B3>>") == 0) {
            string2 = "R3> F1> R3> ";
        } else if (string.compareTo("F2> R3>>") == 0) {
            string2 = "R3> F1< B1< ";
        } else if (string.compareTo("R1< B1>>") == 0) {
            string2 = "F1<<R3< ";
        } else if (string.substring(0, 2).equals("F2")) {
            g.abort("trick1AlternateTurn: inStr=" + string);
        } else {
            string2 = String.valueOf(string);
        }
        String string3 = null;
        int n = string2.length() / 4;
        int n2 = 0;
        while (n2 < n) {
            if (string2.substring(n2 * 4, n2 * 4 + 2).compareTo("B1") == 0) {
                string3 = string2.substring(0, n2 * 4) + "R1> " + string2.substring(n2 * 4, n2 * 4 + 4) + "R1< " + string2.substring(n2 * 4 + 4, n * 4);
                break;
            }
            ++n2;
        }
        g.dbg(0, "trick1AlternateTurn: inStr=" + string + ";outStr=" + string2 + ";tempStr=" + string3);
        if (string3 != null) {
            string2 = string3;
        }
        return string2;
    }

    public String trick1Bac() {
        AcolorPair acolorPair = null;
        if (this.trick1BacSocket.topColor == 6) {
            this.opPreTrick1 = "";
            return this.opPreTrick1;
        }
        int n = 0;
        while (n < 6) {
            acolorPair = this.sliceInfo[n].locateCP(this.trick1BacSocket.topColor, this.trick1BacSocket.sideColor, this.trick1BacSocket.cubeid);
            if (acolorPair != null) break;
            ++n;
        }
        String string = this.turnOpStr(acolorPair, this.trick1BacCP);
        this.opPreTrick1 = this.trick1AlternateTurn(string);
        g.dbg(2, "trick1Bac: opPreTrick1=" + this.opPreTrick1 + ";trick1cp3=" + acolorPair);
        return this.opPreTrick1;
    }

    public void trick1Init() {
        this.trick1BotCP = this.sliceInfo[2].colorPair[1][1];
        this.trick1TopCP = this.sliceInfo[3].colorPair[1][1];
        this.trick1BacCP = this.sliceInfo[2].colorPair[0][1];
        this.trick1BotSocket.init(this.sliceInfo[2].colorPair[1][0].topColor, this.sliceInfo[2].colorPair[1][0].sideColor, 0, this.nDIM);
        this.trick1TopSocket.init(this.sliceInfo[3].colorPair[1][0].topColor, this.sliceInfo[3].colorPair[1][0].sideColor, 0, this.nDIM);
        this.trick1BotSocket.init(this.sliceInfo[2].colorPair[0][0].topColor, this.sliceInfo[2].colorPair[0][0].sideColor, 0, this.nDIM);
    }

    public boolean trick1Ready() {
        if (this.NbadCorners > 0) {
            return false;
        }
        int n = 0;
        while (n < 6) {
            if (!this.sliceInfo[n].starConfig()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean trick1Ready3() {
        if (this.trick1BotCP.isIdenticalColor(this.trick1TopSocket)) {
            return true;
        }
        if (this.trick1TopCP.isIdenticalColor(this.trick1BacSocket)) {
            return true;
        }
        if (this.trick1BacCP.isIdenticalColor(this.trick1BotSocket)) {
            return true;
        }
        g.dbg(0, "*******trick1Ready3: not ready; trick1BotCP    =" + this.trick1BotCP + ";trick1TopCP    =" + this.trick1TopCP + ";trick1BacCP    =" + this.trick1BacCP);
        g.dbg(0, "*******trick1Ready3: not ready; trick1BotSocket=" + this.trick1BotSocket + ";trick1TopSocket=" + this.trick1TopSocket + ";trick1BacSocket=" + this.trick1BacSocket);
        return false;
    }

    public String trick1Rotate() {
        String string = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (!this.trick1Ready()) {
            g.abort("trick1Rotate: trick1Ready=false");
        }
        boolean bl = false;
        boolean bl2 = false;
        int n6 = 0;
        while (n6 < 6) {
            if (this.sliceInfo[n6].NbadEdge != 0) {
                int n7 = this.sliceInfo[AcubeInfo.oppSliceId[n6]].goodFaceColorcode;
                this.sliceInfo[n6].setNopposite(n7);
                if (this.sliceInfo[n6].NoppositeCP > n) {
                    n = this.sliceInfo[n6].NoppositeCP;
                    n4 = n6;
                }
                if (this.sliceInfo[n6].NbadCP > n2) {
                    n2 = this.sliceInfo[n6].NbadCP;
                    n5 = n6;
                }
            }
            ++n6;
        }
        if (n2 + n == 0) {
            g.abort("trick1Rotate:maxNbad+maxNopp==0");
        }
        n3 = -1;
        if (this.sliceInfo[2].NoppositeCP > 0) {
            g.dbg(2, "---trick1Rotate best slice: bottom NoppositeCP=" + this.sliceInfo[2].NoppositeCP);
            n3 = 2;
        } else if (n > 0) {
            g.dbg(2, "---trick1Rotate best slice: sliceIdOpp=" + n4 + ";maxNopp=" + n + "=sliceInfo[sliceIdOpp].NoppositeCP" + this.sliceInfo[n4].NoppositeCP);
            n3 = n4;
        } else {
            int n8 = this.opposingSlice();
            if (n8 >= 0) {
                g.dbg(2, "---trick1Rotate best slice: opposingSliceId=" + n8);
                n3 = n8;
            }
        }
        if (n3 == -1) {
            g.dbg(2, "---trick1Rotate best slice: no opposite,no opposing, sliceIdBad=" + n5);
            n3 = n5;
        }
        Avec avec = this.sliceInfo[n3].targetCP.topNormal;
        Avec avec2 = this.sliceInfo[n3].targetCP.sideNormal;
        string = this.rotateOpStr(this.sliceInfo[n3].targetCP, this.trick1BotCP);
        g.dbg(0, "trick1Rotate: v0,w0=" + avec + "," + avec2 + "; rotStr=" + string);
        return string;
    }

    public String trick1Top() {
        g.dbg(2, "trick1Top: trick1bot cp=" + this.trick1BotCP);
        this.trick1cp2 = this.sliceInfo[3].socketForTrick1Bot(this.trick1BotCP);
        if (this.trick1cp2 == null) {
            this.trick1cp2 = this.sliceInfo[0].socketForTrick1Bot(this.trick1BotCP);
        }
        if (this.trick1cp2 == null) {
            this.trick1cp2 = this.sliceInfo[1].socketForTrick1Bot(this.trick1BotCP);
        }
        if (this.trick1cp2 == null) {
            this.trick1cp2 = this.sliceInfo[2].locateSocket(null, 0);
        }
        if (this.trick1cp2 == null) {
            g.dbg(2, "trick1Top: trick1cp2=" + this.trick1cp2);
            throw new InternalError();
        }
        String string = this.turnOpStr(this.trick1cp2, this.sliceInfo[3].colorPair[1][1]);
        this.opTrick1Top = this.trick1AlternateTurn(string);
        g.dbg(2, "trick1Top: opTrick1Top=" + this.opTrick1Top + ";trick1cp2=" + this.trick1cp2);
        g.dbg(2, "trick1Top-locate plug for trick1Bac socket: plug=trick1cp2=" + this.trick1cp2);
        AcolorPair acolorPair = null;
        int n = 5;
        while (n >= 0) {
            AcolorPair acolorPair2 = this.sliceInfo[n].socketForTrick1Top(this.trick1cp2);
            g.dbg(2, "trick1Top-locate plug for trick1Bac socket::sliceInfo[" + n + "]; cp=" + acolorPair2);
            if (acolorPair2 != null) {
                if (this.cellIdOf(acolorPair2) == this.cellIdOf(this.trick1cp2) || this.cellIdOf(acolorPair2) == this.cellIdOf(this.trick1BotCP)) {
                    g.dbg(2, "trick1Top-locate plug for trick1Bac socket: cp found & ignore because same as trick1cp2/trick1BotCP");
                } else {
                    if (this.sliceInfo[n].socketCP != null) {
                        g.dbg(0, "trick1Top-located plug for trick1Bac socket: found plug/socketCP=" + this.sliceInfo[n].socketCP);
                        acolorPair = this.sliceInfo[n].socketCP;
                        break;
                    }
                    if (acolorPair2 != null && acolorPair == null) {
                        acolorPair = acolorPair2;
                    }
                }
            }
            --n;
        }
        if (acolorPair != null) {
            this.trick1BacSocket.init(acolorPair.topColor, acolorPair.sideColor, acolorPair.cubeid, this.nDIM);
        } else {
            this.trick1BacSocket.init(6, 6, -1, this.nDIM);
        }
        return this.opTrick1Top;
    }

    public void trick2Info(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.bTrick2Move = false;
        this.preTrick2Move = "";
        this.postTrick2Move = "";
        this.preTrick2Rotate = "";
        this.postTrick2Rotate = "";
        if (n != 3) {
            return;
        }
        int n6 = this.sliceInfo[n].goodFaceColorcode;
        int n7 = 0;
        while (n7 < 4) {
            n5 = this.sliceInfo[n].colorPair[n7][0].sideColor;
            n4 = this.sliceInfo[n].colorPair[n7][this.nDIM_1].sideColor;
            n3 = this.sliceInfo[n].colorPair[n7][0].topColor;
            n2 = this.sliceInfo[n].colorPair[n7][this.nDIM_1].topColor;
            if (n3 != n2 || n3 != n6) {
                if (n5 == n4) {
                    this.preTrick2Rotate = n7 == 0 ? "B1> " : (n7 == 1 ? "B1< " : (n7 == 2 ? "B1>>" : ""));
                    this.bTrick2Move = true;
                } else if (n3 == n2) {
                    if (n7 == 0) {
                        this.preTrick2Rotate = "B1< R1< ";
                        this.postTrick2Rotate = "R1> ";
                    } else if (n7 == 1) {
                        this.preTrick2Rotate = "B1> R1< ";
                        this.postTrick2Rotate = "R1> ";
                    } else if (n7 == 2) {
                        this.preTrick2Rotate = "R1< ";
                        this.postTrick2Rotate = "R1> ";
                    } else {
                        this.preTrick2Rotate = "B1>>R1< ";
                        this.postTrick2Rotate = "R1> ";
                    }
                    this.bTrick2Move = true;
                }
                if (this.bTrick2Move) {
                    g.dbg(0, "trick2Info:0 side= " + n7 + ";topcol=" + AcubeCanvas.cName[n6]);
                    g.dbg(0, "trick2Info:0 preTrick2Rotate= " + this.preTrick2Rotate);
                    g.dbg(0, "trick2Info:0 top  colors: " + AcubeCanvas.cName[n3] + ";" + AcubeCanvas.cName[n2]);
                    g.dbg(0, "trick2Info:0 side colors: " + AcubeCanvas.cName[n5] + ";" + AcubeCanvas.cName[n4]);
                    return;
                }
            }
            ++n7;
        }
        int n8 = 0;
        while (n8 < 4) {
            n5 = this.sliceInfo[n].colorPair[n8][0].sideColor;
            n4 = this.sliceInfo[n].colorPair[n8][this.nDIM_1].sideColor;
            n3 = this.sliceInfo[n].colorPair[n8][0].topColor;
            n2 = this.sliceInfo[n].colorPair[n8][this.nDIM_1].topColor;
            if (n5 == n6) {
                if (n2 == n6) {
                    if (n8 == 0 || n8 == 3) {
                        this.preTrick2Move = "R1< ";
                        this.postTrick2Move = "R1> ";
                    } else {
                        this.preTrick2Move = "RN< ";
                        this.postTrick2Move = "RN> ";
                    }
                }
                this.bTrick2Move = true;
            } else if (n4 == n6) {
                if (n3 == n6) {
                    if (n8 == 1 || n8 == 2) {
                        this.preTrick2Move = "R1< ";
                        this.postTrick2Move = "R1> ";
                    } else {
                        this.preTrick2Move = "RN< ";
                        this.postTrick2Move = "RN> ";
                    }
                }
                this.bTrick2Move = true;
            }
            if (this.bTrick2Move) {
                this.preTrick2Rotate = n8 == 0 ? "B1> " : (n8 == 1 ? "B1< " : (n8 == 2 ? "B1>>" : ""));
                g.dbg(0, "trick2Info:2 side= " + n8 + ";topcol=" + AcubeCanvas.cName[n6]);
                g.dbg(0, "trick2Info:2 preTrick2Rotate= " + this.preTrick2Rotate);
                g.dbg(0, "trick2Info:2 top  colors: " + AcubeCanvas.cName[n3] + ";" + AcubeCanvas.cName[n2]);
                g.dbg(0, "trick2Info:2 side colors: " + AcubeCanvas.cName[n5] + ";" + AcubeCanvas.cName[n4]);
                return;
            }
            ++n8;
        }
        g.dbg(0, "trick2Info: bTrick2Move=" + this.bTrick2Move + ";pre/postTrick2Move=" + this.preTrick2Move + this.postTrick2Move);
    }

    public String trick3Info(int n) {
        int n2;
        int n3;
        int n4;
        if (n != 1) {
            return "";
        }
        String string = "";
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[7];
        nArray[0] = this.nDIM_1 * this.nDIM2 + this.nDIM_1 * this.nDIM + this.nDIM_1;
        nArray[1] = this.nDIM_1 * this.nDIM2 + this.nDIM_1;
        nArray[2] = this.nDIM_1 * this.nDIM2;
        nArray[3] = this.nDIM_1 * this.nDIM2 + this.nDIM_1 * this.nDIM;
        nArray2[0] = this.nDIM_1 * this.nDIM + this.nDIM_1;
        nArray2[1] = this.nDIM_1;
        nArray2[2] = 0;
        nArray2[3] = this.nDIM_1 * this.nDIM;
        int n5 = 0;
        while (n5 < 7) {
            n4 = this.cell[nArray[n5 % 4]];
            nArray4[n5] = this.cube[n4].colorId;
            ++n5;
        }
        int[] nArray5 = new int[6];
        nArray5[0] = 1;
        nArray5[2] = 30;
        nArray5[3] = 20;
        nArray5[4] = 500;
        nArray5[5] = 400;
        int[] nArray6 = nArray5;
        n5 = 0;
        while (n5 < 4) {
            n4 = this.cell[nArray2[n5]];
            nArray3[n5] = this.cube[n4].colorId;
            int n6 = this.cube[n4].getFace((int)0).colorcode;
            nArray3[n5] = nArray3[n5] - AcubeLet.colorEncode[n6] + nArray6[n6];
            ++n5;
        }
        int n7 = 0;
        while (n7 < 4) {
            if (nArray4[n7] == nArray3[0]) break;
            ++n7;
        }
        if (n7 >= 4) {
            g.dbg(9, "trick3Info: desiredColorId=" + g.arrString(nArray3, 4));
            g.dbg(9, "trick3Info: sliceColorId=" + g.arrString(nArray4, 7));
            g.abort("trick3Info: no desiredColor[4] found in right slice!");
        }
        String string2 = "0";
        n5 = 1;
        while (n5 < 4) {
            n3 = 1;
            while (n3 < 4) {
                if (nArray4[n7 + n5] == nArray3[n3]) {
                    string2 = String.valueOf(string2) + n3;
                    break;
                }
                ++n3;
            }
            ++n5;
        }
        g.dbg(0, "trick3Info: startIx=" + n7 + "; config=" + string2);
        this.bTrick3Move = true;
        if (string2.compareTo("0321") == 0) {
            n2 = n7;
            n3 = 31;
            int n8 = 0;
            n4 = this.cell[nArray[n8]];
            int n9 = this.cube[n4].getFace((int)1).colorcode;
            if (n9 != this.sliceInfo[1].centerColorcode[0]) {
                this.preTrick3Move = "R1> B1< ";
                this.postTrick3Move = "B1> R1< ";
            } else {
                this.preTrick3Move = "R1< B1< ";
                this.postTrick3Move = "B1> R1> ";
            }
        } else if (string2.compareTo("0312") == 0) {
            n2 = n7 + 1;
            n3 = 30;
            int n10 = 2;
            n4 = this.cell[nArray[n10]];
            int n11 = this.cube[n4].getFace((int)1).colorcode;
            if (n11 == this.sliceInfo[1].centerColorcode[0]) {
                this.preTrick3Move = "R1< FN< ";
                this.postTrick3Move = "FN> R1> ";
            } else {
                this.preTrick3Move = "R1< ";
                this.postTrick3Move = "R1> ";
            }
        } else if (string2.compareTo("0231") == 0) {
            n2 = n7 - 1;
            n3 = 10;
            int n12 = 3;
            n4 = this.cell[nArray[n12]];
            int n13 = this.cube[n4].getFace((int)1).colorcode;
            if (n13 == this.sliceInfo[1].centerColorcode[0]) {
                this.preTrick3Move = "FN< ";
                this.postTrick3Move = "FN> ";
            } else {
                this.preTrick3Move = "";
                this.postTrick3Move = "";
            }
        } else if (string2.compareTo("0213") == 0) {
            n2 = n7;
            n3 = 21;
            int n14 = 0;
            n4 = this.cell[nArray[n14]];
            int n15 = this.cube[n4].getFace((int)1).colorcode;
            if (n15 == this.sliceInfo[1].centerColorcode[0]) {
                this.preTrick3Move = "R1> FN< ";
                this.postTrick3Move = "FN> R1< ";
            } else {
                this.preTrick3Move = "R1> ";
                this.postTrick3Move = "R1< ";
            }
        } else if (string2.compareTo("0132") == 0) {
            n2 = n7;
            n3 = 32;
            int n16 = 1;
            n4 = this.cell[nArray[n16]];
            int n17 = this.cube[n4].getFace((int)1).colorcode;
            if (n17 == this.sliceInfo[1].centerColorcode[0]) {
                this.preTrick3Move = "R1>>FN< ";
                this.postTrick3Move = "FN> R1>>";
            } else {
                this.preTrick3Move = "R1>>";
                this.postTrick3Move = "R1>>";
            }
        } else {
            n2 = n7;
            n3 = 0;
            boolean bl = false;
            this.preTrick3Move = "";
            this.postTrick3Move = "";
            this.bTrick3Move = false;
        }
        if (n2 > 2) {
            n2 -= 4;
        }
        string = n2 == 1 ? "R1> " : (n2 == 2 ? "R1>>" : (n2 == -1 ? "R1< " : ""));
        g.dbg(0, "trick3Info: opStr=" + string);
        return string;
    }

    private String turnOpStr(AcolorPair acolorPair, AcolorPair acolorPair2) {
        g.dbg(0, "----turnOpStr: fromCP=" + acolorPair + "; toCP=" + acolorPair2);
        Avec avec = new Avec(acolorPair.topNormal);
        Avec avec2 = new Avec(acolorPair.sideNormal);
        Avec avec3 = new Avec(acolorPair2.topNormal);
        Avec avec4 = new Avec(acolorPair2.sideNormal);
        int n = this.cellIdOf(acolorPair);
        Apoint apoint = new Apoint((double)(n / this.nDIM2) + 0.5, (double)(n % this.nDIM2 / this.nDIM) + 0.5, (double)(n % this.nDIM) + 0.5);
        AxisRotation axisRotation = new AxisRotation();
        AxisRotation axisRotation2 = new AxisRotation();
        g.dbg(0, "----turnOpStr: v0,w0,fromCenter=" + avec + "," + avec2 + apoint);
        Apoint apoint2 = new Apoint((double)this.nDIM * 0.5, (double)this.nDIM * 0.5, (double)this.nDIM * 0.5);
        axisRotation.initVecCross(avec, avec3, avec2, this.nDIM);
        String string = axisRotation.turnStr(apoint);
        if (axisRotation.turnAxis != null) {
            axisRotation.rotateM.matTransform(avec2);
            apoint = axisRotation.rotateM.matRotation(apoint, apoint2);
        }
        g.dbg(0, "----turnOpStr: v0,w0,fromCenter=" + avec + "," + avec2 + apoint + "; rotStr=" + string);
        axisRotation2.initVecCross(avec2, avec4, null, this.nDIM);
        string = String.valueOf(string) + axisRotation2.turnStr(apoint);
        g.dbg(0, "----turnOpStr: w0,w1,fromCenter=" + avec2 + "," + avec4 + "; rotStr=" + string);
        return string;
    }
}

