/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class AcubeGame
extends Panel
implements Runnable,
ActionListener,
ItemListener,
AdjustmentListener {
    cubeApp cuApp;
    AcubeCanvas cubeCanvas;
    AcubeInfo cubeInfo;
    Panel controlPanel;
    int nDIM;
    Point cubeGameOrigin;
    AcubeOp[] mCubeOpArr = new AcubeOp[100];
    AcubeOp mTrick1;
    AcubeOp mTrick2;
    AcubeOp mTrick3;
    int NcubeOp = 0;
    Thread cubethread = null;
    int gameState;
    int gameStatePrev;
    static final int GAMESTATE_0 = 0;
    static final int GAMESTATE_START = 1;
    static final int GAMESTATE_TRICK = 2;
    static final int GAMESTATE_SOLVE = 3;
    static final int GAMESTATE_SETCUBE = 4;
    static final int GAMESTATE_TEST = 5;
    int solveState;
    int solveStateNext;
    int solveMode;
    static final int SOLVESTATE00 = 0;
    static final int SOLVESTATE10 = 10;
    static final int SOLVESTATE11 = 11;
    static final int S12TOPCORNER = 12;
    static final int S13TOPTARGET = 13;
    static final int S30TOPCENTER = 30;
    static final int S31SIDE_CNTR = 31;
    static final int S40TRICK3T2L = 40;
    static final int SOLVESTATE41 = 41;
    static final int S42TRICK3COR = 42;
    static final int S43TRICK3PRE = 43;
    static final int S44TRICK3MOV = 44;
    static final int S45TRICK3POS = 45;
    static final int S48TRICK3R2T = 48;
    static final int SOLVESTATE49 = 49;
    static final int S50TRICK2COR = 50;
    static final int S51TRICK2RO1 = 51;
    static final int SOLVESTATE52 = 52;
    static final int S55TRICK2PRE = 55;
    static final int S56TRICK2MOV = 56;
    static final int S57TRICK2POS = 57;
    static final int S58TRICK2RO2 = 58;
    static final int S60TRICK1INF = 60;
    static final int S61TRICK1TOP = 61;
    static final int S62TRICK1PRE = 62;
    static final int S63TRICK1MOV = 63;
    static final int S65TRICK1POS = 65;
    static final int SOLVESTATE99 = 99;
    static final int SOLVEMODE_HINT = 1;
    static final int SOLVEMODE_SOLVE = 2;
    long startTime;
    long endTime;
    boolean optViewPanel;
    boolean optPerformPanel;
    boolean optTune;
    boolean showMirroredFace = false;
    boolean showPerspective = false;
    boolean showDirectionArrow = false;
    movingBanner banner1;
    int degZ;
    int degY;
    int incrY;
    int degX;
    int incrX;
    TextField txtCounter;
    TextField txtSpeed;
    TextField degViewY;
    TextField degIncrY;
    TextField degViewX;
    TextField degIncrX;
    Button buViewY;
    Button buIncrY;
    Button buViewX;
    Button buIncrX;
    Panel panelVX;
    Panel panelVY;
    Checkbox cbMirror;
    Checkbox cbPerspective;
    Checkbox cbUntilDone;
    Checkbox cbTimes;
    Checkbox cbAudio;
    Checkbox cb1;
    Checkbox cb2;
    Button opPerform1;
    Button buStop;
    Button buReset;
    Button buScramble;
    Button buSolve1;
    Button buSolve;
    Button buSetCube;
    Button buTest;
    List opList1;
    TextField opTimes;
    TextField opRepeat1;
    Label label1;
    Label lblCompleted;
    Scrollbar sbSpeed;
    int sbSpeedValue;
    Label[] tuneLbl;
    Scrollbar[] tuneSb;
    TextField[] tuneTxt;

    public AcubeGame(int n, cubeApp cubeApp2) {
        this.nDIM = n;
        this.cuApp = cubeApp2;
        this.degZ = 0;
        this.degY = 30;
        this.degX = 20;
        this.incrY = 5;
        this.incrX = 5;
        this.showDirectionArrow = true;
        this.optViewPanel = false;
        this.optPerformPanel = true;
        this.optTune = true;
        if (cubeApp.freeware) {
            this.optViewPanel = false;
            this.optPerformPanel = false;
            this.optTune = false;
        }
        this.showMirroredFace = true;
        this.showPerspective = true;
        this.cuApp.playAudio = true;
        String[][] stringArrayArray = new String[][]{{"Trick1", "R1>>FM< R1>>FM> "}, {"Trick2", "BN< R1< BN> R1> BN< R1< BN> R1> F1> BN< R1< BN> R1> BN< R1< BN> R1> BN< R1< BN> R1> BN< R1< BN> R1> F1< "}, {"Trick3", "B1> R1> B1< R1< B1< F1> B1> F1< R1> "}};
        this.NcubeOp = 0;
        while (this.NcubeOp < 3) {
            this.mCubeOpArr[this.NcubeOp] = new AcubeOp(stringArrayArray[this.NcubeOp][0], stringArrayArray[this.NcubeOp][1], this.nDIM, null);
            ++this.NcubeOp;
        }
        if (this.nDIM >= 3) {
            cubeOpImport cubeOpImport2 = new cubeOpImport("cubeOp.imp");
            if (cubeOpImport2.token9 != null) {
                String string;
                while ((string = cubeOpImport2.getNextOp()) != null && string != "") {
                    this.mCubeOpArr[this.NcubeOp] = new AcubeOp(cubeOpImport2.opName, string, this.nDIM, this.mCubeOpArr);
                    ++this.NcubeOp;
                }
            } else {
                this.NcubeOp = 3;
                while (this.NcubeOp < stringArrayArray.length) {
                    this.mCubeOpArr[this.NcubeOp] = new AcubeOp(stringArrayArray[this.NcubeOp][0], stringArrayArray[this.NcubeOp][1], this.nDIM, this.mCubeOpArr);
                    ++this.NcubeOp;
                }
            }
        }
        this.mTrick1 = AcubeOp.getOp("Trick1", this.mCubeOpArr, this.NcubeOp);
        this.mTrick2 = AcubeOp.getOp("Trick2", this.mCubeOpArr, this.NcubeOp);
        this.mTrick3 = AcubeOp.getOp("Trick3", this.mCubeOpArr, this.NcubeOp);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.optViewPanel) {
            if (this.buViewY.equals(actionEvent.getSource())) {
                this.degY = Integer.valueOf(this.degViewY.getText());
                this.cubeCanvas.setView(0, this.degY, this.degX);
                this.cubeCanvas.repaint();
            }
            if (this.buViewX.equals(actionEvent.getSource())) {
                this.degX = Integer.valueOf(this.degViewX.getText());
                this.cubeCanvas.setView(0, this.degY, this.degX);
                this.cubeCanvas.repaint();
            }
            if (this.buIncrY.equals(actionEvent.getSource())) {
                this.incrY = Integer.valueOf(this.degIncrY.getText());
                this.degY += this.incrY;
                this.degViewY.setText(String.valueOf(this.degY));
                this.cubeCanvas.setView(0, this.degY, this.degX);
                this.cubeCanvas.repaint();
            }
            if (this.buIncrX.equals(actionEvent.getSource())) {
                this.incrX = Integer.valueOf(this.degIncrX.getText());
                this.degX += this.incrX;
                this.degViewX.setText(String.valueOf(this.degX));
                this.cubeCanvas.setView(0, this.degY, this.degX);
                this.cubeCanvas.repaint();
            }
        }
        if (this.buReset.equals(actionEvent.getSource())) {
            this.cubeCanvas.resetCube();
            this.incrTxtCounter(0);
        } else if (this.buScramble.equals(actionEvent.getSource())) {
            this.cubeCanvas.scrambleCube();
            this.incrTxtCounter(0);
        } else if (this.buSolve.equals(actionEvent.getSource())) {
            this.solveMode = 2;
            this.gameState = 1;
            this.solveState = 0;
            this.incrTxtCounter(0);
            this.solveCube();
        } else if (this.buSolve1.equals(actionEvent.getSource())) {
            this.solveMode = 1;
            this.gameState = 1;
            this.solveState = 0;
            this.solveCube();
        } else if (this.buSetCube.equals(actionEvent.getSource())) {
            this.cubeCanvas.setCube(null);
        } else if (this.buTest.equals(actionEvent.getSource())) {
            this.cubeCanvas.testCube(1);
        } else if (this.opPerform1.equals(actionEvent.getSource())) {
            String string = this.opList1.getSelectedItem();
            AcubeOp acubeOp = AcubeOp.getOp(string, this.mCubeOpArr, this.NcubeOp);
            if (acubeOp == null) {
                return;
            }
            int n = this.cbTimes.getState() ? Integer.valueOf(this.opTimes.getText()) : 9999;
            this.cubeCanvas.performTrick(acubeOp, n);
        } else if (this.buStop.equals(actionEvent.getSource())) {
            this.cubeCanvas.stopAnimation();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n;
        if (this.sbSpeed.equals(adjustmentEvent.getSource())) {
            n = this.sbSpeed.getValue();
            this.txtSpeed.setText(String.valueOf(n));
            Aturn.Nframe = Aturn.maxNframe - (n - 1) * (Aturn.maxNframe - 1) / 99;
            if (Aturn.Nframe <= 0) {
                Aturn.Nframe = 1;
            }
            this.cubeCanvas.repaint();
        }
        n = 0;
        while (n < this.tuneSb.length) {
            if (this.tuneSb[n].equals(adjustmentEvent.getSource())) {
                int n2 = this.tuneSb[n].getValue();
                this.tuneTxt[n].setText(String.valueOf(n2));
                if (n == 0) {
                    this.banner1.sleepMs = n2;
                }
                if (n == 1) {
                    this.banner1.nPixPerSec = n2;
                }
                if (n == 2) {
                    this.banner1.waveFactor = (double)n2 / 100.0;
                }
                if (n < 3) {
                    this.banner1.setTransient();
                }
            }
            ++n;
        }
    }

    public int getTxtCounter() {
        int n = Integer.valueOf(this.txtCounter.getText());
        return n;
    }

    public void incrOpRepeat1(int n) {
        if (n == 0) {
            this.opRepeat1.setText("0");
        } else {
            int n2 = Integer.valueOf(this.opRepeat1.getText());
            this.opRepeat1.setText(String.valueOf(++n2));
        }
    }

    public void incrTxtCounter(int n) {
        if (n == 0) {
            this.txtCounter.setText("0");
        } else {
            int n2 = Integer.valueOf(this.txtCounter.getText());
            this.txtCounter.setText(String.valueOf(++n2));
        }
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.banner1 = new movingBanner(cubeApp.VCBANNER, new Font("Bookman Old Style", 0, 9));
        this.banner1.addBannerStr(cubeApp.VCBANNER1);
        this.add("North", this.banner1);
        this.cubeCanvas = new AcubeCanvas(this.nDIM, this.showMirroredFace, this.showPerspective, this);
        this.cubeInfo = new AcubeInfo(this.cubeCanvas.cube, this.cubeCanvas.cell, this.nDIM);
        this.add("Center", this.cubeCanvas);
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        String string = " 0. <Reset>\n 1. Select Op\n 2. <DoOperation>\n";
        TextArea textArea = new TextArea(string, 3, 10);
        textArea.setEditable(false);
        gridBagLayout.setConstraints(textArea, gridBagConstraints);
        panel.add(textArea);
        this.opPerform1 = new Button("DoOperation:");
        this.opPerform1.addActionListener(this);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagLayout.setConstraints(this.opPerform1, gridBagConstraints);
        panel.add(this.opPerform1);
        this.opList1 = new List(12, false);
        int n = 3;
        while (n < this.NcubeOp) {
            if (!this.mCubeOpArr[n].id.substring(0, 3).equals("pre")) {
                this.opList1.add(this.mCubeOpArr[n].id);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 3) {
            this.opList1.add(this.mCubeOpArr[n2].id);
            ++n2;
        }
        this.opList1.select(0);
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(this.opList1, gridBagConstraints);
        panel.add(this.opList1);
        this.add("East", panel);
        Panel panel2 = new Panel();
        int n3 = 1;
        if (this.optViewPanel || this.optPerformPanel) {
            ++n3;
        }
        if (this.optTune) {
            ++n3;
        }
        panel2.setLayout(new GridLayout(n3, 1));
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(1, 10));
        this.buReset = new Button("Reset");
        this.buReset.addActionListener(this);
        this.buScramble = new Button("Scramble");
        this.buScramble.addActionListener(this);
        this.buSolve = new Button("SolveAll");
        this.buSolve.addActionListener(this);
        this.buSolve1 = new Button("Solve1Step");
        this.buSolve1.addActionListener(this);
        this.buStop = new Button("Stop");
        this.buStop.addActionListener(this);
        this.buSetCube = new Button("setup cube");
        this.buSetCube.addActionListener(this);
        this.buTest = new Button("Test");
        this.buTest.addActionListener(this);
        this.cbAudio = new Checkbox("sound");
        this.cbAudio.addItemListener(this);
        this.cbAudio.setState(this.cuApp.playAudio);
        panel3.add(this.buReset);
        panel3.add(this.buScramble);
        panel3.add(this.buSolve);
        panel3.add(this.buSolve1);
        panel3.add(this.buStop);
        if (!cubeApp.freeware) {
            panel3.add(this.buSetCube);
        }
        this.sbSpeedValue = 1 + 99 * (Aturn.maxNframe - Aturn.Nframe) / (Aturn.maxNframe - 1);
        this.sbSpeed = new Scrollbar(0, this.sbSpeedValue, 1, 1, 100);
        this.sbSpeed.setUnitIncrement(5);
        this.sbSpeed.addAdjustmentListener(this);
        panel3.add(this.sbSpeed);
        this.txtSpeed = new TextField(String.valueOf(this.sbSpeedValue), 2);
        panel3.add(this.cbAudio);
        panel2.add(panel3);
        Panel panel4 = new Panel();
        int n4 = 1;
        if (this.optViewPanel && this.optPerformPanel) {
            ++n4;
        }
        if (this.optTune) {
            ++n4;
        }
        panel4.setLayout(new GridLayout(n4, 10));
        if (this.optViewPanel) {
            this.panelVY = new Panel();
            this.panelVY.setLayout(new FlowLayout());
            this.buViewY = new Button("Left View(degree)=");
            this.buViewY.addActionListener(this);
            this.panelVY.add(this.buViewY);
            this.buIncrY = new Button("Incr");
            this.buIncrY.addActionListener(this);
            this.panelVY.add(this.degViewY);
            this.degViewY = new TextField(String.valueOf(this.degY), 4);
            this.degViewY.addActionListener(this);
            this.panelVY.add(this.buIncrY);
            this.degIncrY = new TextField(String.valueOf(this.incrY), 4);
            this.degIncrY.addActionListener(this);
            this.panelVY.add(this.degIncrY);
            panel4.add(this.panelVY);
            this.panelVX = new Panel();
            this.panelVX.setLayout(new FlowLayout());
            this.buViewX = new Button("Top  View(degree)=");
            this.buViewX.addActionListener(this);
            this.panelVX.add(this.buViewX);
            this.buIncrX = new Button("Incr");
            this.buIncrX.addActionListener(this);
            this.panelVX.add(this.degViewX);
            this.degViewX = new TextField(String.valueOf(this.degX), 4);
            this.degViewX.addActionListener(this);
            this.panelVX.add(this.buIncrX);
            this.degIncrX = new TextField(String.valueOf(this.incrX), 4);
            this.degIncrX.addActionListener(this);
            this.panelVX.add(this.degIncrX);
            panel4.add(this.panelVX);
        }
        Panel panel5 = new Panel();
        panel5.setLayout(new FlowLayout());
        this.cbTimes = new Checkbox("Times=");
        this.cbTimes.setState(true);
        this.cbTimes.addItemListener(this);
        panel5.add(this.cbTimes);
        this.opTimes = new TextField("1", 2);
        panel5.add(this.opTimes);
        this.cbUntilDone = new Checkbox("Until Done");
        this.cbUntilDone.setState(false);
        this.cbUntilDone.addItemListener(this);
        panel5.add(this.cbUntilDone);
        this.lblCompleted = new Label("Times Completed=");
        panel5.add(this.lblCompleted);
        this.opRepeat1 = new TextField("0", 3);
        panel5.add(this.opRepeat1);
        panel4.add(panel5);
        Panel panel6 = new Panel();
        panel6.setLayout(new FlowLayout());
        this.cbPerspective = new Checkbox("Perspective");
        this.cbPerspective.setState(this.showPerspective);
        this.cbPerspective.addItemListener(this);
        panel6.add(this.cbPerspective);
        this.cbMirror = new Checkbox("Show Mirror");
        this.cbMirror.setState(this.showMirroredFace);
        this.cbMirror.addItemListener(this);
        panel6.add(this.cbMirror);
        this.cb1 = new Checkbox("Wave_Y/N");
        this.cb1.setState(true);
        this.cb1.addItemListener(this);
        panel6.add(this.cb1);
        this.txtCounter = new TextField("0", 4);
        panel6.add(this.txtCounter);
        panel4.add(panel6);
        if (this.optViewPanel || this.optPerformPanel) {
            panel2.add(panel4);
        }
        Panel panel7 = new Panel();
        panel7.setLayout(new FlowLayout());
        int n5 = 3;
        this.tuneLbl = new Label[n5];
        this.tuneSb = new Scrollbar[n5];
        this.tuneTxt = new TextField[n5];
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        int[] nArray3 = new int[n5];
        int n6 = 0;
        while (n6 < n5) {
            nArray2[n6] = 50;
            nArray[n6] = 1;
            nArray3[n6] = 100;
            ++n6;
        }
        nArray2[0] = this.banner1.sleepMs;
        nArray[0] = 10;
        nArray3[0] = 500;
        nArray2[1] = this.banner1.nPixPerSec;
        nArray[1] = 10;
        nArray3[1] = 500;
        nArray2[2] = (int)this.banner1.waveFactor * 100;
        nArray[2] = 1;
        nArray3[2] = 50;
        int n7 = 0;
        while (n7 < n5) {
            this.tuneLbl[n7] = new Label("tune" + n7);
            panel7.add(this.tuneLbl[n7]);
            this.tuneSb[n7] = new Scrollbar(0, nArray2[n7], 1, nArray[n7], nArray3[n7]);
            this.tuneSb[n7].setUnitIncrement(1);
            this.tuneSb[n7].addAdjustmentListener(this);
            panel7.add(this.tuneSb[n7]);
            this.tuneTxt[n7] = new TextField(String.valueOf(nArray2[n7]), 3);
            panel7.add(this.tuneTxt[n7]);
            if (this.optTune) {
                panel2.add(panel7);
            }
            ++n7;
        }
        this.add("South", panel2);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.cbUntilDone.equals(itemEvent.getSource())) {
            if (this.cbUntilDone.getState()) {
                this.cbTimes.setState(false);
            } else {
                this.cbTimes.setState(true);
            }
        } else if (this.cbTimes.equals(itemEvent.getSource())) {
            if (this.cbTimes.getState()) {
                this.cbUntilDone.setState(false);
            } else {
                this.cbUntilDone.setState(true);
            }
        } else if (this.cbAudio.equals(itemEvent.getSource())) {
            this.cuApp.playAudio = this.cbAudio.getState();
        } else if (this.cbMirror.equals(itemEvent.getSource())) {
            this.showMirroredFace = this.cbMirror.getState();
            this.cubeCanvas.setOptMirror(this.showMirroredFace);
        } else if (!this.cb1.equals(itemEvent.getSource()) && this.cbPerspective.equals(itemEvent.getSource())) {
            this.showPerspective = this.cbPerspective.getState();
            this.cubeCanvas.setOptPerspective(this.showPerspective);
        }
    }

    public void resetTextFields() {
        this.degY = 30;
        this.degX = 20;
        this.incrY = 5;
        this.incrX = 5;
        this.degViewX.setText(String.valueOf(this.degX));
        this.degIncrX.setText(String.valueOf(this.incrX));
        this.degViewY.setText(String.valueOf(this.degY));
        this.degIncrY.setText(String.valueOf(this.incrY));
    }

    public void run() {
        Dimension dimension = this.getSize();
        int n = dimension.width / 8;
        int n2 = dimension.height / 24;
        while (this.cubethread != null) {
            long l = System.currentTimeMillis();
            switch (this.gameState) {
                case 5: {
                    this.cubeCanvas.testCube(this.gameState);
                    break;
                }
                case 2: {
                    this.cubeCanvas.animateTrick(this.gameState);
                    break;
                }
                case 3: {
                    this.solveCube();
                    break;
                }
                case 0: 
                case 1: {
                    this.repaint();
                    break;
                }
                default: {
                    g.abort("unexpected gameState=" + this.gameState);
                }
                case 4: 
            }
            int n3 = 25 - (int)(System.currentTimeMillis() - l);
            if (n3 < 0) {
                n3 = 0;
            }
            try {
                Thread.sleep(n3);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void solveCube() {
        switch (this.solveState) {
            case 0: {
                this.startTime = System.currentTimeMillis();
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                this.gameState = 3;
                if (this.cubeInfo.trick1Ready()) {
                    this.solveState = 60;
                    break;
                }
                this.solveState = 10;
                break;
            }
            case 10: {
                String string;
                this.cubeInfo.bestFace();
                if (this.cubeInfo.bestSliceId == 3) {
                    this.solveState = 12;
                    break;
                }
                switch (this.cubeInfo.bestSliceId) {
                    case 0: {
                        string = "F1> ";
                        break;
                    }
                    case 1: {
                        string = "F1< ";
                        break;
                    }
                    case 2: {
                        string = "R1>>";
                        break;
                    }
                    case 4: {
                        string = "R1< ";
                        break;
                    }
                    case 5: {
                        string = "R1> ";
                        break;
                    }
                    default: {
                        string = "";
                    }
                }
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 12;
                    this.cubeCanvas.performRotate("rotate2Top", string);
                }
                this.solveState = 12;
                break;
            }
            case 12: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                int n = this.cubeInfo.locateBadCornerCellid();
                String string = "";
                if (n < 0) {
                    this.solveState = 30;
                    break;
                }
                string = n == this.cubeInfo.cornerCellId[2] ? "" : (n == this.cubeInfo.cornerCellId[0] ? String.valueOf(string) + "BN>>" : (n == this.cubeInfo.cornerCellId[1] ? String.valueOf(string) + "BN> " : String.valueOf(string) + "BN< "));
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 13;
                    this.cubeCanvas.performTrick(new AcubeOp("topTurn", string, this.nDIM), 1);
                }
                this.solveState = 13;
                break;
            }
            case 13: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                String string = this.cubeInfo.moveToRTF();
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = this.solveMode == 2 ? 12 : 99;
                    this.cubeCanvas.performTrick(new AcubeOp("toRTF", string, this.nDIM), 1);
                }
                this.solveState = 99;
                if (this.solveMode != 2) break;
                this.solveState = 12;
                break;
            }
            case 30: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                String string = this.cubeInfo.moveCenterSlice(3);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 31;
                    this.cubeCanvas.performTrick(new AcubeOp("topCenter", string, this.nDIM), 1);
                }
                this.solveState = 31;
                break;
            }
            case 31: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                String string = this.cubeInfo.moveCenterSlice(1);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 40;
                    this.cubeCanvas.performTrick(new AcubeOp("rightCenter", string, this.nDIM), 1);
                }
                this.solveState = 40;
                break;
            }
            case 40: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                if (this.cubeInfo.trick1Ready()) {
                    this.solveState = 60;
                    break;
                }
                this.gameStatePrev = 3;
                this.solveStateNext = 42;
                this.cubeCanvas.performRotate("rotate2Left", "F1< ");
                break;
            }
            case 42: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                String string = this.cubeInfo.trick3Info(1);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 43;
                    this.cubeCanvas.performTrick(new AcubeOp("trick3cor", string, this.nDIM), 1);
                }
                this.solveState = 43;
                break;
            }
            case 43: {
                String string = this.cubeInfo.preTrick3Move;
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 44;
                    this.cubeCanvas.performTrick(new AcubeOp("preTrick3", string, this.nDIM), 1);
                }
                this.solveState = 44;
                break;
            }
            case 44: {
                if (this.cubeInfo.bTrick3Move) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 45;
                    this.cubeCanvas.performTrick(this.mTrick3, 1);
                }
                this.solveState = 45;
                break;
            }
            case 45: {
                String string = AcubeOp.invOpStr(this.cubeInfo.preTrick3Move);
                string = this.cubeInfo.postTrick3Move;
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 48;
                    this.cubeCanvas.performTrick(new AcubeOp("postTrick3", string, this.nDIM), 1);
                }
                this.solveState = 48;
                break;
            }
            case 48: {
                if (this.cubeInfo.trick1Ready()) {
                    this.solveState = 60;
                    break;
                }
                this.gameStatePrev = 3;
                this.solveStateNext = 50;
                this.cubeCanvas.performRotate("rotateR2T", "F1< ");
                break;
            }
            case 50: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                this.cubeInfo.trick2Info(3);
                if (!this.cubeInfo.bTrick2Move) {
                    this.solveState = 60;
                    break;
                }
                this.solveState = 51;
                break;
            }
            case 51: {
                if (this.cubeInfo.preTrick2Rotate.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 55;
                    this.cubeCanvas.performRotate("preTrick2Rotate", this.cubeInfo.preTrick2Rotate);
                }
                this.solveState = 55;
                break;
            }
            case 55: {
                String string = this.cubeInfo.preTrick2Move;
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 56;
                    this.cubeCanvas.performTrick(new AcubeOp("preTrick2", string, this.nDIM), 1);
                }
                this.solveState = 56;
                break;
            }
            case 56: {
                this.gameStatePrev = 3;
                this.solveStateNext = 57;
                this.cubeCanvas.performTrick(this.mTrick2, 1);
                break;
            }
            case 57: {
                String string = this.cubeInfo.postTrick2Move;
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 58;
                    this.cubeCanvas.performTrick(new AcubeOp("postTrick3", string, this.nDIM), 1);
                }
                this.solveState = 58;
                break;
            }
            case 58: {
                if (this.cubeInfo.postTrick2Rotate.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 99;
                    if (this.solveMode == 2) {
                        this.solveStateNext = 50;
                    }
                    this.cubeCanvas.performRotate("postTrick2Rotate", this.cubeInfo.postTrick2Rotate);
                }
                this.solveState = 99;
                if (this.solveMode != 2) break;
                this.solveState = 50;
                break;
            }
            case 60: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                this.cubeInfo.trick1Init();
                if (!this.cubeInfo.trick1Ready()) {
                    this.solveState = 99;
                    break;
                }
                if (this.cubeInfo.NbadEdges == 0) {
                    this.solveState = 99;
                    break;
                }
                String string = this.cubeInfo.trick1Rotate();
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 61;
                    this.cubeCanvas.performRotate("Trick1Rotate", string);
                }
                this.solveState = 61;
                break;
            }
            case 61: {
                this.cubeInfo.setInfo();
                String string = this.cubeInfo.trick1Top();
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 62;
                    this.cubeCanvas.performTrick(new AcubeOp("Trick1Top", string, this.nDIM), 1);
                }
                this.solveState = 62;
                break;
            }
            case 62: {
                this.cubeInfo.setInfo();
                String string = this.cubeInfo.trick1Bac();
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 63;
                    this.cubeCanvas.performTrick(new AcubeOp("preTrick1", string, this.nDIM), 1);
                }
                this.solveState = 63;
                break;
            }
            case 63: {
                this.gameStatePrev = 3;
                this.solveStateNext = 65;
                this.cubeCanvas.performTrick(this.mTrick1, 1);
                break;
            }
            case 65: {
                String string = AcubeOp.invOpStr(this.cubeInfo.opPreTrick1);
                string = String.valueOf(string) + AcubeOp.invOpStr(this.cubeInfo.opTrick1Top);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = this.solveMode == 2 ? 60 : 99;
                    this.cubeCanvas.performTrick(new AcubeOp("posTrick1", string, this.nDIM), 1);
                }
                if (this.solveMode == 2) {
                    this.solveState = 60;
                    break;
                }
                this.solveStateNext = 99;
                break;
            }
            case 99: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                this.endTime = System.currentTimeMillis();
                this.solveState = 0;
                this.gameState = 0;
                this.gameStatePrev = 0;
                this.cubeCanvas.solved(this.cubeInfo);
                break;
            }
        }
    }

    public void start() {
        this.cubeGameOrigin = this.getLocation();
        this.banner1.init();
        this.banner1.start();
        this.banner1.repaint();
        if (this.cubethread == null) {
            this.cubethread = new Thread(this);
            this.cubethread.setPriority(10);
            this.cubethread.start();
        }
    }

    public void stop() {
        this.cubethread = null;
    }
}

