/*
 * Decompiled with CFR 0.152.
 */
package cubespin;

import cubespin.Amatx;
import cubespin.Apoint;
import cubespin.Aturn;
import cubespin.Avec;
import cubespin.g;

class AxisRotation {
    Amatx rotateM = new Amatx();
    Avec turnAxis;
    int Nturn;
    int axisIx;
    int nDIM;
    int nDIM_1;
    static final String[] turnChar = new String[]{"R", "B", "F", "R", "B", "F"};
    static final String[] dirChar = new String[]{"<", ">", "<", ">", "<", ">"};
    static final Avec[] axisVec = new Avec[]{new Avec(g.vI), new Avec(g.vJ), new Avec(g.vK), new Avec(g.v_I), new Avec(g.v_J), new Avec(g.v_K)};

    AxisRotation() {
    }

    public static int getAxisIx(Avec avec) {
        int n = avec.equals(g.vI) ? 0 : (avec.equals(g.vJ) ? 1 : (avec.equals(g.vK) ? 2 : (avec.equals(g.v_I) ? 3 : (avec.equals(g.v_J) ? 4 : 5))));
        return n;
    }

    public void init(Avec avec, int n, int n2) {
        this.turnAxis = avec;
        this.Nturn = n;
        this.nDIM = n2;
        this.nDIM_1 = this.nDIM_1;
        if (this.turnAxis == null) {
            this.axisIx = 0;
            this.rotateM.set(g.I);
        } else {
            double d = this.turnAxis.getMultipleOf(g.vI);
            if (d != 0.0) {
                if (d > 0.0) {
                    this.axisIx = 0;
                    this.rotateM.set(g.X);
                } else {
                    this.axisIx = 3;
                    this.rotateM.set(g.X_1);
                }
            } else {
                d = this.turnAxis.getMultipleOf(g.vJ);
                if (d != 0.0) {
                    if (d > 0.0) {
                        this.axisIx = 1;
                        this.rotateM.set(g.Y);
                    } else {
                        this.axisIx = 4;
                        this.rotateM.set(g.Y_1);
                    }
                } else {
                    d = this.turnAxis.getMultipleOf(g.vK);
                    if (d != 0.0) {
                        if (d > 0.0) {
                            this.axisIx = 2;
                            this.rotateM.set(g.Z);
                        } else {
                            this.axisIx = 5;
                            this.rotateM.set(g.Z_1);
                        }
                    } else {
                        g.abort("AxisRotation.init: turnAxis=" + this.turnAxis);
                    }
                }
            }
        }
        if (this.Nturn > 1) {
            int n3 = 2;
            while (n3 <= this.Nturn) {
                this.rotateM.square();
                ++n3;
            }
        }
    }

    public void initVecCross(Avec avec, Avec avec2, Avec avec3, int n) {
        Avec avec4;
        int n2;
        double d = (int)avec.getMultipleOf(avec2);
        if (d == 0.0) {
            n2 = 1;
            avec4 = Avec.VecCross(avec, avec2);
        } else if (d == 1.0) {
            n2 = 1;
            avec4 = null;
        } else {
            n2 = 2;
            avec4 = avec3 != null ? avec3 : (avec.getMultipleOf(g.vJ) == 0.0 ? new Avec(g.vJ) : (avec.getMultipleOf(g.vK) == 0.0 ? new Avec(g.vK) : new Avec(g.vI)));
        }
        this.init(avec4, n2, n);
    }

    public static Avec toTurnAxis(char c, char c2) {
        int n = 0;
        if (c == 'R' && c2 == '<') {
            n = 0;
        } else if (c == 'R' && c2 == '>') {
            n = 3;
        } else if (c == 'B' && c2 == '>') {
            n = 1;
        } else if (c == 'B' && c2 == '<') {
            n = 4;
        } else if (c == 'F' && c2 == '<') {
            n = 2;
        } else if (c == 'F' && c2 == '>') {
            n = 5;
        } else {
            g.abort("toTurnAxis: BRF=" + c + ";lr=" + c2);
        }
        return axisVec[n];
    }

    public static String toTurnStr(Avec avec, int n, int n2) {
        int n3 = AxisRotation.getAxisIx(avec);
        String string = String.valueOf(turnChar[n3]) + n + dirChar[n3];
        string = n2 == 2 ? String.valueOf(string) + dirChar[n3] : String.valueOf(string) + " ";
        return string;
    }

    public String turnStr(Apoint apoint) {
        int n = 0;
        if (this.turnAxis == null) {
            return "";
        }
        String string = turnChar[this.axisIx];
        n = (int)apoint.pos[this.axisIx % 3];
        int n2 = Aturn.getslice1N(this.axisIx, n, this.nDIM);
        string = String.valueOf(string) + n2;
        string = String.valueOf(string) + dirChar[this.axisIx];
        string = this.Nturn == 2 ? String.valueOf(string) + dirChar[this.axisIx] : String.valueOf(string) + " ";
        return string;
    }
}

