/*
 * Decompiled with CFR 0.152.
 */
package cubespin;

import cubespin.Apoint;
import cubespin.g;

class Avec {
    public double[] v = new double[3];

    public Avec() {
        this.v[2] = 0.0;
        this.v[1] = 0.0;
        this.v[0] = 0.0;
    }

    public Avec(double d, double d2, double d3) {
        this.v[0] = d;
        this.v[1] = d2;
        this.v[2] = d3;
    }

    public Avec(Apoint apoint) {
        int n = 0;
        while (n < 3) {
            this.v[n] = apoint.pos[n];
            ++n;
        }
    }

    public Avec(Apoint apoint, Apoint apoint2) {
        int n = 0;
        while (n < 3) {
            this.v[n] = apoint2.pos[n] - apoint.pos[n];
            ++n;
        }
    }

    public Avec(Avec avec) {
        int n = 0;
        while (n < 3) {
            this.v[n] = avec.v[n];
            ++n;
        }
    }

    static Apoint VecAdd(Apoint apoint, double d, Avec avec, double d2, Avec avec2) {
        Apoint apoint2 = new Apoint();
        int n = 0;
        while (n < 3) {
            if (d2 != 0.0) {
                apoint2.pos[n] = apoint.pos[n] + d * avec.v[n] + d2 * avec2.v[n];
            }
            if (d2 == 0.0) {
                apoint2.pos[n] = apoint.pos[n] + d * avec.v[n];
            }
            ++n;
        }
        return apoint2;
    }

    static Avec VecCross(Avec avec, Avec avec2) {
        Avec avec3 = new Avec();
        avec3.v[0] = avec.v[1] * avec2.v[2] - avec.v[2] * avec2.v[1];
        avec3.v[1] = avec.v[0] * avec2.v[2] - avec.v[2] * avec2.v[0];
        if (avec3.v[1] != 0.0) {
            avec3.v[1] = -avec3.v[1];
        }
        avec3.v[2] = avec.v[0] * avec2.v[1] - avec.v[1] * avec2.v[0];
        return avec3;
    }

    static double VecDot(Avec avec, Avec avec2) {
        return avec.v[0] * avec2.v[0] + avec.v[1] * avec2.v[1] + avec.v[2] * avec2.v[2];
    }

    public void add(Avec avec) {
        int n = 0;
        while (n < 3) {
            this.v[n] = this.v[n] + avec.v[n];
            ++n;
        }
    }

    public boolean equals(Avec avec) {
        int n = 0;
        while (n < 3) {
            if (avec.v[n] != this.v[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public double getMultipleOf(Avec avec) {
        Avec avec2 = Avec.VecCross(this, avec);
        if (!avec2.equals(g.vec0)) {
            return 0.0;
        }
        int n = 0;
        while (n < 3) {
            if (avec.v[n] != 0.0) break;
            ++n;
        }
        if (n < 3) {
            return this.v[n] / avec.v[n];
        }
        return 0.0;
    }

    public void mult(int n) {
        int n2 = 0;
        while (n2 < 3) {
            int n3 = n2++;
            this.v[n3] = this.v[n3] * (double)n;
        }
    }

    public void normalize() {
        double d = Avec.VecDot(this, this);
        if (Math.abs(d) > 0.0) {
            d = Math.sqrt(d);
            this.v[0] = this.v[0] / d;
            this.v[1] = this.v[1] / d;
            this.v[2] = this.v[2] / d;
        } else {
            this.v[0] = 1.0;
            this.v[1] = 0.0;
            this.v[2] = 0.0;
        }
    }

    public void set(double d, double d2, double d3) {
        this.v[0] = d;
        this.v[1] = d2;
        this.v[2] = d3;
    }

    public void set(Apoint apoint) {
        this.v[0] = apoint.pos[0];
        this.v[1] = apoint.pos[1];
        this.v[2] = apoint.pos[2];
    }

    public void set(Avec avec) {
        this.v[0] = avec.v[0];
        this.v[1] = avec.v[1];
        this.v[2] = avec.v[2];
    }

    public void sub(Avec avec) {
        int n = 0;
        while (n < 3) {
            this.v[n] = this.v[n] - avec.v[n];
            ++n;
        }
    }

    static Avec unitNormal(Avec avec, Avec avec2) {
        Avec avec3 = Avec.VecCross(avec, avec2);
        avec3.normalize();
        return avec3;
    }
}

