/*
 * Decompiled with CFR 0.152.
 */
package cubespin;

import cubespin.AcubeCanvas;
import cubespin.AcubeOp;
import cubespin.cubeApp;
import cubespin.cubeOpImport;
import cubespin.g;
import java.awt.BorderLayout;
import java.awt.Panel;
import java.util.Random;

class AcubeGame
extends Panel
implements Runnable {
    private cubeApp cuApp;
    private AcubeCanvas cubeCanvas;
    private int nDIM;
    Thread cubethread = null;
    private int gameState;
    private int gameStatePrev;
    public int NframePerTurn;
    static Thread animateThread;
    private AcubeOp[] mCubeOpArr = new AcubeOp[100];
    private int NcubeOp = 0;
    static final int GAMESTATE_0 = 0;
    static final int GAMESTATE_START = 1;
    static final int GAMESTATE_TRICK = 2;
    static final int GAMESTATE_SOLVE = 3;
    static final int GAMESTATE_SETCUBE = 4;
    static final int GAMESTATE_TEST = 5;
    static final int GAMESTATE_EXIT = 9;

    public AcubeGame(int n, cubeApp cubeApp2) {
        this.nDIM = n;
        this.cuApp = cubeApp2;
        String[][] stringArrayArray = new String[][]{{"Trick1", "R1>>FM< R1>>FM> "}, {"Trick2", "BN< R1< BN> R1> BN< R1< BN> R1> F1> BN< R1< BN> R1> BN< R1< BN> R1> BN< R1< BN> R1> BN< R1< BN> R1> F1< "}, {"Trick3", "B1> R1> B1< R1< B1< F1> B1> F1< R1> "}};
        this.NcubeOp = 0;
        while (this.NcubeOp < 3) {
            this.mCubeOpArr[this.NcubeOp] = new AcubeOp(stringArrayArray[this.NcubeOp][0], stringArrayArray[this.NcubeOp][1], this.nDIM, null);
            ++this.NcubeOp;
        }
        if (this.nDIM >= 3) {
            cubeOpImport cubeOpImport2 = new cubeOpImport("cubeOp.imp");
            if (cubeOpImport2.token9 != null) {
                String string;
                while ((string = cubeOpImport2.getNextOp()) != null && string != "") {
                    this.mCubeOpArr[this.NcubeOp] = new AcubeOp(cubeOpImport2.opName, string, this.nDIM, this.mCubeOpArr);
                    ++this.NcubeOp;
                }
            } else {
                this.NcubeOp = 3;
                while (this.NcubeOp < stringArrayArray.length) {
                    this.mCubeOpArr[this.NcubeOp] = new AcubeOp(stringArrayArray[this.NcubeOp][0], stringArrayArray[this.NcubeOp][1], this.nDIM, this.mCubeOpArr);
                    ++this.NcubeOp;
                }
            }
        }
        this.setBackground(cubeApp.cubeBackground);
        this.NframePerTurn = this.cuApp.NframePerTurn;
    }

    public synchronized Thread getAnimateThread() {
        return animateThread;
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.cubeCanvas = new AcubeCanvas(this.nDIM, false, true, this);
        this.add("Center", this.cubeCanvas);
    }

    public void run() {
        String[] stringArray = new String[]{"CheckerBox", "4Donut", "6Donut", "myVoicesOfFire", "4Cross", "4Cross2Star", "4Hospital", "6Hospital", "Why", "1x1In3x3", "Head&Shoulder", "2x2In3x3", "1In2In3Cube", "Trick1", "HomeAlone", "Trick2", "Trick1Times3", "UofT"};
        int n = this.cuApp.opListIx;
        Random random = new Random();
        while (this.cubethread != null) {
            long l = System.currentTimeMillis();
            switch (this.gameState) {
                case 2: {
                    this.cubeCanvas.animateTrick(this.gameState);
                    break;
                }
                case 0: 
                case 1: {
                    int n2 = this.cuApp.msBetweenTricks - 1000 + (int)(random.nextDouble() * 2000.0);
                    if (n2 < 0) {
                        n2 = 500;
                    }
                    try {
                        Thread.sleep(n2);
                    }
                    catch (Exception exception) {}
                    if (n >= stringArray.length) {
                        n = 0;
                        this.cubeCanvas.displayVCINFO();
                        try {
                            Thread.sleep(this.cuApp.msBetweenTricks);
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    if (this.getAnimateThread() != null || this.cubethread == null) break;
                    this.setAnimateThread(true);
                    animateThread = this.cubethread;
                    String string = stringArray[n++];
                    this.cubeCanvas.resetCube();
                    AcubeOp acubeOp = new AcubeOp("opList" + n, "(" + string + ")B*>>B*>>R*>>R*>>", 3, this.mCubeOpArr);
                    this.cubeCanvas.performTrick(acubeOp, 1);
                    this.repaint();
                    break;
                }
                case 9: {
                    return;
                }
                default: {
                    g.abort("unexpected gameState=" + this.gameState);
                }
            }
            int n3 = this.cuApp.msPause - (int)(System.currentTimeMillis() - l);
            if (n3 < 0) {
                n3 = 0;
            }
            try {
                Thread.sleep(n3);
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void setAnimateThread(boolean bl) {
        animateThread = bl ? this.cubethread : null;
    }

    public void setGameState(int n) {
        this.gameState = n;
    }

    public void start() {
        if (this.cubethread == null) {
            this.cubethread = new Thread(this);
            this.cubethread.setPriority(10);
            this.cubethread.start();
        }
    }

    public void stop() {
        this.setGameState(9);
        this.setAnimateThread(false);
        this.cubethread = null;
    }
}

