/*
 * Decompiled with CFR 0.152.
 */
package cubespin;

import cubespin.A322d;
import cubespin.AcubeFrame;
import cubespin.AcubeGame;
import cubespin.AcubeLet;
import cubespin.AcubeOp;
import cubespin.Aface;
import cubespin.Amatx;
import cubespin.Apoint;
import cubespin.Aturn;
import cubespin.Avec;
import cubespin.cubeApp;
import cubespin.g;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;

class AcubeCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    int nDIM;
    int nDIM3;
    int nDIM3_1;
    int nDIM2;
    int nDIM_1;
    AcubeLet[] cube;
    Apoint cubeCenter;
    int[] cell;
    AcubeFrame cubeFrame;
    AcubeGame cuGame;
    Aturn mSliceCubeTurn;
    int[] mSliceCubeId;
    int[] mSliceCubeId0;
    int mSliceCubeIdLen;
    int mSliceCubeId0Len;
    AcubeOp mTrickOp;
    int mTrickNrepeat;
    private boolean forceReDraw;
    static final int fudgeFactor = 150;
    Amatx prevMatrix = new Amatx();
    private int cState;
    private int prevCState;
    static final int STATE_0 = 0;
    static final int STATE_ROTATE_INIT = 1;
    static final int STATE_VIEW = 2;
    static final int STATE_ROTATE = 3;
    static final int STATE_ANIMATE = 4;
    static final int STATE_SETCUBE_INIT = 5;
    static final int STATE_SETCUBE = 6;
    static final int STATE_SETCUBE_ROTATE = 7;
    boolean painted;
    private Image offscreen = null;
    private Image animateScreen = null;
    private Dimension offscreensize;
    private Dimension animateScreenSize;
    private Graphics offgraphics;
    private Graphics animateGraphics;
    static final int MOUSE_0 = 0;
    static final int MOUSE_PRESSED = 1;
    static final int MOUSE_DRAGGED = 2;
    private int mState = 0;
    A322d a322d;
    A322d a322d0;
    private Color[] colorArr = new Color[8];
    private String[] cName = new String[8];
    Color canvasBackground;

    public AcubeCanvas(int n, boolean bl, boolean bl2, AcubeGame acubeGame) {
        this.nDIM = n;
        this.nDIM3 = n * n * n;
        this.nDIM3_1 = this.nDIM3 - 1;
        this.nDIM2 = n * n;
        this.nDIM_1 = n - 1;
        this.cuGame = acubeGame;
        this.cubeCenter = new Apoint(0.5 * (double)n, 0.5 * (double)n, 0.5 * (double)n);
        Apoint apoint = new Apoint(this.cubeCenter);
        apoint.times(150.0);
        this.a322d = new A322d(apoint, 150);
        this.a322d0 = new A322d(apoint, 150);
        this.a322d.perspective = true;
        this.a322d0.perspective = true;
        this.cube = new AcubeLet[this.nDIM3];
        int n2 = 0;
        while (n2 < this.nDIM3) {
            this.cube[n2] = new AcubeLet(n2, this.nDIM);
            ++n2;
        }
        this.cell = new int[this.nDIM3];
        this.cubeInit(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.cubeFrame = new AcubeFrame(this.nDIM);
        this.mSliceCubeId = new int[this.nDIM3];
        this.mSliceCubeId0 = new int[this.nDIM3];
        this.forceReDraw = false;
        this.setCState(0);
        this.canvasBackground = cubeApp.cubeBackground;
        this.colorArr[0] = Color.red;
        this.cName[0] = "red";
        this.colorArr[1] = new Color(255, 160, 0);
        this.cName[1] = "orange";
        this.colorArr[2] = Color.white;
        this.cName[2] = "white";
        this.colorArr[3] = Color.blue;
        this.cName[3] = "blue";
        this.colorArr[4] = Color.yellow;
        this.cName[4] = "yellow";
        this.colorArr[5] = Color.green.darker();
        this.cName[5] = "green";
        this.colorArr[6] = Color.black;
        this.cName[6] = "black";
        this.colorArr[7] = Color.gray;
        this.cName[6] = "gray";
    }

    public synchronized void animateTrick(int n) {
        if (n == 1) {
            this.cuGame.setGameState(2);
            this.setCState(4);
            this.savePrevState();
            this.mSliceCubeTurn = this.mTrickOp.nextTurn(0);
            this.setmSliceCubeId();
            this.drawSubCube0();
            return;
        }
        if (n != 2) {
            return;
        }
        int n2 = this.mSliceCubeTurn.incrDeg(this.cuGame.NframePerTurn);
        Graphics graphics = this.getGraphics();
        if (n2 > 0) {
            this.offgraphics.drawImage(this.animateScreen, 0, 0, null);
            this.a322d.setRotationMatrix(this.mSliceCubeTurn.turnAxis, -this.mSliceCubeTurn.clockwise * n2);
            this.drawSubCube(this.offgraphics);
            graphics.drawImage(this.offscreen, 0, 0, null);
        } else {
            this.restorePrevState();
            this.logicalSliceOp();
            this.mSliceCubeTurn = this.mTrickOp.nextTurn(1);
            if (this.mSliceCubeTurn == null) {
                this.cuGame.setGameState(0);
                this.setCState(0);
                this.forceReDraw = true;
                this.repaint();
                this.cuGame.setAnimateThread(false);
            } else {
                this.savePrevState();
                this.setmSliceCubeId();
                this.drawSubCube0();
            }
        }
    }

    private void cubeInit(boolean bl) {
        this.a322d.setRotationMatrix(0, 30, 20);
        this.a322d0.setRotationMatrix(0, 30, 20);
        int n = 0;
        while (n < this.nDIM) {
            int n2 = 0;
            while (n2 < this.nDIM) {
                int n3 = 0;
                while (n3 < this.nDIM) {
                    int n4 = n * this.nDIM2 + n2 * this.nDIM + n3;
                    this.cube[n4].cubeLetInit((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, bl);
                    this.cell[n4] = n4;
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void displayVCINFO() {
        Graphics graphics = this.getGraphics();
        Font font = new Font("Bookman Old Style", 0, 9);
        graphics.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.getHeight() + 2;
        int n2 = 5;
        int n3 = n;
        graphics.setColor(this.canvasBackground);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(Color.black);
        graphics.drawString(cubeApp.VCNAME, n2, n3);
        graphics.drawString(String.valueOf(cubeApp.VCVERSION) + "; " + cubeApp.VCDATE, n2, n3 + n);
        graphics.drawString(cubeApp.VCEMAIL, n2, n3 + n * 2);
    }

    void drawCube() {
        int n;
        Serializable serializable;
        Dimension dimension = this.getSize();
        if (this.offscreen == null || dimension.width != this.offscreensize.width || dimension.height != this.offscreensize.height) {
            serializable = new Rectangle(dimension.width, dimension.height);
            n = this.nDIM * 2;
            Rectangle rectangle = new Rectangle(n, n);
            int n2 = Math.min(dimension.width, dimension.height);
            Point point = new Point((int)((double)dimension.width * 0.5), (int)((double)dimension.height * 0.5));
            this.a322d.setScreen((Rectangle)serializable, rectangle, point);
            this.a322d0.setScreen((Rectangle)serializable, rectangle, point);
            this.offscreensize = dimension;
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.offgraphics = this.offscreen.getGraphics();
        }
        this.offgraphics.setColor(this.canvasBackground);
        this.offgraphics.fillRect(0, 0, dimension.width, dimension.height);
        serializable = Color.darkGray;
        if (this.cState == 0) {
            this.cubeFrame.drawCubeFaces(this.offgraphics, this.a322d0, (Color)serializable);
        } else {
            this.cubeFrame.drawCubeFaces(this.offgraphics, this.a322d, (Color)serializable);
        }
        int n3 = 0;
        while (n3 < this.nDIM3) {
            n = 0;
            while (n < 6) {
                if (this.cube[n3].face[n].colorcode != 6) {
                    this.drawFace3D(this.offgraphics, this.cube[n3].face[n], n3, true);
                }
                ++n;
            }
            ++n3;
        }
    }

    private boolean drawFace3D(Graphics graphics, Aface aface, int n, boolean bl) {
        if (aface.colorcode == 6) {
            return false;
        }
        Avec avec = this.a322d.rotateVec(aface.normal);
        if (Avec.VecDot(avec, g.vK) <= 0.0) {
            return false;
        }
        int n2 = 4;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        aface.setVertice(0.9);
        int n3 = 0;
        while (n3 < n2) {
            Apoint apoint = new Apoint(aface.vertice[n3]);
            apoint.times(150.0);
            Point point = this.a322d.map3Dto2Dscreen(apoint);
            nArray[n3] = point.x;
            nArray2[n3] = point.y;
            ++n3;
        }
        Color color = this.colorArr[aface.colorcode];
        graphics.setColor(color);
        graphics.fillPolygon(nArray, nArray2, n2);
        graphics.setColor(Color.black);
        if (bl) {
            graphics.drawPolygon(nArray, nArray2, n2);
            graphics.drawLine(nArray[n2 - 1], nArray2[n2 - 1], nArray[0], nArray2[0]);
        }
        return true;
    }

    void drawSubCube(Graphics graphics) {
        int n = 0;
        while (n < this.mSliceCubeIdLen) {
            int n2 = this.mSliceCubeId[n];
            int n3 = 0;
            while (n3 < 6) {
                if (this.cube[n2].face[n3].colorcode != 6) {
                    this.drawFace3D(graphics, this.cube[n2].face[n3], n2, true);
                }
                ++n3;
            }
            ++n;
        }
    }

    void drawSubCube0() {
        Dimension dimension = this.getSize();
        if (this.animateScreen == null || !this.animateScreenSize.equals(dimension)) {
            this.animateScreenSize = dimension;
            this.animateScreen = this.createImage(dimension.width, dimension.height);
            this.animateGraphics = this.animateScreen.getGraphics();
        }
        this.animateGraphics.setColor(this.canvasBackground);
        this.animateGraphics.fillRect(0, 0, dimension.width, dimension.height);
        int n = 0;
        while (n < this.mSliceCubeId0Len) {
            int n2 = this.mSliceCubeId0[n];
            int n3 = 0;
            while (n3 < 6) {
                if (this.cube[n2].face[n3].colorcode != 6) {
                    try {
                        this.drawFace3D(this.animateGraphics, this.cube[n2].face[n3], n2, true);
                    }
                    catch (Exception exception) {}
                }
                ++n3;
            }
            ++n;
        }
    }

    private void logicalSliceOp() {
        int n;
        Apoint apoint;
        Amatx amatx = new Amatx();
        double d = this.mSliceCubeTurn.turnAxis.getMultipleOf(g.vI);
        if (d != 0.0) {
            apoint = new Apoint(0.0, (double)this.nDIM * 0.5, (double)this.nDIM * 0.5);
            if (d > 0.0) {
                amatx.set(g.X);
            } else {
                amatx.set(g.X_1);
            }
        } else {
            d = this.mSliceCubeTurn.turnAxis.getMultipleOf(g.vJ);
            if (d != 0.0) {
                apoint = new Apoint((double)this.nDIM * 0.5, 0.0, (double)this.nDIM * 0.5);
                if (d > 0.0) {
                    amatx.set(g.Y);
                } else {
                    amatx.set(g.Y_1);
                }
            } else {
                d = this.mSliceCubeTurn.turnAxis.getMultipleOf(g.vK);
                apoint = new Apoint((double)this.nDIM * 0.5, (double)this.nDIM * 0.5, 0.0);
                if (d > 0.0) {
                    amatx.set(g.Z);
                } else {
                    amatx.set(g.Z_1);
                }
            }
        }
        if (this.mSliceCubeTurn.NqTurn > 1) {
            n = 2;
            while (n <= this.mSliceCubeTurn.NqTurn) {
                amatx.square();
                ++n;
            }
        }
        int n2 = 0;
        while (n2 < this.mSliceCubeIdLen) {
            n = this.cube[this.mSliceCubeId[n2]].cellId();
            int n3 = this.cube[this.mSliceCubeId[n2]].transform(apoint, amatx);
            this.cell[n3] = this.mSliceCubeId[n2];
            ++n2;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public synchronized void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.mState = 1;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.mState = 0;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.painted = false;
        if (this.offscreen == null || dimension.width != this.offscreensize.width || dimension.height != this.offscreensize.height || this.forceReDraw) {
            this.drawCube();
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
        this.setPainted();
    }

    public boolean performTrick(AcubeOp acubeOp, int n) {
        this.mTrickOp = acubeOp;
        this.mTrickNrepeat = n;
        this.animateTrick(1);
        return true;
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.mState != 1) {
            return;
        }
        Point point = mouseEvent.getPoint();
        Dimension dimension = this.getSize();
        if (point.x >= dimension.width) {
            this.displayVCINFO();
        }
    }

    private void resetAllStates() {
        this.setCState(0);
        this.cuGame.setGameState(0);
    }

    public void resetCube() {
        this.cubeInit(true);
        this.resetAllStates();
        this.forceReDraw = true;
        this.repaint();
    }

    private void restorePrevState() {
        this.a322d.setRotationMatrix(this.prevMatrix);
    }

    private void savePrevState() {
        this.prevMatrix.set(this.a322d.getMatrix());
    }

    private void setCState(int n) {
        this.cState = n;
    }

    private synchronized void setPainted() {
        this.painted = true;
        this.forceReDraw = false;
        this.notifyAll();
    }

    private void setmSliceCubeId() {
        int n = 0;
        int n2 = 0;
        int n3 = this.mSliceCubeTurn.slice0N;
        int n4 = this.mSliceCubeTurn.slice0N + this.mSliceCubeTurn.Nslice;
        if (this.mSliceCubeTurn.turnAxis.getMultipleOf(g.vI) != 0.0) {
            int n5 = 0;
            while (n5 < this.nDIM) {
                int n6 = 0;
                while (n6 < this.nDIM) {
                    int n7 = 0;
                    while (n7 < this.nDIM) {
                        int n8 = n5 * this.nDIM2 + n6 * this.nDIM + n7;
                        if (n5 >= n3 && n5 < n4) {
                            this.mSliceCubeId[n++] = this.cell[n8];
                        } else {
                            this.mSliceCubeId0[n2++] = this.cell[n8];
                        }
                        ++n7;
                    }
                    ++n6;
                }
                ++n5;
            }
        } else if (this.mSliceCubeTurn.turnAxis.getMultipleOf(g.vJ) != 0.0) {
            int n9 = 0;
            while (n9 < this.nDIM) {
                int n10 = 0;
                while (n10 < this.nDIM) {
                    int n11 = 0;
                    while (n11 < this.nDIM) {
                        int n12 = n10 * this.nDIM2 + n9 * this.nDIM + n11;
                        if (n9 >= n3 && n9 < n4) {
                            this.mSliceCubeId[n++] = this.cell[n12];
                        } else {
                            this.mSliceCubeId0[n2++] = this.cell[n12];
                        }
                        ++n11;
                    }
                    ++n10;
                }
                ++n9;
            }
        } else {
            int n13 = 0;
            while (n13 < this.nDIM) {
                int n14 = 0;
                while (n14 < this.nDIM) {
                    int n15 = 0;
                    while (n15 < this.nDIM) {
                        int n16 = n14 * this.nDIM2 + n15 * this.nDIM + n13;
                        if (n13 >= n3 && n13 < n4) {
                            this.mSliceCubeId[n++] = this.cell[n16];
                        } else {
                            this.mSliceCubeId0[n2++] = this.cell[n16];
                        }
                        ++n15;
                    }
                    ++n14;
                }
                ++n13;
            }
        }
        this.mSliceCubeIdLen = n;
        this.mSliceCubeId0Len = n2;
    }

    public void update(Graphics graphics) {
        if (this.painted) {
            System.gc();
            this.paint(graphics);
        }
    }
}

