/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;

public class movingBanner
extends Canvas
implements Runnable,
Serializable,
MouseListener {
    static final Color colorFG = Color.black;
    private Container parent;
    private String[] bannerStr = new String[4];
    private int bannerStrIx;
    private String trailerStr;
    private Font bannerFont;
    public int sleepMs;
    public int nPixPerSec;
    private int waveCycles;
    public double waveAmplitude;
    private double waveAmplitudeIncr = 0.1;
    public double waveFactor;
    private transient int viewPaneSize;
    private transient char[] bannerChars;
    private transient long prevMs;
    private transient Thread bannerRunner = null;
    private transient int threadState;
    static final int SUSPEND = 0;
    static final int RUN = 1;
    private transient int posCurr;
    private transient int posLeft;
    private transient int posRight;
    private transient int bannerW;
    private transient int bannerH;
    private transient int charHeight;
    private transient String bStr;
    private transient int charWidth;
    private transient Image offscreen;

    public movingBanner(Container container) {
        this("this is a test", new Font("TimesRoman", 2, 8), container);
    }

    public movingBanner(String string, Font font, Container container) {
        this.parent = container;
        this.bannerStr[0] = "";
        this.bannerStr[1] = string;
        this.bannerStrIx = 1;
        this.bannerFont = font != null ? font : new Font("TimesRoman", 2, 8);
        this.offscreen = null;
        this.setDefault();
        this.setTransient();
        this.addMouseListener(this);
    }

    public void addBannerStr(String string) {
        int n = 0;
        while (n < this.bannerStr.length) {
            if (this.bannerStr[n] == null) break;
            ++n;
        }
        if (n < this.bannerStr.length) {
            this.bannerStr[n] = string;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.bannerW, this.bannerH);
    }

    public void init() {
        this.setFont(this.bannerFont);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        ++this.bannerStrIx;
        if (this.bannerStrIx >= this.bannerStr.length || this.bannerStr[this.bannerStrIx] == null) {
            this.bannerStrIx = 0;
        }
        this.setTransient();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.parent.getSize();
        if (this.offscreen == null || this.viewPaneSize != dimension.width) {
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.viewPaneSize = dimension.width;
            this.setTransient();
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        graphics2.setColor(colorFG);
        if (this.bannerStr[this.bannerStrIx].length() == 0) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            this.stop();
            this.parent.remove(this);
            this.parent.validate();
            this.parent.repaint();
            return;
        }
        int n = this.bannerH * 6 / 10;
        this.waveFactor = Math.random();
        if (Math.abs(this.posCurr) % this.viewPaneSize <= (int)((double)this.viewPaneSize * this.waveFactor)) {
            this.waveAmplitude += this.waveAmplitudeIncr;
            if (this.waveAmplitude <= 0.0) {
                this.waveAmplitude = this.waveAmplitudeIncr = Math.abs(this.waveAmplitudeIncr);
            }
            if (this.waveAmplitude >= 1.0) {
                this.waveAmplitudeIncr = -Math.abs(this.waveAmplitudeIncr);
                this.waveAmplitude = 1.0 + this.waveAmplitudeIncr;
            }
        }
        int n2 = this.bannerChars.length + this.viewPaneSize / this.charWidth;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.posCurr + n3 * this.charWidth;
            if (n4 >= 0) {
                if (n4 > this.viewPaneSize) break;
                double d = Math.sin((double)n4 / (double)this.viewPaneSize * 2.0 * Math.PI * (double)this.waveCycles);
                int n5 = (int)((double)n + this.waveAmplitude * (double)this.charHeight * d);
                graphics2.drawChars(this.bannerChars, n3 % this.bannerChars.length, 1, n4, n5);
            }
            ++n3;
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
        int n6 = (int)(System.currentTimeMillis() - this.prevMs);
        this.posCurr -= this.nPixPerSec * n6 / 1000;
        this.prevMs += (long)n6;
        if (this.posCurr <= this.posLeft) {
            this.posCurr = this.posRight;
        }
    }

    public void run() {
        this.prevMs = System.currentTimeMillis();
        g.dbg(2, "movingBanner.run: threadState=" + this.threadState + ";bannerRunner=" + this.bannerRunner);
        while (this.bannerRunner != null) {
            if (this.threadState == 0) {
                g.dbg(2, "---------------movingBanner.run: threadState=" + this.threadState + ";bannerRunner=" + this.bannerRunner);
                try {
                    movingBanner movingBanner2 = this;
                    synchronized (movingBanner2) {
                        while (this.threadState == 0) {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                Thread.sleep(this.sleepMs);
            }
            catch (InterruptedException interruptedException) {}
            this.repaint();
        }
    }

    private void setDefault() {
        this.trailerStr = "......";
        this.sleepMs = 50;
        this.waveCycles = 3;
        this.nPixPerSec = 60;
        this.waveAmplitude = 0.6;
        this.waveFactor = 0.4;
    }

    public synchronized void setThreadState(int n) {
        this.threadState = n;
        this.notify();
    }

    public void setTransient() {
        this.bStr = String.valueOf(this.trailerStr) + this.bannerStr[this.bannerStrIx] + this.trailerStr;
        this.bStr = this.bStr.replace('\n', '.');
        this.bStr = this.bStr.replace('\t', '.');
        this.bannerChars = this.bStr.toCharArray();
        FontMetrics fontMetrics = this.getFontMetrics(this.bannerFont);
        this.charHeight = fontMetrics.getHeight();
        this.charWidth = fontMetrics.charWidth('m');
        this.bannerW = this.charWidth * this.bannerChars.length;
        this.bannerH = this.charHeight * 3;
        this.posCurr = 0;
        this.posLeft = -this.bannerW;
        this.posRight = 0;
    }

    public void start() {
        if (this.bannerRunner == null) {
            g.dbg(2, "movingBanner.start: bannerRunner=null");
            this.bannerRunner = new Thread(this);
            this.bannerRunner.start();
        } else {
            this.setTransient();
            this.setThreadState(1);
            g.dbg(2, "movingBanner.start: threadState=" + this.threadState + ";bannerRunner=" + this.bannerRunner);
        }
    }

    public synchronized void stop() {
        this.bannerRunner = null;
    }
}

