/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;

public class cubeApp
extends JApplet
implements ChangeListener,
ComponentListener {
    static String VCNAME = "VirtualCube";
    static String VCVERSION = "v2.00";
    static String VCGAN = "GAN Software";
    static String VCDATE = "March, 2000";
    static String VCAUTHOR = "Cheong Gan";
    static String VCEMAIL = "cheong.gan@home.com";
    static String VCBANNER = "This version of " + VCNAME + " " + VCVERSION + "....is a freeware brought to you...." + "by " + VCGAN + "....Please send no money....You may freely " + "redistribute this freeware....'as is without modifications'....";
    static String VCBANNER1 = "....................Knock-knock....Who's there....Yoda!....Yoda who?....Yoda the one for me!....Got'ya....";
    static String VCINFO = "\n\t" + VCNAME + " " + VCVERSION + " by " + VCGAN + "\n\n" + "\tDate\t: " + VCDATE + "\n" + "\tAuthor\t: " + VCAUTHOR + "\n" + "\tEmail\t: " + VCEMAIL + "\n" + "\n" + "\tYou are free to distribute this version of " + VCNAME + "\n" + "\t'as is without modification'.  Please forward bug report,\n" + "\tsuggestion  and comment to the author.";
    AcubeGame[] cuGame = new AcubeGame[3];
    JTabbedPane tabbedPane;
    JScrollPane[] vcInfoScroller;
    String[] vcFname = new String[]{"html/vcquick.htm", "html/vcreg.htm"};
    int Ngame = 1;
    int Ndim = 3;
    static boolean inApplet = true;
    static int mainNdim;
    static long mainRandomSeed;
    static boolean mainScramble;
    static boolean freeware;
    boolean playAudio = true;

    static {
        mainRandomSeed = 0L;
        mainScramble = false;
        freeware = true;
    }

    public cubeApp() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void auPlay(String string) {
    }

    public void auPlay1(String string) {
        if (!this.playAudio) {
            return;
        }
        URL uRL = this.getClass().getResource(string);
        g.dbg(9, "cubeApp.auPlay: audioURL=" + uRL);
        if (inApplet) {
            g.dbg(9, "cubeApp.auPlay: audioURL=" + uRL);
            this.play(uRL);
        } else {
            AudioStream audioStream = null;
            try {
                audioStream = new AudioStream(uRL.openStream());
            }
            catch (IOException iOException) {}
            g.dbg(9, "cubeApp.auPlay: AudioStream=" + audioStream);
            AudioPlayer.player.start((InputStream)audioStream);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        g.dbg(2, "cubeApp.componentResized, size=" + this.getSize());
        int n = 0;
        while (n < this.Ngame) {
            this.cuGame[n].resize();
            ++n;
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public String getAppletInfo() {
        return VCINFO;
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Ndim", "numeric string", "specifies Ndim x Ndim x Ndim cube"}};
        return stringArray;
    }

    private JEditorPane get_vcFname(int n) {
        JEditorPane jEditorPane = new JEditorPane();
        String string = this.vcFname[n];
        jEditorPane.setEditable(false);
        jEditorPane.setContentType("text/html");
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        try {
            g.dbg(2, "cubeApp.init: inStream2 file found: " + string);
            jEditorPane.read(inputStream, (Object)null);
            g.dbg(2, "cubeApp.init: inStream2 read: " + inputStream);
        }
        catch (Exception exception) {
            jEditorPane.setText(VCINFO);
            g.dbg(2, "cubeApp.init: inStream2 read error: " + inputStream);
        }
        return jEditorPane;
    }

    public void init() {
        int n;
        Dimension dimension = this.getSize();
        g.dbg(9, "cubeApp.init:" + dimension);
        if (inApplet) {
            try {
                this.Ndim = Integer.parseInt(this.getParameter("Ndim"));
            }
            catch (Exception exception) {
                this.Ndim = -1;
            }
        } else {
            this.Ndim = mainNdim;
        }
        this.Ngame = this.Ndim == -1 ? 3 : 1;
        if (freeware) {
            this.Ndim = -1;
            this.Ngame = 3;
        }
        if (this.Ngame > 3) {
            this.Ngame = 3;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1));
        this.tabbedPane = new JTabbedPane(1);
        int n2 = 0;
        while (n2 < this.Ngame) {
            n = 2 + n2;
            if (this.Ngame == 1) {
                n = this.Ndim;
            }
            this.cuGame[n2] = new AcubeGame(n, this);
            this.tabbedPane.insertTab(n + "x" + n + "x" + n, null, this.cuGame[n2], null, n2);
            ++n2;
        }
        n = 2;
        JEditorPane[] jEditorPaneArray = new JEditorPane[n];
        this.vcInfoScroller = new JScrollPane[n];
        String[] stringArray = new String[]{"QuickStart", "Registration"};
        int n3 = 0;
        while (n3 < n) {
            jEditorPaneArray[n3] = this.get_vcFname(n3);
            this.vcInfoScroller[n3] = new JScrollPane(jEditorPaneArray[n3]);
            this.tabbedPane.insertTab(stringArray[n3], null, this.vcInfoScroller[n3], null, n2 + n3);
            ++n3;
        }
        this.tabbedPane.setOpaque(true);
        jPanel.add(this.tabbedPane);
        this.setContentPane(jPanel);
    }

    private void jbInit() throws Exception {
    }

    public static void main(String[] stringArray) {
        inApplet = false;
        cubeApp cubeApp2 = new cubeApp();
        try {
            Object object;
            if (stringArray[0].equals("dump")) {
                object = new AcubeOpImport("cubeOp.imp");
                ((AcubeOpImport)object).dumpStrOpFromFile();
                System.exit(0);
            }
            if (stringArray[0].equals("info")) {
                object = cubeApp2.getAppletInfo();
                System.out.println((String)object);
                System.exit(0);
            }
            mainNdim = Integer.parseInt(stringArray[0]);
        }
        catch (Exception exception) {
            mainNdim = -1;
        }
        try {
            int n = stringArray[1].indexOf("random=");
            g.dbg(2, "main: args[1]=" + stringArray[1] + ";i=" + n);
            if (n >= 0) {
                mainRandomSeed = Integer.parseInt(stringArray[1].substring(7));
                g.dbg(2, "main: mainRandomSeed=" + mainRandomSeed);
            }
        }
        catch (Exception exception) {}
        g.dbg(0, "main: 110: myApp=" + cubeApp2);
        mainFrame mainFrame2 = new mainFrame(VCNAME);
        g.dbg(0, "main: 110: myFrame=" + mainFrame2);
        ((Component)mainFrame2).setSize(600, 450);
        mainFrame2.getContentPane().add("Center", cubeApp2);
        cubeApp2.init();
        cubeApp2.start();
        mainFrame2.show();
    }

    public void start() {
        g.dbg(9, "cubeApp.start");
        int n = 0;
        while (n < this.Ngame) {
            this.cuGame[n].init();
            this.cuGame[n].start();
            ++n;
        }
        if (this.tabbedPane != null) {
            this.tabbedPane.setSelectedIndex(1);
        }
        this.repaint();
        this.tabbedPane.addChangeListener(this);
        this.addComponentListener(this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.tabbedPane.getSelectedIndex();
        g.dbg(2, "cubeApp.stateChanged: j=" + n);
        int n2 = 0;
        while (n2 < this.Ngame) {
            if (n2 != n) {
                this.cuGame[n2].banner1.setThreadState(0);
                this.cuGame[n2].setThreadState(2);
                this.cuGame[n2].revalidate();
            }
            ++n2;
        }
        if (n < this.Ngame) {
            this.cuGame[n].setThreadState(1);
            this.cuGame[n].banner1.setThreadState(1);
            this.cuGame[n].revalidate();
        } else if (n == this.Ngame) {
            Dimension dimension = this.getSize();
            g.dbg(2, "cubeApp.stateChanged: getSize=" + dimension);
            Graphics graphics = ((Component)this).getGraphics();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        this.repaint();
    }
}

