/*
 * Decompiled with CFR 0.152.
 */
class AfaceInfo {
    private AcubeLet[] cube;
    private int[] cell;
    private int nDIM;
    private int nDIM_1;
    private int nDIM2;
    public int Nedge_good;
    public int Nedge_T1;
    public int Nedge_nonT1;
    AcolorPair[][] faceEdgeCP;
    int[] faceEdgeFlag = new int[4];
    static final int EDGE_NONT1 = 1;
    static final int EDGE_T1 = 2;
    static final int EDGE_GOOD = 8;
    int centerColorcode;
    int NgoodCorners;
    int NoppEdge;
    int NwrongEdge;
    int targetEdge;
    AcolorPair socketCP;
    private int faceId;
    private int[][] cubeId;
    int[][] faceColorcode;
    static final int[][] sliceSide;
    static final int CONFIG4CORNERS = 4;
    static final int CONFIGSTAR = 8;

    static {
        int[][] nArrayArray = new int[6][];
        nArrayArray[0] = new int[]{2, 3, 4, 5};
        nArrayArray[1] = new int[]{2, 3, 4, 5};
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 5;
        nArrayArray[2] = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[2] = 4;
        nArray2[3] = 5;
        nArrayArray[3] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 3;
        nArrayArray[4] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[1] = 1;
        nArray4[2] = 2;
        nArray4[3] = 3;
        nArrayArray[5] = nArray4;
        sliceSide = nArrayArray;
    }

    AfaceInfo(AcubeLet[] acubeLetArray, int[] nArray, int n, int n2) {
        this.cube = acubeLetArray;
        this.cell = nArray;
        this.faceId = n;
        this.nDIM = n2;
        this.nDIM2 = this.nDIM * this.nDIM;
        this.nDIM_1 = this.nDIM - 1;
        this.cubeId = new int[this.nDIM][this.nDIM];
        this.centerColorcode = 6;
        this.faceColorcode = new int[this.nDIM][this.nDIM];
        this.faceEdgeCP = new AcolorPair[4][this.nDIM];
        int n3 = 0;
        while (n3 < 4) {
            int n4 = 0;
            while (n4 < this.nDIM) {
                this.faceEdgeCP[n3][n4] = new AcolorPair();
                ++n4;
            }
            ++n3;
        }
    }

    private void flagGood(int n) {
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < this.nDIM) {
                AcolorPair acolorPair = this.faceEdgeCP[n2][n3];
                if (acolorPair.cubeid == n) {
                    acolorPair.flag = 1;
                    g.dbg(0, "AfaceInfo.flagGood: top/side colors=" + acolorPair.topColor + "/" + acolorPair.sideColor + ";cubeid=" + n);
                }
                ++n3;
            }
            ++n2;
        }
    }

    int getFaceConfig() {
        int n = this.faceEdgeCP[0][0].topColor;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            int n4 = 0;
            while (n4 < this.nDIM) {
                AcolorPair acolorPair = this.faceEdgeCP[n3][n4];
                if (acolorPair.flag != 1 || acolorPair.topColor != n) {
                    n = 6;
                    break;
                }
                n4 += this.nDIM_1;
            }
            ++n3;
        }
        if (n != 6) {
            n2 |= 4;
            if (this.centerColorcode == n) {
                n2 |= 8;
            }
        }
        return n2;
    }

    public int goodFaceColorcode(boolean bl) {
        int n = 6;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < this.nDIM) {
                AcolorPair acolorPair = this.faceEdgeCP[n2][n3];
                if (acolorPair.flag == 1) {
                    n = acolorPair.topColor;
                    break;
                }
                n3 += this.nDIM_1;
            }
            ++n2;
        }
        if (n == 6 && !bl) {
            g.abort("AfaceInfo[" + this.faceId + "]: goodFaceColorcode=" + n);
        }
        return n;
    }

    AcolorPair locateCP(int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < 4) {
            int n5 = 0;
            while (n5 < this.nDIM) {
                AcolorPair acolorPair = this.faceEdgeCP[n4][n5];
                if (acolorPair.cubeid == n3 && acolorPair.topColor == n && acolorPair.sideColor == n2) {
                    g.dbg(0, "AfaceInfo.locateCP: found top/side colors=" + n + "/" + n2 + ";cubeid=" + n3 + acolorPair);
                    return acolorPair;
                }
                ++n5;
            }
            ++n4;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    AcolorPair locateSocket(AcolorPair acolorPair, int n) {
        int n2 = -1;
        int n3 = -1;
        AcolorPair acolorPair2 = null;
        g.dbg(0, "AfaceInfo::locateSocket: slice=" + this.faceId + "; cpStartSideIx=" + n + "; plugcp=" + acolorPair);
        if (acolorPair == null) {
            g.abort("locateSocket -10: null plugcp not allowed");
        }
        this.socketCP = null;
        int n4 = n;
        while (n4 < n + 4) {
            AcolorPair acolorPair3 = this.faceEdgeCP[n4 % 4][0];
            AcolorPair acolorPair4 = this.faceEdgeCP[n4 % 4][1];
            AcolorPair acolorPair5 = this.faceEdgeCP[n4 % 4][this.nDIM_1];
            if (acolorPair3.isIdenticalColor(acolorPair) || acolorPair5.isIdenticalColor(acolorPair)) {
                if (!acolorPair4.isSameColor(acolorPair)) {
                    this.socketCP = this.faceEdgeCP[n4 % 4][1];
                    g.dbg(0, "AfaceInfo::locateSocket: found a mate socketCP=" + this.socketCP);
                    return this.socketCP;
                }
                g.dbg(2, "AfaceInfo::locateSocket: fcode=" + this.faceId + "; found & ignore reverse plug/socket:" + acolorPair + "/" + acolorPair4);
                acolorPair2 = acolorPair4;
            } else if (acolorPair4.flag != 1 && !acolorPair4.isIdenticalColor(acolorPair3)) {
                if (acolorPair4.isSameColor(acolorPair)) {
                    n3 = n4;
                } else {
                    n2 = n4;
                }
            }
            ++n4;
        }
        if (n2 >= 0) {
            g.dbg(2, "AfaceInfo::locateSocke faceId=" + this.goodFaceColorcode(false) + "; found a non-mating socketCP=" + this.faceEdgeCP[n2 % 4][1]);
            return this.faceEdgeCP[n2 % 4][1];
        }
        if (n3 >= 0) {
            g.dbg(0, "AfaceInfo::locateSocket: found a reverse socketCP=" + this.faceEdgeCP[n3 % 4][1]);
            return this.faceEdgeCP[n3 % 4][1];
        }
        if (acolorPair2 != null) {
            g.dbg(2, "-----AfaceInfo::locateSocket:faceId=" + this.faceId + ": only found a quark=" + acolorPair2);
            return null;
        }
        g.dbg(2, "-----AfaceInfo::locateSocket:faceId=" + this.faceId + ": found no socket/no bad/no reverse");
        return null;
    }

    private void markCorner() {
        int[] nArray = new int[8];
        int n = 6;
        int[] nArray2 = new int[4];
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            AcolorPair acolorPair = this.faceEdgeCP[n3][0];
            AcolorPair acolorPair2 = this.faceEdgeCP[n3][this.nDIM_1];
            if (acolorPair.isIdenticalColor(acolorPair2) && (n == 6 || acolorPair.topColor == n)) {
                n = acolorPair.topColor;
                nArray[n2++] = acolorPair.cubeid;
                nArray[n2++] = acolorPair2.cubeid;
            }
            ++n3;
        }
        this.NgoodCorners = n2 <= 2 ? n2 : (n2 == 8 ? 4 : (n2 == 4 ? 3 : 0));
        int n4 = this.faceColorcode[1][1];
        if (n4 == 6) {
            g.abort("AfaceInfo::markCorner -20: fsa=" + this.faceId + "11 is black");
        }
        this.centerColorcode = n4;
        int n5 = 1;
        while (n5 <= this.nDIM - 2) {
            int n6 = 1;
            while (n6 <= this.nDIM - 2) {
                if (this.faceColorcode[n5][n6] != n4) {
                    this.centerColorcode = 6;
                    break;
                }
                ++n6;
            }
            ++n5;
        }
        int n7 = 0;
        while (n7 < n2) {
            this.flagGood(nArray[n7]);
            ++n7;
        }
    }

    private void markEdge() {
        this.Nedge_nonT1 = 0;
        this.Nedge_good = 0;
        this.Nedge_T1 = 0;
        int n = 0;
        while (n < 4) {
            AcolorPair acolorPair = this.faceEdgeCP[n][0];
            AcolorPair acolorPair2 = this.faceEdgeCP[n][this.nDIM_1];
            boolean bl = acolorPair.isIdenticalColor(acolorPair2);
            acolorPair2 = this.faceEdgeCP[n][1];
            this.faceEdgeFlag[n] = 2;
            int n2 = 2;
            while (n2 <= this.nDIM - 2) {
                AcolorPair acolorPair3 = this.faceEdgeCP[n][n2];
                if (!acolorPair3.isIdenticalColor(acolorPair2)) {
                    this.faceEdgeFlag[n] = 1;
                    break;
                }
                ++n2;
            }
            if (this.faceEdgeFlag[n] == 2 && bl && acolorPair2.isIdenticalColor(acolorPair)) {
                this.faceEdgeFlag[n] = 8;
            }
            if (this.faceEdgeFlag[n] == 2) {
                ++this.Nedge_T1;
            } else if (this.faceEdgeFlag[n] == 8) {
                ++this.Nedge_good;
            } else {
                ++this.Nedge_nonT1;
            }
            ++n;
        }
        if (this.Nedge_T1 + this.Nedge_good + this.Nedge_nonT1 != 4) {
            g.abort("AfaceInfo.markEdge -10: bad,T1,good=" + this.Nedge_nonT1 + this.Nedge_T1 + this.Nedge_good);
        }
    }

    void setInfo() {
        int n;
        int n2;
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.nDIM) {
            n2 = 0;
            while (n2 < this.nDIM) {
                int n4 = this.faceId == 0 || this.faceId == 1 ? this.faceId * this.nDIM_1 * this.nDIM2 + n3 * this.nDIM + n2 : (this.faceId == 2 || this.faceId == 3 ? n3 * this.nDIM2 + (this.faceId - 2) * this.nDIM_1 * this.nDIM + n2 : n3 * this.nDIM2 + n2 * this.nDIM + (this.faceId - 4) * this.nDIM_1);
                this.cubeId[n3][n2] = n = this.cell[n4];
                this.faceColorcode[n3][n2] = this.cube[n].getColorcode(this.faceId);
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < 4) {
            int n5 = 0;
            while (n5 < this.nDIM) {
                n = n2 == 0 || n2 == 1 ? this.cubeId[n2 * this.nDIM_1][n5] : this.cubeId[n5][(n2 - 2) * this.nDIM_1];
                int n6 = this.cube[n].getColorcode(this.faceId);
                int n7 = this.cube[n].getColorcode(sliceSide[this.faceId][n2]);
                this.faceEdgeCP[n2][n5].init(n6, n7, n, this.nDIM);
                this.faceEdgeCP[n2][n5].topNormal = this.cube[n].getFaceNormal(n6);
                this.faceEdgeCP[n2][n5].sideNormal = this.cube[n].getFaceNormal(n7);
                g.dbg(0, "AfaceInfo: faceEdgeCP[" + n2 + "][" + n5 + "]=" + this.faceEdgeCP[n2][n5].toString());
                ++n5;
            }
            ++n2;
        }
        this.markCorner();
        this.markEdge();
    }

    int setNoppositeEdge(int n) {
        int n2 = -1;
        int n3 = -1;
        this.NoppEdge = 0;
        this.NwrongEdge = 0;
        this.targetEdge = -1;
        if (this.Nedge_good == 4) {
            return this.NwrongEdge;
        }
        int n4 = 0;
        while (n4 < 4) {
            if (this.faceEdgeFlag[n4] != 1) {
                AcolorPair acolorPair = this.faceEdgeCP[n4][1];
                if (acolorPair.topColor == n) {
                    ++this.NoppEdge;
                    n2 = AcubeInfo.encodeEdge(this.faceId, n4, 0);
                } else if (!acolorPair.isIdenticalColor(this.faceEdgeCP[n4][0])) {
                    ++this.NwrongEdge;
                    n3 = AcubeInfo.encodeEdge(this.faceId, n4, 0);
                }
            }
            ++n4;
        }
        if (this.NoppEdge > 0) {
            this.targetEdge = n2;
        } else if (this.NwrongEdge > 0) {
            this.targetEdge = n3;
            if (this.faceId == 2 && !this.faceEdgeCP[1][1].isIdenticalColor(this.faceEdgeCP[1][0])) {
                this.targetEdge = AcubeInfo.encodeEdge(this.faceId, 1, 0);
            }
        }
        if (this.Nedge_nonT1 + this.Nedge_T1 != this.NoppEdge + this.NwrongEdge) {
            g.abort("setNopposite -50: AfaceInfo[" + this.faceId + "]: NoppEdge+NwrongEdge=" + this.NoppEdge + "+" + this.NwrongEdge + "!= Nedge_nonT1+Nedge_T1=" + this.Nedge_nonT1 + "+" + this.Nedge_T1);
        }
        g.dbg(2, "  setNoppositeEdge return: fsaOpp=" + n2 + ";fsaBad=" + n3 + "; NoppNwrong=" + this.NoppEdge + this.NwrongEdge);
        return this.NwrongEdge;
    }

    int setScore() {
        g.dbg(0, "AfaceInfo.setScore:");
        int n = 1;
        int n2 = 50;
        int n3 = 10;
        int n4 = 25;
        int n5 = 0;
        if (this.faceId == 3) {
            n5 += n;
        }
        int n6 = 0;
        while (n6 < 4) {
            int n7 = 0;
            while (n7 < this.nDIM) {
                AcolorPair acolorPair = this.faceEdgeCP[n6][n7];
                if (acolorPair.flag == 1) {
                    if (acolorPair.type == 3) {
                        n5 += n2;
                    } else if (acolorPair.type == 2) {
                        n5 += n3;
                    }
                }
                ++n7;
            }
            ++n6;
        }
        if (this.centerColorcode == this.goodFaceColorcode(true)) {
            n5 += n4;
        }
        return n5;
    }

    AcolorPair socketForTrick1Bot(AcolorPair acolorPair) {
        return this.locateSocket(acolorPair, 2);
    }

    AcolorPair socketForTrick1Top(AcolorPair acolorPair) {
        return this.locateSocket(acolorPair, 1);
    }
}

