/*
 * Decompiled with CFR 0.152.
 */
class AcubeInfo {
    private AcubeLet[] cube;
    private int[] cell;
    private int nDIM;
    private int nDIM_1;
    private int nDIM2;
    private AfaceInfo[] faceInfo;
    public int bestFaceId;
    public int NbadCorners;
    public int Nedge_good;
    public int Nedge_T1;
    public int Nedge_nonT1;
    public int starFaceColorcode = 6;
    public int[] cornerCellId = new int[8];
    int targetCellId;
    int targetStrIx;
    Avec targetNormal;
    static final int[] oppfaceId;
    public String preTrick3Move;
    public String postTrick3Move;
    public String preTrick2Move;
    public String postTrick2Move;
    public String preTrick2Rotate;
    public String postTrick2Rotate;
    public String opTurnStr;
    public String opRotateStr;
    private int f1Colorcode;
    private int f2Colorcode;
    public boolean bTrick3Move;
    public boolean bTrick2Move;
    static final Avec trick1botTopNormal;
    static final Avec trick1botSideNormal;
    static final Avec trick1topTopNormal;
    static final Avec trick1topSideNormal;
    static final Avec trick1bacTopNormal;
    static final Avec trick1bacSideNormal;
    AcolorPair trick1BotCP;
    AcolorPair trick1TopCP;
    AcolorPair trick1BacCP;
    AcolorPair trick1BotSocket;
    AcolorPair trick1TopSocket;
    AcolorPair trick1BacSocket;
    public String opTrick1Top;
    public String opPreTrick1;
    AcolorPair trick1cp2;
    static final int rcRepeat = 0;
    static final int rcDone = 1;
    static final int rcFIXEDGE = 11;
    static final int rcMAKET1EDGE = 12;
    static final int rcFIXCENTER = 13;
    static final int[] oppix;
    static final String[] targetStr;
    static final String[] newNormal;

    static {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[2] = 3;
        nArray[3] = 2;
        nArray[4] = 5;
        nArray[5] = 4;
        oppfaceId = nArray;
        trick1botTopNormal = new Avec(g.v_J);
        trick1botSideNormal = new Avec(g.vI);
        trick1topTopNormal = new Avec(g.vJ);
        trick1topSideNormal = new Avec(g.vI);
        trick1bacTopNormal = new Avec(g.v_I);
        trick1bacSideNormal = new Avec(g.v_J);
        int[] nArray2 = new int[6];
        nArray2[0] = 1;
        nArray2[2] = 3;
        nArray2[3] = 2;
        nArray2[4] = 5;
        nArray2[5] = 4;
        oppix = nArray2;
        targetStr = new String[]{"RN> B1<<RN< ", "RN> B1<<RN< ", "FN< B1<<FN> ", "RN< B1> RN> ", "RN< B1> RN> ", "F1< B1> F1< ", "FN< R1< FN> ", "", "RN> F1> RN< ", "R1<<", "FN> B1< FN< ", "FN> B1< FN< ", "B1>>", "B1>>", "B1>>", "B1> ", "B1> ", "B1> ", "", "", "", "B1< ", "B1< ", "B1< "};
        newNormal = new String[]{"i", "k", "k", "k", "i", "i", "i", "j", "k", "i", "k", "i", "i", "-j", "k", "k", "-j", "i", "i", "-j", "k", "k", "-j", "i"};
    }

    AcubeInfo(AcubeLet[] acubeLetArray, int[] nArray, int n) {
        this.cube = acubeLetArray;
        this.cell = nArray;
        this.nDIM = n;
        this.nDIM2 = this.nDIM * this.nDIM;
        this.nDIM_1 = this.nDIM - 1;
        this.faceInfo = new AfaceInfo[6];
        int n2 = 0;
        while (n2 < 6) {
            this.faceInfo[n2] = new AfaceInfo(this.cube, this.cell, n2, this.nDIM);
            ++n2;
        }
        this.cornerCellId[0] = this.nDIM_1 * this.nDIM;
        this.cornerCellId[1] = this.nDIM_1 * this.nDIM + this.nDIM_1;
        this.cornerCellId[2] = this.nDIM_1 * this.nDIM2 + this.nDIM_1 * this.nDIM + this.nDIM_1;
        this.cornerCellId[3] = this.nDIM_1 * this.nDIM2 + this.nDIM_1 * this.nDIM;
        this.cornerCellId[4] = 0;
        this.cornerCellId[5] = this.nDIM_1;
        this.cornerCellId[6] = this.nDIM_1 * this.nDIM2 + this.nDIM_1;
        this.cornerCellId[7] = this.nDIM_1 * this.nDIM2;
        this.trick1BotSocket = new AcolorPair();
        this.trick1TopSocket = new AcolorPair();
        this.trick1BacSocket = new AcolorPair();
        this.starFaceColorcode = 6;
    }

    private void allTopTurns() {
        int n = 0;
        while (n <= 5) {
            int n2 = 0;
            while (n2 < 4) {
                int n3 = 0;
                while (n3 < this.nDIM) {
                    String string = this.turnEdgeStr(this.faceInfo[n].faceEdgeCP[n2][n3], this.faceInfo[3].faceEdgeCP[3][2]);
                    g.dbg(0, "----allTopTurns: f,s,a=" + n + "," + n2 + "," + n3 + "; fromCP=" + this.faceInfo[n].faceEdgeCP[n2][n3] + "; rotStr=" + string);
                    n3 += this.nDIM_1;
                }
                ++n2;
            }
            ++n;
        }
    }

    public String bestFace() {
        g.dbg(0, "AcubeInfo.bestFace:" + this.bestFaceId);
        this.setFaceScore();
        String string = this.rotateFace(this.bestFaceId, 3);
        return string;
    }

    public int bestTopFace() {
        int n = 5;
        int n2 = 5;
        int n3 = -1;
        int n4 = 6;
        if (this.starFaceColorcode != 6) {
            int n5 = 0;
            while (n5 < 6) {
                if (this.faceInfo[n5].goodFaceColorcode(true) == this.starFaceColorcode) {
                    n4 = n5;
                    break;
                }
                ++n5;
            }
            this.opRotateStr = this.rotateFace(n4, 5);
            if (this.faceInfo[n4].centerColorcode == this.starFaceColorcode) {
                this.opRotateStr = this.rotateFace(n4, 5);
                return 1;
            }
            this.opRotateStr = this.rotateFace(n4, 3);
            return 0;
        }
        int n6 = 3;
        while (n6 <= 7) {
            int n7 = n6 % 6;
            n = this.faceInfo[n7].Nedge_T1 + this.faceInfo[n7].Nedge_good;
            n2 = this.faceInfo[n7 - 1].Nedge_T1 + this.faceInfo[n7 - 1].Nedge_good;
            if (n + n2 > n3) {
                n3 = n + n2;
                n4 = n7;
            }
            n6 += 2;
        }
        if (n == 4) {
            --n4;
        }
        this.starFaceColorcode = n6 = this.faceInfo[n4].goodFaceColorcode(false);
        String string = this.rotateFace(n4, 3);
        g.dbg(2, "---- bestTopFace: faceColor=" + AcubeCanvas.cName[n6]);
        this.opRotateStr = string;
        return 0;
    }

    int cellIdOf(AcolorPair acolorPair) {
        return this.cube[acolorPair.cubeid].cellId();
    }

    public int centerEdgeX() {
        int n = this.getFaceId(this.f1Colorcode);
        int n2 = this.getFaceId(this.f2Colorcode);
        if (n == 3) {
            if (n2 != 5 && n2 != 2) {
                g.abort("centerEdgeX -10: faces are now top & (fro/dow), f1,f2=" + n + n2);
            }
        } else if (n2 == 3) {
            if (n != 5 && n != 2) {
                g.abort("centerEdgeX -20: faces are now top & (fro/dow), f1,f2=" + n + n2);
            }
            n2 = n;
            n = 3;
        } else {
            g.abort("centerEdgeX -30: faces are now top & (fro/dow), facecode: f1,f2=" + n + n2);
        }
        AcenterEdgeInfo acenterEdgeInfo = new AcenterEdgeInfo(n, this.faceInfo[n].faceColorcode, this.nDIM);
        AcenterEdgeInfo acenterEdgeInfo2 = new AcenterEdgeInfo(n2, this.faceInfo[n2].faceColorcode, this.nDIM);
        acenterEdgeInfo.setTOPedgeInfo(this.starFaceColorcode);
        acenterEdgeInfo2.setDOWFROedgeInfo(this.starFaceColorcode);
        this.opTurnStr = AcenterEdgeInfo.edgeExchange(acenterEdgeInfo2, acenterEdgeInfo);
        return 0;
    }

    static int decodeEdge(int n, char c) {
        switch (c) {
            case 'f': {
                return n / 100;
            }
            case 's': {
                return n % 100 / 10;
            }
            case 'a': {
                return n % 10;
            }
        }
        g.abort("decodeEdge: edgecode=" + n + "; type=" + c);
        return 0;
    }

    static int encodeEdge(int n, int n2, int n3) {
        return n * 100 + n2 * 10 + n3;
    }

    private int getFaceId(int n) {
        int n2 = 0;
        while (n2 < 6) {
            if (this.faceInfo[n2].goodFaceColorcode(false) == n) {
                return n2;
            }
            ++n2;
        }
        g.abort("getFaceId -10: no faceId whose goodFaceColorcode=" + n);
        return -1;
    }

    public int handleLast2Edge() {
        int n = 11;
        String string = "F2< (Trick1a)F3>>";
        g.dbg(2, "------handleLast2Edge 100: trick1BotCP=" + this.trick1BotCP + "; trick1TopCP=" + this.trick1TopCP);
        g.dbg(2, "------handleLast2Edge 101: BotCP.faceEdgeFlag=" + this.faceInfo[2].faceEdgeFlag[1] + "; Top.faceEdgeFlag=" + this.faceInfo[3].faceEdgeFlag[1]);
        if (this.faceInfo[2].faceEdgeFlag[1] == 8 || this.faceInfo[2].faceEdgeFlag[1] == 1) {
            g.abort("handleLast2Edge -102: trick1BotCP=" + this.trick1BotCP);
        }
        if (this.faceInfo[3].faceEdgeFlag[1] == 8) {
            g.dbg(2, "------handleLast2Edge=2.ABDC - 1 bottom quark");
            this.opTurnStr = string;
            n = 12;
        } else {
            int n2 = this.faceInfo[3].faceEdgeCP[1][0].topColor;
            int n3 = this.faceInfo[3].faceEdgeCP[1][0].sideColor;
            int n4 = this.faceInfo[1].centerColorcode;
            int n5 = this.faceInfo[2].centerColorcode;
            if (this.trick1BotCP.sideColor == n5 && this.trick1BotCP.topColor == n4) {
                g.dbg(2, "------handleLast2Edge=4.BADC - 2 quarks");
                this.opTurnStr = "(Trick1)";
                n = 11;
            } else if (this.trick1TopCP.topColor == n4 && this.trick1TopCP.sideColor == n5) {
                if (this.trick1BotCP.sideColor == n2 && this.trick1BotCP.topColor == n3) {
                    g.dbg(2, "------handleLast2Edge=5.CDAB - T4good");
                    this.opTurnStr = "B*< (Trick4)B*> ";
                    n = 13;
                } else {
                    g.dbg(2, "------handleLast2Edge=6.CDBA - T4topquark");
                    this.opTurnStr = string;
                    n = 12;
                }
            } else if (this.trick1TopCP.topColor == n5 && this.trick1TopCP.sideColor == n4) {
                if (this.trick1BotCP.sideColor == n2 && this.trick1BotCP.topColor == n3) {
                    g.dbg(2, "------handleLast2Edge=7.DCAB - T4botquark");
                    this.opTurnStr = string;
                    n = 12;
                } else {
                    g.dbg(2, "------handleLast2Edge=8.DCBA - T42quark");
                    this.opTurnStr = "B*< (Trick4)B*> (Trick1)";
                    n = 13;
                }
            } else {
                g.abort("------handleLast2Edge -300: trick1BotCP=" + this.trick1BotCP + "; trick1TopCP=" + this.trick1TopCP);
            }
        }
        this.starFaceColorcode = this.faceInfo[5].goodFaceColorcode(false);
        this.opTurnStr = String.valueOf(this.opTurnStr) + AcubeOp.invOpStr(this.opTrick1Top);
        g.dbg(2, "------handleLast2Edge: rc=" + n + "; opTurnStr=" + this.opTurnStr);
        return n;
    }

    public boolean isStarConfig() {
        int n = 0;
        while (n < 6) {
            if ((this.faceInfo[n].getFaceConfig() & 8) == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int locateBadCornerCellid() {
        g.dbg(0, "AcubeInfo::locateBadTopCorner:NgoodCorners=" + this.faceInfo[3].NgoodCorners);
        if (this.faceInfo[3].NgoodCorners == 4) {
            return -1;
        }
        if (this.faceInfo[3].NgoodCorners == 0) {
            return this.nDIM_1 * (this.nDIM2 + this.nDIM + 1);
        }
        int n = -1;
        if (this.faceInfo[3].faceEdgeCP[0][0].flag == 1 && this.faceInfo[3].faceEdgeCP[0][this.nDIM_1].flag != 1) {
            n = this.faceInfo[3].faceEdgeCP[0][this.nDIM_1].cubeid;
        } else if (this.faceInfo[3].faceEdgeCP[3][0].flag == 1 && this.faceInfo[3].faceEdgeCP[3][this.nDIM_1].flag != 1) {
            n = this.faceInfo[3].faceEdgeCP[3][this.nDIM_1].cubeid;
        } else if (this.faceInfo[3].faceEdgeCP[1][this.nDIM_1].flag == 1 && this.faceInfo[3].faceEdgeCP[1][0].flag != 1) {
            n = this.faceInfo[3].faceEdgeCP[1][0].cubeid;
        } else if (this.faceInfo[3].faceEdgeCP[2][this.nDIM_1].flag == 1 && this.faceInfo[3].faceEdgeCP[2][0].flag != 1) {
            n = this.faceInfo[3].faceEdgeCP[2][0].cubeid;
        }
        if (n == -1) {
            throw new InternalError();
        }
        int n2 = this.cube[n].cellId();
        g.dbg(0, "AcubeInfo::locateBadTopCorner:cellid=" + n2);
        this.starFaceColorcode = 6;
        return n2;
    }

    public String locateBadFROEdge() {
        int n = -1;
        int n2 = 6;
        int n3 = -1;
        g.dbg(0, "        locateBadFROEdge: starFaceColorcode=" + this.starFaceColorcode);
        g.dbg(0, "        locateBadFROEdge: goodFaceColorcode=" + this.faceInfo[5].goodFaceColorcode(true));
        int n4 = this.faceInfo[5].Nedge_T1 + this.faceInfo[5].Nedge_good;
        int n5 = this.faceInfo[4].Nedge_T1 + this.faceInfo[4].Nedge_good;
        n = n4 + n5;
        if (n == 0 || n == 8) {
            return "";
        }
        n2 = n4 < 4 ? 5 : 4;
        g.dbg(0, "---- locateBadFROEdge: facId=" + n2 + ";n1,n2=" + n4 + n5);
        int n6 = 0;
        while (n6 < 4) {
            if (this.faceInfo[n2].faceEdgeFlag[n6] == 1) break;
            ++n6;
        }
        if (n6 == 4) {
            g.abort("AcubeInfo.locateBadFROEdge: maxNt1=" + n + ";facId=" + AcubeCanvas.cName[n2] + "; badEdge=" + n6);
        }
        String string = n2 == 5 ? (n6 == 0 ? "" : (n6 == 1 ? "F*>>" : (n6 == 2 ? "F*> " : "F*< "))) : (n6 == 0 ? "R*>>" : (n6 == 1 ? "B*>>" : (n6 == 2 ? "B*>>F*> " : "B*>>F*< ")));
        g.dbg(2, "AcubeInfo.locateBadFROEdge: rotStr=" + string);
        return string;
    }

    private int locateTarget_Center(int n) {
        g.dbg(0, "AcubeInfo.locateTarget_Center:");
        int n2 = 0;
        while (n2 < 6) {
            if (this.faceInfo[n2].centerColorcode == n) {
                return n2;
            }
            ++n2;
        }
        return 6;
    }

    private void locateTarget_Corner() {
        g.dbg(2, "AcubeInfo.locateTarget_Corner:");
        int n = this.faceInfo[3].faceEdgeCP[3][0].topColor;
        int n2 = this.faceInfo[3].faceEdgeCP[3][0].sideColor;
        g.dbg(0, "AcubeInfo.locateTarget_Corner: topcol,sidecol" + n + n2);
        if (this.faceInfo[3].NgoodCorners > 0) {
            int cfr_ignored_0 = this.faceInfo[3].faceEdgeCP[3][0].flag;
        }
        this.targetCellId = -1;
        this.targetNormal = null;
        int n3 = 0;
        while (n3 < 8) {
            if (n3 != 1) {
                this.targetCellId = this.cornerCellId[n3];
                AcubeLet acubeLet = this.cube[this.cell[this.targetCellId]];
                int n4 = acubeLet.colorId / 100;
                int n5 = acubeLet.colorId % 100 / 10;
                int n6 = acubeLet.colorId % 10;
                g.dbg(0, "locateTarget_Corner: targetCellId=" + this.targetCellId + ";colorId=" + acubeLet.colorId);
                if (!(n2 != n4 && n2 != n5 && n2 != n6 || n != n4 && n != n5 && n != n6)) {
                    this.targetNormal = acubeLet.getFaceNormal(n);
                    this.targetStrIx = this.targetNormal.getMultipleOf(g.vI) != 0.0 ? 0 : (this.targetNormal.getMultipleOf(g.vJ) != 0.0 ? 1 : 2);
                    this.targetStrIx += n3 * 3;
                    g.dbg(0, "locateTarget_Corner: targetCellId=" + this.targetCellId + ";targetNormal=" + this.targetNormal);
                    break;
                }
            }
            ++n3;
        }
        if (this.targetNormal == null) {
            g.abort("locateTarget_Corner: no targetNormal");
        }
    }

    public int makeCenterEdge(int n) {
        this.opRotateStr = "";
        g.dbg(2, "****makeCenterEdge: starFaceColorcode=" + AcubeCanvas.cName[this.starFaceColorcode]);
        int n2 = this.faceInfo[n].goodFaceColorcode(false);
        if (n2 != this.starFaceColorcode) {
            g.dbg(2, "makeCenterEdge -10: starFaceColorcode not = top goodFaceColorcode=" + AcubeCanvas.cName[n2]);
        }
        if ((this.faceInfo[n].getFaceConfig() & 8) != 0) {
            return 1;
        }
        this.f1Colorcode = -1;
        this.f2Colorcode = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 9;
        while (n5 >= 4) {
            int n6 = n5 % 6;
            if (n6 != n) {
                AcenterEdgeInfo acenterEdgeInfo = new AcenterEdgeInfo(n6, this.faceInfo[n6].faceColorcode, this.nDIM);
                if (acenterEdgeInfo.targetVtype(this.starFaceColorcode) == 2) {
                    n3 = n6;
                    n4 = n;
                    break;
                }
                if (acenterEdgeInfo.targetVtype(this.starFaceColorcode) == 1) {
                    if (n3 == -1) {
                        n3 = n6;
                    } else if (n4 == -1) {
                        n4 = n6;
                    }
                }
            }
            --n5;
        }
        if (n3 == -1) {
            this.opRotateStr = "";
            return 1;
        }
        if (n4 == -1) {
            n4 = n;
        }
        this.opRotateStr = g.faceNormal[n4].getMultipleOf(g.faceNormal[n3]) == 0.0 ? this.rotateOpStr(g.faceNormal[n4], g.faceNormal[n3], g.faceNormal[3], g.faceNormal[5]) : this.rotateFace(n4, 3);
        this.f1Colorcode = this.faceInfo[n3].goodFaceColorcode(false);
        this.f2Colorcode = this.faceInfo[n4].goodFaceColorcode(false);
        g.dbg(2, "---- makeCenterEdge: f1Colorcode,f2Colorcode=" + n3 + AcubeCanvas.cName[this.f1Colorcode] + n4 + AcubeCanvas.cName[this.f2Colorcode] + ";opRotateStr=" + this.opRotateStr);
        return 0;
    }

    public int makeLast4T1edges() {
        AcolorPair acolorPair;
        int n;
        int[] nArray = new int[]{AcubeInfo.encodeEdge(2, 2, 0), AcubeInfo.encodeEdge(2, 3, 0), AcubeInfo.encodeEdge(3, 3, 0), AcubeInfo.encodeEdge(3, 2, 0), AcubeInfo.encodeEdge(2, 2, 0)};
        int n2 = 0;
        int n3 = 0;
        String string = "";
        int n4 = 0;
        while (n4 < 4) {
            n2 = AcubeInfo.decodeEdge(nArray[n4], 'f');
            n3 = AcubeInfo.decodeEdge(nArray[n4], 's');
            int n5 = AcubeInfo.decodeEdge(nArray[n4 + 1], 'f');
            int n6 = AcubeInfo.decodeEdge(nArray[n4 + 1], 's');
            if (this.faceInfo[n2].faceEdgeFlag[n3] != 1 && this.faceInfo[n5].faceEdgeFlag[n6] == 1) break;
            ++n4;
        }
        switch (n4) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = "R*< ";
                break;
            }
            case 2: {
                string = "R*<<";
                break;
            }
            case 3: {
                string = "R*> ";
                break;
            }
            default: {
                if (this.faceInfo[n2].faceEdgeFlag[n3] != 1) {
                    return 1;
                }
                g.abort("makeLast4T1edges: all 4 edges are EDGE_" + this.faceInfo[n2].faceEdgeFlag[n3]);
            }
        }
        if (string.length() > 0) {
            this.opTurnStr = string;
            return 0;
        }
        AcolorPair acolorPair2 = this.faceInfo[2].faceEdgeCP[3][1];
        AcolorPair acolorPair3 = this.faceInfo[2].faceEdgeCP[3][this.nDIM - 2];
        AcolorPair acolorPair4 = null;
        AcolorPair acolorPair5 = null;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = 3;
        while (n11 >= 2) {
            n = 1;
            while (n <= this.nDIM - 2) {
                acolorPair = this.faceInfo[3].faceEdgeCP[n11][n];
                if (acolorPair.isSameColor(acolorPair2)) {
                    acolorPair4 = acolorPair;
                    n8 = n11;
                    n7 = n;
                }
                if (acolorPair.isSameColor(acolorPair3)) {
                    acolorPair5 = acolorPair;
                    n10 = n11;
                    n9 = n;
                }
                ++n;
            }
            --n11;
        }
        if (acolorPair4 == null) {
            g.abort("makeLast4T1edges -11: CP01=" + acolorPair2.toString());
        }
        if (acolorPair5 == null) {
            g.abort("makeLast4T1edges -12: CP02=" + acolorPair3.toString());
        }
        n = this.nDIM - n7;
        int n12 = n7 + 1;
        String string2 = "BN<<R" + n + "> BN<<R" + n + "< ";
        String string3 = "R" + n12 + "> BN<<R" + n12 + "< ";
        String string4 = "R*> B*< (Trick1a)B*> R*< ";
        int n13 = 0;
        if (n8 == 3 && n7 != 1) {
            n13 = 11;
            n = this.nDIM - n7;
            string = string2;
        } else if (n10 == 3 && n9 != this.nDIM - 2) {
            n13 = 21;
            n = this.nDIM - n9;
            string = string2;
        } else if (n8 == 2 && n7 == 1) {
            n13 = 12;
            n12 = n7 + 1;
            string = String.valueOf(string3) + "BN<<";
        } else if (n10 == 2 && n9 == this.nDIM - 2) {
            n13 = 22;
            n12 = n9 + 1;
            string = String.valueOf(string3) + "BN<<";
        } else if (n8 == 3 && n7 == 1) {
            n13 = 13;
            string = string4;
        } else if (n8 == 2 && n7 != 1) {
            n13 = 14;
            string = "BN<<" + string4 + "BN<<";
        } else {
            g.abort("makeLast4T1edges -20: side1,a1,side2,a2=" + n8 + n7 + "," + n10 + n9);
        }
        if (string.length() == 0) {
            g.abort("makeLast4T1edges -21: side1,a1,side2,a2=" + n8 + n7 + "," + n10 + n9);
        }
        this.opTurnStr = string;
        acolorPair = n13 >= 20 ? acolorPair5 : acolorPair4;
        g.dbg(2, "makeLast4T1edges: ----------- m=" + n13 + ";\ttarget cp=" + AcubeCanvas.cName[acolorPair.topColor] + AcubeCanvas.cName[acolorPair.sideColor]);
        g.dbg(2, "                  ----------- opTurnStr=" + this.opTurnStr);
        return 0;
    }

    public int makeT1edge() {
        Object object;
        String string;
        String string2;
        AcolorPair acolorPair;
        int n;
        int n2;
        int n3;
        int[] nArray = new int[this.nDIM - 2];
        boolean bl = false;
        if (this.faceInfo[5].Nedge_nonT1 + this.faceInfo[4].Nedge_nonT1 == 0) {
            bl = true;
        }
        int n4 = 3;
        while (n4 >= 2) {
            n3 = 1;
            while (n3 >= 0) {
                if (this.faceInfo[n4].faceEdgeFlag[n3] != 1) {
                    if (n4 == 3 && n3 == 1) {
                        this.opTurnStr = "";
                    } else if (n4 == 3 && n3 == 0) {
                        this.opTurnStr = "FM> ";
                    } else if (n4 == 2 && n3 == 1) {
                        this.opTurnStr = "FM< ";
                    } else if (n4 == 2 && n3 == 0) {
                        this.opTurnStr = "FM>>";
                    } else {
                        g.abort("makeT1edge -2: f,s=" + n4 + n3);
                    }
                    if (bl) {
                        this.opTurnStr = String.valueOf(this.opTurnStr) + "B*< ";
                        return 2;
                    }
                    return 1;
                }
                --n3;
            }
            --n4;
        }
        int[][] nArray2 = new int[6][4];
        int n5 = 0;
        while (n5 < 6) {
            n2 = 0;
            while (n2 < 4) {
                nArray2[n5][n2] = 0;
                ++n2;
            }
            ++n5;
        }
        int n6 = -1;
        int n7 = -1;
        n4 = 3;
        while (n4 >= 2) {
            n3 = 1;
            while (n3 >= 0) {
                n = 1;
                while (n <= this.nDIM - 2) {
                    acolorPair = this.faceInfo[n4].faceEdgeCP[n3][n];
                    if (acolorPair.topColor > acolorPair.sideColor) {
                        n6 = acolorPair.topColor;
                        n7 = acolorPair.sideColor;
                    } else {
                        n6 = acolorPair.sideColor;
                        n7 = acolorPair.topColor;
                    }
                    int[] nArray3 = nArray2[n6];
                    int n8 = n7;
                    nArray3[n8] = nArray3[n8] + 1;
                    ++n;
                }
                --n3;
            }
            --n4;
        }
        int n9 = 0;
        n5 = 0;
        while (n5 < 6) {
            n2 = 0;
            while (n2 < 4) {
                if (nArray2[n5][n2] > n9) {
                    n6 = n5;
                    n7 = n2;
                    n9 = nArray2[n5][n2];
                }
                ++n2;
            }
            ++n5;
        }
        n9 = 0;
        n4 = 3;
        while (n4 >= 2) {
            n3 = 1;
            while (n3 >= 0) {
                n = 1;
                while (n <= this.nDIM - 2) {
                    acolorPair = this.faceInfo[n4].faceEdgeCP[n3][n];
                    if (acolorPair.topColor == n6 && acolorPair.sideColor == n7) {
                        nArray[n9++] = AcubeInfo.encodeEdge(n4, n3, n);
                    } else if (acolorPair.topColor == n7 && acolorPair.sideColor == n6) {
                        nArray[n9++] = AcubeInfo.encodeEdge(n4, n3, n);
                    }
                    ++n;
                }
                --n3;
            }
            --n4;
        }
        this.opTurnStr = "";
        int[] nArray4 = new int[this.nDIM - 2];
        n = 1;
        while (n <= this.nDIM - 2) {
            int n10 = 0;
            n5 = 0;
            while (n5 < n9) {
                if (AcubeInfo.decodeEdge(nArray[n5], 'a') == n) {
                    n4 = AcubeInfo.decodeEdge(nArray[n5], 'f');
                    n3 = AcubeInfo.decodeEdge(nArray[n5], 's');
                    nArray4[n10++] = AcubeInfo.encodeEdge(n4, n3, 0);
                }
                ++n5;
            }
            g.dbg(2, "-----------------------------makeT1edge: nOnSliceA on a=" + n + " is =" + n10);
            if (n10 != 0) {
                int n11;
                string2 = "";
                if (n10 == 1) {
                    n11 = this.nDIM - n;
                    if (nArray4[0] == 300) {
                        string2 = "F" + n11 + "> ";
                    } else if (nArray4[0] == 200) {
                        string2 = "F" + n11 + ">>";
                    } else if (nArray4[0] == 210) {
                        string2 = "F" + n11 + "< ";
                    } else if (nArray4[0] == 310) {
                        string2 = "";
                    } else {
                        g.abort("makeT1edge -10: fsSet=" + g.arrString(nArray4, n10));
                    }
                    this.opTurnStr = String.valueOf(this.opTurnStr) + string2;
                } else {
                    string = "";
                    if (nArray4[0] > nArray4[1]) {
                        int n12 = nArray4[0];
                        nArray4[0] = nArray4[1];
                        nArray4[1] = n12;
                    }
                    if (nArray4[0] == 200) {
                        if (nArray4[1] == 210) {
                            string = "01";
                        } else if (nArray4[1] == 300) {
                            string = "12";
                        } else if (nArray4[1] == 310) {
                            string = "13";
                        } else {
                            g.abort("makeT1edge -11: fsSet=" + g.arrString(nArray4, n10));
                        }
                    } else if (nArray4[0] == 210) {
                        if (nArray4[1] == 300) {
                            string = "02";
                        } else if (nArray4[1] == 310) {
                            string = "03";
                        } else {
                            g.abort("makeT1edge -12: fsSet=" + g.arrString(nArray4, n10));
                        }
                    } else if (nArray4[0] == 300 && nArray4[1] == 310) {
                        string = "23";
                    } else {
                        g.abort("makeT1edge -13: fsSet=" + g.arrString(nArray4, n10));
                    }
                    object = "";
                    string2 = "";
                    n11 = this.nDIM - n;
                    if (string.equals("01")) {
                        string2 = "F" + n11 + ">>";
                        string = "23";
                    } else if (string.equals("02")) {
                        string2 = "F" + n11 + "> ";
                        string = "13";
                    } else if (string.equals("03")) {
                        string2 = "F" + n11 + "< ";
                        string = "23";
                    } else if (string.equals("12")) {
                        string2 = "F" + n11 + "> ";
                        string = "23";
                    }
                    n11 = this.nDIM + 1 - (this.nDIM - n);
                    if (string.equals("13")) {
                        object = "RN>>F" + n11 + "> RN>>";
                    } else if (string.equals("23")) {
                        object = "RN>>F" + n11 + ">>RN>>";
                    } else {
                        g.abort("makeT1edge -14: fsSet=" + g.arrString(nArray4, n10));
                    }
                    this.opTurnStr = String.valueOf(this.opTurnStr) + string2 + (String)object;
                    g.dbg(2, "-----------------------------makeT1edge: c1,c2=" + AcubeCanvas.cName[n6] + AcubeCanvas.cName[n7]);
                    g.dbg(2, "-----------------------------makeT1edge: config=" + string + "; op1=" + string2 + "; op2=" + (String)object);
                }
            }
            ++n;
        }
        if (n9 == this.nDIM - 2) {
            g.dbg(2, "-----------------------------makeT1edge: c1,c2=" + AcubeCanvas.cName[n6] + AcubeCanvas.cName[n7]);
            if (bl) {
                this.opTurnStr = String.valueOf(this.opTurnStr) + "B*< ";
                return 2;
            }
            return 1;
        }
        string2 = String.valueOf(this.opTurnStr) + "FM> ";
        object = null;
        n4 = 5;
        while (n4 >= 4) {
            n3 = 0;
            while (n3 < 4) {
                n = 1;
                while (n <= this.nDIM - 2) {
                    acolorPair = this.faceInfo[n4].faceEdgeCP[n3][n];
                    if (acolorPair.topColor == n6 && acolorPair.sideColor == n7) {
                        object = acolorPair;
                        break;
                    }
                    if (acolorPair.topColor == n7 && acolorPair.sideColor == n6) {
                        object = acolorPair;
                        break;
                    }
                    ++n;
                }
                ++n3;
            }
            --n4;
        }
        if (object == null) {
            g.abort("makeT1edge: c1,c2=" + AcubeCanvas.cName[n6] + AcubeCanvas.cName[n7]);
        }
        string = this.makeT1edgeStr((AcolorPair)object, g.v_I);
        g.dbg(2, "-----------------------------makeT1edge:makeT1edgeStr=" + string);
        this.opTurnStr = String.valueOf(string2) + string + "(Trick1)" + AcubeOp.invOpStr(string);
        return 0;
    }

    private String makeT1edgeStr(AcolorPair acolorPair, Avec avec) {
        char c;
        String string;
        AxisRotation axisRotation = new AxisRotation();
        axisRotation.initVecCross(acolorPair.sideNormal, avec, acolorPair.topNormal, this.nDIM);
        if (acolorPair.topNormal.equals(g.vK)) {
            string = "RN< ";
            c = '1';
        } else {
            string = "RN> ";
            c = 'N';
        }
        String string2 = axisRotation.turnStr(c);
        string2 = String.valueOf(string2) + string;
        g.dbg(2, "---------------- makeT1edgeStr: tStr=" + string2);
        return string2;
    }

    public String moveCenterSlice(int n) {
        int n2;
        String string = "";
        if (n == 3) {
            int n3 = this.faceInfo[3].faceEdgeCP[0][0].topColor;
            if (this.faceInfo[3].centerColorcode != n3) {
                int n4 = this.locateTarget_Center(n3);
                switch (n4) {
                    case 0: {
                        string = "FM> ";
                        break;
                    }
                    case 1: {
                        string = "FM< ";
                        break;
                    }
                    case 2: {
                        string = "FM>>";
                        break;
                    }
                    case 5: {
                        string = "RM> ";
                        break;
                    }
                    case 4: {
                        string = "RM< ";
                        break;
                    }
                    default: {
                        string = "";
                        break;
                    }
                }
            }
        } else if (n == 1 && this.faceInfo[1].centerColorcode != (n2 = this.faceInfo[1].goodFaceColorcode(false))) {
            int n5 = this.locateTarget_Center(n2);
            switch (n5) {
                case 0: {
                    string = "BM>>";
                    break;
                }
                case 5: {
                    string = "BM> ";
                    break;
                }
                case 4: {
                    string = "BM< ";
                    break;
                }
                default: {
                    string = "";
                }
            }
        }
        g.dbg(0, "     moveCenterSlice: facecode=" + n + "; opStr=" + string);
        return string;
    }

    public String moveToRTF() {
        this.locateTarget_Corner();
        String string = targetStr[this.targetStrIx];
        if (newNormal[this.targetStrIx] == "i") {
            string = String.valueOf(string) + "RN> F1< RN< ";
        } else if (newNormal[this.targetStrIx] == "k") {
            string = String.valueOf(string) + "FN< R1> FN> ";
        } else if (newNormal[this.targetStrIx] == "-j") {
            string = String.valueOf(string) + "RN> F1<<RN< B1> RN> F1< RN< ";
        }
        return string;
    }

    private int opposingFace() {
        int n = 2;
        while (n < 8) {
            int n2 = n % 6;
            if (this.faceInfo[n2].NwrongEdge > 0 && this.faceInfo[AcubeInfo.oppix[n2]].NwrongEdge > 0) {
                return n2;
            }
            ++n;
        }
        g.dbg(0, "oppositeSlice: no opposing faces found!");
        return -1;
    }

    private String rotateFace(int n, int n2) {
        Avec avec = new Avec(g.faceNormal[n]);
        Avec avec2 = new Avec(g.faceNormal[n2]);
        AxisRotation axisRotation = new AxisRotation();
        axisRotation.initVecCross(avec, avec2, null, this.nDIM);
        String string = axisRotation.rotateStr();
        return string;
    }

    private String rotateMiddleSlice(int n, int n2) {
        String string = this.rotateFace(n, n2);
        string = string.replace('*', 'M');
        return string;
    }

    private String rotateOpStr(AcolorPair acolorPair, AcolorPair acolorPair2) {
        g.dbg(0, "----rotateOpStr: fromCP=" + acolorPair + "; toCP=" + acolorPair2);
        Avec avec = new Avec(acolorPair.topNormal);
        Avec avec2 = new Avec(acolorPair.sideNormal);
        Avec avec3 = new Avec(acolorPair2.topNormal);
        Avec avec4 = new Avec(acolorPair2.sideNormal);
        return this.rotateOpStr(avec, avec2, avec3, avec4);
    }

    private String rotateOpStr(Avec avec, Avec avec2, Avec avec3, Avec avec4) {
        Avec avec5 = new Avec(avec);
        Avec avec6 = new Avec(avec2);
        Avec avec7 = new Avec(avec3);
        Avec avec8 = new Avec(avec4);
        AxisRotation axisRotation = new AxisRotation();
        AxisRotation axisRotation2 = new AxisRotation();
        axisRotation.initVecCross(avec5, avec7, avec6, this.nDIM);
        String string = axisRotation.rotateStr();
        if (axisRotation.turnAxis != null) {
            axisRotation.rotateM.matTransform(avec6);
        }
        g.dbg(0, "----rotateOpStr: v0,w0=" + avec5 + "," + avec6 + ";v1,w1=" + avec7 + "," + avec8);
        axisRotation2.initVecCross(avec6, avec8, null, this.nDIM);
        string = String.valueOf(string) + axisRotation2.rotateStr();
        g.dbg(0, "----rotateOpStr: v0,w0=" + avec5 + "," + avec6 + ";v1,w1=" + avec7 + "," + avec8);
        g.dbg(0, "----rotateOpStr: rotStr=" + string);
        return string;
    }

    private void setFaceScore() {
        g.dbg(0, "AcubeInfo.setFaceScore:");
        boolean bl = true;
        int n = 50;
        int n2 = 10;
        boolean bl2 = true;
        int n3 = 25;
        int n4 = 0;
        this.bestFaceId = 6;
        int n5 = 0;
        while (n5 < 6) {
            int n6 = this.faceInfo[n5].setScore();
            if (n6 > n4) {
                n4 = n6;
                this.bestFaceId = n5;
            }
            g.dbg(0, "setFaceScore: f=" + n5 + ";fscore=" + n6);
            ++n5;
        }
        g.dbg(0, "AcubeInfo::setFaceScore:" + n4 + ";bestFaceId=" + this.bestFaceId);
    }

    public void setInfo() {
        int n;
        this.Nedge_T1 = 0;
        this.Nedge_nonT1 = 0;
        this.Nedge_good = 0;
        int n2 = 0;
        while (n2 < 6) {
            this.faceInfo[n2].setInfo();
            n = 0;
            while (n < 4) {
                if (this.faceInfo[n2].faceEdgeFlag[n] == 1) {
                    ++this.Nedge_nonT1;
                } else if (this.faceInfo[n2].faceEdgeFlag[n] == 2) {
                    ++this.Nedge_T1;
                } else {
                    ++this.Nedge_good;
                }
                ++n;
            }
            ++n2;
        }
        this.Nedge_T1 /= 2;
        this.Nedge_nonT1 /= 2;
        this.Nedge_good /= 2;
        n = this.faceInfo[3].NgoodCorners;
        int n3 = 0;
        while (n3 < 2) {
            AcolorPair acolorPair = this.faceInfo[3].faceEdgeCP[n3][0];
            AcolorPair acolorPair2 = this.faceInfo[3].faceEdgeCP[n3][this.nDIM_1];
            AcolorPair acolorPair3 = this.faceInfo[2].faceEdgeCP[n3][0];
            AcolorPair acolorPair4 = this.faceInfo[2].faceEdgeCP[n3][this.nDIM_1];
            if (acolorPair.flag == 1 && acolorPair3.flag == 1 && acolorPair.sideColor == acolorPair3.sideColor) {
                ++n;
            }
            if (acolorPair2.flag == 1 && acolorPair4.flag == 1 && acolorPair2.sideColor == acolorPair4.sideColor) {
                ++n;
            }
            ++n3;
        }
        this.NbadCorners = 8 - n;
        g.dbg(2, "****AcubeInfo.setInfo: NbadCorners=" + this.NbadCorners + ";Nedge_nonT1,T1,good=" + this.Nedge_nonT1 + "," + this.Nedge_T1 + "," + this.Nedge_good);
        this.trick1BotCP = this.faceInfo[2].faceEdgeCP[1][1];
        this.trick1TopCP = this.faceInfo[3].faceEdgeCP[1][1];
        this.trick1BacCP = this.faceInfo[2].faceEdgeCP[0][1];
    }

    public int setStarFace() {
        int n = 0;
        while (n < 6) {
            if ((this.faceInfo[n].getFaceConfig() & 8) == 0) {
                this.starFaceColorcode = this.faceInfo[n].goodFaceColorcode(false);
                return 0;
            }
            ++n;
        }
        g.dbg(2, "setStarFace : all faces have star config!");
        return 1;
    }

    private String trick1AlternateTurn(String string) {
        if (string.length() == 0) {
            return "";
        }
        String string2 = null;
        if (string.compareTo("FM< ") == 0) {
            string2 = "RN< F1< B1< ";
        } else if (string.compareTo("FM< B1>>") == 0) {
            string2 = "RN> F1< B1< ";
        } else if (string.compareTo("FM< B1<<") == 0) {
            string2 = "RN> F1< B1< ";
        } else if (string.compareTo("FM> RN>>") == 0) {
            string2 = "RN> F1< B1< ";
        } else if (string.compareTo("FM> RN<<") == 0) {
            string2 = "RN> F1< B1< ";
        } else if (string.compareTo("R1< B1>>") == 0) {
            string2 = "F1<<RN< ";
        } else if (string.compareTo("R1< B1<<") == 0) {
            string2 = "F1<<RN< ";
        } else if (string.compareTo("R1> B1>>") == 0) {
            string2 = "FN<<RN> ";
        } else if (string.compareTo("R1> B1<<") == 0) {
            string2 = "FN<<RN> ";
        } else if (string.compareTo("FM< BN>>") == 0 || string.compareTo("FM> R1>>") == 0 || string.compareTo("FM< BN<<") == 0 || string.compareTo("FM> R1<<") == 0) {
            string2 = "BN>>RN< F1> BN> ";
            g.dbg(2, "trick1AlternateTurn: reverses trick1top, inStr=" + string + ";outStr=" + string2);
        } else if (string.indexOf("F2") >= 0 || string.indexOf("FM") >= 0 || string.indexOf("R1") >= 0 || string.indexOf("B1>>") >= 0 || string.indexOf("B1<<") >= 0) {
            g.abort("trick1AlternateTurn -22: inStr=" + string);
        } else {
            string2 = String.valueOf(string);
        }
        String string3 = null;
        int n = string2.length() / 4;
        int n2 = 0;
        while (n2 < n) {
            if (string2.substring(n2 * 4, n2 * 4 + 2).compareTo("B1") == 0) {
                string3 = string2.substring(0, n2 * 4) + "R1> " + string2.substring(n2 * 4, n2 * 4 + 4) + "R1< " + string2.substring(n2 * 4 + 4, n * 4);
                break;
            }
            ++n2;
        }
        if (string3 != null) {
            string2 = string3;
        }
        if (!string.equals(string2)) {
            g.dbg(2, "trick1AlternateTurn: inStr=" + string + ";outStr=" + string2);
        }
        return string2;
    }

    public int trick1Bac() {
        AcolorPair acolorPair = null;
        if (this.trick1BacSocket.topColor == 6) {
            g.dbg(2, "------trick1Bac: Nedge_T1,Nedge_good=" + this.Nedge_T1 + "," + this.Nedge_good);
            this.opPreTrick1 = "";
            if (this.nDIM == 4) {
                return 1;
            }
            return 0;
        }
        int n = 0;
        while (n < 6) {
            acolorPair = this.faceInfo[n].locateCP(this.trick1BacSocket.topColor, this.trick1BacSocket.sideColor, this.trick1BacSocket.cubeid);
            if (acolorPair != null) break;
            ++n;
        }
        g.dbg(0, "------trick1Bac: trick1BacCP=" + this.trick1BacCP);
        g.dbg(0, "------trick1Bac: trick1cp3=" + acolorPair);
        String string = this.turnEdgeStr(acolorPair, this.trick1BacCP);
        this.opPreTrick1 = this.trick1AlternateTurn(string);
        g.dbg(2, "------trick1Bac: opPreTrick1=" + this.opPreTrick1 + ";trick1cp3=" + acolorPair);
        return 0;
    }

    public void trick1Init() {
        this.trick1BotSocket.init(this.faceInfo[2].faceEdgeCP[1][0].topColor, this.faceInfo[2].faceEdgeCP[1][0].sideColor, 0, this.nDIM);
        this.trick1TopSocket.init(this.faceInfo[3].faceEdgeCP[1][0].topColor, this.faceInfo[3].faceEdgeCP[1][0].sideColor, 0, this.nDIM);
        this.trick1BotSocket.init(this.faceInfo[2].faceEdgeCP[0][0].topColor, this.faceInfo[2].faceEdgeCP[0][0].sideColor, 0, this.nDIM);
    }

    public boolean trick1Ready() {
        if (this.NbadCorners > 0) {
            return false;
        }
        int n = 0;
        while (n < 6) {
            if ((this.faceInfo[n].getFaceConfig() & 8) == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String trick1Rotate() {
        int n;
        String string = "";
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (!this.trick1Ready()) {
            g.abort("trick1Rotate -10: trick1Ready=false");
        }
        int n7 = 0;
        while (n7 < 6) {
            int n8 = this.faceInfo[oppfaceId[n7]].goodFaceColorcode(false);
            this.faceInfo[n7].setNoppositeEdge(n8);
            if (this.faceInfo[n7].NoppEdge > n2) {
                n2 = this.faceInfo[n7].NoppEdge;
                n5 = n7;
            }
            if (this.faceInfo[n7].NwrongEdge > n3) {
                n3 = this.faceInfo[n7].NwrongEdge;
                n6 = n7;
            } else if (this.faceInfo[n7].NwrongEdge == n3 && n7 == 2) {
                g.dbg(0, "---trick1Rotate 110: bottom slice's targetEdge=" + this.faceInfo[n7].targetEdge);
                n6 = n7;
            }
            ++n7;
        }
        if (n3 + n2 == 0) {
            g.abort("trick1Rotate -20:maxNwrong+maxNopp=0");
        }
        n4 = -1;
        if (this.faceInfo[2].NoppEdge > 0) {
            g.dbg(0, "---trick1Rotate 111: bottom face targetEdge=" + this.faceInfo[2].targetEdge);
            n4 = 2;
        } else if (n2 > 0) {
            g.dbg(0, "---trick1Rotate 112: faceIdOpp=" + n5 + " targetEdge=" + this.faceInfo[n5].targetEdge);
            n4 = n5;
        } else {
            n = this.opposingFace();
            if (n >= 0) {
                g.dbg(0, "---trick1Rotate 115 opposingFace return targetEdge=" + this.faceInfo[n].targetEdge);
                n4 = n;
            }
        }
        if (n4 == -1) {
            g.dbg(0, "---trick1Rotate 201: no opposite,no opposing, faceIdBad=" + n6);
            g.dbg(0, "---trick1Rotate 202: encodedEdge=" + this.faceInfo[n6].targetEdge);
            n4 = n6;
        }
        n = AcubeInfo.decodeEdge(this.faceInfo[n4].targetEdge, 's');
        AcolorPair acolorPair = this.faceInfo[n4].faceEdgeCP[n][1];
        string = this.rotateOpStr(acolorPair, this.trick1BotCP);
        return string;
    }

    public int trick1Top() {
        this.opTrick1Top = "";
        if (this.nDIM == 4 && this.Nedge_good > 10) {
            return 1;
        }
        g.dbg(0, "trick1Top: trick1bot cp=" + this.trick1BotCP);
        this.trick1cp2 = this.faceInfo[3].socketForTrick1Bot(this.trick1BotCP);
        if (this.trick1cp2 == null) {
            this.trick1cp2 = this.faceInfo[0].socketForTrick1Bot(this.trick1BotCP);
        }
        if (this.trick1cp2 == null) {
            this.trick1cp2 = this.faceInfo[1].socketForTrick1Bot(this.trick1BotCP);
        }
        if (this.trick1cp2 == null) {
            this.trick1cp2 = this.faceInfo[2].socketForTrick1Bot(this.trick1BotCP);
        }
        if (this.trick1cp2 == null) {
            g.abort("trick1Top -14: cannot find socket for trick1Bot trick1cp2=" + this.trick1cp2);
        }
        String string = this.turnEdgeStr(this.trick1cp2, this.trick1TopCP);
        this.opTrick1Top = this.trick1AlternateTurn(string);
        g.dbg(0, "trick1Top: opTrick1Top=" + this.opTrick1Top + ";trick1cp2=" + this.trick1cp2);
        g.dbg(0, "trick1Top: locate socket for trick1top candidate: plug=trick1cp2=" + this.trick1cp2);
        AcolorPair acolorPair = null;
        int n = 5;
        while (n >= 0) {
            AcolorPair acolorPair2 = this.faceInfo[n].socketForTrick1Top(this.trick1cp2);
            g.dbg(0, "trick1Top-locate plug for trick1Bac socket::faceInfo[" + n + "]; cp=" + acolorPair2);
            if (acolorPair2 != null) {
                if (this.cellIdOf(acolorPair2) == this.cellIdOf(this.trick1cp2) || this.cellIdOf(acolorPair2) == this.cellIdOf(this.trick1BotCP)) {
                    g.dbg(0, "trick1Top: locate socket for trick1top candidate: cp found & ignore because same as trick1cp2 or trick1BotCP");
                } else {
                    if (this.faceInfo[n].socketCP != null) {
                        g.dbg(0, "trick1Top: locate socket for trick1top candidate: found socketCP=" + this.faceInfo[n].socketCP);
                        acolorPair = this.faceInfo[n].socketCP;
                        break;
                    }
                    if (acolorPair2 != null && acolorPair == null) {
                        acolorPair = acolorPair2;
                    }
                }
            }
            --n;
        }
        if (acolorPair != null) {
            this.trick1BacSocket.init(acolorPair.topColor, acolorPair.sideColor, acolorPair.cubeid, this.nDIM);
        } else {
            this.trick1BacSocket.init(6, 6, -1, this.nDIM);
        }
        return 0;
    }

    public void trick2Info(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.bTrick2Move = false;
        this.preTrick2Move = "";
        this.postTrick2Move = "";
        this.preTrick2Rotate = "";
        this.postTrick2Rotate = "";
        if (n != 3) {
            return;
        }
        int n6 = oppix[this.faceInfo[2].goodFaceColorcode(false)];
        int n7 = 0;
        while (n7 < 4) {
            n5 = this.faceInfo[n].faceEdgeCP[n7][0].sideColor;
            n4 = this.faceInfo[n].faceEdgeCP[n7][this.nDIM_1].sideColor;
            n3 = this.faceInfo[n].faceEdgeCP[n7][0].topColor;
            n2 = this.faceInfo[n].faceEdgeCP[n7][this.nDIM_1].topColor;
            if (n3 != n2 || n3 != n6) {
                if (n5 == n4) {
                    this.preTrick2Rotate = n7 == 0 ? "B*> " : (n7 == 1 ? "B*< " : (n7 == 2 ? "B*>>" : ""));
                    this.bTrick2Move = true;
                } else if (n3 == n2) {
                    if (n7 == 0) {
                        this.preTrick2Rotate = "B*< R*< ";
                        this.postTrick2Rotate = "R*> ";
                    } else if (n7 == 1) {
                        this.preTrick2Rotate = "B*> R*< ";
                        this.postTrick2Rotate = "R*> ";
                    } else if (n7 == 2) {
                        this.preTrick2Rotate = "R*< ";
                        this.postTrick2Rotate = "R*> ";
                    } else {
                        this.preTrick2Rotate = "B*>>R*< ";
                        this.postTrick2Rotate = "R*> ";
                    }
                    this.bTrick2Move = true;
                }
                if (this.bTrick2Move) {
                    g.dbg(0, "trick2Info:0 side= " + n7 + ";topcol=" + AcubeCanvas.cName[n6]);
                    g.dbg(0, "trick2Info:0 preTrick2Rotate= " + this.preTrick2Rotate);
                    g.dbg(0, "trick2Info:0 top  colors: " + AcubeCanvas.cName[n3] + ";" + AcubeCanvas.cName[n2]);
                    g.dbg(0, "trick2Info:0 side colors: " + AcubeCanvas.cName[n5] + ";" + AcubeCanvas.cName[n4]);
                    return;
                }
            }
            ++n7;
        }
        int n8 = 0;
        while (n8 < 4) {
            n5 = this.faceInfo[n].faceEdgeCP[n8][0].sideColor;
            n3 = this.faceInfo[n].faceEdgeCP[n8][0].topColor;
            n4 = this.faceInfo[n].faceEdgeCP[n8][this.nDIM_1].sideColor;
            n2 = this.faceInfo[n].faceEdgeCP[n8][this.nDIM_1].topColor;
            if (n5 == n6) {
                if (n2 == n6) {
                    if (n8 == 0 || n8 == 3) {
                        this.preTrick2Move = "R1< ";
                        this.postTrick2Move = "R1> ";
                    } else {
                        this.preTrick2Move = "RN< ";
                        this.postTrick2Move = "RN> ";
                    }
                }
                this.bTrick2Move = true;
            } else if (n4 == n6) {
                if (n3 == n6) {
                    if (n8 == 1 || n8 == 2) {
                        this.preTrick2Move = "R1< ";
                        this.postTrick2Move = "R1> ";
                    } else {
                        this.preTrick2Move = "RN< ";
                        this.postTrick2Move = "RN> ";
                    }
                }
                this.bTrick2Move = true;
            }
            if (this.bTrick2Move) {
                this.preTrick2Rotate = n8 == 0 ? "B*> " : (n8 == 1 ? "B*< " : (n8 == 2 ? "B*>>" : ""));
                g.dbg(0, "trick2Info:2 side= " + n8 + ";topcol=" + AcubeCanvas.cName[n6]);
                g.dbg(0, "trick2Info:2 preTrick2Rotate= " + this.preTrick2Rotate);
                g.dbg(0, "trick2Info:2 top  colors: " + AcubeCanvas.cName[n3] + ";" + AcubeCanvas.cName[n2]);
                g.dbg(0, "trick2Info:2 side colors: " + AcubeCanvas.cName[n5] + ";" + AcubeCanvas.cName[n4]);
                return;
            }
            ++n8;
        }
    }

    public String trick3Info(int n) {
        int n2;
        int n3;
        int n4;
        if (n != 1) {
            return "";
        }
        String string = "";
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[7];
        nArray[0] = this.nDIM_1 * this.nDIM2 + this.nDIM_1 * this.nDIM + this.nDIM_1;
        nArray[1] = this.nDIM_1 * this.nDIM2 + this.nDIM_1;
        nArray[2] = this.nDIM_1 * this.nDIM2;
        nArray[3] = this.nDIM_1 * this.nDIM2 + this.nDIM_1 * this.nDIM;
        nArray2[0] = this.nDIM_1 * this.nDIM + this.nDIM_1;
        nArray2[1] = this.nDIM_1;
        nArray2[2] = 0;
        nArray2[3] = this.nDIM_1 * this.nDIM;
        int n5 = 0;
        while (n5 < 7) {
            n4 = this.cell[nArray[n5 % 4]];
            nArray4[n5] = this.cube[n4].colorId;
            ++n5;
        }
        int[] nArray5 = new int[6];
        nArray5[0] = 1;
        nArray5[2] = 30;
        nArray5[3] = 20;
        nArray5[4] = 500;
        nArray5[5] = 400;
        int[] nArray6 = nArray5;
        n5 = 0;
        while (n5 < 4) {
            n4 = this.cell[nArray2[n5]];
            nArray3[n5] = this.cube[n4].colorId;
            int n6 = this.cube[n4].getFace((int)0).colorcode;
            nArray3[n5] = nArray3[n5] - AcubeLet.colorEncode[n6] + nArray6[n6];
            ++n5;
        }
        int n7 = 0;
        while (n7 < 4) {
            if (nArray4[n7] == nArray3[0]) break;
            ++n7;
        }
        if (n7 >= 4) {
            g.dbg(9, "trick3Info: desiredColorId=" + g.arrString(nArray3, 4));
            g.dbg(9, "trick3Info: sliceColorId=" + g.arrString(nArray4, 7));
            g.abort("trick3Info: no desiredColor[4] found in right slice!");
        }
        String string2 = "0";
        n5 = 1;
        while (n5 < 4) {
            n3 = 1;
            while (n3 < 4) {
                if (nArray4[n7 + n5] == nArray3[n3]) {
                    string2 = String.valueOf(string2) + n3;
                    break;
                }
                ++n3;
            }
            ++n5;
        }
        g.dbg(0, "trick3Info: startIx=" + n7 + "; config=" + string2);
        this.bTrick3Move = true;
        int n8 = oppix[this.faceInfo[0].goodFaceColorcode(false)];
        if (string2.compareTo("0321") == 0) {
            n2 = n7;
            n3 = 31;
            int n9 = 0;
            n4 = this.cell[nArray[n9]];
            int n10 = this.cube[n4].getFace((int)1).colorcode;
            if (n10 != n8) {
                this.preTrick3Move = "R1> B1< ";
                this.postTrick3Move = "B1> R1< ";
            } else {
                this.preTrick3Move = "R1< B1< ";
                this.postTrick3Move = "B1> R1> ";
            }
        } else if (string2.compareTo("0312") == 0) {
            n2 = n7 + 1;
            n3 = 30;
            int n11 = 2;
            n4 = this.cell[nArray[n11]];
            int n12 = this.cube[n4].getFace((int)1).colorcode;
            if (n12 != n8) {
                this.preTrick3Move = "R1< FN< ";
                this.postTrick3Move = "FN> R1> ";
            } else {
                this.preTrick3Move = "R1< ";
                this.postTrick3Move = "R1> ";
            }
        } else if (string2.compareTo("0231") == 0) {
            n2 = n7 - 1;
            n3 = 10;
            int n13 = 3;
            n4 = this.cell[nArray[n13]];
            int n14 = this.cube[n4].getFace((int)1).colorcode;
            if (n14 != n8) {
                this.preTrick3Move = "FN< ";
                this.postTrick3Move = "FN> ";
            } else {
                this.preTrick3Move = "";
                this.postTrick3Move = "";
            }
        } else if (string2.compareTo("0213") == 0) {
            n2 = n7;
            n3 = 21;
            int n15 = 0;
            n4 = this.cell[nArray[n15]];
            int n16 = this.cube[n4].getFace((int)1).colorcode;
            if (n16 != n8) {
                this.preTrick3Move = "R1> FN< ";
                this.postTrick3Move = "FN> R1< ";
            } else {
                this.preTrick3Move = "R1> ";
                this.postTrick3Move = "R1< ";
            }
        } else if (string2.compareTo("0132") == 0) {
            n2 = n7;
            n3 = 32;
            int n17 = 1;
            n4 = this.cell[nArray[n17]];
            int n18 = this.cube[n4].getFace((int)1).colorcode;
            if (n18 != n8) {
                this.preTrick3Move = "R1>>FN< ";
                this.postTrick3Move = "FN> R1>>";
            } else {
                this.preTrick3Move = "R1>>";
                this.postTrick3Move = "R1>>";
            }
        } else {
            n2 = n7;
            n3 = 0;
            boolean bl = false;
            this.preTrick3Move = "";
            this.postTrick3Move = "";
            this.bTrick3Move = false;
        }
        if (n2 > 2) {
            n2 -= 4;
        }
        string = n2 == 1 ? "R1> " : (n2 == 2 ? "R1>>" : (n2 == -1 ? "R1< " : ""));
        g.dbg(2, "trick3Info: opStr=" + string + ";preTrick3Move=" + this.preTrick3Move + ";rigColor=" + AcubeCanvas.cName[n8]);
        return string;
    }

    private String turnEdgeStr(AcolorPair acolorPair, AcolorPair acolorPair2) {
        g.dbg(0, "----turnEdgeStr1: fromCP=" + acolorPair + "; toCP=" + acolorPair2);
        Avec avec = new Avec(acolorPair.topNormal);
        Avec avec2 = new Avec(acolorPair.sideNormal);
        Avec avec3 = new Avec(acolorPair2.topNormal);
        Avec avec4 = new Avec(acolorPair2.sideNormal);
        int n = this.cellIdOf(acolorPair);
        Apoint apoint = new Apoint((double)(n / this.nDIM2) + 0.5, (double)(n % this.nDIM2 / this.nDIM) + 0.5, (double)(n % this.nDIM) + 0.5);
        AxisRotation axisRotation = new AxisRotation();
        AxisRotation axisRotation2 = new AxisRotation();
        axisRotation.initVecCross(avec, avec3, avec2, this.nDIM);
        g.dbg(0, "----turnEdgeStr2: v0,w0,fromCellCenter=" + avec + "," + avec2 + apoint);
        String string = axisRotation.turnEdge(apoint);
        g.dbg(0, "----turnEdgeStr2: v0,w0,fromCellCenter=" + avec + "," + avec2 + apoint);
        if (axisRotation.turnAxis != null) {
            axisRotation.rotateM.matTransform(avec2);
            Apoint apoint2 = new Apoint((double)this.nDIM * 0.5, (double)this.nDIM * 0.5, (double)this.nDIM * 0.5);
            apoint = axisRotation.rotateM.matRotation(apoint, apoint2);
        }
        g.dbg(0, "----turnEdgeStr3: v0,w0,fromCellCenter=" + avec + "," + avec2 + apoint + "; tStr=" + string);
        axisRotation2.initVecCross(avec2, avec4, null, this.nDIM);
        string = String.valueOf(string) + axisRotation2.turnEdge(apoint);
        g.dbg(0, "----turnEdgeStr4: w0,w1,fromCellCenter=" + avec2 + "," + avec4 + "; tStr=" + string);
        return string;
    }
}

