/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class AcubeGame
extends JPanel
implements Runnable,
ChangeListener,
ActionListener,
ItemListener {
    cubeApp cuApp;
    AcubeCanvas cubeCanvas;
    AcubeInfo cubeInfo;
    JPanel controlPanel;
    int nDIM;
    Point cubeGameOrigin;
    AcubeOp[] mCubeOpArr = new AcubeOp[100];
    AcubeOp mTrick1;
    AcubeOp mTrick2;
    AcubeOp mTrick3;
    int NcubeOp = 0;
    Thread cubethread = null;
    int cubethreadState;
    static final int ZERO = 0;
    static final int RUN = 1;
    static final int SUSPEND = 2;
    int gameState;
    int gameStatePrev;
    static final int GAMESTATE_0 = 0;
    static final int GAMESTATE_START = 1;
    static final int GAMESTATE_TRICK = 2;
    static final int GAMESTATE_SOLVE = 3;
    static final int GAMESTATE_SETCUBE = 4;
    static final int GAMESTATE_TEST = 5;
    static final int GAMESTATE_INITSCRAMBLE = 6;
    int solveState;
    int solveStateNext;
    int solveMode;
    static final int SOLVESTATE10 = 10;
    static final int S14TOPCORNER = 14;
    static final int S18TOPTARGET = 18;
    static final int SOLVESTATE20T3 = 20;
    static final int S22TRICK3COR = 22;
    static final int S23TRICK3PRE = 23;
    static final int S24TRICK3MOV = 24;
    static final int S25TRICK3POS = 25;
    static final int S28TRICK3R2T = 28;
    static final int S30TRICK2COR = 30;
    static final int S31TRICK2RO1 = 31;
    static final int S35TRICK2PRE = 35;
    static final int S36TRICK2MOV = 36;
    static final int S37TRICK2POS = 37;
    static final int S38TRICK2RO2 = 38;
    static final int SOLVESTATE40TOP = 40;
    static final int S41TOPCENTER = 41;
    static final int S42CENTEREDGEX = 42;
    static final int SOLVESTATE45EDGE = 45;
    static final int S46MAKET1EDGE = 46;
    static final int S47EDGETRICK1 = 47;
    static final int S48CENTERS = 48;
    static final int SOLVESTATE50CTR = 50;
    static final int SOLVESTATE60 = 60;
    static final int S62SIDE_CNTR = 62;
    static final int SOLVESTATE80T1 = 80;
    static final int S82TRICK1TOP = 82;
    static final int S84TRICK1PRE = 84;
    static final int S86TRICK1MOV = 86;
    static final int S88TRICK1POS = 88;
    static final int S90QUARK = 90;
    static final int SOLVESTATE99 = 99;
    static final int SOLVEMODE_HINT = 1;
    static final int SOLVEMODE_SOLVE = 2;
    long startTime;
    long endTime;
    boolean optViewPanel;
    boolean optPerformPanel;
    boolean optTune;
    static String notAvail = "Sorry, not available in freeware";
    boolean showMirroredFace = false;
    boolean showPerspective = false;
    boolean showDirectionArrow = false;
    movingBanner banner1;
    public int msPause = 25;
    public int NframePerTurn = 5;
    private int degZ;
    private int degY;
    private int incrY;
    private int degX;
    private int incrX;
    JTextField txtCounter;
    JTextField txtSpeed;
    JTextField degViewY;
    JTextField degIncrY;
    JTextField degViewX;
    JTextField degIncrX;
    JButton buViewY;
    JButton buIncrY;
    JButton buViewX;
    JButton buIncrX;
    JPanel panelVX;
    JPanel panelVY;
    JCheckBox cbMirror;
    JCheckBox cbPerspective;
    JCheckBox cbAudio;
    JCheckBox cb1;
    JCheckBox cb2;
    JRadioButton doOpNtimes;
    JRadioButton doUntilDone;
    JButton opPerform1;
    JButton opPerform2;
    JButton buStop;
    JButton buReset;
    JButton buScramble;
    JButton buSolve1;
    JButton buSolve;
    JButton buSetCube;
    JList opList1;
    JScrollPane opScrollPane;
    JTextField opTimes;
    JTextField opRepeat1;
    JLabel label1;
    JLabel lblCompleted;
    JSlider nFrameSlider;
    JLabel[] tuneLbl;
    JSlider[] tuneSlider;
    JTextField[] tuneTxt;
    JPanel eastPanel;
    JPanel opPanel;
    JPanel nFramePanel;
    Box eastBox;

    public AcubeGame(int n, cubeApp cubeApp2) {
        String string;
        this.nDIM = n;
        this.cuApp = cubeApp2;
        this.degZ = 0;
        this.degY = 30;
        this.degX = 20;
        this.incrY = 5;
        this.incrX = 5;
        this.showDirectionArrow = true;
        this.optViewPanel = false;
        this.optPerformPanel = true;
        this.optTune = true;
        this.cuApp.playAudio = true;
        if (cubeApp.freeware) {
            this.optViewPanel = false;
            this.optPerformPanel = false;
            this.optTune = false;
            this.cuApp.playAudio = false;
        }
        this.showMirroredFace = true;
        this.showPerspective = true;
        this.gameState = 0;
        if (cubeApp.mainScramble) {
            this.gameState = 6;
        }
        AcubeOpImport acubeOpImport = new AcubeOpImport("cubeOp.imp");
        String[][] stringArrayArray = new String[][]{{"Trick1", "R1>>FM< R1>>FM> "}, {"Trick2", "BN< R1< BN> R1> BN< R1< BN> R1> F1> BN< R1< BN> R1> BN< R1< BN> R1> BN< R1< BN> R1> BN< R1< BN> R1> F1< "}, {"Trick3", "B1> R1> B1< R1< B1< F1> B1> F1< R1> "}};
        this.NcubeOp = 0;
        while (this.NcubeOp < 3) {
            this.mCubeOpArr[this.NcubeOp] = new AcubeOp(stringArrayArray[this.NcubeOp][0], stringArrayArray[this.NcubeOp][1], this.nDIM, null);
            ++this.NcubeOp;
        }
        while ((string = acubeOpImport.getNextOp(this.nDIM)) != null && string != "") {
            this.mCubeOpArr[this.NcubeOp] = new AcubeOp(acubeOpImport.opName, string, this.nDIM, this.mCubeOpArr);
            ++this.NcubeOp;
        }
        this.mTrick1 = AcubeOp.getOp("Trick1", this.mCubeOpArr, this.NcubeOp);
        this.mTrick2 = AcubeOp.getOp("Trick2", this.mCubeOpArr, this.NcubeOp);
        this.mTrick3 = AcubeOp.getOp("Trick3", this.mCubeOpArr, this.NcubeOp);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.optViewPanel) {
            if (this.buViewY.equals(actionEvent.getSource())) {
                this.degY = Integer.valueOf(this.degViewY.getText());
                this.cubeCanvas.setView(0, this.degY, this.degX);
                this.cubeCanvas.repaint();
            }
            if (this.buViewX.equals(actionEvent.getSource())) {
                this.degX = Integer.valueOf(this.degViewX.getText());
                this.cubeCanvas.setView(0, this.degY, this.degX);
                this.cubeCanvas.repaint();
            }
            if (this.buIncrY.equals(actionEvent.getSource())) {
                this.incrY = Integer.valueOf(this.degIncrY.getText());
                this.degY += this.incrY;
                this.degViewY.setText(String.valueOf(this.degY));
                this.cubeCanvas.setView(0, this.degY, this.degX);
                this.cubeCanvas.repaint();
            }
            if (this.buIncrX.equals(actionEvent.getSource())) {
                this.incrX = Integer.valueOf(this.degIncrX.getText());
                this.degX += this.incrX;
                this.degViewX.setText(String.valueOf(this.degX));
                this.cubeCanvas.setView(0, this.degY, this.degX);
                this.cubeCanvas.repaint();
            }
        }
        if (this.buReset.equals(actionEvent.getSource())) {
            g.dbg(2, "buReset processed:");
            this.cubeCanvas.resetCube();
            this.incrTxtCounter(0);
            this.disableButton(false, this.buReset);
        } else if (this.buScramble.equals(actionEvent.getSource())) {
            g.dbg(2, "buScramble processed:");
            this.callScrambleCube();
            this.disableButton(false, this.buScramble);
        } else if (this.buSolve.equals(actionEvent.getSource())) {
            g.dbg(2, "buSolve processed:");
            this.callSolveCube();
            this.disableButton(true, this.buSolve);
        } else if (this.buSolve1.equals(actionEvent.getSource())) {
            g.dbg(2, "buSolve1 processed:");
            this.solveMode = 1;
            this.gameState = 1;
            this.solveState = 10;
            this.solveCube();
            this.disableButton(true, this.buSolve1);
        } else if (this.buSetCube.equals(actionEvent.getSource())) {
            g.dbg(2, "buSetCube processed:");
            this.cubeCanvas.setCube(null);
            this.disableButton(true, this.buSetCube);
        } else if (this.buStop.equals(actionEvent.getSource())) {
            g.dbg(4, "buStop processed:");
            this.solveState = 99;
            this.cubeCanvas.stopAnimation();
        } else if (this.opPerform1.equals(actionEvent.getSource())) {
            String string = (String)this.opList1.getSelectedValue();
            AcubeOp acubeOp = AcubeOp.getOp(string, this.mCubeOpArr, this.NcubeOp);
            g.dbg(3, "opPerform1: op selected=" + acubeOp.id);
            if (acubeOp == null) {
                return;
            }
            int n = this.doOpNtimes.isSelected() ? Integer.valueOf(this.opTimes.getText()) : 9999;
            this.cubeCanvas.performTrick(acubeOp, n);
            this.disableButton(true, this.opPerform1);
        } else if (this.opPerform2.equals(actionEvent.getSource())) {
            String string = (String)this.opList1.getSelectedValue();
            AcubeOp acubeOp = AcubeOp.getOp(string, this.mCubeOpArr, this.NcubeOp);
            String string2 = acubeOp.getInvOpStr();
            this.cubeCanvas.performTrick(new AcubeOp("unDoOperation", string2, this.nDIM), 1);
            this.disableButton(true, this.opPerform2);
        } else if (this.doOpNtimes.equals(actionEvent.getSource())) {
            this.doOpNtimes.setSelected(true);
        } else if (this.doUntilDone.equals(actionEvent.getSource())) {
            this.doUntilDone.setSelected(true);
        }
        Dimension dimension = this.getSize();
        this.setSize(dimension);
        this.repaint();
    }

    private void addEastPanel() {
        this.eastBox = Box.createVerticalBox();
        this.opPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.opPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.opPerform1 = new JButton("DoOperation:");
        String string = "Don't forget to Reset cube first";
        this.opPerform1.setToolTipText(string);
        this.opPerform1.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 0;
        gridBagLayout.setConstraints(this.opPerform1, gridBagConstraints);
        this.opPanel.add(this.opPerform1);
        String string2 = "perform the selected operation below in reverse";
        this.opPerform2 = new JButton("unDoOperation:");
        this.opPerform2.setToolTipText(string2);
        this.opPerform2.addActionListener(this);
        this.doOpNtimes = new JRadioButton("do Op ");
        this.doOpNtimes.setMnemonic('d');
        this.doOpNtimes.setToolTipText("Do operation N times");
        this.doOpNtimes.setSelected(true);
        this.opTimes = new JTextField("1", 2);
        gridBagLayout.setConstraints(this.opTimes, gridBagConstraints);
        JLabel jLabel = new JLabel("Times");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.doUntilDone = new JRadioButton("do Until Done; Count=");
        this.doUntilDone.setMnemonic('u');
        this.doUntilDone.setToolTipText("Do operation Until Vcube is completed");
        this.doUntilDone.setSelected(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.doUntilDone, gridBagConstraints);
        this.opRepeat1 = new JTextField("0", 3);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.opRepeat1, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.doOpNtimes);
        buttonGroup.add(this.doUntilDone);
        int n = 3;
        String[] stringArray = new String[this.NcubeOp];
        int n2 = 3;
        while (n2 < this.NcubeOp) {
            if (!this.mCubeOpArr[n2].id.substring(0, 3).equals("pre")) {
                stringArray[n++] = this.mCubeOpArr[n2].id;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < 3) {
            stringArray[n3] = this.mCubeOpArr[n3].id;
            ++n3;
        }
        int n4 = 14;
        this.opList1 = new JList<String>(stringArray);
        this.opList1.setFixedCellHeight(n4);
        this.opList1.setSelectedIndex(3);
        this.opScrollPane = new JScrollPane(this.opList1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(this.opScrollPane, gridBagConstraints);
        this.opPanel.add(this.opScrollPane);
        this.opPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), new TitledBorder("Cube Operations:")));
        this.eastBox.add(this.opPanel);
        this.nFramePanel = new JPanel();
        this.nFrameSlider = new JSlider(0, 0, Aturn.maxNframe, this.NframePerTurn);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(1), new JLabel("Fast"));
        hashtable.put(new Integer(Aturn.maxNframe), new JLabel("Slow"));
        this.nFrameSlider.setLabelTable(hashtable);
        this.nFrameSlider.setPaintLabels(true);
        this.nFrameSlider.setPaintTicks(false);
        this.nFrameSlider.setInverted(true);
        this.nFramePanel.add(this.nFrameSlider);
        this.nFramePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), new TitledBorder("Animation Speed:")));
        this.txtSpeed = new JTextField(String.valueOf(this.NframePerTurn), 2);
        this.eastBox.add(Box.createVerticalGlue());
        this.eastBox.add(this.nFramePanel);
        this.add("East", this.eastBox);
    }

    private void addSouthPanel() {
        JPanel jPanel = new JPanel();
        int n = 1;
        if (this.optViewPanel || this.optPerformPanel) {
            ++n;
        }
        jPanel.setLayout(new GridLayout(n, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 10));
        this.buReset = new JButton("Reset");
        this.buReset.addActionListener(this);
        this.buScramble = new JButton("Scramble");
        this.buScramble.addActionListener(this);
        this.buSolve = new JButton("SolveAll");
        this.buSolve.addActionListener(this);
        this.buSolve1 = new JButton("Solve1Step");
        this.buSolve1.addActionListener(this);
        this.buStop = new JButton("Stop");
        this.buStop.addActionListener(this);
        this.buSetCube = new JButton("setup cube");
        this.buSetCube.addActionListener(this);
        this.cbAudio = new JCheckBox("sound");
        this.cbAudio.setSelected(this.cuApp.playAudio);
        JButton[] jButtonArray = new JButton[]{this.buReset, this.buScramble, this.buSolve, this.buSolve1, this.buStop, this.buSetCube};
        int n2 = 0;
        while (n2 < jButtonArray.length) {
            jButtonArray[n2].setOpaque(true);
            jButtonArray[n2].setMargin(new Insets(2, 2, 2, 2));
            jPanel2.add(jButtonArray[n2]);
            ++n2;
        }
        jPanel2.add(this.cbAudio);
        jPanel2.setBorder(BorderFactory.createRaisedBevelBorder());
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        int n3 = 1;
        if (this.optViewPanel && this.optPerformPanel) {
            ++n3;
        }
        jPanel3.setLayout(new GridLayout(n3, 10));
        if (this.optViewPanel) {
            this.panelVY = new JPanel();
            this.panelVY.setLayout(new FlowLayout());
            this.buViewY = new JButton("Left View(degree)=");
            this.buViewY.addActionListener(this);
            this.panelVY.add(this.buViewY);
            this.buIncrY = new JButton("Incr");
            this.buIncrY.addActionListener(this);
            this.panelVY.add(this.degViewY);
            this.degViewY = new JTextField(String.valueOf(this.degY), 4);
            this.degViewY.addActionListener(this);
            this.panelVY.add(this.buIncrY);
            this.degIncrY = new JTextField(String.valueOf(this.incrY), 4);
            this.degIncrY.addActionListener(this);
            this.panelVY.add(this.degIncrY);
            jPanel3.add(this.panelVY);
            this.panelVX = new JPanel();
            this.panelVX.setLayout(new FlowLayout());
            this.buViewX = new JButton("Top  View(degree)=");
            this.buViewX.addActionListener(this);
            this.panelVX.add(this.buViewX);
            this.buIncrX = new JButton("Incr");
            this.buIncrX.addActionListener(this);
            this.panelVX.add(this.degViewX);
            this.degViewX = new JTextField(String.valueOf(this.degX), 4);
            this.degViewX.addActionListener(this);
            this.panelVX.add(this.buIncrX);
            this.degIncrX = new JTextField(String.valueOf(this.incrX), 4);
            this.degIncrX.addActionListener(this);
            this.panelVX.add(this.degIncrX);
            jPanel3.add(this.panelVX);
        }
        this.cbPerspective = new JCheckBox("Perspective");
        this.cbPerspective.setSelected(this.showPerspective);
        this.cbMirror = new JCheckBox("Show Mirror");
        this.cbMirror.setSelected(this.showMirroredFace);
        this.cb1 = new JCheckBox("Wave_Y/N");
        this.cb1.setSelected(true);
        this.txtCounter = new JTextField("0", 4);
        if (!cubeApp.freeware) {
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new FlowLayout());
            jPanel4.add(this.cbPerspective);
            jPanel4.add(this.cbMirror);
            jPanel4.add(this.cb1);
            jPanel4.add(this.txtCounter);
            jPanel3.add(jPanel4);
            this.cbMirror.addItemListener(this);
            this.cbPerspective.addItemListener(this);
            this.cb1.addItemListener(this);
        }
        this.cbAudio.addItemListener(this);
        if (this.optViewPanel || this.optPerformPanel) {
            jPanel.add(jPanel3);
        }
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.add("South", jPanel);
    }

    private void addWestPanel() {
        if (this.optTune) {
            int n = 3;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(n * 2, 1));
            this.tuneLbl = new JLabel[n];
            this.tuneSlider = new JSlider[n];
            this.tuneTxt = new JTextField[n];
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray2[n2] = 50;
                nArray[n2] = 0;
                nArray3[n2] = 100;
                ++n2;
            }
            nArray2[0] = this.banner1.sleepMs;
            nArray[0] = 0;
            nArray3[0] = 100;
            nArray2[1] = this.banner1.nPixPerSec;
            nArray[1] = 0;
            nArray3[1] = 100;
            nArray2[2] = this.msPause;
            nArray[2] = 0;
            nArray3[2] = 100;
            int n3 = 0;
            while (n3 < n) {
                this.tuneLbl[n3] = new JLabel("tune" + n3);
                this.tuneSlider[n3] = new JSlider(0, nArray[n3], nArray3[n3], nArray2[n3]);
                this.tuneSlider[n3].setMajorTickSpacing(10);
                this.tuneSlider[n3].setPaintTicks(true);
                this.tuneSlider[n3].setPaintLabels(true);
                this.tuneSlider[n3].setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
                this.tuneSlider[n3].addChangeListener(this);
                jPanel.add(this.tuneSlider[n3]);
                this.tuneTxt[n3] = new JTextField(String.valueOf(nArray2[n3]), 3);
                jPanel.add(this.tuneTxt[n3]);
                ++n3;
            }
        }
    }

    public void callScrambleCube() {
        this.cubeCanvas.scrambleCube();
        this.incrTxtCounter(0);
    }

    public void callSolveCube() {
        this.solveMode = 2;
        this.gameState = 1;
        this.solveState = 10;
        this.incrTxtCounter(0);
        this.solveCube();
    }

    private void disableButton(boolean bl, Component component) {
        if (bl) {
            this.buReset.setEnabled(false);
            this.buSolve1.setEnabled(false);
            this.buScramble.setEnabled(false);
            this.opPerform1.setEnabled(false);
            this.buSolve.setEnabled(false);
            this.opPerform2.setEnabled(false);
            this.buStop.setEnabled(false);
            this.buSetCube.setEnabled(false);
        } else {
            this.buReset.setEnabled(true);
            this.buSolve1.setEnabled(true);
            this.buScramble.setEnabled(true);
            this.opPerform1.setEnabled(true);
            this.buSolve.setEnabled(true);
            this.opPerform2.setEnabled(true);
            this.buStop.setEnabled(true);
            if (cubeApp.freeware && this.nDIM == 2) {
                this.buSetCube.setEnabled(true);
            }
        }
        if (component != this.buSetCube) {
            this.buStop.setEnabled(true);
        }
    }

    public int getTxtCounter() {
        int n = Integer.valueOf(this.txtCounter.getText());
        return n;
    }

    public void incrOpRepeat1(int n) {
        if (n == 0) {
            this.opRepeat1.setText("0");
        } else {
            int n2 = Integer.valueOf(this.opRepeat1.getText());
            g.dbg(0, "incrOpRepeat1: " + ++n2);
            this.opRepeat1.setText(String.valueOf(n2));
        }
    }

    public void incrTxtCounter(int n) {
        if (n == 0) {
            this.txtCounter.setText("0");
        } else {
            int n2 = Integer.valueOf(this.txtCounter.getText());
            g.dbg(0, "txtCounter: " + ++n2);
            this.txtCounter.setText(String.valueOf(n2));
        }
    }

    public void init() {
        g.dbg(2, "AcubeGame.init " + this.getSize());
        this.setLayout(new BorderLayout());
        this.banner1 = new movingBanner(new String(cubeApp.VCBANNER), new Font("Bookman Old Style", 0, 9), this);
        this.banner1.addBannerStr(new String(cubeApp.VCBANNER1));
        this.add("North", this.banner1);
        this.cubeCanvas = new AcubeCanvas(this.nDIM, this.showMirroredFace, this.showPerspective, this);
        this.cubeInfo = new AcubeInfo(this.cubeCanvas.cube, this.cubeCanvas.cell, this.nDIM);
        this.cubeCanvas.setBorder(BorderFactory.createRaisedBevelBorder());
        this.add("Center", this.cubeCanvas);
        this.addEastPanel();
        this.addSouthPanel();
        this.addWestPanel();
        this.banner1.init();
        if (cubeApp.freeware) {
            this.cbAudio.setEnabled(false);
            this.cbAudio.setToolTipText(notAvail);
        }
        this.nFrameSlider.addChangeListener(this);
        if (cubeApp.freeware && this.nDIM > 2) {
            this.buSetCube.setEnabled(false);
            this.buSetCube.setToolTipText(notAvail);
        }
        if (cubeApp.freeware && this.nDIM >= 4) {
            this.NframePerTurn = 4;
            this.nFrameSlider.setEnabled(false);
            this.nFrameSlider.setToolTipText(notAvail);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.cbAudio.equals(itemEvent.getSource())) {
            g.dbg(2, "AcubeGame.itemStateChanged. cuApp.playAudio=" + this.cuApp.playAudio);
            this.cuApp.playAudio = this.cbAudio.isSelected();
            g.dbg(2, "AcubeGame.itemStateChanged. cuApp.playAudio=" + this.cuApp.playAudio);
        } else if (this.cbMirror.equals(itemEvent.getSource())) {
            this.showMirroredFace = this.cbMirror.isSelected();
            this.cubeCanvas.setOptMirror(this.showMirroredFace);
        } else if (!this.cb1.equals(itemEvent.getSource()) && this.cbPerspective.equals(itemEvent.getSource())) {
            this.showPerspective = this.cbPerspective.isSelected();
            this.cubeCanvas.setOptPerspective(this.showPerspective);
        }
    }

    public void paintComponent(Graphics graphics) {
        g.dbg(0, "AcubeGame.paintComponent: opList1=" + this.opList1);
        super.paintComponent(graphics);
    }

    public void resetTextFields() {
        this.degY = 30;
        this.degX = 20;
        this.incrY = 5;
        this.incrX = 5;
        this.degViewX.setText(String.valueOf(this.degX));
        this.degIncrX.setText(String.valueOf(this.incrX));
        this.degViewY.setText(String.valueOf(this.degY));
        this.degIncrY.setText(String.valueOf(this.incrY));
    }

    public void resize() {
        Dimension dimension = this.getSize();
        g.dbg(2, "AcubeGame.resize: nDIM=" + this.nDIM + "; size=" + dimension);
        g.dbg(0, "AcubeGame.resize: nDIM=" + this.nDIM + "; eastBox.size=" + this.eastBox.getSize());
        g.dbg(0, "AcubeGame.resize: nDIM=" + this.nDIM + "; opScrollPane.getViewSize=" + this.opScrollPane.getViewport().getViewSize());
        g.dbg(0, "AcubeGame.resize: nDIM=" + this.nDIM + "; nFramePanel.size=" + this.nFramePanel.getSize());
        g.dbg(0, "              ");
        int n = dimension.width / 4 - 6;
        Dimension dimension2 = this.opScrollPane.getVerticalScrollBar().getSize();
        g.dbg(0, "AcubeGame.resize: nDIM=" + this.nDIM + "; getVerticalScrollBar.size=" + dimension2);
        this.opList1.setFixedCellWidth(n - dimension2.width);
        this.opList1.revalidate();
        dimension2 = this.nFrameSlider.getSize();
        dimension2.width = n;
        if (dimension2.height < 54) {
            dimension2.height = 54;
        }
        this.nFrameSlider.setPreferredSize(dimension2);
        this.nFrameSlider.revalidate();
        dimension2 = this.opPerform1.getSize();
        dimension2.width = n;
        if (dimension2.height < 27) {
            dimension2.height = 27;
        }
        this.opPerform1.setPreferredSize(dimension2);
        this.opPerform1.revalidate();
        this.nFramePanel.revalidate();
        dimension2 = this.opScrollPane.getViewport().getViewSize();
        dimension2.width = n;
        if (dimension2.height < n * 7 / 4) {
            dimension2.height = n * 7 / 4;
        }
        this.opScrollPane.getViewport().setViewSize(dimension2);
        this.opScrollPane.revalidate();
        this.opScrollPane.validate();
        this.opScrollPane.repaint();
        this.eastBox.invalidate();
        this.eastBox.validate();
        this.eastBox.repaint();
        super.validate();
    }

    public void run() {
        int n = 0;
        Dimension dimension = this.getSize();
        g.dbg(2, "AcubeGame.run:                        ");
        while (this.cubethread != null && dimension.width <= 0) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
            dimension = this.getSize();
            g.dbg(2, "AcubeGame.run: nDIM=" + this.nDIM + "; size=" + dimension + ++n);
        }
        this.resize();
        g.dbg(2, "AcubeGame.run: nDIM=" + this.nDIM + "; size=" + dimension);
        if (this.cubethread != null) {
            this.banner1.start();
        }
        while (this.cubethread != null) {
            if (this.cubethreadState == 2) {
                this.banner1.setThreadState(0);
                try {
                    AcubeGame acubeGame = this;
                    synchronized (acubeGame) {
                        while (this.cubethreadState == 2) {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            long l = System.currentTimeMillis();
            switch (this.gameState) {
                case 2: {
                    this.cubeCanvas.animateTrick(this.gameState);
                    break;
                }
                case 3: {
                    this.solveCube();
                    break;
                }
                case 6: {
                    this.callScrambleCube();
                    this.callSolveCube();
                    this.gameState = 0;
                    break;
                }
                default: {
                    g.abort("unexpected gameState=" + this.gameState);
                }
                case 0: 
                case 1: 
                case 4: 
            }
            long l2 = System.currentTimeMillis();
            int n2 = this.msPause - (int)(l2 - l);
            if (n2 < 0) {
                g.dbg(0, "AcubeGame.run: t1-t0=" + (l2 - l));
                n2 = 0;
            }
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setGameState(int n) {
        this.gameState = n;
        if (this.gameState == 0) {
            this.disableButton(false, null);
        }
    }

    public synchronized void setThreadState(int n) {
        this.cubethreadState = n;
        this.notify();
    }

    public void solveCube() {
        g.dbg(3, "AcubeGame.solveCube: solveState=================" + this.solveState);
        switch (this.solveState) {
            case 10: {
                this.startTime = System.currentTimeMillis();
                g.dbg(0, "AcubeGame.solveCube: startTime=================" + this.startTime);
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                this.gameState = 3;
                if (this.cubeInfo.NbadCorners == 0) {
                    this.solveState = 40;
                    break;
                }
                String string = this.cubeInfo.bestFace();
                g.dbg(2, "AcubeGame.solveCube: bestFaceId=" + this.cubeInfo.bestFaceId);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 14;
                    this.cubeCanvas.performRotate("rotate2Top", string);
                }
                this.solveState = 14;
                break;
            }
            case 14: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                int n = this.cubeInfo.locateBadCornerCellid();
                String string = "";
                if (n < 0) {
                    this.solveState = 20;
                    break;
                }
                string = n == this.cubeInfo.cornerCellId[2] ? "" : (n == this.cubeInfo.cornerCellId[0] ? String.valueOf(string) + "BN>>" : (n == this.cubeInfo.cornerCellId[1] ? String.valueOf(string) + "BN> " : String.valueOf(string) + "BN< "));
                g.dbg(2, "solveCube.S14TOPCORNER: opStr=" + string);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 18;
                    this.cubeCanvas.performTrick(new AcubeOp("topTurn", string, this.nDIM), 1);
                }
                this.solveState = 18;
                break;
            }
            case 18: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                String string = this.cubeInfo.moveToRTF();
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = this.solveMode == 2 ? 14 : 99;
                    this.cubeCanvas.performTrick(new AcubeOp("toRTF", string, this.nDIM), 1);
                }
                this.solveState = 99;
                if (this.solveMode != 2) break;
                this.solveState = 14;
                break;
            }
            case 20: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                if (this.cubeInfo.NbadCorners == 0) {
                    this.solveState = 40;
                    break;
                }
                this.gameStatePrev = 3;
                this.solveStateNext = 22;
                this.cubeCanvas.performRotate("rotate2Left", "F*< ");
                break;
            }
            case 22: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                String string = this.cubeInfo.trick3Info(1);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 23;
                    this.cubeCanvas.performTrick(new AcubeOp("trick3cor", string, this.nDIM), 1);
                }
                this.solveState = 23;
                break;
            }
            case 23: {
                String string = this.cubeInfo.preTrick3Move;
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 24;
                    this.cubeCanvas.performTrick(new AcubeOp("preTrick3", string, this.nDIM), 1);
                }
                this.solveState = 24;
                break;
            }
            case 24: {
                if (this.cubeInfo.bTrick3Move) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 25;
                    this.cubeCanvas.performTrick(this.mTrick3, 1);
                }
                this.solveState = 25;
                break;
            }
            case 25: {
                String string = AcubeOp.invOpStr(this.cubeInfo.preTrick3Move);
                string = this.cubeInfo.postTrick3Move;
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 28;
                    this.cubeCanvas.performTrick(new AcubeOp("postTrick3", string, this.nDIM), 1);
                }
                this.solveState = 28;
                break;
            }
            case 28: {
                if (this.cubeInfo.trick1Ready()) {
                    this.solveState = 60;
                    break;
                }
                this.gameStatePrev = 3;
                this.solveStateNext = 30;
                this.cubeCanvas.performRotate("rotateR2T", "F*< ");
                break;
            }
            case 30: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                this.cubeInfo.trick2Info(3);
                if (!this.cubeInfo.bTrick2Move) {
                    this.solveState = 40;
                    break;
                }
                this.solveState = 31;
                break;
            }
            case 31: {
                if (this.cubeInfo.preTrick2Rotate.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 35;
                    this.cubeCanvas.performRotate("preTrick2Rotate", this.cubeInfo.preTrick2Rotate);
                }
                this.solveState = 35;
                break;
            }
            case 35: {
                String string = this.cubeInfo.preTrick2Move;
                if (string.length() > 0) {
                    g.dbg(2, "solveCube: solvestate=35; preTrick2Move=" + this.cubeInfo.preTrick2Move);
                    this.gameStatePrev = 3;
                    this.solveStateNext = 36;
                    this.cubeCanvas.performTrick(new AcubeOp("preTrick2", string, this.nDIM), 1);
                }
                this.solveState = 36;
                break;
            }
            case 36: {
                this.gameStatePrev = 3;
                this.solveStateNext = 37;
                this.cubeCanvas.performTrick(this.mTrick2, 1);
                break;
            }
            case 37: {
                String string = this.cubeInfo.postTrick2Move;
                if (string.length() > 0) {
                    g.dbg(2, "solveCube: solvestate=37; postTrick2Move=" + this.cubeInfo.postTrick2Move);
                    this.gameStatePrev = 3;
                    this.solveStateNext = 38;
                    this.cubeCanvas.performTrick(new AcubeOp("postTrick3", string, this.nDIM), 1);
                }
                this.solveState = 38;
                break;
            }
            case 38: {
                if (this.cubeInfo.postTrick2Rotate.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 99;
                    if (this.solveMode == 2) {
                        this.solveStateNext = 30;
                    }
                    this.cubeCanvas.performRotate("postTrick2Rotate", this.cubeInfo.postTrick2Rotate);
                }
                this.solveState = 99;
                if (this.solveMode != 2) break;
                this.solveState = 30;
                break;
            }
            case 40: {
                if (this.nDIM <= 3) {
                    this.solveState = 60;
                    break;
                }
                this.cubeInfo.setInfo();
                int n = this.cubeInfo.bestTopFace();
                String string = this.cubeInfo.opRotateStr;
                g.dbg(2, "---------SOLVESTATE40TOP: opStr=" + string);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 41;
                    if (n == 1) {
                        this.solveStateNext = 45;
                    }
                    this.cubeCanvas.performTrick(new AcubeOp("bestTopFace", string, this.nDIM), 1);
                }
                this.solveState = 41;
                if (n != 1) break;
                this.solveState = 45;
                break;
            }
            case 41: {
                this.cubeInfo.setInfo();
                int n = this.cubeInfo.makeCenterEdge(3);
                String string = this.cubeInfo.opRotateStr;
                if (n == 1) {
                    string = String.valueOf(string) + "R*< ";
                }
                g.dbg(2, "---------S41TOPCENTER: rc=" + n + ";opStr=" + string);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = n == 1 ? 45 : 42;
                    this.cubeCanvas.performTrick(new AcubeOp("topCenterRot", string, this.nDIM), 1);
                }
                if (n == 1) {
                    this.solveState = 45;
                    break;
                }
                this.solveState = 42;
                break;
            }
            case 42: {
                this.cubeInfo.setInfo();
                int n = this.cubeInfo.centerEdgeX();
                String string = this.cubeInfo.opTurnStr;
                g.dbg(2, "---------S42CENTEREDGEX: rc=" + n + ";opStr=" + string);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 99;
                    if (this.solveMode == 2) {
                        this.solveStateNext = 41;
                    }
                    this.cubeCanvas.performTrick(new AcubeOp("centerEdgeX", string, this.nDIM, this.mCubeOpArr), 1);
                }
                if (n == 1) {
                    this.solveState = 45;
                    break;
                }
                this.solveState = 99;
                if (this.solveMode != 2) break;
                this.solveState = 41;
                break;
            }
            case 45: {
                this.cubeInfo.setInfo();
                if (this.cubeInfo.NbadCorners != 0) {
                    g.abort("solveCube: solvestate=45; #badCorners=" + this.cubeInfo.NbadCorners);
                }
                if (this.cubeInfo.Nedge_nonT1 == 0) {
                    this.solveState = 50;
                    break;
                }
                String string = this.cubeInfo.locateBadFROEdge();
                g.dbg(2, "---------SOLVESTATE45EDGE: opStr=" + string);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 46;
                    this.cubeCanvas.performTrick(new AcubeOp("badFROEdge", string, this.nDIM), 1);
                }
                this.solveState = 46;
                break;
            }
            case 46: {
                this.cubeInfo.setInfo();
                int n = this.cubeInfo.makeT1edge();
                String string = this.cubeInfo.opTurnStr;
                g.dbg(2, "---------S46MAKET1EDGE1: rc=" + n + ";opStr=" + string);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = n == 0 ? 46 : (n == 1 ? 47 : 48);
                    this.cubeCanvas.performTrick(new AcubeOp("makeT1Edge", string, this.nDIM, this.mCubeOpArr), 1);
                }
                if (n == 0) {
                    this.solveState = 46;
                    break;
                }
                if (n == 1) {
                    this.solveState = 47;
                    break;
                }
                this.solveStateNext = 48;
                break;
            }
            case 47: {
                String string = "RN< (Trick1)RN> ";
                this.gameStatePrev = 3;
                this.solveStateNext = 99;
                if (this.solveMode == 2) {
                    this.solveStateNext = 45;
                }
                this.cubeCanvas.performTrick(new AcubeOp("edgeTrick1", string, this.nDIM, this.mCubeOpArr), 1);
                this.solveState = 99;
                if (this.solveMode != 2) break;
                this.solveState = 45;
                break;
            }
            case 48: {
                this.cubeInfo.setInfo();
                int n = this.cubeInfo.makeLast4T1edges();
                String string = this.cubeInfo.opTurnStr;
                g.dbg(2, "---------S48CENTERS: rc=" + n + ";opStr=" + string);
                if (n == 1) {
                    this.solveState = 99;
                    if (this.solveMode != 2) break;
                    this.solveState = 50;
                    break;
                }
                this.gameStatePrev = 3;
                this.solveStateNext = 48;
                this.cubeCanvas.performTrick(new AcubeOp("last4T1edge", string, this.nDIM, this.mCubeOpArr), 1);
                this.solveState = 48;
                break;
            }
            case 50: {
                this.cubeInfo.setInfo();
                int n = this.cubeInfo.setStarFace();
                if (n == 0) {
                    this.solveState = 40;
                    break;
                }
                this.solveState = 60;
                break;
            }
            case 60: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                String string = this.cubeInfo.moveCenterSlice(3);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 62;
                    this.cubeCanvas.performTrick(new AcubeOp("topCenter", string, this.nDIM), 1);
                }
                this.solveState = 62;
                break;
            }
            case 62: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                String string = this.cubeInfo.moveCenterSlice(1);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 80;
                    this.cubeCanvas.performTrick(new AcubeOp("rightCenter", string, this.nDIM), 1);
                }
                this.solveState = 80;
                break;
            }
            case 80: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                this.cubeInfo.trick1Init();
                if (!this.cubeInfo.trick1Ready()) {
                    g.dbg(9, "******************solveCube: SOLVESTATE80T1: trick1 not ready");
                    this.solveState = 10;
                    break;
                }
                if (this.cubeInfo.Nedge_good == 12) {
                    this.solveState = 99;
                    break;
                }
                String string = this.cubeInfo.trick1Rotate();
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 82;
                    this.cubeCanvas.performRotate("Trick1Rotate", string);
                }
                this.solveState = 82;
                break;
            }
            case 82: {
                this.cubeInfo.setInfo();
                int n = this.cubeInfo.trick1Top();
                if (n != 0) {
                    this.solveState = 90;
                    break;
                }
                String string = this.cubeInfo.opTrick1Top;
                g.dbg(2, "cubeApp.trick1Top=" + string);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 84;
                    this.cubeCanvas.performTrick(new AcubeOp("Trick1Top", string, this.nDIM), 1);
                }
                this.solveState = 84;
                break;
            }
            case 84: {
                this.cubeInfo.setInfo();
                int n = this.cubeInfo.trick1Bac();
                String string = this.cubeInfo.opPreTrick1;
                if (n != 0) {
                    this.solveState = 90;
                    break;
                }
                g.dbg(3, "cubeApp.trick1Bac=" + string);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 86;
                    this.cubeCanvas.performTrick(new AcubeOp("preTrick1", string, this.nDIM), 1);
                }
                this.solveState = 86;
                break;
            }
            case 86: {
                this.gameStatePrev = 3;
                this.solveStateNext = 88;
                this.cubeCanvas.performTrick(this.mTrick1, 1);
                break;
            }
            case 88: {
                String string = AcubeOp.invOpStr(this.cubeInfo.opPreTrick1);
                string = String.valueOf(string) + AcubeOp.invOpStr(this.cubeInfo.opTrick1Top);
                g.dbg(2, "cubeApp.trick1pos=" + string);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = this.solveMode == 2 ? 80 : 99;
                    this.cubeCanvas.performTrick(new AcubeOp("posTrick1", string, this.nDIM), 1);
                }
                this.solveState = 99;
                if (this.solveMode == 2) {
                    this.solveState = 80;
                }
                g.dbg(2, "cubeApp.S88TRICK1POS: Nedge_nonT1,T1=" + this.cubeInfo.Nedge_nonT1 + "," + this.cubeInfo.Nedge_T1);
                break;
            }
            case 90: {
                this.cubeInfo.setInfo();
                int n = this.cubeInfo.handleLast2Edge();
                String string = this.cubeInfo.opTurnStr;
                g.dbg(2, "cubeApp.handleLast2Edge=" + string);
                if (string.length() > 0) {
                    this.gameStatePrev = 3;
                    this.solveStateNext = 99;
                    if (this.solveMode == 2) {
                        if (n == 12) {
                            this.solveStateNext = 45;
                        } else if (n == 13) {
                            this.solveStateNext = 40;
                        } else if (n == 11) {
                            this.solveStateNext = 80;
                        } else {
                            g.abort("solveCube -90: invalide rc from handleLast2Edge=" + n);
                        }
                    }
                    this.cubeCanvas.performTrick(new AcubeOp("handleQuarks", string, this.nDIM, this.mCubeOpArr), 1);
                }
                this.solveState = 99;
                if (n == 12) {
                    this.solveState = 45;
                    break;
                }
                if (n == 13) {
                    this.solveState = 40;
                    break;
                }
                if (n == 11) {
                    this.solveState = 80;
                    break;
                }
                g.abort("solveCube -90: invalide rc from handleLast2Edge=" + n);
                break;
            }
            case 99: {
                this.cubeInfo.setInfo();
                this.cubeCanvas.setInfoLines(this.cubeInfo);
                g.dbg(2, "cubeApp.SOLVESTATE99: Nedge_nonT1,T1=" + this.cubeInfo.Nedge_nonT1 + "," + this.cubeInfo.Nedge_T1);
                this.endTime = System.currentTimeMillis();
                g.dbg(3, "cubeApp.SOLVESTATE99: endTime  =" + this.endTime + " ms");
                g.dbg(3, "cubeApp.SOLVESTATE99: startTime=" + this.startTime + " ms");
                g.dbg(3, "cubeApp.SOLVESTATE99: duration =" + (this.endTime - this.startTime) + " ms");
                this.solveState = 10;
                this.setGameState(0);
                this.gameStatePrev = 0;
                int n = this.cubeCanvas.solved(this.cubeInfo);
                if (n <= 0) break;
                g.dbg(2, "cubeApp.SOLVESTATE99: Nmove=" + n);
                break;
            }
        }
    }

    public void start() {
        if (this.cubethread == null) {
            this.cubethread = new Thread(this);
            g.dbg(2, "AcubeGame.start: thread current priority=" + this.cubethread.getPriority() + ",max=" + this.cubethread.getThreadGroup().getMaxPriority());
            this.cubethread.setPriority(10);
            g.dbg(2, "AcubeGame.start: thread new priority=" + this.cubethread.getPriority());
            this.banner1.start();
            this.cubethread.start();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        g.dbg(0, "stateChanged: ChangeEvent=" + changeEvent);
        if (this.nFrameSlider.equals(changeEvent.getSource())) {
            this.NframePerTurn = this.nFrameSlider.getValue();
            if (this.NframePerTurn <= 0) {
                this.NframePerTurn = 1;
            }
            g.dbg(3, "nFrameSlider, NframePerTurn=" + this.NframePerTurn);
            this.txtSpeed.setText(String.valueOf(this.NframePerTurn));
            this.nFrameSlider.invalidate();
            this.validate();
        } else {
            int n = 0;
            while (n < this.tuneSlider.length) {
                if (this.tuneSlider[n].equals(changeEvent.getSource())) {
                    g.dbg(3, "handle tuneSlider, i=" + n);
                    int n2 = this.tuneSlider[n].getValue();
                    this.tuneTxt[n].setText(String.valueOf(n2));
                    if (n == 0) {
                        this.banner1.sleepMs = n2;
                    }
                    if (n == 1) {
                        this.banner1.nPixPerSec = n2;
                    }
                    if (n < 2) {
                        this.banner1.setTransient();
                    }
                    if (n == 2) {
                        this.msPause = n2;
                    }
                    this.tuneSlider[n].repaint();
                }
                ++n;
            }
        }
    }

    public void stop() {
        this.cubethread = null;
    }
}

