/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Random;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AcubeCanvas
extends JPanel
implements MouseListener,
MouseMotionListener {
    int nDIM;
    int nDIM3;
    int nDIM3_1;
    int nDIM2;
    int nDIM_1;
    AcubeLet[] cube;
    private int[][] colorIdArr;
    Apoint cubeCenter;
    int[] cell;
    int[] cell0;
    AcubeFrame cubeFrame;
    AcubeGame cuGame;
    boolean optDrawCubeId = false;
    boolean optShowMirror;
    boolean optShowMirror0;
    boolean optShowArrow;
    Aturn mRotateCubeTurn;
    Aturn mSliceCubeTurn;
    int[] mSliceCubeId;
    int[] mSliceCubeId0;
    int mSliceCubeIdLen;
    int mSliceCubeId0Len;
    AcubeOp mTrickOp;
    int mTrickNrepeat;
    String[] infoLine = new String[3];
    private long startTime;
    private long endTime;
    private long totalDrawTime;
    private boolean forceReDraw;
    private int toggle;
    static int fudgeFactor = 150;
    Point prevMpos = null;
    Amatx prevMatrix = new Amatx();
    private int cState;
    private int prevCState;
    static final int STATE_0 = 0;
    static final int STATE_ROTATE_INIT = 1;
    static final int STATE_VIEW = 2;
    static final int STATE_ROTATE = 3;
    static final int STATE_ANIMATE = 4;
    static final int STATE_SETCUBE_INIT = 5;
    static final int STATE_SETCUBE = 6;
    static final int STATE_SETCUBE_ROTATE = 7;
    private int mState;
    private int prevMState;
    static final int MOUSE_0 = 0;
    static final int MOUSE_PRESSED = 1;
    static final int MOUSE_MOTION = 2;
    static final int MOUSE_RELEASED = 3;
    static final int MOUSE_CLICKED = 4;
    boolean painted;
    Image offscreen = null;
    Image animateScreen = null;
    Dimension offscreensize;
    Dimension animateScreenSize;
    Graphics offgraphics;
    Graphics animateGraphics;
    Aface[][] mirrorFace;
    Areflection reflectX;
    Areflection reflectY;
    Areflection reflectZ;
    A322d a322d;
    A322d a322d0;
    static Color[] colorArr = new Color[8];
    static String[] cName = new String[8];
    private AcolorPanel colPanel;
    static final String auReset = "au/gong.au";
    static final String auScramble = "au/computer.au";
    static final String auSolved = "au/yahoo1.au";
    static final String[] auAnimateTrick;

    static {
        AcubeCanvas.colorArr[0] = Color.red;
        AcubeCanvas.cName[0] = "red";
        AcubeCanvas.colorArr[1] = new Color(255, 160, 0);
        AcubeCanvas.cName[1] = "orange";
        AcubeCanvas.colorArr[2] = Color.white;
        AcubeCanvas.cName[2] = "white";
        AcubeCanvas.colorArr[3] = Color.blue;
        AcubeCanvas.cName[3] = "blue";
        AcubeCanvas.colorArr[4] = Color.yellow;
        AcubeCanvas.cName[4] = "yellow";
        AcubeCanvas.colorArr[5] = Color.green.darker();
        AcubeCanvas.cName[5] = "green";
        AcubeCanvas.colorArr[6] = Color.black;
        AcubeCanvas.cName[6] = "black";
        AcubeCanvas.colorArr[7] = Color.gray;
        AcubeCanvas.cName[6] = "gray";
        auAnimateTrick = new String[]{"au/0.au", "au/1.au", "au/2.au", "au/3.au", "au/4.au", "au/5.au", "au/6.au", "au/7.au", "au/8.au", "au/9.au", "au/drip.au", "au/chirp1.au", "au/ding.au", "au/ip.au", "au/ip.au"};
    }

    public AcubeCanvas(int n, boolean bl, boolean bl2, AcubeGame acubeGame) {
        this.nDIM = n;
        this.nDIM3 = n * n * n;
        this.nDIM3_1 = this.nDIM3 - 1;
        this.nDIM2 = n * n;
        this.nDIM_1 = n - 1;
        this.optShowMirror = bl;
        this.optShowMirror0 = bl;
        this.cuGame = acubeGame;
        this.cubeCenter = new Apoint(0.5 * (double)n, 0.5 * (double)n, 0.5 * (double)n);
        Apoint apoint = new Apoint(this.cubeCenter);
        apoint.times(fudgeFactor);
        this.a322d = new A322d(apoint);
        this.a322d0 = new A322d(apoint);
        this.a322d.perspective = bl2;
        this.a322d0.perspective = bl2;
        this.reflectX = new Areflection(0, (double)(-this.nDIM) * 0.3);
        this.reflectY = new Areflection(1, (double)(-this.nDIM) * 0.2);
        this.reflectZ = new Areflection(2, (double)(-this.nDIM) * 0.65);
        this.reflectZ = new Areflection(2, (double)(-this.nDIM) * 0.85);
        this.cube = new AcubeLet[this.nDIM3];
        this.colorIdArr = new int[this.nDIM * this.nDIM * this.nDIM][3];
        int n2 = 0;
        while (n2 < this.nDIM3) {
            this.cube[n2] = new AcubeLet(n2, this.nDIM);
            ++n2;
        }
        this.cell = new int[this.nDIM3];
        this.cell0 = new int[this.nDIM3];
        this.mirrorFace = new Aface[6][this.nDIM3];
        int n3 = 0;
        while (n3 < 6) {
            int n4 = 0;
            while (n4 < this.nDIM3) {
                this.mirrorFace[n3][n4] = new Aface();
                ++n4;
            }
            ++n3;
        }
        this.cubeInit(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.cubeFrame = new AcubeFrame(this.nDIM);
        this.mSliceCubeId = new int[this.nDIM3];
        this.mSliceCubeId0 = new int[this.nDIM3];
        this.forceReDraw = false;
        this.optShowArrow = true;
        this.optDrawCubeId = false;
        this.setCState(0);
        this.mState = 0;
        this.prevMState = 0;
    }

    public synchronized void animateTrick(int n) {
        g.dbg(0, "animateTrick:gamestate=" + n);
        int n2 = (int)(Math.random() * (double)auAnimateTrick.length);
        if (n == 1) {
            this.setGameState(2);
            this.setCState(4);
            if (this.mTrickNrepeat == 9999) {
                this.copyCellArray();
            }
            this.cuGame.incrOpRepeat1(0);
            this.savePrevState();
            this.mSliceCubeTurn = this.mTrickOp.nextTurn(0);
            this.setmSliceCubeId();
            this.drawSubCube0();
            this.cuGame.cuApp.auPlay(auAnimateTrick[n2]);
            return;
        }
        if (n != 2) {
            return;
        }
        g.dbg(0, "animateTrick:mSliceCubeTurn=" + this.mSliceCubeTurn.turnStr);
        int n3 = this.mSliceCubeTurn.incrDeg(this.cuGame.NframePerTurn);
        Graphics graphics = this.getGraphics();
        g.dbg(0, "AcubeCanvas.animateTrick:" + n + ";deg=" + n3);
        if (n3 > 0) {
            long l = System.currentTimeMillis();
            this.offgraphics.drawImage(this.animateScreen, 0, 0, null);
            this.a322d.setRotationMatrix(this.mSliceCubeTurn.turnAxis, -this.mSliceCubeTurn.clockwise * n3);
            this.drawSubCube(this.offgraphics);
            this.displayInfoLines(this.offgraphics);
            graphics.drawImage(this.offscreen, 0, 0, null);
            long l2 = System.currentTimeMillis() - l;
            this.totalDrawTime += l2;
            g.dbg(0, "AcubeCanvas.animateTrick: drawTime=" + l2 + " tot=" + this.totalDrawTime);
        } else {
            this.restorePrevState();
            this.logicalSliceOp();
            this.cuGame.incrTxtCounter(1);
            this.mSliceCubeTurn = this.mTrickOp.nextTurn(1);
            if (this.mSliceCubeTurn == null) {
                this.cuGame.incrOpRepeat1(1);
                if (this.mTrickNrepeat == 9999) {
                    if (this.isDone()) {
                        System.gc();
                        this.endTime = System.currentTimeMillis();
                        g.dbg(4, "AcubeCanvas.animateTrick: endTime  =" + this.endTime + " ms");
                        g.dbg(4, "AcubeCanvas.animateTrick: startTime=" + this.startTime + " ms");
                        g.dbg(4, "AcubeCanvas.animateTrick: duration =" + (this.endTime - this.startTime) + " ms");
                        g.dbg(4, "AcubeCanvas.animateTrick: drawTime =" + this.totalDrawTime + " ms");
                        g.dbg(4, "AcubeCanvas.animateTrick: drawTime/total=" + (double)this.totalDrawTime * 100.0 / (double)(this.endTime - this.startTime) + " %");
                        this.setGameState(0);
                        this.setCState(0);
                        this.forceReDraw = true;
                        this.repaint();
                    } else {
                        this.savePrevState();
                        this.mSliceCubeTurn = this.mTrickOp.nextTurn(0);
                        this.setmSliceCubeId();
                        this.drawSubCube0();
                    }
                } else {
                    --this.mTrickNrepeat;
                    if (this.mTrickNrepeat > 0) {
                        this.savePrevState();
                        this.mSliceCubeTurn = this.mTrickOp.nextTurn(0);
                        this.setmSliceCubeId();
                        this.drawSubCube0();
                    } else {
                        if (this.cuGame.gameStatePrev == 3) {
                            g.dbg(2, "animateTrick: gameStatePrev=" + this.cuGame.gameStatePrev + ";solvestate=" + this.cuGame.solveState);
                            this.setGameState(this.cuGame.gameStatePrev);
                            this.setSolveState(this.cuGame.solveStateNext);
                            this.setCState(0);
                        } else {
                            this.setGameState(0);
                            this.setCState(0);
                        }
                        this.forceReDraw = true;
                        this.repaint();
                        if (this.isComplete()) {
                            this.cuGame.cuApp.auPlay(auSolved);
                        }
                    }
                }
            } else {
                this.savePrevState();
                this.setmSliceCubeId();
                this.drawSubCube0();
                this.cuGame.cuApp.auPlay(auAnimateTrick[n2]);
            }
        }
    }

    private void colorCubeFace(Point point) {
        Graphics graphics;
        Aface aface;
        int n;
        int n2 = -1;
        AfaceLet afaceLet = this.cubeFrame.faceLetContaining(point, this.a322d0, false);
        if (afaceLet != null) {
            n2 = afaceLet.cellId(this.nDIM);
            n = afaceLet.faceCode;
        } else {
            n = -1;
            int n3 = 0;
            while (n3 < 6) {
                n2 = this.mirrorFaceContaining(point, this.a322d0, n3);
                if (n2 != -1) {
                    n = n3;
                    break;
                }
                n3 += 2;
            }
            if (n == -1) {
                return;
            }
            aface = this.mirrorFace[n][n2];
            aface.colorcode = this.colPanel.selectedColorPaneId;
            graphics = this.getGraphics();
            this.drawFace3D(graphics, aface, 0, true);
        }
        g.dbg(2, "AcubeCanvas.colorCubeFace: return cellid=" + n2);
        AcubeLet acubeLet = this.cube[this.cell[n2]];
        aface = acubeLet.getFace(n);
        aface.colorcode = this.colPanel.selectedColorPaneId;
        graphics = this.getGraphics();
        this.drawFace3D(graphics, aface, acubeLet.id, true);
    }

    public void copyCellArray() {
        System.arraycopy(this.cell, 0, this.cell0, 0, this.nDIM3);
    }

    private int cubeId(int n) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.colorIdArr.length) {
            if (this.colorIdArr[n3][0] == n && this.colorIdArr[n3][1] == 0) {
                n2 = n3;
                int[] nArray = this.colorIdArr[n3];
                nArray[1] = nArray[1] + 1;
                break;
            }
            ++n3;
        }
        if (n2 == -1) {
            g.abort("AcubeLet.cubeId -140: bad colorid=" + n);
        }
        int n4 = this.colorIdArr[n3][2];
        return n4;
    }

    private void cubeInit(boolean bl) {
        this.a322d.setRotationMatrix(0, 30, 20);
        this.a322d0.setRotationMatrix(0, 30, 20);
        int n = 0;
        while (n < this.nDIM) {
            int n2 = 0;
            while (n2 < this.nDIM) {
                int n3 = 0;
                while (n3 < this.nDIM) {
                    int n4 = n * this.nDIM2 + n2 * this.nDIM + n3;
                    this.cube[n4].cubeLetInit((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, bl);
                    this.cell[n4] = n4;
                    this.colorIdArr[n4][0] = this.cube[n4].naturalColorId();
                    this.colorIdArr[n4][1] = 0;
                    this.colorIdArr[n4][2] = n4;
                    if (bl) {
                        g.dbg(0, "AcubeCanvas.cubeInit: colorId,cubeid=" + this.cube[n4].colorId + "," + n4 + ";cubeId=" + this.cubeId(this.cube[n4].colorId));
                    }
                    g.dbg(0, "  cubeInit: " + this.cube[n4].toString('c'));
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.setMirrorView();
        this.setOpaque(true);
    }

    private void displayInfoLines(Graphics graphics) {
        if (cubeApp.freeware) {
            return;
        }
        if (!cubeApp.freeware) {
            return;
        }
        Font font = new Font("TimesRoman", 3, 12);
        graphics.setFont(font);
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(font);
        int n = 10;
        int n2 = 45;
        int n3 = fontMetrics.getHeight();
        int n4 = this.getSize().width - n - n;
        graphics.clearRect(n, n2 - n3, n4, n3 * this.infoLine.length);
        int n5 = 0;
        while (n5 < this.infoLine.length) {
            if (this.infoLine[n5] == null) break;
            if (this.infoLine[n5].length() > 0) {
                graphics.drawString(this.infoLine[n5], n, n2 + n3 * n5);
            }
            ++n5;
        }
    }

    private void doLogicalTurn(Aturn aturn) {
        this.mSliceCubeTurn = aturn;
        this.setmSliceCubeId();
        this.logicalSliceOp();
    }

    void drawCube() {
        long l;
        int n;
        Object object;
        long l2;
        long l3 = 0L;
        Dimension dimension = this.getSize();
        long l4 = l2 = System.currentTimeMillis();
        g.dbg(0, "AcubeCanvas.drawCube: forceReDraw=" + this.forceReDraw + "; offscreen=" + this.offscreensize);
        if (this.offscreen == null || dimension.width != this.offscreensize.width || dimension.height != this.offscreensize.height) {
            object = new Rectangle(dimension.width, dimension.height);
            n = (int)((double)this.nDIM * 3.5);
            Rectangle rectangle = new Rectangle(n, n);
            int n2 = Math.min(dimension.width, dimension.height);
            Point point = new Point((int)((double)dimension.width * 0.5), (int)((double)dimension.height * 0.5));
            this.a322d.setScreen((Rectangle)object, rectangle, point);
            this.a322d0.setScreen((Rectangle)object, rectangle, point);
            this.offscreensize = dimension;
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.offgraphics = this.offscreen.getGraphics();
            this.colPanel = new AcolorPanel(dimension);
            l = System.currentTimeMillis() - l4;
            l4 += l;
            g.dbg(0, "\t\tdrawCube.1 ms=" + l + "\telapse=" + (l3 += l));
        }
        this.offgraphics.setColor(this.getBackground());
        this.offgraphics.fillRect(0, 0, dimension.width, dimension.height);
        if (g.debugging(0)) {
            object = Runtime.getRuntime();
            long l5 = 100L * ((Runtime)object).freeMemory() / ((Runtime)object).totalMemory();
            System.out.println("  drawCube: freePercent=" + ((Runtime)object).freeMemory() + "/" + ((Runtime)object).totalMemory() + "=" + l5 + "% of the VM's memory is free.");
        }
        l = System.currentTimeMillis() - l4;
        l4 += l;
        g.dbg(0, "\t\tdrawCube.2 ms=" + l + "\telapse=" + (l3 += l));
        if (this.optShowMirror && this.cuGame.gameStatePrev != 3) {
            this.setMirrorView();
            int n3 = 0;
            while (n3 < this.nDIM3) {
                this.drawFace3D(this.offgraphics, this.mirrorFace[0][n3], 0, true);
                this.drawFace3D(this.offgraphics, this.mirrorFace[4][n3], 0, true);
                this.drawFace3D(this.offgraphics, this.mirrorFace[2][n3], 0, true);
                ++n3;
            }
        }
        l = System.currentTimeMillis() - l4;
        l4 += l;
        g.dbg(0, "\t\tdrawCube.3 ms=" + l + "\telapse=" + (l3 += l));
        Color color = this.getBackground();
        if (this.cState == 0) {
            this.cubeFrame.drawCubeFaces(this.offgraphics, this.a322d0, color);
        } else {
            this.cubeFrame.drawCubeFaces(this.offgraphics, this.a322d, color);
        }
        l = System.currentTimeMillis() - l4;
        l4 += l;
        g.dbg(0, "\t\tdrawCube.3 ms=" + l + "\telapse=" + (l3 += l));
        int n4 = 0;
        while (n4 < this.nDIM3) {
            n = 0;
            while (n < 6) {
                if (this.cube[n4].face[n].colorcode != 6) {
                    this.drawFace3D(this.offgraphics, this.cube[n4].face[n], n4, true);
                    l = System.currentTimeMillis() - l4;
                    l4 += l;
                    g.dbg(0, "\t\tdrawCube.4" + n + " ms=" + l + "\telapse=" + (l3 += l));
                }
                ++n;
            }
            ++n4;
        }
        if (this.optShowArrow && this.cState == 0) {
            this.cubeFrame.drawArrow(this.offgraphics, this.a322d0);
        }
        l = System.currentTimeMillis() - l4;
        l4 += l;
        g.dbg(0, "\t\tdrawCube.5 ms=" + l + "\telapse=" + (l3 += l));
        if (this.cState == 3) {
            this.offgraphics.setColor(Color.gray);
            this.offgraphics.drawString(String.valueOf(cubeApp.VCNAME) + " " + cubeApp.VCVERSION, 10, 20);
            this.offgraphics.drawString("Date  : " + cubeApp.VCDATE, 10, 32);
            this.offgraphics.drawString("Author: " + cubeApp.VCAUTHOR, 10, 44);
            this.offgraphics.drawString("Email : " + cubeApp.VCEMAIL, 10, 56);
        }
        if (this.cuGame.gameState == 4) {
            this.displayInfoLines(this.offgraphics);
            this.colPanel.paintComponent(this.offgraphics);
        }
        l = System.currentTimeMillis() - l4;
        l4 += l;
        g.dbg(0, "\t\tdrawCube.6 ms=" + l + "\telapse=" + (l3 += l));
        this.totalDrawTime += l3;
    }

    private boolean drawFace3D(Graphics graphics, Aface aface, int n, boolean bl) {
        if (aface.colorcode == 6) {
            return false;
        }
        Avec avec = this.a322d.rotateVec(aface.normal);
        if (Avec.VecDot(avec, g.vK) <= 0.0) {
            return false;
        }
        int n2 = 4;
        aface.setVertice(0.9);
        g.dbg(0, "AcubeCanvas.drawFace3D: cubeid=" + n + ", faceid=" + aface.faceCode);
        aface.poly2d.npoints = 0;
        int n3 = 0;
        while (n3 < n2) {
            Apoint apoint = new Apoint(aface.vertice[n3]);
            apoint.times(fudgeFactor);
            Point point = this.a322d.map3Dto2Dscreen(apoint);
            aface.poly2d.addPoint(point.x, point.y);
            ++n3;
        }
        Color color = colorArr[aface.colorcode];
        graphics.setColor(color);
        graphics.fillPolygon(aface.poly2d);
        graphics.setColor(Color.black);
        if (this.optDrawCubeId) {
            graphics.drawString(String.valueOf(n), g.min(aface.poly2d.xpoints, n2) + 2, g.max(aface.poly2d.ypoints, n2) - 2);
        }
        if (bl) {
            graphics.drawPolygon(aface.poly2d);
        }
        return true;
    }

    void drawSubCube(Graphics graphics) {
        int n = 0;
        while (n < this.mSliceCubeIdLen) {
            int n2 = this.mSliceCubeId[n];
            int n3 = 0;
            while (n3 < 6) {
                if (this.cube[n2].face[n3].colorcode != 6) {
                    this.drawFace3D(graphics, this.cube[n2].face[n3], n2, true);
                }
                ++n3;
            }
            ++n;
        }
    }

    void drawSubCube0() {
        int n;
        Dimension dimension = this.getSize();
        if (this.animateScreen == null || !this.animateScreenSize.equals(dimension)) {
            this.animateScreenSize = dimension;
            this.animateScreen = this.createImage(dimension.width, dimension.height);
            this.animateGraphics = this.animateScreen.getGraphics();
        }
        this.animateGraphics.setColor(this.getBackground());
        this.animateGraphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.optShowMirror) {
            this.setMirrorView();
            n = 0;
            while (n < this.nDIM3) {
                this.drawFace3D(this.animateGraphics, this.mirrorFace[0][n], 0, true);
                this.drawFace3D(this.animateGraphics, this.mirrorFace[4][n], 0, true);
                this.drawFace3D(this.animateGraphics, this.mirrorFace[2][n], 0, true);
                ++n;
            }
        }
        n = 0;
        while (n < this.mSliceCubeId0Len) {
            int n2 = this.mSliceCubeId0[n];
            int n3 = 0;
            while (n3 < 6) {
                if (this.cube[n2].face[n3].colorcode != 6) {
                    this.drawFace3D(this.animateGraphics, this.cube[n2].face[n3], n2, true);
                }
                ++n3;
            }
            ++n;
        }
    }

    private int incrColorIdCount(int n) {
        int n2 = 0;
        while (n2 < this.colorIdArr.length) {
            if (this.colorIdArr[n2][0] == n && this.colorIdArr[n2][1] == 0) {
                this.colorIdArr[n2][1] = 1;
                break;
            }
            ++n2;
        }
        if (n2 < this.colorIdArr.length) {
            return 1;
        }
        return 0;
    }

    public boolean isComplete() {
        AcubeInfo acubeInfo = this.cuGame.cubeInfo;
        acubeInfo.setInfo();
        boolean bl = acubeInfo.isStarConfig();
        if (acubeInfo.Nedge_good != 12 || acubeInfo.NbadCorners > 0) {
            bl = false;
        }
        return bl;
    }

    public boolean isDone() {
        int n = 0;
        while (n < this.nDIM3) {
            if (this.cell[n] != this.cell0[n]) {
                return false;
            }
            AcubeLet acubeLet = this.cube[this.cell[n]];
            Aface aface = acubeLet.getFace(1);
            if (aface.colorcode != 6 && aface.colorcode != 1) {
                return false;
            }
            ++n;
        }
        g.dbg(0, "AcubeCanvas.isDone:" + g.arrString(this.cell, this.nDIM3));
        return true;
    }

    private void logicalSliceOp() {
        int n;
        Apoint apoint;
        Amatx amatx = new Amatx();
        double d = this.mSliceCubeTurn.turnAxis.getMultipleOf(g.vI);
        if (d != 0.0) {
            apoint = new Apoint(0.0, (double)this.nDIM * 0.5, (double)this.nDIM * 0.5);
            if (d > 0.0) {
                amatx.set(g.X);
            } else {
                amatx.set(g.X_1);
            }
        } else {
            d = this.mSliceCubeTurn.turnAxis.getMultipleOf(g.vJ);
            if (d != 0.0) {
                apoint = new Apoint((double)this.nDIM * 0.5, 0.0, (double)this.nDIM * 0.5);
                if (d > 0.0) {
                    amatx.set(g.Y);
                } else {
                    amatx.set(g.Y_1);
                }
            } else {
                d = this.mSliceCubeTurn.turnAxis.getMultipleOf(g.vK);
                apoint = new Apoint((double)this.nDIM * 0.5, (double)this.nDIM * 0.5, 0.0);
                if (d > 0.0) {
                    amatx.set(g.Z);
                } else {
                    amatx.set(g.Z_1);
                }
            }
        }
        if (this.mSliceCubeTurn.NqTurn > 1) {
            n = 2;
            while (n <= this.mSliceCubeTurn.NqTurn) {
                amatx.square();
                ++n;
            }
        }
        int n2 = 0;
        while (n2 < this.mSliceCubeIdLen) {
            n = this.cube[this.mSliceCubeId[n2]].cellId();
            int n3 = this.cube[this.mSliceCubeId[n2]].transform(apoint, amatx);
            this.cell[n3] = this.mSliceCubeId[n2];
            ++n2;
        }
        g.dbg(0, "logicalSliceOp: mSliceCubeIdLen=" + this.mSliceCubeIdLen);
    }

    private int mPressedOnArrow(Point point) {
        AfaceLet afaceLet = this.cubeFrame.faceLetContaining(point, this.a322d0, true);
        if (afaceLet == null) {
            return -1;
        }
        g.dbg(3, "AcubeCanvas.mPressedOnArrow: return faceId=" + afaceLet.id);
        Avec avec = Avec.VecCross(afaceLet.normal, afaceLet.directionArrow);
        this.mRotateCubeTurn = new Aturn(avec, 0, 1, this.nDIM);
        this.mRotateCubeTurn.setNslice(this.nDIM);
        return afaceLet.id;
    }

    private int mirrorFaceContaining(Point point, A322d a322d, int n) {
        int n2 = 0;
        while (n2 < this.nDIM3) {
            Aface aface = this.mirrorFace[n][n2];
            Avec avec = a322d.rotateVec(aface.normal);
            if (!(Avec.VecDot(avec, g.vK) <= 0.0) && aface.poly2d.npoints != 0) {
                g.dbg(2, "AcubeCanvas.mirrorFaceContaining: poly2d=" + aface.poly2d);
                if (g.PtInPolygon(point, aface.poly2d)) {
                    g.dbg(2, "AcubeCanvas.mirrorFaceContaining: returned fac=" + aface);
                    return n2;
                }
            }
            ++n2;
        }
        return -1;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.cState == 4 || this.cState == 0) {
            return;
        }
        Point point = mouseEvent.getPoint();
        g.dbg(0, "mouseClicked:" + point + "; cState=" + this.cState);
        this.prevMState = this.mState;
        this.mState = 4;
        switch (this.cState) {
            case 1: {
                this.procMouseClick(point);
                break;
            }
            case 5: 
            case 6: {
                this.setCube(point);
                break;
            }
            default: {
                g.abort("mouseClicked: unexpect cState=" + this.cState);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        g.dbg(3, "mouseDragged:" + mouseEvent.getPoint());
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        g.dbg(0, "mouseEntered:" + mouseEvent.getPoint());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        g.dbg(0, "mouseExited:" + mouseEvent.getPoint());
    }

    public void mouseMove(MouseEvent mouseEvent) {
        g.dbg(3, "mouseMove:" + mouseEvent.getPoint());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        g.dbg(3, "mouseMoved" + mouseEvent.getPoint());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.cState == 4) {
            return;
        }
        this.prevMState = this.mState;
        this.mState = 1;
        Point point = mouseEvent.getPoint();
        g.dbg(0, "mousePressed:" + point + "; cState=" + this.cState);
        switch (this.cState) {
            case 0: {
                this.prevMpos = point;
                this.savePrevState();
                int n = this.mPressedOnArrow(point);
                if (n < 0) {
                    this.setCState(2);
                    break;
                }
                this.prevCState = 0;
                this.setCState(1);
                break;
            }
            case 5: 
            case 6: {
                this.prevMpos = point;
                this.setCube(point);
                break;
            }
            default: {
                g.abort("mousePressed: unexpect cState=" + this.cState);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.cState == 4) {
            return;
        }
        Point point = mouseEvent.getPoint();
        g.dbg(0, "mouseReleased:" + point + "; cState=" + this.cState);
        this.prevMState = this.mState;
        this.mState = 3;
        switch (this.cState) {
            case 0: 
            case 1: {
                this.resetView(false);
                if (this.prevMState != 2) break;
                g.dbg(0, "small mousemotion:" + point);
                this.procMouseClick(point);
                break;
            }
            case 3: {
                this.rotateCube(this.mRotateCubeTurn);
                this.setMirrorView();
                this.resetView(true);
                this.setCState(this.prevCState);
                break;
            }
            case 2: {
                this.resetView(true);
                this.setCState(0);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.setCube(point);
                break;
            }
            default: {
                g.abort("mouseReleased: unexpect cState=" + this.cState);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.setOpaque(true);
        Dimension dimension = this.getSize();
        this.painted = false;
        if (this.offscreen == null || dimension.width != this.offscreensize.width || dimension.height != this.offscreensize.height || this.forceReDraw) {
            g.dbg(0, "AcubeCanvas.paint: drawCube: ");
            System.gc();
            this.drawCube();
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
        this.setPainted();
    }

    public void performRotate(String string, String string2) {
        int n = string2.length();
        int n2 = n / 4;
        AcubeOp acubeOp = new AcubeOp(string, n2);
        acubeOp.addTurns(string2, this.nDIM);
        g.dbg(3, "performRotate: rotate=" + string2);
        this.mTrickOp = acubeOp;
        this.mTrickNrepeat = 1;
        this.animateTrick(1);
    }

    public boolean performTrick(AcubeOp acubeOp, int n) {
        g.dbg(2, "performTrick:" + acubeOp.id + "; Nrepeat=" + n);
        this.mTrickOp = acubeOp;
        this.mTrickNrepeat = n;
        if (n == 9999) {
            System.gc();
            this.startTime = System.currentTimeMillis();
            this.totalDrawTime = 0L;
            g.dbg(4, "AcubeCanvas.performTrick: startTime=================" + this.startTime);
        }
        this.animateTrick(1);
        return true;
    }

    private boolean procMouseClick(Point point) {
        this.setCState(0);
        AfaceLet afaceLet = this.cubeFrame.faceLetContaining(point, this.a322d0, true);
        if (afaceLet == null) {
            return false;
        }
        g.dbg(3, "AcubeCanvas.procMouseClick: return faceId=" + afaceLet.id);
        Avec avec = Avec.VecCross(afaceLet.normal, afaceLet.directionArrow);
        int n = 0;
        if (avec.getMultipleOf(g.vI) != 0.0) {
            n = (int)(afaceLet.oCenter.pos[0] - 0.5);
        }
        if (avec.getMultipleOf(g.vJ) != 0.0) {
            n = (int)(afaceLet.oCenter.pos[1] - 0.5);
        }
        if (avec.getMultipleOf(g.vK) != 0.0) {
            n = (int)(afaceLet.oCenter.pos[2] - 0.5);
        }
        AcubeOp acubeOp = new AcubeOp("sliceTurn", 1);
        acubeOp.addTurn(new Aturn(avec, n, 1, this.nDIM));
        this.mTrickOp = acubeOp;
        this.mTrickNrepeat = 1;
        this.animateTrick(1);
        return true;
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.cState == 0 || this.cState == 4) {
            return;
        }
        Point point = mouseEvent.getPoint();
        g.dbg(0, "processMouseMotionEvent:" + point + "; cState=" + this.cState);
        this.prevMState = this.mState;
        this.mState = 2;
        this.optShowArrow = false;
        this.optShowMirror = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 4;
        if (this.prevMpos != null) {
            n2 = (int)((float)(point.x - this.prevMpos.x) * (360.0f / (float)this.getSize().width));
            n3 = (int)((float)(point.y - this.prevMpos.y) * (360.0f / (float)this.getSize().height));
            g.dbg(0, "processMouseMotionEvent:dx:dy=" + n2 + ":" + n3);
        }
        switch (this.cState) {
            case 3: {
                n = this.mRotateCubeTurn.turnAxis.getMultipleOf(g.vI) != 0.0 ? n3 : (this.mRotateCubeTurn.turnAxis.getMultipleOf(g.vJ) != 0.0 ? -n2 : -n2);
                n4 = 2;
                if ((n *= n4) > 90) {
                    n = 90;
                }
                if (n < -90) {
                    n = -90;
                }
                this.a322d.setRotationMatrix(this.mRotateCubeTurn.turnAxis, n);
                this.forceReDraw = true;
                this.repaint();
                break;
            }
            case 2: {
                this.setView(0, 30 - n2 * n4, 20 + n3 * n4);
                this.forceReDraw = true;
                this.repaint();
                break;
            }
            case 1: {
                if (Math.abs(n2) < 4 && Math.abs(n3) < 4) break;
                this.setCState(3);
                break;
            }
            case 7: {
                if (Math.abs(n2) < 4 && Math.abs(n3) < 4) break;
                this.setCState(3);
                break;
            }
            case 5: 
            case 6: {
                this.setCube(point);
                this.prevMpos = point;
                this.optShowMirror = this.optShowMirror0;
                this.forceReDraw = true;
                break;
            }
            default: {
                g.abort("processMouseMotionEvent: unexpect cState=" + this.cState);
            }
        }
    }

    private void resetAllStates() {
        this.setCState(0);
        this.mState = 0;
        this.prevMState = 0;
        this.setGameState(0);
        this.prevMpos = null;
        this.optShowMirror = this.optShowMirror0;
        this.optShowArrow = true;
    }

    public void resetCube() {
        this.cubeInit(true);
        this.resetAllStates();
        this.forceReDraw = true;
        this.repaint();
        this.cuGame.cuApp.auPlay(auReset);
    }

    private void resetView(boolean bl) {
        this.restorePrevState();
        if (bl) {
            this.forceReDraw = true;
            this.repaint();
        }
    }

    private void restorePrevState() {
        this.prevMpos = null;
        this.optShowMirror = this.optShowMirror0;
        this.optShowArrow = true;
        this.a322d.setRotationMatrix(this.prevMatrix);
    }

    void rotateCube(Aturn aturn) {
        int n;
        Apoint apoint;
        Avec avec = aturn.turnAxis;
        int n2 = aturn.slice0N;
        int n3 = aturn.Nslice;
        int n4 = aturn.NqTurn;
        g.dbg(0, "AcubeCanvas.rotateCube:" + aturn);
        int[] nArray = new int[this.nDIM2];
        Amatx amatx = new Amatx();
        double d = avec.getMultipleOf(g.vI);
        if (d != 0.0) {
            apoint = new Apoint(0.0, (double)this.nDIM * 0.5, (double)this.nDIM * 0.5);
            if (d > 0.0) {
                amatx.set(g.X);
            } else {
                amatx.set(g.X_1);
            }
        } else {
            d = avec.getMultipleOf(g.vJ);
            if (d != 0.0) {
                apoint = new Apoint((double)this.nDIM * 0.5, 0.0, (double)this.nDIM * 0.5);
                if (d > 0.0) {
                    amatx.set(g.Y);
                } else {
                    amatx.set(g.Y_1);
                }
            } else {
                d = avec.getMultipleOf(g.vK);
                apoint = new Apoint((double)this.nDIM * 0.5, (double)this.nDIM * 0.5, 0.0);
                if (d > 0.0) {
                    amatx.set(g.Z);
                } else {
                    amatx.set(g.Z_1);
                }
            }
        }
        if (n4 > 1) {
            n = 2;
            while (n <= n4) {
                amatx.square();
                ++n;
            }
        }
        n = n2;
        while (n < n2 + n3) {
            int n5;
            int n6;
            int n7;
            if (avec.getMultipleOf(g.vI) != 0.0) {
                n7 = 0;
                while (n7 < this.nDIM) {
                    n6 = 0;
                    while (n6 < this.nDIM) {
                        n5 = n * this.nDIM2 + n7 * this.nDIM + n6;
                        nArray[n7 * this.nDIM + n6] = this.cell[n5];
                        ++n6;
                    }
                    ++n7;
                }
            } else if (avec.getMultipleOf(g.vJ) != 0.0) {
                n7 = 0;
                while (n7 < this.nDIM) {
                    n6 = 0;
                    while (n6 < this.nDIM) {
                        n5 = n7 * this.nDIM2 + n * this.nDIM + n6;
                        nArray[n7 * this.nDIM + n6] = this.cell[n5];
                        ++n6;
                    }
                    ++n7;
                }
            } else {
                n7 = 0;
                while (n7 < this.nDIM) {
                    n6 = 0;
                    while (n6 < this.nDIM) {
                        n5 = n7 * this.nDIM2 + n6 * this.nDIM + n;
                        nArray[n7 * this.nDIM + n6] = this.cell[n5];
                        ++n6;
                    }
                    ++n7;
                }
            }
            n7 = 0;
            while (n7 < this.nDIM2) {
                n6 = this.cube[nArray[n7]].cellId();
                n5 = this.cube[nArray[n7]].transform(apoint, amatx);
                g.dbg(0, " rotateCube: cubeid=" + nArray[n7] + ";old/new cellid=" + n6 + "/" + n5);
                this.cell[n5] = nArray[n7];
                g.dbg(0, " rotateCube: cubeid at " + n5 + "=" + this.cell[n5]);
                ++n7;
            }
            ++n;
        }
    }

    private void savePrevState() {
        this.optShowMirror = false;
        this.prevMatrix.set(this.a322d.getMatrix());
    }

    public void scrambleCube() {
        Avec avec = new Avec();
        String string = "";
        Random random = cubeApp.mainRandomSeed == 0L ? new Random() : new Random(cubeApp.mainRandomSeed);
        this.optShowMirror = false;
        this.doLogicalTurn(new Aturn(g.vJ, 0, 1, this.nDIM));
        this.doLogicalTurn(new Aturn(g.vI, 1, 2, this.nDIM));
        this.doLogicalTurn(new Aturn(g.vK, 2, 1, this.nDIM));
        int n = 0;
        while (n < 79) {
            int n2 = (int)(random.nextDouble() * 100.0) % (this.nDIM * 2);
            string = n == 0 ? "ranStr=" + n2 : String.valueOf(string) + "," + n2;
            int n3 = Math.abs(n2 % this.nDIM);
            if (n2 % 3 == 0) {
                avec.set(g.vI);
            } else if (n2 % 3 == 1) {
                avec.set(g.vJ);
            } else {
                avec.set(g.vK);
            }
            int n4 = 1;
            this.doLogicalTurn(new Aturn(avec, n3, n4, this.nDIM));
            ++n;
        }
        g.dbg(2, "scrambleCube: mainRandomSeed=" + cubeApp.mainRandomSeed + ";ranStr=" + string);
        this.optShowMirror = this.optShowMirror0;
        this.forceReDraw = true;
        this.repaint();
        this.cuGame.cuApp.auPlay(auScramble);
    }

    private void setCState(int n) {
        this.cState = n;
    }

    /*
     * Exception decompiling
     */
    public void setCube(Point var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setCubeColor(Color color, Color color2, Color color3, Color color4, Color color5, Color color6) {
        AcubeCanvas.colorArr[0] = color;
        AcubeCanvas.cName[0] = "LEFcol";
        AcubeCanvas.colorArr[1] = color2;
        AcubeCanvas.cName[1] = "RIGcol";
        AcubeCanvas.colorArr[2] = color3;
        AcubeCanvas.cName[2] = "DOWcol";
        AcubeCanvas.colorArr[3] = color4;
        AcubeCanvas.cName[3] = "TOPcol";
        AcubeCanvas.colorArr[4] = color5;
        AcubeCanvas.cName[4] = "BACcol";
        AcubeCanvas.colorArr[5] = color6;
        AcubeCanvas.cName[5] = "FROcol";
        AcubeCanvas.colorArr[6] = Color.black;
        AcubeCanvas.cName[6] = "black";
    }

    private int setCubeDone() {
        int n = 0;
        while (n < this.colorIdArr.length) {
            this.colorIdArr[n][1] = 0;
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.nDIM3) {
            int n5 = this.cube[n4].setColorId();
            int n6 = this.incrColorIdCount(n5);
            if (n6 == 0) {
                g.dbg(2, "setCubeDone: NnotFound=" + ++n2 + "; colid=" + n5);
                this.cube[n4].resetFaceColor(7);
            }
            ++n4;
        }
        int n7 = 0;
        while (n7 < this.nDIM3) {
            if (this.colorIdArr[n7][0] != 6 && this.colorIdArr[n7][1] != 1) {
                g.dbg(2, "setCubeDone: NnotUsed=" + n3 + "; i=" + n7 + ";colorIdArr=" + this.colorIdArr[n7][0]);
                ++n3;
            }
            ++n7;
        }
        if (n2 + n3 > 0) {
            this.infoLine[0] = "  Nop! You're not done yet; there are invalid\n color combinations, please redo..";
            this.displayInfoLines(this.getGraphics());
            JOptionPane.showMessageDialog(this, this.infoLine[0]);
            this.optShowMirror = this.optShowMirror0;
            this.forceReDraw = true;
            this.repaint();
            return n2 + n3;
        }
        this.resetAllStates();
        this.forceReDraw = true;
        this.repaint();
        return 0;
    }

    private void setGameState(int n) {
        this.cuGame.setGameState(n);
    }

    public void setInfoLines(AcubeInfo acubeInfo) {
        this.infoLine[0] = "  Number of Bad Corners =" + acubeInfo.NbadCorners + " / 8;";
        this.infoLine[1] = "  Number of Bad Edges   =" + (acubeInfo.Nedge_nonT1 + acubeInfo.Nedge_T1) + " / 12;";
    }

    private boolean setMirrorFace(Areflection areflection, int n) {
        int n2 = this.cell[n];
        AcubeLet acubeLet = this.cube[n2];
        int n3 = areflection.fcode2Breflected;
        Aface aface = acubeLet.getFace(n3);
        this.mirrorFace[n3][n].normal.set(g.vec0);
        if (aface.colorcode == 6) {
            return false;
        }
        this.mirrorFace[n3][n].set(aface);
        this.mirrorFace[n3][n].oCenter.set(areflection.getReflection(aface.oCenter));
        this.mirrorFace[n3][n].normal.set(aface.normal);
        this.mirrorFace[n3][n].normal.mult(-1);
        return true;
    }

    public void setMirrorView() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        while (n4 < this.nDIM) {
            n3 = 0;
            while (n3 < this.nDIM) {
                n2 = n4 * this.nDIM + n3;
                this.setMirrorFace(this.reflectX, n2);
                ++n3;
            }
            ++n4;
        }
        n3 = 0;
        while (n3 < this.nDIM) {
            n2 = 0;
            while (n2 < this.nDIM) {
                n = n3 * this.nDIM2 + n2;
                this.setMirrorFace(this.reflectY, n);
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < this.nDIM) {
            n = 0;
            while (n < this.nDIM) {
                int n5 = n2 * this.nDIM2 + n * this.nDIM;
                this.setMirrorFace(this.reflectZ, n5);
                ++n;
            }
            ++n2;
        }
    }

    public void setOptMirror(boolean bl) {
        if (this.optShowMirror == bl) {
            return;
        }
        this.optShowMirror = bl;
        this.forceReDraw = true;
        this.repaint();
    }

    public void setOptPerspective(boolean bl) {
        g.dbg(0, "AcubeCanvas.setOptPerspective:");
        if (this.a322d.perspective == bl) {
            return;
        }
        this.a322d.perspective = bl;
        this.a322d0.perspective = bl;
        this.forceReDraw = true;
        this.repaint();
    }

    private synchronized void setPainted() {
        this.painted = true;
        this.forceReDraw = false;
        this.notifyAll();
    }

    private void setSolveState(int n) {
        this.cuGame.solveState = n;
    }

    public void setView(int n, int n2, int n3) {
        this.a322d.setRotationMatrix(n, n2, n3);
    }

    private void setmSliceCubeId() {
        int n = 0;
        int n2 = 0;
        int n3 = this.mSliceCubeTurn.slice0N;
        int n4 = this.mSliceCubeTurn.slice0N + this.mSliceCubeTurn.Nslice;
        if (this.mSliceCubeTurn.turnAxis.getMultipleOf(g.vI) != 0.0) {
            int n5 = 0;
            while (n5 < this.nDIM) {
                int n6 = 0;
                while (n6 < this.nDIM) {
                    int n7 = 0;
                    while (n7 < this.nDIM) {
                        int n8 = n5 * this.nDIM2 + n6 * this.nDIM + n7;
                        if (n5 >= n3 && n5 < n4) {
                            this.mSliceCubeId[n++] = this.cell[n8];
                        } else {
                            this.mSliceCubeId0[n2++] = this.cell[n8];
                        }
                        ++n7;
                    }
                    ++n6;
                }
                ++n5;
            }
        } else if (this.mSliceCubeTurn.turnAxis.getMultipleOf(g.vJ) != 0.0) {
            int n9 = 0;
            while (n9 < this.nDIM) {
                int n10 = 0;
                while (n10 < this.nDIM) {
                    int n11 = 0;
                    while (n11 < this.nDIM) {
                        int n12 = n10 * this.nDIM2 + n9 * this.nDIM + n11;
                        if (n9 >= n3 && n9 < n4) {
                            this.mSliceCubeId[n++] = this.cell[n12];
                        } else {
                            this.mSliceCubeId0[n2++] = this.cell[n12];
                        }
                        ++n11;
                    }
                    ++n10;
                }
                ++n9;
            }
        } else {
            int n13 = 0;
            while (n13 < this.nDIM) {
                int n14 = 0;
                while (n14 < this.nDIM) {
                    int n15 = 0;
                    while (n15 < this.nDIM) {
                        int n16 = n14 * this.nDIM2 + n15 * this.nDIM + n13;
                        if (n13 >= n3 && n13 < n4) {
                            this.mSliceCubeId[n++] = this.cell[n16];
                        } else {
                            this.mSliceCubeId0[n2++] = this.cell[n16];
                        }
                        ++n15;
                    }
                    ++n14;
                }
                ++n13;
            }
        }
        this.mSliceCubeIdLen = n;
        this.mSliceCubeId0Len = n2;
        g.dbg(0, "AcubeCanvas::mSliceCubeTurn=" + this.mSliceCubeTurn);
        g.dbg(0, "AcubeCanvas::setmSliceCubeId=" + g.arrString(this.mSliceCubeId, n));
        g.dbg(0, "AcubeCanvas::setmSliceCubeId0=" + g.arrString(this.mSliceCubeId0, n2));
    }

    public int solved(AcubeInfo acubeInfo) {
        g.dbg(0, "solved: solvestate=" + this.cuGame.solveState + "; gameStatePrev=" + this.cuGame.gameStatePrev);
        this.setInfoLines(acubeInfo);
        this.drawCube();
        this.forceReDraw = true;
        this.repaint();
        boolean bl = this.isComplete();
        int n = this.cuGame.getTxtCounter();
        if (bl && n > 2) {
            this.cuGame.cuApp.auPlay(auSolved);
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    public void stopAnimation() {
        g.dbg(0, "stopAnimation: gameStatePrev=" + this.cuGame.gameStatePrev + ";solvestate=" + this.cuGame.solveState);
        this.restorePrevState();
        this.setGameState(0);
        this.cuGame.gameStatePrev = 0;
        this.setCState(0);
        this.prevCState = 0;
        this.mState = 0;
        this.prevMState = 0;
        this.prevMpos = null;
        this.mSliceCubeTurn = null;
        this.cuGame.incrTxtCounter(1);
        Graphics graphics = this.getGraphics();
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        this.resetView(false);
        this.forceReDraw = true;
        this.repaint();
    }
}

