/*
    This class implements the logic of the game.
    It constructs the playground with the specified 
    dimension, fill it with the number of mines you
    want and finishes the ground with the appropriate 
    numbers in it.
    Also implements public methods to retrive/set values.
    Note. Mines class support various size and/or mines but
    currently tha game does it not.
*/ 

import java.util.*;
import java.awt.*;


class mines {

//   il valore MINE nella matrice playfield indica la presenza
//   della mina in quella posizione     

     final static int MINE=16;
     final static int SCOPERTA=32;
     final static int MASK=31;

/*   this is what every bit means:

      5  4   3  2  1  0  
      .   .  .  .  .  .  
     32  16  8  4  2  1
      |   |  |  |  |  |
      |   |  -------------- reserved to cell value (o to 8)
      |   -------------------this indicate the mine
      -------------------------the cell already visited 
*/

//   play_field  is the playground array

     private int[] play_field=null;
     public Vector toShow = new Vector();

//   dimensione della matrice e numero di mine

     private int rows,cols,num_mines;

//   constructor

     public mines(int rows,int cols,int num_mines) {
          this.rows=rows;
          this.cols=cols;
          this.num_mines=num_mines;
          play_field=new int[rows*cols];

          FillPlayfield();
     }
     public int Rows() { return rows; }
     
     public int Cols() { return cols; }
     
     public int Mines() { return num_mines; }

     public int get_play_field(int i,int j){
          if (i<0 || i>rows-1 || j<0 || j>cols-1){ return 0; }
          return play_field[i*rows+j];
     }
     
     public int get_play_field(int i){
          return play_field[i];
     }

     public void set_play_field(int i,int j,int value){
          play_field[i*rows+j]=value; 
     }

     public void set_play_field(int i,int value){
          play_field[i]=value; 
     }

//   fill the ground private method
 
     private void FillPlayfield() {
          int i=0,j=0,r=0;
         
          // pongo le mine
          while (i<num_mines){
             do {
                 r=(int)(Math.random()*rows*cols);
             } while (play_field[r]==MINE);
             play_field[r]=MINE;
             i++;
          }
          int howmuch=0;
          for(i=0;i<rows;i++){
             for(j=0;j<cols;j++){
               if (get_play_field(i,j)!=MINE){
                    try {if (get_play_field(i-1,j-1)==MINE) howmuch++;}catch(ArrayIndexOutOfBoundsException e){};
                    try {if (get_play_field(i-1,j)==MINE) howmuch++;}catch(ArrayIndexOutOfBoundsException e){};
                    try {if (get_play_field(i-1,j+1)==MINE) howmuch++;}catch(ArrayIndexOutOfBoundsException e){};
                    try {if (get_play_field(i,j-1)==MINE) howmuch++;}catch(ArrayIndexOutOfBoundsException e){};
                    try { if (get_play_field(i,j+1)==MINE) howmuch++;}catch(ArrayIndexOutOfBoundsException e){};
                    try {if (get_play_field(i+1,j-1)==MINE) howmuch++;}catch(ArrayIndexOutOfBoundsException e){};
                    try {if (get_play_field(i+1,j)==MINE) howmuch++;}catch(ArrayIndexOutOfBoundsException e){};
                    try { if (get_play_field(i+1,j+1)==MINE) howmuch++;}catch(ArrayIndexOutOfBoundsException e){};
                    set_play_field(i,j,howmuch);      
                    howmuch=0; 
                                      
               }
             }
           }  
     }

/*
     This method does the hard work.
     Giving a position in the playground array (i,j) it fills
     the public array toShow with the index of all the elements
     you can show in the neighborhood.
*/ 
     public void Show(int i,int j){
          if (i>=0 && i<rows && j>=0 && j<cols){
            if ((get_play_field(i,j) & SCOPERTA) != SCOPERTA){
              if (get_play_field(i,j) ==0) {
                 toShow.addElement(new Integer(i*rows+j)); 
                 set_play_field(i,j,get_play_field(i,j)|SCOPERTA); 
                 Show(i-1,j-1);
                 Show(i-1,j);
                 Show(i-1,j+1);
                 Show(i,j-1);
                 Show(i,j+1);
                 Show(i+1,j-1);
                 Show(i+1,j);
                 Show(i+1,j+1);
              }else{
                 toShow.addElement(new Integer(i*rows+j));
                 set_play_field(i,j,get_play_field(i,j)|SCOPERTA); 
              }
            }
          }
     }
} // end class mines