/*
   JVMines v2.0 apr '97
   
   This is the final realese version. 
   written by Umberto Marzo 
   Messina(Italy)
   umarzo@eniware.it
   http://www.geocities.com/SiliconValley/Pines/4619/
   http://www.eniware.it/iwp/
 
   The original concept of the game is copyrighted by Microsoft Corp.
*/ 

import java.awt.*;
import java.awt.image.*;
import java.applet.Applet;
import java.util.Vector;

import mines;
import cell;
import custombutton;
import digitaldisplay;

public class jvmines extends Applet implements Runnable{

   mines cm=null;
   int RowsXCols;
   Vector ArrayOfControl, ArrayOfImages;
   boolean YouLose=false,started=false;
   int founded=0,flaged=0;
   MediaTracker tracker;
   Image img, flag, mina, ask, smile, smile1, smile2;

   // the rest of the number images are arranged in a strip to improve
   // download time
   // the strip image displacement is:  1 2 3 4 5 6 7 8 * ? F
   Image strip;        
   
   Panel p; 
   custombutton cButt;

   digitaldisplay dd1,dd2;
   Thread clock=null;
   int clockvalue=99;

   public void init(){

      tracker = new MediaTracker(this);
      
      img = getImage(getCodeBase(),"back.gif");
      tracker.addImage(img, 0); 
      smile = getImage(getCodeBase(),"smile.gif");
      tracker.addImage(smile, 0);
      smile1 = getImage(getCodeBase(),"smile1.gif");
      tracker.addImage(smile1, 0);
      smile2 = getImage(getCodeBase(),"smile2.gif");
      tracker.addImage(smile2, 0);
      strip = getImage(getCodeBase(),"strip.gif");
      tracker.addImage(strip, 0);

      // this vector implements an array of control
      // doing so we can detect the control (cell) that received input
      ArrayOfControl=new Vector(); 

      ArrayOfImages=new Vector();

      // this is the panel that own the playfield
      p=new Panel();

      try {
            //Start downloading the images. Wait until they're loaded
            tracker.waitForAll();
        } catch (InterruptedException e) {}

      // these images come from the strip
      
      mina=createImage(new FilteredImageSource(strip.getSource(),new CropImageFilter(88,0,11,11)));
      ask=createImage(new FilteredImageSource(strip.getSource(),new CropImageFilter(99,0,11,11)));
      flag=createImage(new FilteredImageSource(strip.getSource(),new CropImageFilter(110,0,11,11)));

      // here we arrange the images in an array so we can retrieve them using an integer
      ArrayOfImages.setSize(17);     
      for (int i=1;i<=8;i++) {
         Image tmpimg=createImage(new FilteredImageSource(strip.getSource(),new CropImageFilter((i-1)*11,0,11,11)));
         ArrayOfImages.setElementAt(tmpimg, i);
      }
      ArrayOfImages.setElementAt(mina, 16);

      setLayout(new FlowLayout(FlowLayout.CENTER,5,10));
      
      cButt= new custombutton(smile,this,30,30);

      dd1=new digitaldisplay(false, 2, Color.black, Color.red); 
      dd2=new digitaldisplay(false, 2, Color.black, Color.red); 
 
      add(dd2);
      add(cButt);
      add(dd1);
         
   } // end init()
   
   public void start() {
      if (!started) { 
       
      started=true;
      startGame();

      } //!started

   } // end start() 

   void startGame() { 

      cButt.setImage(smile);
      clockvalue=99;

      // class Mines support various size and number of mines but the currently GUI does not.
      // So if you change this value you can experience graphic layout problems.

      cm= new mines(8,8,10); 

      RowsXCols=cm.Rows()*cm.Cols();

      p.setLayout(new GridLayout(cm.Rows(),cm.Cols()));

      
      for (int i=0; i< RowsXCols; i++){
         cell c= new cell(null,this,16,16);
         p.add(c);
         ArrayOfControl.addElement(c);
      }

      dd2.SetValue(Integer.toString(cm.Mines()));
    
      
      add(p);

      p.validate();
      
      if (clock==null){
	 clock=new Thread(this);
         clock.start();
      }

   } // startGame()

   public void stop() {
       
       clock=null;
   }

   public void run() {
       while(clock!=null){
           try {Thread.sleep(1000);} catch (InterruptedException e) {}
           clockvalue--;
           if (clockvalue==0) { /* fuori tempo massimo, hai perso  */
              YouLose=true; 
              cButt.setImage(smile2);
              clock=null;
              ShowAll(); 
           } else {
              dd1.SetValue(Integer.toString(clockvalue));
           }
       }
       
   }

   public void paint(Graphics g) {
        
        //If not all the images are loaded...
        if (!tracker.checkAll()) {
          
        } else {
 
            g.drawImage(img,0,0,this);
        }
   }

   public Insets insets() { return new Insets(28,0,0,0); }
   
   public boolean mouseUp(Event  evt, int  x, int  y) {

      if (evt.target instanceof custombutton) {  // new game
         started=true;
         YouLose=false;
         founded=0;flaged=0;clockvalue=99;
         p.removeAll();
         ArrayOfControl.setSize(0); 
         startGame();
      }  
      return true; 
   }

   public boolean mouseDown(Event  evt, int  x, int  y) {

      // who received the input?
 
      cell c=(cell)evt.target;   
      int btnIndex=ArrayOfControl.indexOf(evt.target); 
      int cv=cm.get_play_field(btnIndex);
      cell tmpbtn;
      int tmpcv; int i; int tmpint;

      if (!YouLose) {
      if ((cv & mines.SCOPERTA)==0) {   // non e' gia' scoperta
        if(evt.modifiers==Event.META_MASK){    //tasto destro
          if (c.image==flag) { 
              c.setImage(ask);
              flaged-=1;
              dd2.SetValue(Integer.toString(cm.Mines()-flaged));
              return true;
          }
          if (c.image==ask) { c.setImage(null); return true;}
          c.setImage(flag);
          flaged+=1;
          dd2.SetValue(Integer.toString(cm.Mines()-flaged));
          return true;
        }
        if (cv==mines.MINE) { /* hai perso  */
            YouLose=true; 
            cButt.setImage(smile2);
            clock=null;
            ShowAll(); 
        } 
        cm.toShow.setSize(0);
        cm.Show(btnIndex/cm.Rows(),btnIndex%cm.Rows());
        
        for (i=0;i<cm.toShow.size();i++){
           tmpint=((Integer)cm.toShow.elementAt(i)).intValue();
           tmpbtn=(cell)ArrayOfControl.elementAt(tmpint);
           tmpcv=cm.get_play_field(tmpint);
           tmpbtn.setImage(IntToImage(tmpcv & mines.MASK)); 
           tmpbtn.disableCell();
           tmpcv=tmpcv | mines.SCOPERTA;
           founded++;
           if (founded==(RowsXCols-cm.Mines())) { 
              YouLose=true;
              cButt.setImage(smile1);
              clock=null;
           }
           cm.set_play_field(tmpint,tmpcv);
        }
        return true;     
       }
       return true;
      } // you lose
      return true;
   }

   void ShowAll(){
      int i, cv;
      cell c;
      for (i=0;i<ArrayOfControl.size();i++){
         c=(cell)ArrayOfControl.elementAt(i); 
         cv=cm.get_play_field(i);
         if (cv==mines.MINE) {
            c.setImage(IntToImage(cv));
         }
      }
   }

   Image IntToImage(int i){
      Image img=null;
      img=(Image)ArrayOfImages.elementAt(i);
      return img;
   }
}