/*
   DigitalDisplay class implements a digital display

   costructor: digitaldisplay(boolean    true/false for a big display or not
                              int        number of digits (max MAXNUMCIFRE)
                              Color      display background color  
                              Color      display foreground color)
   methods:    void SetValue(String      value to display)

   written by:
     Umberto Marzo  
     Messina (Italy)
     umarzo@eniware.it
     www.geocities.com/SiliconValley/Pines/4619

     "Thanks to Kazuma's kzmClock applet"
*/

import java.awt.*;
import java.util.*;

public class digitaldisplay extends Canvas  {

	int VerLedx[], VerLedy[], HorLedx[], HorLedy[];
	int CifraXP, CifraYP;	        // x,y position of all the numbers
        
        int CifraVal[];         	// used for displaying
	
	boolean BigClock;		// is the clock big ?
	
        String Led[];			// status of leds
	String Cifre[];			// structure of all the 10 numbers
		
	Color bgColor;			// background color
	Color fgColor;			// foreground color
	
	String strValueDisplayed;
	int NumCifre;
        static int MAXNUMCIFRE=10;	

	//	constructor	//

	public digitaldisplay(boolean BigClock, int NumCifre, Color bgColor, Color fgColor) {
		this.BigClock=BigClock;
		this.NumCifre=NumCifre;
		this.bgColor=bgColor;
		this.fgColor=fgColor;
		CifraVal=new int[MAXNUMCIFRE];

		if (BigClock == true) {
					
			VerLedx = getParameterIntList("2 3 5 5 3 2 0 0 2", ' ');
			VerLedy = getParameterIntList("0 0 2 17 19 19 17 2 0", ' ');
			HorLedx = getParameterIntList("2 17 19 19 17 2 0 0 2", ' ');
			HorLedy = getParameterIntList("0 0 2 3 5 5 3 2 0", ' ');
	            Led = getParameterList("H 4 0,V 0 4,V 22 4,H 4 22,V 0 26,V 22 26,H 4 44", ',');
			CifraYP = 5;
			CifraXP = 37;
			
                        resize(new Dimension(CifraXP*NumCifre, 60));
		} else {
			VerLedx = getParameterIntList("0 1 2 3 3 2 1 0 0", ' ');
			VerLedy = getParameterIntList("1 0 0 1 8 9 9 8 1", ' ');
			HorLedx = getParameterIntList("0 1 8 9 9 8 1 0 0", ' ');
			HorLedy = getParameterIntList("1 0 0 1 2 2 3 2 1", ' ');
            	    Led = getParameterList("H 3 0,V 0 3,V 12 3,H 3 12,V 0 15,V 12 15,H 3 24", ',');
			CifraYP = 3;
			CifraXP = 20;
			
			resize(new Dimension(CifraXP*NumCifre-CifraYP, 32));
		}
		Cifre = new String[10];
            Cifre[0] = "1 1 1 0 1 1 1";
            Cifre[1] = "0 0 1 0 0 1 0";
            Cifre[2] = "1 0 1 1 1 0 1";
            Cifre[3] = "1 0 1 1 0 1 1";
            Cifre[4] = "0 1 1 1 0 1 0";
            Cifre[5] = "1 1 0 1 0 1 1";
            Cifre[6] = "0 1 0 1 1 1 1";
            Cifre[7] = "1 0 1 0 0 1 0";
            Cifre[8] = "1 1 1 1 1 1 1";
            Cifre[9] = "1 1 1 1 0 1 0";
		
		

	} // end of constructor

        public void SetValue(String str) {
		for (int i=0;i<MAXNUMCIFRE-1;i++){ CifraVal[i]=0; }
                for (int i=0;i<str.length();i++){
		     CifraVal[NumCifre-str.length()+i]=Integer.parseInt(str.substring(i,i+1));
		}
                strValueDisplayed=str;
                repaint();
	}

	//
	// 	getParameterList
	//		(read a multiple parameter string and
	//		separated by a definible char and return
	//		a string list containing parameters)
	//
	
	String[] getParameterList(String param, char sep) {
		String p = param;
		String[] result = null;

		if (param != null) {
			int pos = 0;
			int count = 0;
			while ((pos = p.indexOf(sep)) >= 0) {
				p = p.substring(pos + 1);
				count++;
			}
			if (p.length() > 0) {
			count++;
			}
			result = new String[count];
			p = param;
			for (int i=0; i<result.length; i++) {
				pos = p.indexOf(sep);
				if (pos < 0) {
					result[i] = p.substring(0, p.length());
					p = null;
				} else {
					result[i] = p.substring(0, pos);
					p = p.substring(pos+1);
				}
			}
		}
		return result;
	}// end of getParameterList


	//
	// 	getParameterIntList
	//		(read a multiple parameter string and
	//		separated by a definible char and return
	//		a int list containing parameters)
	//
	
	int[] getParameterIntList(String param, char sep) {
		String p = param;
		int[] result = null;

		if (param != null) {
			int pos = 0;
			int count = 0;
			while ((pos = p.indexOf(sep)) >= 0) {
				p = p.substring(pos + 1);
				count++;
			}
			if (p.length() > 0) {
			count++;
			}
			result = new int[count];
			p = param;
			for (int i=0; i<result.length; i++) {
				pos = p.indexOf(sep);
				if (pos < 0) {
					result[i] = Integer.parseInt(p.substring(0, p.length()));
					p = null;
				} else {
					result[i] = Integer.parseInt(p.substring(0, pos));
					p = p.substring(pos+1);
				}
			}
		}
		return result;
	}// end of getParameterIntList


	//
	//	PrintLed	(print a led of a number)
	//
	//	Input:	graphic (Graphics),the led number (int),x (int),y (int),color (Color)
	
	public void PrintLed(Graphics g, int TheLed, int x, int y, Color TheColor) {
		String pTemp[];
		int DrawLedx[],
		    DrawLedy[];

		DrawLedx = new int[9];
		DrawLedy = new int[9];
		pTemp = getParameterList(Led[TheLed],' ');
		if (pTemp[0].compareTo("H") == 0) {
			for (int j=0; j<=8; j++) {
				DrawLedx[j] = 0;
				DrawLedy[j] = 0;
				DrawLedx[j] = HorLedx[j] + x + Integer.parseInt(pTemp[1]);
				DrawLedy[j] = HorLedy[j] + y + Integer.parseInt(pTemp[2]);
			}
		} else {
			for (int j=0; j<=8; j++) {
				DrawLedx[j] = 0;
				DrawLedy[j] = 0;
				DrawLedx[j] = VerLedx[j] + x + Integer.parseInt(pTemp[1]);
				DrawLedy[j] = VerLedy[j] + y + Integer.parseInt(pTemp[2]);
			}
		}
		g.setColor(TheColor);
		g.fillPolygon(DrawLedx, DrawLedy, 9);
	}// end of PrintLed


	//
	//	PrintCifra	(print a number)
	//
	//	Input:	graphic (Graphics),the number (int),x (int),y (int)
	
	public void PrintCifra(Graphics g, int LaCifra, int xpos, int ypos) {
		String CT[];

		CT = getParameterList(Cifre[LaCifra], ' ');
		for (int i=0; i<=6; i++) {
			if (CT[i].compareTo("1") == 0) {
				PrintLed(g, i, xpos, ypos, fgColor);
			} else {
				PrintLed(g, i, xpos, ypos, bgColor);
			}
		}

	}// end of PrintCifra


	// Paint
	//
	public void paint(Graphics g) {
		g.setColor(bgColor);
		g.fillRect(0,0,size().width, size().height);
		g.setColor(fgColor);  
                for (int i=0; i<NumCifre; i++) {
		     PrintCifra(g, CifraVal[i], CifraXP*i, CifraYP);
                }           
	}


	// Update
	//
	public void update(Graphics g) { paint(g);  }
	

} // end of class

