/*
    This class implements a simple button with an 
    image (you can change in runtime) on it. 
*/

import java.awt.*;

class custombutton extends Canvas {
   Container pappy;
   Image image;
   
   Dimension minSize;
   int w, h;
   int DOWN=1,UP=0;
   int buttonstatus=UP;  
   

   public custombutton(Image image, Container parent, int initialWidth, int initialHeight) {
       
       this.image = image;
       pappy = parent;

       w = initialWidth;
       h = initialHeight;

       minSize = new Dimension(w,h);
   }

   public Dimension preferredSize() { return minSize; /* minimumSize();*/ }

   public synchronized Dimension minimumSize() { return minSize; }

   
   public void setImage(Image img){
       this.image=img;
       repaint();
   }

   public boolean mouseDown(Event evt,int x,int y){
      buttonstatus=DOWN;   
      repaint();
      return true;
   }

   public boolean mouseUp(Event evt,int x,int y){

      buttonstatus=UP;
      repaint();
      return false;
   }

   public void paint (Graphics g) {
      
       if (buttonstatus==UP) {    
          g.setColor(getBackground());
          g.draw3DRect(0,0,size().width-2,size().height-2,true);
       } else {
         g.setColor(getBackground());
         g.fillRect(1,1,size().width,size().height);
       }
       
       if (image!=null) g.drawImage(image, (size().width-image.getWidth(this))/2, (size().height-image.getHeight(this))/2, this);   

   }

} // end class 