/*
   This class implements the cell object.
   It acts like a standard button, also you can set an image on it
   change the image displayed during runtime od disable the button.
*/ 

import java.awt.*;

class cell extends Canvas {
   Container pappy;
   Image image;
   
   Dimension minSize;
   int w, h;
   int DOWN=1,UP=0;
   int buttonstatus=UP;  
   boolean enabled=true;

   public cell(Image image, Container parent, int initialWidth, int initialHeight) {
       
       this.image = image;
       pappy = parent;

       w = initialWidth;
       h = initialHeight;

       minSize = new Dimension(w,h);
   }

   public Dimension preferredSize() { return minSize; /* minimumSize();*/ }

   public synchronized Dimension minimumSize() { return minSize; }

   public void disableCell() { enabled=false; disable(); }

   public void setImage(Image img){
       this.image=img;
       repaint();
   }
   
   // the mouse events only simulate the click on the button 

   public boolean mouseDown(Event evt,int x,int y){
      if (evt.modifiers!=Event.META_MASK) {   // il tasto sinistro
         buttonstatus=DOWN;   
         repaint();
         return false;
      } 
      
      return false;
   }

   public boolean mouseUp(Event evt,int x,int y){

      buttonstatus=UP;
      repaint();
      return false;
   }

   public void paint (Graphics g) {
      if (enabled) {
       if (buttonstatus==UP) {    
          g.drawRect(0,0,size().width-1,size().height-1);
          g.setColor(getBackground());
          g.draw3DRect(0,0,size().width-2,size().height-2,true);
       } else {
         g.drawRect(0,0,size().width-1,size().height-1);
         g.setColor(getBackground());
         g.fillRect(1,1,size().width,size().height);
       }
       
       if (image!=null) g.drawImage(image, (size().width-image.getWidth(this))/2, (size().height-image.getHeight(this))/2, this);   
      } else {  /* not enabled  */
         g.setColor(Color.gray);
         g.drawRect(0,0,size().width-1,size().height-1);
         g.setColor(getBackground());
         g.fillRect(1,1,size().width,size().height);
         if (image!=null) g.drawImage(image, (size().width-image.getWidth(this))/2, (size().height-image.getHeight(this))/2, this); 
      }

   }

} // end class cell