/**
  <applet code="Fifteen" width=200 height=250> </applet>
  Copyright (c) Anatoly Goroshnik
  the latest version of this applet can be found at:
  http://www.panix.com/~anatoly

   @version 1, 4/16/96
   @author <A HREF="mailto:anatoly@iscinc.com">Anatoly Goroshnik</A>
**/

import java.awt.*;
import java.applet.*;

public class Fifteen extends Applet {
   int n = 4;
	Labels labels = new Labels(n);
	Button[][] buttons = new Button[n][n];
	Panel controls = new Panel();
	Panel status = new Panel();
	Panel game = new Panel();
	TextField message = new TextField();
	int controlsColor = 200*256*256+50*256+0;
	int statusColor = 0*256*256+50*256+150;
	int gameColor = 0*256*256+100*256+100;
	String shuffle = "Start new game";
	String welcome = "Copyright (c) Anatoly Goroshnik ";
	String moves = "Moves: ";
	String allDone = "Congratulations, well done!";
	String start = "You may start now";
	boolean done = false;
	int numMoves = 0;

	public void paint(Graphics g) {
   		for (int i = 0; i < n; i++) {
       		for (int j = 0; j < n; j++) {
				if (labels.getLabel(i, j) == 0) {
					buttons[i][j].hide();
					buttons[i][j].setLabel("" + labels.getLabel(i, j));
				}
				else {
					buttons[i][j].setLabel("" + labels.getLabel(i, j));
					buttons[i][j].show();
				}
			}
		}
	}

    public void init () {
		setLayout(new BorderLayout());
		setBackground(new Color(gameColor));
		status.setLayout(new FlowLayout());
		status.setBackground(new Color(statusColor));
		message.setForeground(Color.white);
		message.setEditable(false);
		message.setText(welcome);
		status.add(message);
		controls.setLayout(new FlowLayout());
		controls.setBackground(new Color(controlsColor));
		controls.add(new Button(shuffle));
  		game.setLayout (new GridLayout (n, n));
		add("Center", game);
		add("North", controls);
		add("South",status);
   		int width = Integer.parseInt(getParameter("width"));
   		int height = Integer.parseInt(getParameter("height"));
   		for (int i = 0; i < n; i++) {
       		for (int j = 0; j < n; j++) {
            	int k = i*n + j + 1;
				buttons[i][j] = new Button("");
             	game.add(buttons[i][j]);
				labels.setLabel(i, j, (k == n*n)?0:k);
       		}
   		}
		labels.shuffleLabels();
		paint(getGraphics());
  	}

	public boolean action(Event ev, Object ob) {
		if (shuffle.equals(ob)) {
      	// Shuffle button was pressed
			labels.shuffleLabels();
			done = false;
			numMoves = 0;
			message.setText(start);
			paint(getGraphics());
			return true;
		}
		if (ev.target instanceof Button) {
			if (!done) {
				Button t = (Button) ev.target;
				if (labels.distanceFromBlank((new Integer(t.getLabel())).intValue()) == 1) {
					labels.moveToBlank((new Integer(t.getLabel())).intValue());
					message.setText(moves + (++numMoves));
				}
				if (labels.isDone()) {
					message.setText(allDone + " " + numMoves);
					done = true;
				}
				paint(getGraphics());
			}
			return true;
		}
		else
			return false;
	}
}

class Position {
	public int x;
	public int y;

	public void Position() {
		x = 0;
		y = 0;
	}

	void setPosition(int newX, int newY) {
		x = newX;
		y = newY;
	}
}

class Labels {
	int dimentions = 2;
	int n;

	Integer[][] labels;
	Position[] positions;

	public Labels(int dim) {
		n = dim;
		labels = new Integer[n][n];
		positions = new Position[n*n];

		for (int i = 0; i < n*n; i++) {
			positions[i] = new Position();
		}
	}

	public boolean isDone() {
   		for (int i = 0; i < n; i++) {
       		for (int j = 0; j < n; j++) {
            	int k = i*n + j + 1;
				if ((k != n*n) && (k != getLabel(i, j)))
					return false;
			}
		}
		return true;
	}

	public void shuffleLabels() {
		Position[] blankNeighbors = new Position[(int) Math.pow(2, dimentions)];
		int numNeighbors;

		for (int i = 0; i < (int) Math.pow(2, dimentions); i++) {
			blankNeighbors[i] = new Position();
		}

      // create random path for blank square,
      // therefore insuring that the situation is always solvable
		for (int i = 0; i < 200; i++) {
			numNeighbors = 0;
			if ((positions[0].x + 1) < n) {
				blankNeighbors[numNeighbors].setPosition(positions[0].x + 1, positions[0].y);
				numNeighbors++;
			}
			if ((positions[0].x - 1) >= 0) {
				blankNeighbors[numNeighbors].setPosition(positions[0].x - 1, positions[0].y);
				numNeighbors++;
			}
			if ((positions[0].y + 1) < n) {
				blankNeighbors[numNeighbors].setPosition(positions[0].x, positions[0].y + 1);
				numNeighbors++;
			}
			if ((positions[0].y - 1) >= 0) {
				blankNeighbors[numNeighbors].setPosition(positions[0].x, positions[0].y - 1);
				numNeighbors++;
			}
			int k = (int) (Math.random() * (numNeighbors));
			moveToBlank(getLabel(blankNeighbors[k].x, blankNeighbors[k].y));
		}

	}

	public void setLabel(int x, int y, int label) {
		labels[x][y] = new Integer(label);
		positions[label].setPosition(x, y);
	}

	public int getLabel(int x, int y) {
		return labels[x][y].intValue();
	}

	public int distanceFromBlank(int label) {
		int blankX = positions[0].x;
		int blankY = positions[0].y;
		int posX   = positions[label].x;
		int posY   = positions[label].y;
		return Math.abs(blankX - posX) + Math.abs(blankY - posY);
	}

	public void moveToBlank(int label) {
		exchange(label, 0);
	}

	void exchange(int label1, int label2) {
		int label1X = positions[label1].x;
		int label1Y = positions[label1].y;
		int label2X = positions[label2].x;
		int label2Y = positions[label2].y;
		labels[label1X][label1Y] = new Integer(label2);
		positions[label2].setPosition(label1X, label1Y);
		labels[label2X][label2Y] = new Integer(label1);
		positions[label1].setPosition(label2X, label2Y);
	}
}
