// Script: ergosign.styleform.js
// Version: 0.8
//
// License: MIT-style license
//
// Copyright: ERGOSIGN GmbH, http://www.ergosign.de
//
// Usage:
//   call styleSelect() on any SELECT html elements to style it
//   call styleButton() on any input button to style it
//
//   You can adjust the look by editing the CSS
//
// Known Issues:
//   - Drop down list stays open until it is clicked
//   - Drop down list can cause scrolling if it contains many
//     elements (no internal scrolling yet)

function hideElement(el) {
	var hider = new Element('div', {'class': 'hide hideDiv'});
	hider.inject(el, 'before');
	el.inject(hider);
	return hider;
}
function handleSelect() {
	if($('dropdown') != null) {
		$('dropdown').destroy();
		return;
	}
		
	var dropdown = new Element('div', {id: 'dropdown'});
	
	var options = this.sel.getChildren();
	for(var i = 0; i < options.length; i++) {
		var d = new Element('div');
		var li = new Element('p');
		li.set('html', options[i].get('text'));
		li.inject(d);
		d.inject(dropdown)
		d.hoverElement();
		d.addEvent('click', function() {
			this.sel.selectedIndex = this.index;
			$('dropdown').destroy();
			//this.sel.updateNewStyle();
			this.sel.fireEvent('change');
		}.bind({sel: this.sel, index: i}));
	}		
	dropdown.inject(document.body);
	
	var cc = this.getCoordinates();
	var cLeft = this.getFirst('.button_left').getCoordinates().left;
	var cRight = this.getFirst('.button_right').getCoordinates().right;
	var cWidth = cRight - cLeft;
	dropdown.setStyles({
		position: 'absolute',
		top: (cc.bottom-1) + 'px',
		left: cc.left + 'px',
		width: (cWidth - 2) + 'px'
	});
}

Element.implement({
	styleSelect: function() {
		var cc = this.getCoordinates();
		
	// original select verstecken
		var hider = hideElement(this);
		
	// gestyltes select konstruieren
		var newSelect = new Element('div', {'class': 'combobox', style: 'overflow: hidden;'});
		var bLeft = new Element('div', {'class': 'button_left'});
		var bCenter = new Element('div', {'class': 'button_center'});
		var bPfeil = new Element('div', {'class': 'button_combobox'});
		var bRight = new Element('div', {'class': 'button_right'});
				
		bCenter.set('html', this.getSelected().get('text'));
		
		bLeft.inject(newSelect);
		bCenter.inject(newSelect);		
		bPfeil.inject(newSelect);
		bRight.inject(newSelect);
		
		newSelect.sel = this;
		
		newSelect.inject(hider, 'before');
		
		newSelect.addEvent('click', handleSelect);
		this.updateNewStyle = function() {
			this.newSel.getFirst('.button_center').set('html', this.sel.getSelected().get('text'));
		}.bind({sel: this, newSel: newSelect});
		this.addEvent('change', this.updateNewStyle);
		this.addEvent('keyup', this.updateNewStyle);
		
		newSelect.hoverElement();
		
	// check length
		var options = this.getChildren();
		var longest = this.getSelected().get('text');
		var current = longest;
		for(var i = 0; i < options.length; i++) {
			if(options[i].get('text').length > longest.length)
				longest = options[i].get('text');
		}
		bCenter.set('html', longest);

		var newWidth = bCenter.getSize().x;
		if(this.get('rel') != null && newWidth > this.get('rel').toInt()) {
			newWidth = this.get('rel').toInt();
		}
		
		bCenter.setStyle('width', (newWidth - 10) + 'px');
		bCenter.set('html', current);
	}
});
Element.implement({
    styleButton: function() {
       	// original verstecken
		var hider = hideElement(this);
		
		// gestylten button konstruieren
		var newElement = new Element('div', {'class': 'button ' + this.get('rel'), style: 'overflow: hidden;'});

		var bLeft = new Element('div', {'class': 'button_left'});
		var bCenter = new Element('div', {'class': 'button_center'});
		var bRight = new Element('div', {'class': 'button_right'});
				
		bCenter.set('html', this.get('value'));
		
		bLeft.inject(newElement);
		bCenter.inject(newElement);
		bRight.inject(newElement);
		
		newElement.but = this;
		
		newElement.inject(hider, 'before');
		
		newElement.addEvent('click', function() {
			this.but.fireEvent('click');
			
		});
		if(this.get('type') == 'submit') {
			newElement.addEvent('click', function() {
				this.but.form.submit();
			});
		}
		newElement.hoverElement();
    }
});

Element.implement({
    hoverElement: function() {
       	this.addEvent('mouseenter', function() { this.addClass('hoverX'); });
		this.addEvent('mouseleave', function() { this.removeClass('hoverX'); });
		
		this.addEvent('mousedown', function() { this.addClass('pressX'); });
		this.addEvent('mouseup', function() { this.removeClass('pressX'); });
		
		if(this.sel != null) {
			this.sel.addEvent('focus', function() { this.addClass('focusX'); }.bind(this));
			this.sel.addEvent('blur', function() { this.removeClass('focusX'); }.bind(this));
		}
    }
});
