(function($) {
  $.fn.anchorize = function(settings) {
    settings = $.extend({
        menu: '.menu',
        target: '.slider',
        speed : 500,
        height: 180
      }, settings);	

    var container = this;
    var menu = $(settings.menu, container);
    var target = $(settings.target, container);

    container.css({'position':'relative', 'overflow':'hidden'});
    $('li:first', menu).addClass('active');
    target.css('height', settings.height+'px');
    $('li', target).css({'display':'none', 'position':'absolute', 'height': settings.height+'px'});
    $('li:first', target).css('display', 'block').addClass('active');

    var sliding = false;
    
    $('li', menu).each(function() {
      // We use this to save the link variable
      var link = $(this);

      $('a', link).click(function() {
        var oldCurrentItem = target.find('.active');
        var currentItem = $($(this).attr('href'));
        if(!currentItem.hasClass('active') && !sliding) {
          sliding = true;
          menu.find('li').removeClass('active');
          link.addClass('active');

          currentItem
            .addClass('active')
            .css({'top':settings.height+'px', 'display':'block'})
            .animate({top: 0}, settings.speed);
          oldCurrentItem
            .removeClass('active')
            .css('top', 0)
            .animate({top: -settings.height}, settings.speed, function() {
              $(this).css('display', 'none');
              sliding = false;
            });
        }

        return false;
      });
    });
    
    return this;
  }
})(jQuery);