/*
 * jLensMagnify jQuery plugin - Rel. 0.1
 *
 * Copyright (c) 2010 Giovanni Casassa (senamion.com - senamion.it)
 *
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 *
 * http://www.senamion.com
 *
 */


(function($)
{
	$.fn.jLensMagnify = function(o) {

		o = $.extend({
			startEffect: {'font-size': '150%'},
			resetEffect: {'font-size': '100%'},
			splitChar: ''	// '' for char - ' ' for word
		}, o);

		return this.each(function(i) {
			var el = $(this);
			var	elH = null;
			var	uuid = (el.attr('id') || el.attr('class') || 'internalName') + '_jLM';
			var myText = "";
			var aStr = el.text().split(o.splitChar);

			for (var len in aStr)
				myText += "<span class='" + uuid + "'>" + aStr[len] + "</span>" + o.splitChar;
			el.html(myText);

			// ADD LENS TO BODY
			$("<img src='img/MagLens.png' id='_wm" + uuid + "' style='position: absolute; top: 0px; left: 0px; width: 100px; height: 100px; overflow:hidden;' />").appendTo(el).hide();

			// ON HOVER SHOW LENS
			$('.' + uuid).mouseenter(function(){
				if (elH != null)
					elH.css(o.resetEffect);
				elH = $(this);

				elH.css(o.startEffect);
				var h = parseInt(elH.height()) + 9;
				var	w = parseInt(elH.width()) + 6;
				var	position = elH.position();
				var x = parseInt(position.left) - 3;
				var y = parseInt(position.top);

				$("#_wm" + uuid).css({'top': y + 'px', 'left': x + 'px', 'width': w + 'px', 'height': h + 'px'}).show();
			});

			// ON LEAVE CONTAINER RESET EFFECTS
			el.mouseleave(function() {
				if (elH != null)
					elH.css(o.resetEffect);
				$("#_wm" + uuid).hide();
			});
		});
	};
})(jQuery);