function getSelectedText(textComponent)
{
	var selectedText;
	// IE version
	if (document.selection != undefined)
	{
		textComponent.focus();
		var sel = document.selection.createRange();
		selectedText = sel.text;
	}
	// Mozilla version
	else if (textComponent.selectionStart != undefined)
	{
		var startPos = textComponent.selectionStart;
		var endPos = textComponent.selectionEnd;
		selectedText = textComponent.value.substring(startPos, endPos)
	}

	return selectedText;
}

function insertAtCaret(txt, tag){
	if(document.selection) {
		sel = document.selection.createRange();
		sel.text = tag;
	} else if(txt.selectionStart || txt.selectionStart == '0') {
		txt.value = (txt.value).substring(0, txt.selectionStart) + tag + (txt.value).substring(txt.selectionEnd, txt.textLength);
	} else {
		txt.value = tag;
	}
}

function insertTagAtCaret(txt, tag, single){
	if(single === undefined){
		single = false;
	}
	
	if(document.selection) {
		
		sel = document.selection.createRange();
		if(single == true) {
			sel.text = '[' + tag + ']';
		} else {
		    sel.text = '[' + tag + ']' + sel.text + '[/' + tag + ']';
		}
	} else if(txt.selectionStart || txt.selectionStart == '0') {
		if(single == true) {
			txt.value = (txt.value).substring(0, txt.selectionStart) + "["+tag+"]" + (txt.value).substring(txt.selectionEnd, txt.textLength);
		} else {
			txt.value = (txt.value).substring(0, txt.selectionStart) + "["+tag+"]" + (txt.value).substring(txt.selectionStart, txt.selectionEnd) + "[/"+tag+"]" + (txt.value).substring(txt.selectionEnd, txt.textLength);
		}
	} else {
		if(single) {
			txt.value = '[' + tag + ']';
		} else {
			txt.value = '[' + tag + '][/' + tag + ']';
		}
	}
}

function insertCustom(txt, insertObject){
	if(txt.selectionStart || txt.selectionStart == '0') {
		txt.value = (txt.value).substring(0, txt.selectionStart) + insertObject + (txt.value).substring(txt.selectionEnd, txt.textLength);
	} else {
		txt.value = insertObject;
	}
}