/*
 *	textDepth
 *
 *	Description:
 *		A plug-in to create 3D effects on text
 *
 *	Author:
 *		Magnus Ferm
 *
 *	License (MIT):
 *	------------------------------------------------------------------
 *	 Copyright (c) <year> <copyright holders>
 *
 *	 Permission is hereby granted, free of charge, to any person
 *	 obtaining a copy of this software and associated documentation
 *	 files (the "Software"), to deal in the Software without
 *	 restriction, including without limitation the rights to use,
 *	 copy, modify, merge, publish, distribute, sublicense, and/or sell
 *	 copies of the Software, and to permit persons to whom the
 *	 Software is furnished to do so, subject to the following
 *	 conditions:
 *
 *	 The above copyright notice and this permission notice shall be
 *	 included in all copies or substantial portions of the Software. 
 *
 *	 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *	 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 *	 OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 *	 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 *	 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 *	 WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *	 FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 *	 OTHER DEALINGS IN THE SOFTWARE.
 */

(function($){

	$.fn.textDepth = function(ops){
		var defaultOptions = {
			depth: 3,
			wrapper: "body",
			shade_color: '#c7c7c7',
			gradient: true,
			extra_classes: "",
			direction: "downRight"
		};
		var layers = [];
		
		return this.each(function(){
			var options = $.extend({}, defaultOptions, ops);
			var t = $(this);
			var def_class = "textDepthSuperDuperClass" + t.attr('id');
			
			if(t.css('position') == 'relative' || t.css('position') == 'absolute'){
				if(options.wrapper != null){
				
					if(t.css('z-index') < options.depth || t.css('z-index') == "auto")
						t.css('z-index', (options.depth + 1));
				
					//Remove previous remains:
					$('.' + def_class).remove();
					
					var t_top = parseInt(t.css('top'));
					var t_left = parseInt(t.css('left'));
					var z_index = parseInt(t.css('z-index'));
					var opacity = 1.0;

					for(var i = 0; i < options.depth; i++){
						switch(options.direction){
							case "downRight":
								t_top++;
								t_left++;
								break;
								
							case "downLeft":
								t_top++;
								t_left--;
								break;
								
							case "upRight":
								t_top--;
								t_left++;
								break;
								
							case "upLeft":
								t_top--;
								t_left--;
								break;
								
							case "up":
								t_top--;
								break;
								
							case "left":
								t_left--;
								break;
								
							case "right":
								t_left++;
								break;
								
							case "down":
								t_top++;
								break;
						}
						
						z_index--;
						opacity = 1 - parseFloat((i / options.depth));
						
						var shadeDiv = $(document.createElement('div')).css({'position':'absolute',
																			 'top':t_top,
																			 'left':t_left,
																			 'color':options.shade_color,
																			 'z-index':z_index
																			 })
																	   .addClass(options.extra_classes)
																	   .addClass(def_class)
																	   .html(t.html());
						
						if(options.gradient)
							shadeDiv.css('opacity', opacity);
							
						$(options.wrapper).append(shadeDiv);
					}
				}
			}
		});
	};
})(jQuery);