//Output parameters
			var text_depth = 4;
			var text_gradient = true;
			var text_direction = "downRight";
			
			function Init(){
				$('#dataInput').val("Hello World!");
				checkInputOutput();
				
				$('#information')
				.textDepth({
					wrapper: "#wrapper",
					shade_color: "#8a8a8a",
					extra_classes: "informationText"
				});
			}
			
			function add3D_effect(){
				$('#output')
				.textDepth({
					wrapper: "#wrapper",
					depth: text_depth,
					gradient: text_gradient,
					direction: text_direction
				});
			}
			
			function checkInputOutput(){
				var text = formatOutput($('#dataInput').val());
				$('#output').html(text);
				
				$('#output').textDepth({
					wrapper: "#wrapper",
					depth: 6
				});
			}
			
			function formatOutput(text){
				text = text.replace(/\n/g, "<br />");
				text = text.replace(/\t/g, "&nbsp;&nbsp;&nbsp;");
				text = text.replace(/\[bold\](.*?)\[\/bold\]/gi, "<b>$1</b>");
				text = text.replace(/\[italic\](.*?)\[\/italic\]/gi, "<em>$1</em>");
				text = text.replace(/\[underline\](.*?)\[\/underline\]/gi, "<u>$1</u>");				
				
				return text;
			}
			
			$(document).ready(function(){
				
				$('#dataInput')
				.keyup(function(){
					checkInputOutput();
				});
				
				$('.tool')
				.mouseover(function() {
					$(this).addClass('toolHover');
				})
				.mouseout(function(){
					$(this).removeClass('toolHover');
				})
				.click(function(){
					var textarea = $('#dataInput')[0];
					insertTagAtCaret(textarea, $(this).attr('id').replace("tool_", ""));
					checkInputOutput();
				});
				
				$('#gradient').change(function(){
					text_gradient = ($(this).val() == "true") ? true : false;
					add3D_effect();
				});
				
				$('#depth').change(function(){
					text_depth = $(this).val();
					add3D_effect();
				});
				
				$('#direction').change(function(){
					text_direction = $(this).val();
					add3D_effect();
				});
				
				Init();
				
				$('#sidebar').textDepth({
					wrapper: "body",
					shade_color: "#6f6f6f",
					depth: 7,
					extra_classes: "sidebarText"
				});
			});