<?
// ##### CONFIGURATION HERE #####################################

// UNCOMMENT THE ONE YOU WISH TO USE
//require_once ("shoutbox_csv.php"); // Comma Seperated Value files
//require_once ("shoutbox_mysql.php"); // mySQL database

// don't forget to edit the selected file's options

$showamount = "20";
// amount of shouts to show

$linelength = "17";
// maximum length of a line for word wrapping

$maxshoutlen = "120";
// maximum length of a shout in total. (120 was chosen as this is around
// the limit for SMS messages).  If you do change this, realise that 
// the forms in the supplied files have maximum length values in them.

$censormode = "TRUE";
// TRUE = change bad words into good words ala shoutbox_censor.php, 
// FALSE = don't.

$emoticons = "TRUE";
// TRUE = turn typed smileys into images, FALSE = don't.

$emoticon_theme = "orange";
// Choose the colour theme you want.
// beige, blue, clearblack, clearwhite, gray, green, 
// orange, purple, red, turquoise, yellow

$emoticon_text = "w";
//$emoticon_text = ""; // black text
// Some emoticons have text above them.  If you wish to use white, use w.  
// If you want black, set to blank

$direction = "1";
// 1 = new posts at bottom,  -1 = new posts at the top
//
//     Note: If you don't want the shoutbox to scroll to the bottom,
//           you'll need to remove this code from the <BODY> tag of
//           viewshoutbox.php and expanded.php
//     ----> onload="window.scrollTo(0,99999);"

$checkurl = "TRUE";
// Tests submitted URLs to see if they exist or not.

$deletetime = "1200";
// If a user posts, they can delete that post within $deletetime seconds of
// it being posted, as long as they have the same IP address as when they 
// posted it.
// If you don't want deleting, set to -1.

$floodtime = "120";
// if a user has posted 3 times in the last $floodtime seconds, any further 
// posts will not be accepted, until this doesn't apply any more.

$timezonecorrection = "0";
// timezone difference between your target audience and your web server.

require_once ("shoutbox_langpack_english.php");
// Language pack to use.  Change the filename.

// CUSTOMISING THE HTML OUTPUT
//
// To do this you'll need to know how PHP works a little.  I'll try to explain
// here.
//
// * What is inbetween the speech marks is output.
// * Variables, such as $url, are replaced by data.
// * To output a " (speech marks) you'll need to use \"
// * Each output processing function here will list the variables you can use.

function processLink($nick, $url) {
    // This changes what the URL looks like when there
    // is a valid URL to use.  See ProcessNoLink t
    //
    // $url is the url which will be used.
    // $nick is the name of the shouter
    // ONLY CHANGE THE FOLLOWING LINE!
    return "<a href=\"$url\" target=\"_blank\">$nick</a>";
}

function processNoLink($nick) {
    // This changes what the URL looks like when there is
    // NOT a valid URL to use.
    //
    // $nick is the name of the shouter
    //
    // ONLY CHANGE THE FOLLOWING LINE!
    return "$nick";
}

function processDeleteLink($shout, $timestamp) {
    global $lang;
    // This changes what the delete link looks like.  It's shown when users
    // from the same IP recorded with the post are shown the shoutbox.
    // href should be 'shoutbox.php?action=deleteshout&timestamp=$timestamp'
    // $lang['delete_shout'] is from the language pack.
    // $shout is the shout for that post.
    return $shout . "<BR><a href='shoutbox.php?action=deleteshout&timestamp=$timestamp'>" . _DELETE_SHOUT . "</a> ";    
} 

function formatDate($date) {
    global $timezonecorrection;
    // This changes how dates and times are output.
    //
    // $date is the unix-style timestamp recorded for the shout.
    // BUT
    // To format the date as you would like you need to change the
    // letters between the speech marks.
    // You can find a list of these letters and what they mean at:
    // http://www.php.net/manual/en/function.date.php
    // or in your copy of the php manual.
    ///
    $date = $date + ($timezonecorrection * 3600);
    // ONLY CHANGE THE FOLLOWING LINE!
    return date("j M h:ia",$date);
}

function outputShout ($url,$nick,$shout,$date,$colour,$count) {
    // This is what is finally output by the script.
    //
    // $url is the results from processLink above
    // $nick is the name of the shouter
    // $shout is the message they shouted
    // $date is the date formatted by formatDate above
    // $colour is used for alternating the CSS theme for each post.
    //
    return "<table cellpadding=\"2\" cellspacing=\"0\" \"border=0\" width=\"100%\" class=\"table$colour\"><tr><td class=\"shoutbox\" title=\"Posted $date, IP Logged\"><B>$url</B>: $shout</td></tr></table>";
}

// ##################################### CONFIG ENDS HERE ######
?>
