<?php
//
//  CSV Module for Shoutbox
//   Shoutbox (C) 2001 Brett Taylor
//   last updated 28 October 2001

// ##### CONFIG ##############################################################

$shoutfile = "/home/glutnix/public_html/shoutbox-demo/shouts.txt";
// file where shouts are kept

// ###########################################################################
$databasemodule = "Shoutbox CSV Module v2.31"; // DO NOT EDIT THIS VALUE!
// writeShouts
//  Writes shouts to CSV
function writeShouts ($nick, $shout, $url) {
    global $shoutfile, $REMOTE_ADDR;
    $shouts = fopen($shoutfile,"a");
    $nick = str_replace("|","",$nick);
    $shout = str_replace("|","",$shout);
    $url = str_replace("|","",$url);
    $nick = stripslashes(trim($nick));
    $shout = stripslashes(trim($shout));
    $url = stripslashes(trim($url));
    fwrite($shouts,$nick."|".$shout."|".time()."|".$url."|".$REMOTE_ADDR."\n");
    fclose($shouts);
}

// getShouts
//  Gets range of shouts from CSV
function getShouts ($start,$number,$dir) {
    global $shoutfile;
	//echo "getShouts:".$start.", ".$number.", ".$dir."<BR>";
    $shouts = file($shoutfile); // read in shouts for count
    for ($count=$start;$count<=$start+$number;$count++) {
        $csvdata = explode("|",$shouts[$count]);
        $output[$count-$start]= array( 'nick' => $csvdata[0],
                                       'shout' => $csvdata[1],
                                       'time' => $csvdata[2],
                                       'url'  => $csvdata[3],
                                       'ipaddress' => $csvdata[4]
                                     );
    }
    if ($dir == -1) {
        $output= array_reverse($output);
    }
    return $output;
}

function countShouts() {
    global $shoutfile;
	$shouts = file($shoutfile); // read in shouts for count
	//echo "countShouts=".count($shouts)."<BR>";
    return count($shouts);
}

function deleteShout($timestamp) {
    global $shoutfile;
	$newfile = array();
    $shouts = fopen ($shoutfile, "r");
    while (!feof ($shouts)) {
	    $data = fgets($shouts, 8000);
        $csvdata = explode("|",$data);
		if ($csvdata[2] == $timestamp) {
			// found the timestamp, so don't write it
		} else {
            $newfile[] = $data;
		}
    }
    fclose ($shouts);
 	$o_shouts = fopen($shoutfile, "w");
	foreach ($newfile as $data){
		fwrite ($o_shouts, $data);
	}
	fclose ($o_shouts);
}

function getIP($timestamp) {
    global $shoutfile;
    $shouts = file($shoutfile); // read in shouts for count
    for ($count=$start;$count<=$finish;$count++) {
        $csvdata = explode("|",$shouts[$count]);
        if ($csvdata[2] == $timestamp) {
            break;
        }
    }
    return $csvdata[4];
}

function updateShout($timestamp,$nick,$shout,$url) {
    global $shoutfile;
	$newfile = array();
    $shouts = fopen ($shoutfile, "r");
    $nick = str_replace("|","",$nick);
    $shout = str_replace("|","",$shout);
    $url = str_replace("|","",$url);
    $nick = stripslashes(trim($nick));
    $shout = stripslashes(trim($shout));
    $url = stripslashes(trim($url));
    while (!feof ($shouts)) {
	    $data = fgets($shouts, 8000);
        $csvdata = explode("|",$data);
		if ($csvdata[2] == $timestamp) {
			// found the timestamp, so re-write it
			$newfile[] = $nick."|".$shout."|".$timestamp."|".$url."\n";
		} else {
            $newfile[] = $data;
		}
    }
    fclose ($shouts);
 	$o_shouts = fopen($shoutfile, "w");
	foreach ($newfile as $data){
		fwrite ($o_shouts, $data);
	}
	fclose ($o_shouts);
}
?>
