﻿   //Our validation script will go here.
$(document).ready(function () {
    //custom validation rule - checkAge
    $.validator.addMethod("checkAge",
       function (value, element) {
          var currDate=new Date();   
          var dobDate = $('#txtDateOfBirth').val();
          var sdob = dobDate.split('-');
		  //pass year,month,date in new Date object.
          var vDOB = new Date(sdob[2], sdob[1], sdob[0]);
		  //getAge user define function to calculate age.
          var vYrs = getAge(vDOB,currDate);
		  var result=false;
		  $('#txtAge').val(vYrs);
		  if(vYrs>=18 && vYrs<=30){
		  result=true; }
          return result;
       });
    //validation implementation will go here.
    $('#myform').validate({
        rules: {
            txtDateOfBirth: {
                required: true,
                checkAge: true,
            }
        },
        messages: {
            txtDateOfBirth: {
                required: "Date of Birth is required.",
				checkAge:"<span style='color:#ff0000;'>Age range is 18 to 30.</span>"				
            }
        }
    });	
})
//function to calculate age.
function getAge(oldDate,currDate) {
     return currDate.getFullYear() - oldDate.getFullYear();
}
