﻿/// <reference path="jquery-1.5.1.js" />
/// <reference path="jquery.validate.unobtrusive.js" />
/// <reference path="jquery.validate.js" />

//custom validation rule - checkAge
jQuery.validator.addMethod("checkage",
function (value, element, param) {
    var currDate = param;
    var sdoc = currDate.split('-');
    var dobDate = value;
    var sdob = dobDate.split('-');
    //pass year,month,date in new Date object.
    var vDOB = new Date(sdob[2], sdob[1], sdob[0]);
    var vDOC = new Date(sdoc[2], sdoc[1], sdoc[0]);
    //getAge user define function to calculate age.
    var vYrs = getAge(vDOB, vDOC);
    var result = false;
    if (vYrs >= 18 && vYrs <= 30) { result = true; }
    return result;
});

jQuery.validator.unobtrusive.adapters.add("checkage", ["param"], function (options) {

    options.rules["checkage"] = options.params.param;
    options.messages["checkage"] = options.message;
});

function getAge(oldDate, currDate) {
    return currDate.getFullYear() - oldDate.getFullYear();
}