﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;

namespace MvcAppClientValidation.Models
{
    public class StatusCheckAge : ValidationAttribute,IClientValidatable
    {
        protected override ValidationResult IsValid(object value, ValidationContext validationContext)
        {
            DateTime dtV = (DateTime)value;
            long lTicks = DateTime.Now.Ticks - dtV.Ticks;
            DateTime dtAge = new DateTime(lTicks);
            string sErrorMessage = "Age range is 18 to 30 yrs. old.";
            if (!(dtAge.Year >= 18 && dtAge.Year <= 30)) { return new ValidationResult(sErrorMessage); }
            return ValidationResult.Success;            
        }        
        public IEnumerable<ModelClientValidationRule> GetClientValidationRules(ModelMetadata metadata, ControllerContext context)
        {
            ModelClientValidationRule mcvrTwo = new ModelClientValidationRule();
            mcvrTwo.ValidationType = "checkage";
            mcvrTwo.ErrorMessage = "Age range is 18 to 30 yrs. old.";
            mcvrTwo.ValidationParameters.Add("param", DateTime.Now.ToString("dd-MM-yyyy"));            
            return new List<ModelClientValidationRule> { mcvrTwo };
        }        
    }
}